/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.botp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class PmOrderToPurOrderPlugin
extends AbstractConvertPlugIn {
    private static Log log = LogFactory.getLog(PmOrderToPurOrderPlugin.class);

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField("operator");
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        super.afterFieldMapping(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            List srcRows = (List)billDataEntity.getValue("ConvertSource");
            DynamicObject srcRow = (DynamicObject)srcRows.get(0);
            Long operator = (Long)((DynamicProperty)e.getFldProperties().get("operator")).getValue((Object)srcRow);
            if (null == operator || operator.equals(0L)) continue;
            QFilter filter = new QFilter("person", "=", (Object)operator);
            DynamicObject person = BusinessDataServiceHelper.loadSingleFromCache((String)"pur_bizperson", (QFilter[])new QFilter[]{filter});
            if (null == person) {
                person = BusinessDataServiceHelper.loadSingle((String)"pur_bizperson", (String)"id", (QFilter[])new QFilter[]{filter});
            }
            if (null == person) continue;
            billDataEntity.setValue("person_id", person.getPkValue());
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey("pur_order");
        HashSet<String> ids = new HashSet<String>(entitys.length);
        ArrayList<DynamicObject> dynamicObjects = new ArrayList<DynamicObject>(entitys.length);
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject obj = entity.getDataEntity();
            dynamicObjects.add(obj);
            DynamicObjectCollection entries = obj.getDynamicObjectCollection("materialentry");
            for (DynamicObject entry : entries) {
                ids.add(entry.getString("srcbillid"));
            }
        }
        this.updateByMalOrder(dynamicObjects, ids);
    }

    protected void updateByMalOrder(List<DynamicObject> dynamicObjects, Set<String> ids) {
        log.info("###start updateByMalOrder");
        if (ids.size() == 0) {
            return;
        }
        HashSet<Long> idsValue = new HashSet<Long>(ids.size());
        for (String id : ids) {
            idsValue.add(Long.valueOf(id));
        }
        QFilter dfilter = new QFilter("id", "in", idsValue);
        String selector = "id,reqperson,platform,entryentity.id,entryentity.jdorder jdorder,entryentity.goods goods,entryentity.goodsdesc goodsdesc,jdorderid";
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"mal_order", (String)selector, (QFilter[])new QFilter[]{dfilter});
        HashMap<String, DynamicObject> id_orderMap = new HashMap<String, DynamicObject>();
        HashMap<String, DynamicObject> entryId_orderMap = new HashMap<String, DynamicObject>();
        for (DynamicObject malorder : cols) {
            id_orderMap.put(malorder.getString("id"), malorder);
            entryId_orderMap.put(malorder.getString("entryentity.id"), malorder);
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            DynamicObjectCollection entryCol = dynamicObject.getDynamicObjectCollection("materialentry");
            DynamicObject srcData = (DynamicObject)id_orderMap.get(((DynamicObject)entryCol.get(0)).getString("srcbillid"));
            if (null == srcData) {
                log.info("###\u672a\u627e\u5230\u6e90\u5355\u6570\u636e");
                continue;
            }
            if (srcData.get("reqperson") != null) {
                dynamicObject.set("reqperson_id", srcData.get("reqperson"));
            }
            String srctype = "3";
            if (srcData.get("platform") != null) {
                String type = srcData.get("platform").toString();
                String string = srctype = "1".equals(type) || "2".equals(type) ? type : "2";
            }
            if (srctype.equals("2")) {
                dynamicObject.set("logstatus", (Object)"C");
                dynamicObject.set("cfmstatus", (Object)"B");
                dynamicObject.set("jdorderid", (Object)srcData.getString("jdorderid"));
            }
            dynamicObject.set("srctype", (Object)srctype);
            for (DynamicObject entry : entryCol) {
                DynamicObject srcEntry = (DynamicObject)entryId_orderMap.get(entry.get("srcentryid"));
                if (null == srcEntry) continue;
                entry.set("jdorder", srcEntry.get("jdorder"));
                entry.set("goods_id", srcEntry.get("goods"));
                entry.set("goodsdesc", srcEntry.get("goodsdesc"));
            }
        }
    }
}

