/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.botp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.pm.pur.business.service.SupColDispatchService;

public class PurApply2SrcDemandConvertPlugin
extends AbstractConvertPlugIn {
    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        Map variables = this.getOption().getVariables();
        if (variables != null && "pssc_mytask".equals(variables.get("formId"))) {
            Collection values;
            Map fldProperties = e.getFldProperties();
            String data = (String)variables.get("data");
            Map infosMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
            HashMap<String, DynamicObject> storeMap = new HashMap<String, DynamicObject>();
            if (infosMap != null && infosMap.size() > 0 && !(values = infosMap.values()).isEmpty()) {
                QFilter qFilter = new QFilter("id", "in", values);
                DynamicObjectCollection taskColls = QueryServiceHelper.query((String)"pssc_mytask", (String)"srcentryid,sourcetype,srctype,sourceorg", (QFilter[])new QFilter[]{qFilter}, (String)null);
                for (DynamicObject taskColl : taskColls) {
                    storeMap.put(taskColl.getString("srcentryid"), taskColl);
                }
            }
            List sourceRows = e.getSourceRows();
            for (DynamicObject sourceRow : sourceRows) {
                Long entryId = (Long)sourceRow.get((IDataEntityProperty)fldProperties.get("billentry.id"));
                DynamicObject info = (DynamicObject)storeMap.get(String.valueOf(entryId));
                if (info == null) continue;
                long sourceorg = info.getLong("sourceorg");
                sourceRow.set((IDataEntityProperty)fldProperties.get("org"), (Object)sourceorg);
            }
        }
    }

    public void afterConvert(AfterConvertEventArgs evt) {
        ExtendedDataEntitySet entitySet = evt.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entities = entitySet.FindByEntityKey("src_demand");
        this.bindTaskData(entities);
        ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>(8);
        for (int i = 0; i < entities.length; ++i) {
            ExtendedDataEntity entity = entities[i];
            DynamicObject demandObj = entity.getDataEntity();
            demandObj.set("curr", demandObj.get("currency"));
            objs.add(demandObj);
        }
        SupColDispatchService.invokeService4SupCol("convert2SrcDemand", new Object[]{objs});
    }

    private void bindTaskData(ExtendedDataEntity[] entities) {
        Map variables = this.getOption().getVariables();
        if (variables != null && "pssc_mytask".equals(variables.get("formId"))) {
            ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(16);
            for (ExtendedDataEntity entity : entities) {
                bills.add(entity.getDataEntity());
            }
            if (CollectionUtils.isEmpty(bills)) {
                return;
            }
            String data = (String)variables.get("data");
            this.wrapDemandsBill4Pssc(bills, data);
        }
    }

    private void wrapDemandsBill4Pssc(List<DynamicObject> bills, String data) {
        Collection values;
        Map infosMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class);
        HashMap<String, DynamicObject> storeMap = new HashMap<String, DynamicObject>();
        if (infosMap != null && infosMap.size() > 0 && !(values = infosMap.values()).isEmpty()) {
            QFilter qFilter = new QFilter("id", "in", values);
            DynamicObjectCollection taskColls = QueryServiceHelper.query((String)"pssc_mytask", (String)"srcentryid,sourcetype,srctype,sourceorg", (QFilter[])new QFilter[]{qFilter}, null);
            for (DynamicObject taskColl : taskColls) {
                storeMap.put(taskColl.getString("srcentryid"), taskColl);
            }
        }
        HashMap<Long, DynamicObject> baseInfoMap = new HashMap<Long, DynamicObject>(bills.size());
        for (DynamicObject demand : bills) {
            DynamicObjectCollection billentry = demand.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : billentry) {
                DynamicObject info = (DynamicObject)storeMap.get(dynamicObject.getString("srcentryid"));
                if (info == null) continue;
                DynamicObject org = this.storeBaseData(baseInfoMap, info.getLong("sourceorg"), "bos_org");
                demand.set("org", (Object)org);
                demand.set("org_tmp", (Object)org);
                DynamicObject sourcetype = this.storeBaseData(baseInfoMap, info.getLong("sourcetype"), "pds_extdata");
                demand.set("sourcetype2", (Object)sourcetype);
                DynamicObject srctype = this.storeBaseData(baseInfoMap, info.getLong("srctype"), "pbd_sourceflow");
                demand.set("srctype2", (Object)srctype);
                DynamicObject sourcetype2 = demand.getDynamicObject("sourcetype2");
                if (sourcetype2 == null || !sourcetype2.getBoolean("isselloff")) continue;
                demand.set("isselloff", (Object)"A");
            }
        }
    }

    private DynamicObject storeBaseData(Map<Long, DynamicObject> baseInfoMap, Long pk, String baseFormId) {
        DynamicObject baseData = baseInfoMap.get(pk);
        if (baseData == null) {
            baseData = BusinessDataServiceHelper.loadSingleFromCache((Object)pk, (String)baseFormId);
            baseInfoMap.put(pk, baseData);
        }
        return baseData;
    }
}

