/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.botp;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class PurapplybillToBidProjectPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] extendedDataEntities;
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(this.getTgtMainType().toString())) {
            DynamicObject contact;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObject purtype = QueryServiceHelper.queryOne((String)"bid_purtype", (String)"id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1"), new QFilter("materialpur", "=", (Object)Boolean.TRUE)});
            if (purtype == null) {
                BizLog.log((String)"No material purtype");
                return;
            }
            DynamicObject purType = BusinessDataServiceHelper.loadSingle((Object)purtype.getLong("id"), (String)"bid_purtype");
            dataEntity.set("purtype", (Object)purType);
            DynamicObject[] bidmode = BusinessDataServiceHelper.load((String)"bid_bidmode", (String)"id", (QFilter[])new QFilter[]{new QFilter("opentenderflag", "=", (Object)Boolean.FALSE), new QFilter("enable", "=", (Object)"1")}, (String)"id desc");
            if (bidmode == null || bidmode.length == 0) {
                BizLog.log((String)"No invite bidmode");
                return;
            }
            DynamicObject bidMode = BusinessDataServiceHelper.loadSingle((Object)bidmode[0].getLong("id"), (String)"bid_bidmode");
            if (bidMode != null) {
                dataEntity.set("bidmode", (Object)bidMode);
                String bidModeSteps = this.getBidModeSteps(bidMode, dataEntity);
                DynamicObjectCollection memberentity = dataEntity.getDynamicObjectCollection("memberentity");
                memberentity.forEach(entry -> entry.set("respbusiness", (Object)bidModeSteps));
            }
            if ((contact = dataEntity.getDynamicObject("contact")) == null) {
                contact = dataEntity.getDynamicObject("creator");
            }
            if (contact == null) continue;
            dataEntity.set("contacttel", (Object)contact.getString("phone"));
            dataEntity.set("proemail", (Object)contact.getString("email"));
        }
    }

    protected String getBidModeSteps(DynamicObject bidMode, DynamicObject dataEntity) {
        StringBuilder sb = new StringBuilder();
        sb.append("01");
        sb.append(',');
        sb.append("08");
        sb.append(',');
        if (bidMode.getBoolean("supplierinvitation")) {
            sb.append("02");
            sb.append(',');
            dataEntity.set("supplierinvitation", (Object)Boolean.TRUE);
        }
        if (bidMode.getBoolean("biddocument")) {
            sb.append("09");
            sb.append(',');
            dataEntity.set("biddocument", (Object)Boolean.TRUE);
        }
        if (bidMode.getBoolean("bidpublish")) {
            sb.append("05");
            sb.append(',');
            dataEntity.set("bidpublish", (Object)Boolean.TRUE);
        }
        if (bidMode.getBoolean("bidanswerquestion")) {
            sb.append("10");
            sb.append(',');
            dataEntity.set("bidanswerquestion", (Object)Boolean.TRUE);
        }
        if (bidMode.getBoolean("bidopen")) {
            sb.append("06");
            sb.append(',');
            dataEntity.set("bidopen", (Object)Boolean.TRUE);
        }
        if (bidMode.getBoolean("bidevaluation")) {
            sb.append("07");
            sb.append(',');
            dataEntity.set("bidevaluation", (Object)Boolean.TRUE);
        }
        if (bidMode.getBoolean("bidbustalk")) {
            sb.append("15");
            sb.append(',');
            dataEntity.set("bidbustalk", (Object)Boolean.TRUE);
        }
        return sb.toString();
    }
}

