/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mpscmm.msbd.business.service.TrackLogService;
import kd.scmc.pm.business.helper.SuppCollaHepler;
import kd.scmc.pm.mservice.api.PmSupColService;

public class PmSupColServiceImpl
implements PmSupColService {
    private static Log log = LogFactory.getLog(PmSupColServiceImpl.class);
    private static TrackLogService trackLog = new TrackLogService(PmSupColServiceImpl.class, "pm");

    @Override
    public boolean updatePmBillStatus(Map<String, Object> map) {
        trackLog.startInfo(this.serialization(map));
        log.info("update pmBillStatus service param --> " + map);
        if (map == null || map.size() < 1) {
            log.info("service param is null");
            return false;
        }
        String entity = (String)map.get("entity");
        List ids = (List)map.get("ids");
        if (StringUtils.isBlank((CharSequence)entity) || ids == null || ids.isEmpty()) {
            log.info("service param(entity/ids) exception is null");
            trackLog.endInfo("service param(entity/ids) exception is null");
            return false;
        }
        QFilter[] qFilter = new QFilter[]{new QFilter("id", "in", (Object)ids)};
        switch (entity) {
            case "pm_purapplybill": {
                return this.updatePurApplyBill(qFilter, map);
            }
            case "pm_purorderbill": {
                return this.updatePurOrderBill(qFilter, map);
            }
            case "pm_xpurorderbill": {
                return this.updateXPurOrderBill(qFilter, map);
            }
            case "pm_purrefundapplybill": {
                return this.updatePurRefundApplyBill(qFilter, map);
            }
        }
        trackLog.endInfo("service param(entity) exception out of range");
        return false;
    }

    @Override
    public boolean cancelPurOrder(List list) {
        trackLog.startInfo(this.serialization(list));
        log.info("\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u7684\u4ed8\u6b3e\u72b6\u6001\u63a5\u53e3\u53c2\u6570  --> " + list);
        if (list == null || list.size() < 1) {
            log.info("\u63a5\u53e3\u53c2\u6570\u4e3a\u7a7a");
            return false;
        }
        QFilter[] q = new QFilter[]{new QFilter("id", "in", (Object)list)};
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)"pm_purorderbill", (String)"id,billstatus,closestatus", (QFilter[])q);
        if (loads == null || loads.length < 1) {
            trackLog.endInfo("list(pm_purorderbill no exist in database)" + list);
            log.info("\u63a5\u53e3\u53c2\u6570\u5728\u91c7\u8d2d\u8ba2\u5355\u4e2d\u4e0d\u5b58\u5728  --> " + list);
            return false;
        }
        ArrayList<Long> AIDs = new ArrayList<Long>();
        ArrayList<Long> BIDs = new ArrayList<Long>();
        ArrayList<Long> CIDs = new ArrayList<Long>();
        for (int i = 0; i < list.size(); ++i) {
            Long ID = (Long)list.get(i);
            DynamicObject purOrder = loads[i];
            String billStatus = purOrder.getString("billstatus");
            if ("C".equalsIgnoreCase(billStatus)) {
                CIDs.add(ID);
                continue;
            }
            if ("B".equalsIgnoreCase(billStatus)) {
                BIDs.add(ID);
                continue;
            }
            AIDs.add(ID);
        }
        if (CIDs != null && CIDs.size() > 0) {
            int CSize = CIDs.size();
            QFilter[] Cq = new QFilter[]{new QFilter("id", "in", CIDs)};
            DynamicObject[] Cloads = BusinessDataServiceHelper.load((String)"pm_purorderbill", (String)"id,billstatus,closestatus", (QFilter[])Cq);
            DynamicObject[] purOrders = new DynamicObject[CSize];
            for (int i = 0; i < CSize; ++i) {
                DynamicObject purOrder = Cloads[i];
                purOrder.set("closestatus", (Object)"B");
                purOrders[i] = purOrder;
            }
            Object[] save = SaveServiceHelper.save((DynamicObject[])purOrders);
            log.info("\u91c7\u8d2d\u8ba2\u5355\u6574\u5355\u5173\u95ed\u7ed3\u679c --> " + Arrays.toString(save));
        }
        if (BIDs != null && BIDs.size() > 0) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", String.valueOf(false));
            option.setVariableValue("ishasright", String.valueOf(true));
            OperationResult unsubmitResult = OperationServiceHelper.executeOperate((String)"unsubmit", (String)"pm_purorderbill", (Object[])BIDs.toArray(), (OperateOption)option);
            log.info("\u91c7\u8d2d\u8ba2\u5355\u64a4\u9500\u64cd\u4f5c\u7ed3\u679c --> " + unsubmitResult);
            if (unsubmitResult.isSuccess()) {
                AIDs.addAll(BIDs);
            }
        }
        if (AIDs != null && AIDs.size() > 0) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("isStrict", String.valueOf(false));
            option.setVariableValue("ishasright", String.valueOf(true));
            OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)"pm_purorderbill", (Object[])AIDs.toArray(), (OperateOption)option);
            log.info("\u91c7\u8d2d\u8ba2\u5355\u5220\u9664\u64cd\u4f5c\u7ed3\u679c --> " + deleteResult);
        }
        trackLog.endInfo("billstatus=A:" + AIDs + ", billstatus=B" + BIDs + ", billstatus=C" + CIDs);
        return true;
    }

    private boolean updatePurRefundApplyBill(QFilter[] qFilter, Map<String, Object> map) {
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)"pm_purrefundapplybill", (String)"id,confirmstatus", (QFilter[])qFilter);
        if (loads == null || loads.length < 1) {
            trackLog.endInfo("param ids(pm_purrefundapplybill) no exist in database");
            log.info("param ids(pm_purrefundapplybill) no exist in database");
            return false;
        }
        List<String> confirmStatusList = Arrays.asList("A", "B", "C", "D");
        boolean isChange4Confirm = false;
        String confirmStatus = (String)map.get("confirmstatus");
        if (StringUtils.isNotBlank((CharSequence)confirmStatus) && confirmStatusList.contains(confirmStatus)) {
            isChange4Confirm = true;
        }
        if (!isChange4Confirm) {
            trackLog.endInfo("param status(pm_purrefundapplybill) out of range");
            log.info("param status(pm_purrefundapplybill) out of range");
            return false;
        }
        for (DynamicObject load : loads) {
            if (!isChange4Confirm) continue;
            load.set("confirmstatus", (Object)confirmStatus);
        }
        SaveServiceHelper.update((DynamicObject[])loads);
        return true;
    }

    private boolean updateXPurOrderBill(QFilter[] qFilter, Map<String, Object> map) {
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)"pm_xpurorderbill", (String)"id,confirmstatus", (QFilter[])qFilter);
        if (loads == null || loads.length < 1) {
            trackLog.endInfo("param ids(pm_xpurorderbill) no exist in database");
            log.info("param ids(pm_xpurorderbill) no exist in database");
            return false;
        }
        List<String> confirmStatusList = Arrays.asList("A", "B", "C", "D");
        boolean isChange4Confirm = false;
        String confirmStatus = (String)map.get("confirmstatus");
        if (StringUtils.isNotBlank((CharSequence)confirmStatus) && confirmStatusList.contains(confirmStatus)) {
            isChange4Confirm = true;
        }
        if (!isChange4Confirm) {
            trackLog.endInfo("param status(pm_xpurorderbill) out of range");
            log.info("param status(pm_xpurorderbill) out of range");
            return false;
        }
        for (DynamicObject load : loads) {
            if (!isChange4Confirm) continue;
            load.set("confirmstatus", (Object)confirmStatus);
        }
        SaveServiceHelper.update((DynamicObject[])loads);
        return true;
    }

    private boolean updatePurOrderBill(QFilter[] qFilter, Map<String, Object> map) {
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)"pm_purorderbill", (String)"id,confirmstatus,logisticsstatus,paystatus", (QFilter[])qFilter);
        if (loads == null || loads.length < 1) {
            trackLog.endInfo("param ids(pm_purorderbill) no exist in database");
            log.info("param ids(pm_purorderbill) no exist in database");
            return false;
        }
        List<String> confirmStatusList = Arrays.asList("A", "B", "C", "D");
        List<String> logisticsStatusList = Arrays.asList("A", "B", "C", "D", "E", "F", "G");
        List<String> payStatusList = Arrays.asList("A", "B", "C");
        boolean isChange4Confirm = false;
        boolean isChange4Logistics = false;
        boolean isChange4Pay = false;
        String confirmStatus = (String)map.get("confirmstatus");
        String logisticsStatus = (String)map.get("logisticsstatus");
        String payStatus = (String)map.get("paystatus");
        if (StringUtils.isNotBlank((CharSequence)confirmStatus) && confirmStatusList.contains(confirmStatus)) {
            isChange4Confirm = true;
        }
        if (StringUtils.isNotBlank((CharSequence)logisticsStatus) && logisticsStatusList.contains(logisticsStatus)) {
            isChange4Logistics = true;
        }
        if (StringUtils.isNotBlank((Object)isChange4Pay) && payStatusList.contains(payStatus)) {
            isChange4Pay = true;
        }
        if (!(isChange4Confirm || isChange4Logistics || isChange4Pay)) {
            trackLog.endInfo("param status(pm_purorderbill) all out of range");
            log.info("param status(pm_purorderbill) all out of range");
            return false;
        }
        for (DynamicObject load : loads) {
            if (isChange4Confirm) {
                load.set("confirmstatus", (Object)confirmStatus);
            }
            if (isChange4Logistics) {
                load.set("logisticsstatus", (Object)logisticsStatus);
            }
            if (!isChange4Pay) continue;
            load.set("paystatus", (Object)payStatus);
        }
        SaveServiceHelper.update((DynamicObject[])loads);
        return true;
    }

    private boolean updatePurApplyBill(QFilter[] qFilter, Map<String, Object> map) {
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)"pm_purapplybill", (String)"id,inquirystatus,bidstatus", (QFilter[])qFilter);
        if (loads == null || loads.length < 1) {
            trackLog.endInfo("param ids(pm_purapplybill) no exist in database");
            log.info("param ids(pm_purapplybill) no exist in database");
            return false;
        }
        List<String> statusList = Arrays.asList("A", "B");
        boolean isChange4Inquiry = false;
        boolean isChange4Bid = false;
        String inquiryStatus = (String)map.get("inquirystatus");
        String bidStatus = (String)map.get("bidstatus");
        if (StringUtils.isNotBlank((CharSequence)inquiryStatus) && statusList.contains(inquiryStatus)) {
            isChange4Inquiry = true;
        }
        if (StringUtils.isNotBlank((CharSequence)bidStatus) && statusList.contains(bidStatus)) {
            isChange4Bid = true;
        }
        if (!isChange4Inquiry && !isChange4Bid) {
            trackLog.endInfo("param status(pm_purapplybill) all out of range");
            log.info("param status(pm_purapplybill) all out of range");
            return false;
        }
        for (DynamicObject load : loads) {
            if (isChange4Inquiry) {
                load.set("inquirystatus", (Object)inquiryStatus);
            }
            if (!isChange4Bid) continue;
            load.set("bidstatus", (Object)bidStatus);
        }
        SaveServiceHelper.update((DynamicObject[])loads);
        return true;
    }

    @Override
    @Deprecated
    public boolean isSuppColla(Long suppID) {
        trackLog.startInfo(this.serialization(suppID));
        log.info("\u662f\u5426\u542f\u7528\u4f9b\u5e94\u5546\u534f\u540c\u63a5\u53e3\u53c2\u6570  --> " + suppID);
        if (suppID == null) {
            log.info("\u63a5\u53e3\u53c2\u6570\u4e3a\u7a7a");
            return false;
        }
        return SuppCollaHepler.isSuppColla(suppID);
    }

    @Override
    @Deprecated
    public boolean upApplyQuiryStatus(Map<String, Object> map) {
        trackLog.startInfo(this.serialization(map));
        log.info("\u66f4\u65b0\u91c7\u8d2d\u7533\u8bf7\u5355\u7684\u8be2\u4ef7\u72b6\u6001\u63a5\u53e3\u53c2\u6570  --> " + map);
        if (map == null || map.size() < 1) {
            log.info("\u63a5\u53e3\u53c2\u6570\u4e3a\u7a7a");
            return false;
        }
        List IDs = (List)map.get("ids");
        if (IDs == null || IDs.size() < 1) {
            log.info("\u63a5\u53e3\u53c2\u6570\u91c7\u8d2d\u7533\u8bf7\u5355ID\u4e3a\u7a7a");
            return false;
        }
        QFilter[] q = new QFilter[]{new QFilter("id", "in", (Object)IDs)};
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)"pm_purapplybill", (String)"id,inquirystatus,bidstatus", (QFilter[])q);
        if (loads == null || loads.length < 1) {
            trackLog.endInfo("ids(pm_purapplybill) no exist in database" + IDs);
            log.info("\u63a5\u53e3\u53c2\u6570\u5728\u91c7\u8d2d\u7533\u8bf7\u5355\u4e2d\u4e0d\u5b58\u5728  --> " + IDs);
            return false;
        }
        String status = (String)map.get("status");
        ArrayList<DynamicObject> purApplys = new ArrayList<DynamicObject>(loads.length);
        for (DynamicObject purApply : loads) {
            purApply.set("inquirystatus", (Object)status);
            purApplys.add(purApply);
        }
        SaveServiceHelper.save((DynamicObject[])purApplys.toArray(new DynamicObject[0]));
        log.info("\u66f4\u65b0\u91c7\u8d2d\u7533\u8bf7\u5355\u7684\u8be2\u4ef7\u72b6\u6001\u6210\u529f");
        return true;
    }

    @Override
    @Deprecated
    public boolean upApplyBidStatus(Map<String, Object> map) {
        trackLog.startInfo(this.serialization(map));
        log.info("\u66f4\u65b0\u91c7\u8d2d\u7533\u8bf7\u5355\u7684\u7ade\u4ef7\u72b6\u6001\u63a5\u53e3\u53c2\u6570  --> " + map);
        if (map == null || map.size() < 1) {
            log.info("\u63a5\u53e3\u53c2\u6570\u4e3a\u7a7a");
            return false;
        }
        List IDs = (List)map.get("ids");
        if (IDs == null || IDs.size() < 1) {
            log.info("\u63a5\u53e3\u53c2\u6570\u91c7\u8d2d\u7533\u8bf7\u5355ID\u4e3a\u7a7a");
            return false;
        }
        QFilter[] q = new QFilter[]{new QFilter("id", "in", (Object)IDs)};
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)"pm_purapplybill", (String)"id,inquirystatus,bidstatus", (QFilter[])q);
        if (loads == null || loads.length < 1) {
            trackLog.endInfo("ids(pm_purapplybill) no exist in database" + IDs);
            log.info("\u63a5\u53e3\u53c2\u6570\u5728\u91c7\u8d2d\u7533\u8bf7\u5355\u4e2d\u4e0d\u5b58\u5728  --> " + IDs);
            return false;
        }
        String status = (String)map.get("status");
        ArrayList<DynamicObject> purApplys = new ArrayList<DynamicObject>(loads.length);
        for (DynamicObject purApply : loads) {
            purApply.set("bidstatus", (Object)status);
            purApplys.add(purApply);
        }
        SaveServiceHelper.save((DynamicObject[])purApplys.toArray(new DynamicObject[0]));
        log.info("\u66f4\u65b0\u91c7\u8d2d\u7533\u8bf7\u5355\u7684\u7ade\u4ef7\u72b6\u6001");
        return true;
    }

    @Override
    @Deprecated
    public boolean upOrderConfirmStatus(Map<String, Object> map) {
        trackLog.startInfo(this.serialization(map));
        log.info("\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u7684\u786e\u8ba4\u72b6\u6001\u63a5\u53e3\u53c2\u6570  --> " + map);
        if (map == null || map.size() < 1) {
            log.info("\u63a5\u53e3\u53c2\u6570\u4e3a\u7a7a");
            return false;
        }
        List IDs = (List)map.get("ids");
        if (IDs == null || IDs.size() < 1) {
            log.info("\u63a5\u53e3\u53c2\u6570\u91c7\u8d2d\u8ba2\u5355ID\u4e3a\u7a7a");
            return false;
        }
        QFilter[] q = new QFilter[]{new QFilter("id", "in", (Object)IDs)};
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)"pm_purorderbill", (String)"id,confirmstatus,logisticsstatus,paystatus", (QFilter[])q);
        if (loads == null || loads.length < 1) {
            trackLog.endInfo("ids(pm_purorderbill) no exist in database" + IDs);
            log.info("\u63a5\u53e3\u53c2\u6570\u5728\u91c7\u8d2d\u8ba2\u5355\u4e2d\u4e0d\u5b58\u5728  --> " + IDs);
            return false;
        }
        String status = (String)map.get("status");
        ArrayList<DynamicObject> purOrders = new ArrayList<DynamicObject>(loads.length);
        for (DynamicObject purOrder : loads) {
            purOrder.set("confirmstatus", (Object)status);
            purOrders.add(purOrder);
        }
        SaveServiceHelper.save((DynamicObject[])purOrders.toArray(new DynamicObject[0]));
        log.info("\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u7684\u786e\u8ba4\u72b6\u6001");
        return true;
    }

    @Override
    @Deprecated
    public boolean upChangeConfirmStatus(Map<String, Object> map) {
        trackLog.startInfo(this.serialization(map));
        log.info("\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u53d8\u66f4\u7684\u786e\u8ba4\u72b6\u6001\u63a5\u53e3\u53c2\u6570  --> " + map);
        if (map == null || map.size() < 1) {
            log.info("\u63a5\u53e3\u53c2\u6570\u4e3a\u7a7a");
            return false;
        }
        List IDs = (List)map.get("ids");
        if (IDs == null || IDs.size() < 1) {
            log.info("\u63a5\u53e3\u53c2\u6570\u91c7\u8d2d\u8ba2\u5355\u53d8\u66f4ID\u4e3a\u7a7a");
            return false;
        }
        QFilter[] q = new QFilter[]{new QFilter("id", "in", (Object)IDs)};
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)"pm_xpurorderbill", (String)"id,confirmstatus,logisticsstatus,paystatus", (QFilter[])q);
        if (loads == null || loads.length < 1) {
            trackLog.endInfo("ids(pm_xpurorderbill) no exist in database" + IDs);
            log.info("\u63a5\u53e3\u53c2\u6570\u5728\u91c7\u8d2d\u8ba2\u5355\u53d8\u66f4\u4e2d\u4e0d\u5b58\u5728  --> " + IDs);
            return false;
        }
        String status = (String)map.get("status");
        ArrayList<DynamicObject> purChanges = new ArrayList<DynamicObject>(loads.length);
        for (DynamicObject purChange : loads) {
            purChange.set("confirmstatus", (Object)status);
            purChanges.add(purChange);
        }
        SaveServiceHelper.save((DynamicObject[])purChanges.toArray(new DynamicObject[0]));
        log.info("\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u53d8\u66f4\u7684\u786e\u8ba4\u72b6\u6001");
        return true;
    }

    @Override
    @Deprecated
    public boolean upRefundConfirmStatus(Map<String, Object> map) {
        trackLog.startInfo(this.serialization(map));
        log.info("\u66f4\u65b0\u91c7\u8d2d\u9000\u8d27\u7533\u8bf7\u7684\u786e\u8ba4\u72b6\u6001\u63a5\u53e3\u53c2\u6570  --> " + map);
        if (map == null || map.size() < 1) {
            log.info("\u63a5\u53e3\u53c2\u6570\u4e3a\u7a7a");
            return false;
        }
        List IDs = (List)map.get("ids");
        if (IDs == null || IDs.size() < 1) {
            log.info("\u63a5\u53e3\u53c2\u6570\u91c7\u8d2d\u9000\u8d27\u7533\u8bf7ID\u4e3a\u7a7a");
            return false;
        }
        QFilter[] q = new QFilter[]{new QFilter("id", "in", (Object)IDs)};
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)"pm_purrefundapplybill", (String)"id,confirmstatus,logisticsstatus,paystatus", (QFilter[])q);
        if (loads == null || loads.length < 1) {
            trackLog.endInfo("ids(pm_purrefundapplybill) no exist in database" + IDs);
            log.info("\u63a5\u53e3\u53c2\u6570\u5728\u91c7\u8d2d\u9000\u8d27\u7533\u8bf7\u4e2d\u4e0d\u5b58\u5728  --> " + IDs);
            return false;
        }
        String status = (String)map.get("status");
        ArrayList<DynamicObject> purRefunds = new ArrayList<DynamicObject>(loads.length);
        for (DynamicObject purRefund : loads) {
            purRefund.set("confirmstatus", (Object)status);
            purRefunds.add(purRefund);
        }
        SaveServiceHelper.save((DynamicObject[])purRefunds.toArray(new DynamicObject[0]));
        log.info("\u66f4\u65b0\u91c7\u8d2d\u9000\u8d27\u7533\u8bf7\u7684\u786e\u8ba4\u72b6\u6001\u7ed3\u679c");
        return true;
    }

    @Override
    @Deprecated
    public boolean upLogisticsStatus(Map<String, Object> map) {
        trackLog.startInfo(this.serialization(map));
        log.info("\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u7684\u7269\u6d41\u72b6\u6001\u63a5\u53e3\u53c2\u6570  --> " + map);
        if (map == null || map.size() < 1) {
            log.info("\u63a5\u53e3\u53c2\u6570\u4e3a\u7a7a");
            return false;
        }
        List IDs = (List)map.get("ids");
        if (IDs == null || IDs.size() < 1) {
            log.info("\u63a5\u53e3\u53c2\u6570\u91c7\u8d2d\u8ba2\u5355ID\u4e3a\u7a7a");
            return false;
        }
        QFilter[] q = new QFilter[]{new QFilter("id", "in", (Object)IDs)};
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)"pm_purorderbill", (String)"id,confirmstatus,logisticsstatus,paystatus", (QFilter[])q);
        if (loads == null || loads.length < 1) {
            trackLog.endInfo("ids(pm_purorderbill) no exist in database" + IDs);
            log.info("\u63a5\u53e3\u53c2\u6570\u5728\u91c7\u8d2d\u8ba2\u5355\u4e2d\u4e0d\u5b58\u5728  --> " + IDs);
            return false;
        }
        String status = (String)map.get("status");
        ArrayList<DynamicObject> purOrders = new ArrayList<DynamicObject>(loads.length);
        for (DynamicObject purOrder : loads) {
            purOrder.set("logisticsstatus", (Object)status);
            purOrders.add(purOrder);
        }
        Object[] save = SaveServiceHelper.save((DynamicObject[])purOrders.toArray(new DynamicObject[0]));
        log.info("\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u7684\u7269\u6d41\u72b6\u6001\u7ed3\u679c --> " + Arrays.toString(save));
        return true;
    }

    @Override
    @Deprecated
    public boolean upPayStatus(Map<String, Object> map) {
        trackLog.startInfo(this.serialization(map));
        log.info("\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u7684\u4ed8\u6b3e\u72b6\u6001\u63a5\u53e3\u53c2\u6570  --> " + map);
        if (map == null || map.size() < 1) {
            log.info("\u63a5\u53e3\u53c2\u6570\u4e3a\u7a7a");
            return false;
        }
        List IDs = (List)map.get("ids");
        if (IDs == null || IDs.size() < 1) {
            log.info("\u63a5\u53e3\u53c2\u6570\u91c7\u8d2d\u8ba2\u5355ID\u4e3a\u7a7a");
            return false;
        }
        QFilter[] q = new QFilter[]{new QFilter("id", "in", (Object)IDs)};
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)"pm_purorderbill", (String)"id,confirmstatus,logisticsstatus,paystatus", (QFilter[])q);
        if (loads == null || loads.length < 1) {
            trackLog.endInfo("ids(pm_purorderbill) no exist in database" + IDs);
            log.info("\u63a5\u53e3\u53c2\u6570\u5728\u91c7\u8d2d\u8ba2\u5355\u4e2d\u4e0d\u5b58\u5728  --> " + IDs);
            return false;
        }
        String status = (String)map.get("status");
        ArrayList<DynamicObject> purOrders = new ArrayList<DynamicObject>(loads.length);
        for (DynamicObject purOrder : loads) {
            purOrder.set("paystatus", (Object)status);
            purOrders.add(purOrder);
        }
        Object[] save = SaveServiceHelper.save((DynamicObject[])purOrders.toArray(new DynamicObject[0]));
        log.info("\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u7684\u4ed8\u6b3e\u72b6\u6001\u7ed3\u679c --> " + Arrays.toString(save));
        return true;
    }

    @Override
    @Deprecated
    public boolean upOrderStatus(Map<String, Object> map) {
        trackLog.startInfo(this.serialization(map));
        log.info("\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u7684\u786e\u8ba4\u7269\u6d41\u72b6\u6001\u63a5\u53e3\u53c2\u6570  --> " + map);
        if (map == null || map.size() < 1) {
            log.info("\u63a5\u53e3\u53c2\u6570\u4e3a\u7a7a");
            return false;
        }
        List IDs = (List)map.get("ids");
        if (IDs == null || IDs.size() < 1) {
            log.info("\u63a5\u53e3\u53c2\u6570\u91c7\u8d2d\u8ba2\u5355ID\u4e3a\u7a7a");
            return false;
        }
        QFilter[] q = new QFilter[]{new QFilter("id", "in", (Object)IDs)};
        DynamicObject[] loads = BusinessDataServiceHelper.load((String)"pm_purorderbill", (String)"id,confirmstatus,logisticsstatus,paystatus", (QFilter[])q);
        if (loads == null || loads.length < 1) {
            trackLog.endInfo("ids(pm_purorderbill no exist in database)" + IDs);
            log.info("\u63a5\u53e3\u53c2\u6570\u5728\u91c7\u8d2d\u8ba2\u5355\u4e2d\u4e0d\u5b58\u5728  --> " + IDs);
            return false;
        }
        String cfmStatus = (String)map.get("cfmstatus");
        String logStatus = (String)map.get("logstatus");
        ArrayList<DynamicObject> purOrders = new ArrayList<DynamicObject>(loads.length);
        for (DynamicObject purOrder : loads) {
            purOrder.set("confirmstatus", (Object)cfmStatus);
            purOrder.set("logisticsstatus", (Object)logStatus);
            purOrders.add(purOrder);
        }
        SaveServiceHelper.save((DynamicObject[])purOrders.toArray(new DynamicObject[0]));
        log.info("\u66f4\u65b0\u91c7\u8d2d\u8ba2\u5355\u7684\u786e\u8ba4\u7269\u6d41\u72b6\u6001\u7ed3\u679c");
        return true;
    }

    private String serialization(Object o) {
        String jsonString = "";
        if (o == null) {
            jsonString = "param is null";
        } else if (o instanceof Map || o instanceof List) {
            jsonString = SerializationUtils.toJsonString((Object)o);
        } else if (o instanceof Long) {
            jsonString = String.valueOf(o);
        }
        return jsonString;
    }
}

