/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.pur.formplugin.wb;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.botp.plugin.AbstractWriteBackPlugIn;
import kd.bos.entity.botp.plugin.args.AfterSaveSourceBillEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeReadSourceBillEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class PurReplenreq2PurOrderWriteBackPlugin
extends AbstractWriteBackPlugIn {
    public void beforeReadSourceBill(BeforeReadSourceBillEventArgs e) {
        super.beforeReadSourceBill(e);
        String opType = this.getOpType();
        if ("pur_replenishreq".equals(e.getSrcMainType().getName()) && "audit".equalsIgnoreCase(opType)) {
            e.getFieldKeys().add("orderstatus");
            e.getFieldKeys().add("entryentity.baseqty");
            e.getFieldKeys().add("entryentity.orderedbaseqty");
        } else if ("pur_replenishreq".equals(e.getSrcMainType().getName()) && "unaudit".equalsIgnoreCase(opType)) {
            e.getFieldKeys().add("orderstatus");
            e.getFieldKeys().add("entryentity.baseqty");
            e.getFieldKeys().add("entryentity.orderedbaseqty");
        }
    }

    public void afterSaveSourceBill(AfterSaveSourceBillEventArgs e) {
        super.afterSaveSourceBill(e);
        BillEntityType srcSubMainType = e.getSrcSubMainType();
        String opType = this.getOpType();
        if ("pur_replenishreq".equals(srcSubMainType.getName())) {
            DynamicObject[] srcDataEntities = e.getSrcDataEntities();
            HashSet<Long> idSet = new HashSet<Long>(1024);
            for (DynamicObject dyn : srcDataEntities) {
                idSet.add(dyn.getLong("id"));
            }
            QFilter qFilter = new QFilter("id", "in", idSet);
            DynamicObject[] purReplenishreq = BusinessDataServiceHelper.load((String)"pur_replenishreq", (String)"orderstatus,entryentity.baseqty,entryentity.orderedbaseqty", (QFilter[])qFilter.toArray());
            ArrayList<DynamicObject> bills = new ArrayList<DynamicObject>(1024);
            for (DynamicObject dyn : purReplenishreq) {
                DynamicObjectCollection entrys = dyn.getDynamicObjectCollection("entryentity");
                boolean isPart = false;
                boolean isAll = false;
                for (DynamicObject row : entrys) {
                    BigDecimal baseqty = row.getBigDecimal("baseqty");
                    BigDecimal orderedbaseqty = row.getBigDecimal("orderedbaseqty");
                    if (!"audit".equalsIgnoreCase(opType) && !"unaudit".equalsIgnoreCase(opType) || orderedbaseqty.compareTo(BigDecimal.ZERO) <= 0) continue;
                    if (orderedbaseqty.compareTo(baseqty) >= 0) {
                        isAll = true;
                        continue;
                    }
                    isPart = true;
                    break;
                }
                if (!"audit".equalsIgnoreCase(opType) && !"unaudit".equalsIgnoreCase(opType)) continue;
                if (isPart) {
                    dyn.set("orderstatus", (Object)"B");
                    bills.add(dyn);
                    continue;
                }
                if (isAll) {
                    dyn.set("orderstatus", (Object)"C");
                    bills.add(dyn);
                    continue;
                }
                dyn.set("orderstatus", (Object)"A");
                bills.add(dyn);
            }
            if (bills.size() > 0) {
                SaveServiceHelper.save((DynamicObject[])bills.toArray(new DynamicObject[bills.size()]));
            }
        }
    }
}

