/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;

public class CommonUtils {
    private CommonUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean isNull(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String && ((String)o).length() == 0) {
            return true;
        }
        if (o instanceof StringBuffer && ((StringBuffer)o).length() == 0) {
            return true;
        }
        if (o instanceof List && ((List)o).isEmpty()) {
            return true;
        }
        if (o instanceof Collection && ((Collection)o).isEmpty()) {
            return true;
        }
        if (o instanceof Object[] && ((Object[])o).length == 0) {
            return true;
        }
        return o instanceof Map && ((Map)o).size() == 0;
    }

    public static boolean isRealChanged(ChangeData changeSet) {
        if (changeSet == null) {
            return false;
        }
        Object oldObject = changeSet.getOldValue();
        Object newObject = changeSet.getNewValue();
        return CommonUtils.isRealChanged(oldObject, newObject);
    }

    public static boolean isRealChanged(Object oldObject, Object newObject) {
        if (oldObject == null && newObject == null) {
            return true;
        }
        if (oldObject == null) {
            return true;
        }
        if (newObject == null) {
            return true;
        }
        if (oldObject instanceof BigDecimal) {
            if (newObject instanceof BigDecimal && ((BigDecimal)oldObject).compareTo((BigDecimal)newObject) != 0) {
                return true;
            }
            if (newObject instanceof String && ((BigDecimal)oldObject).compareTo(new BigDecimal(newObject.toString())) != 0) {
                return true;
            }
        } else if (oldObject.getClass().isAssignableFrom(newObject.getClass())) {
            if (newObject instanceof DynamicObject) {
                if (!((DynamicObject)newObject).getPkValue().equals(((DynamicObject)oldObject).getPkValue())) {
                    return true;
                }
            } else if (newObject instanceof OrmLocaleValue) {
                if (!oldObject.toString().equals(newObject.toString())) {
                    return true;
                }
            } else {
                return !oldObject.equals(newObject);
            }
        }
        return false;
    }

    public static String getCodeErrorMessage(ErrorCode errorCode) {
        KDException kde = new KDException(errorCode, new Object[0]);
        return kde.getMessage();
    }

    public static String getCodeErrorMessage(ErrorCode errorCode, Object ... args) {
        KDException kde = new KDException(errorCode, args);
        return kde.getMessage();
    }

    public static String serializerDynamicObjectList(List<DynamicObject> list, IDataEntityType dt) {
        if (CommonUtils.isNull(list)) {
            return null;
        }
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        String[] ss = DataEntitySerializer.serializerToListString((IDataEntityType)dt, list, (DataEntitySerializerOption)option);
        return SerializationUtils.toJsonString((Object)ss);
    }

    public static List<DynamicObject> deserializerDynamicObjectList(List<DynamicObject> list, IDataEntityType dt, String s) {
        String[] ss = (String[])SerializationUtils.fromJsonString((String)s, String[].class);
        DataEntitySerializer.deserializerFromListString(list, (IDataEntityType)dt, (String[])ss);
        return list;
    }

    public static List<Long> getIdList(DynamicObjectCollection colls) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (DynamicObject obj : colls) {
            idList.add(obj.getLong("id"));
        }
        return idList;
    }
}

