/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report;

import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.pm.business.helper.AppParameterHelper;
import kd.scmc.pm.report.helper.PurReceivingRptHelper;

public class PmReceivingPlanRptQuery
extends AbstractReportListDataPlugin {
    private static final Log log = LogFactory.getLog(PurReceivingRptHelper.class);

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        QFilter billStatus = new QFilter("billstatus", "=", (Object)"C");
        QFilter changeStatus = new QFilter("changestatus", "!=", (Object)"B");
        List<QFilter> filters = PurReceivingRptHelper.getFilters(filterInfo);
        filters.add(billStatus);
        filters.add(changeStatus);
        DynamicObject org = filterInfo.getDynamicObject("purorg");
        QFilter q = null;
        List<Long> orgGrpList = PurReceivingRptHelper.getOperatorGroupByOrg(Long.parseLong(org.getPkValue().toString()));
        Object operatorGroupIsolate = AppParameterHelper.getPmAppParameter((Long)Long.parseLong(org.getPkValue().toString()), (String)"foperatorgroupisolate");
        if (operatorGroupIsolate instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue()) {
            QFilter q3;
            QFilter q2;
            long userId = UserServiceHelper.getCurrentUserId();
            List<Long> userGrpList = PurReceivingRptHelper.getOperatorGroupByUser(userId);
            List<Long> grpList = PurReceivingRptHelper.getValidOperatorGroup(orgGrpList, userGrpList);
            q = grpList != null && grpList.size() > 0 ? (q2 = new QFilter("operatorgroup", "in", grpList)) : (q3 = new QFilter("operatorgroup", "=", (Object)0));
        } else if (orgGrpList != null && orgGrpList.size() > 0) {
            QFilter q4;
            orgGrpList.add(0L);
            q = q4 = new QFilter("operatorgroup", "in", orgGrpList);
        } else {
            QFilter q5;
            q = q5 = new QFilter("operatorgroup", "=", (Object)0);
        }
        filters.add(q);
        String selectField = PurReceivingRptHelper.getSelectField();
        DataSet smSalorder = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_purorderbill", (String)selectField, (QFilter[])filters.toArray(new QFilter[filters.size()]), null);
        DataSet finish1 = smSalorder.groupBy(new String[]{"entry_supplier", "suppliername", "entry_material", "entry_operator", "materialname", "entry_operategroup"}).count().finish();
        DataSet select = smSalorder.select(new String[]{"ontimenum", "entry_supplier", "suppliername", "entry_material", "entry_operator", "overduenum", "unfinishnum", "materialname", "entry_operategroup"});
        DataSet finish = select.groupBy(new String[]{"entry_supplier", "suppliername", "entry_material", "entry_operator", "materialname", "entry_operategroup"}).sum("ontimenum").sum("overduenum").sum("unfinishnum").finish();
        finish = finish.join(finish1, JoinType.LEFT).on("entry_supplier", "entry_supplier").on("suppliername", "suppliername").on("entry_material", "entry_material").on("materialname", "materialname").on("entry_operator", "entry_operator").on("entry_operategroup", "entry_operategroup").select(new String[]{"count as plantodelivernum", "entry_supplier", "suppliername", "entry_material", "materialname", "entry_operator", "ontimenum", "overduenum", "unfinishnum", "entry_operategroup"}).finish();
        return finish.select(this.getShowFields());
    }

    private String getShowFields() {
        return "entry_supplier,suppliername,entry_material,materialname,entry_operator,entry_operategroup,ontimenum,plantodelivernum,overduenum,unfinishnum,(ontimenum + overduenum) * 100.0 / plantodelivernum * 1.0  as finnishrate";
    }
}

