/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.pm.enums.StatusEnum;
import kd.scmc.pm.report.helper.PurApplyRptHelper;
import kd.scmc.pm.utils.DateUtil;

public class PurApplyRptQuery
extends AbstractReportListDataPlugin {
    private QFilter auditFilter = new QFilter("billstatus", "=", (Object)StatusEnum.AUDIT.getValue());
    private QFilter qtyLessThanZeroFilter = new QFilter("billentry.qty", "<", (Object)BigDecimal.ZERO);
    private QFilter isVirtualBillFilter = new QFilter("isvirtualbill", "=", (Object)Boolean.FALSE);

    public DataSet query(ReportQueryParam reportQueryParam, Object o) {
        FilterInfo filterInfo = reportQueryParam.getFilter();
        List<QFilter> filters = PurApplyRptHelper.getFilters(filterInfo);
        Date startDate = filterInfo.getDate("startdate");
        QFilter startDateFilter = new QFilter("biztime", ">=", (Object)DateUtil.getStartOrEndDate((Date)startDate, (boolean)false));
        DataSet allPr2PoDataSet = this.getAllPr2PoDataSet(filters, startDateFilter);
        DataSet all2ReturnDateSet = this.getAll2ReturnDataSet(startDateFilter);
        DataSet result = allPr2PoDataSet.leftJoin(all2ReturnDateSet).on("poid", "poid").select(new String[]{"purrecnocbillno", "purrecnocqty", "purrecnocunit", "org", "billno", "billtype", "biztime", "dept", "bizuser", "auxpty", "materialmasterid", "unit", "applyqty", "qty", "project", "conmbillno", "conmunit", "conmqty", "conmbiztime", "pobillno", "pounit", "poqty", "pobiztime", "supplier", "purinbillno", "purinunit", "purinqty", "returnbillno", "returnunit", "returnqty", "refundapplyno", "refundapplyunit", "refundapplyqty", "purreceivebillno", "purreceiveunit", "purreceiveqty"}).finish();
        result = result.select(this.getShowField());
        return result;
    }

    private DataSet getAll2ReturnDataSet(QFilter startDateFilter) {
        DataSet purRNPurRec2PurRetrun = this.getPurRNPurRec2PurRetrun(startDateFilter);
        DataSet purRec2PurRetrun = this.getPurRec2PurRetrun(startDateFilter);
        DataSet purIn2PurRetrun = this.getPurIn2PurRetrun(startDateFilter);
        DataSet purRefund2PurRetrun = this.getPurRefund2PurRetrun(startDateFilter);
        return purRec2PurRetrun.union(purIn2PurRetrun).union(purRefund2PurRetrun).union(purRNPurRec2PurRetrun);
    }

    private DataSet getPurIn2PurRetrun(QFilter startDateFilter) {
        QFilter po2PurInFilter = new QFilter("billentry.srcbillentity", "=", (Object)"pm_purorderbill");
        DataSet po2PurIn = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_purinbill", (String)PurApplyRptHelper.getSelectField2returnBill(), (QFilter[])new QFilter[]{this.auditFilter, po2PurInFilter, startDateFilter}, null);
        QFilter purIn2PurReturnFilter = new QFilter("billentry.srcbillentity", "=", (Object)"im_purinbill");
        DataSet purIn2PurReturn = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_purinbill", (String)PurApplyRptHelper.getSelectField2returnorderbill(), (QFilter[])new QFilter[]{this.auditFilter, purIn2PurReturnFilter, this.qtyLessThanZeroFilter, this.isVirtualBillFilter, startDateFilter}, null);
        DataSet purIn2PurReturnDataSet = po2PurIn.leftJoin(purIn2PurReturn).on("purinid", "srcbillid").select(new String[]{"returnbillno", "returnqty", "returnunit", "purinbillno", "purinqty", "purinunit", "poid"}).finish();
        purIn2PurReturnDataSet = purIn2PurReturnDataSet.addNullField(new String[]{"purrecnocbillno", "purrecnocqty", "purrecnocunit"});
        purIn2PurReturnDataSet = purIn2PurReturnDataSet.addNullField(new String[]{"refundapplyno", "refundapplyqty", "refundapplyunit"});
        purIn2PurReturnDataSet = purIn2PurReturnDataSet.addNullField(new String[]{"purreceivebillno", "purreceiveqty", "purreceiveunit"});
        purIn2PurReturnDataSet = purIn2PurReturnDataSet.select(new String[]{"purrecnocbillno", "purrecnocqty", "purrecnocunit", "purinbillno", "purinqty", "purinunit", "purreceivebillno", "purreceiveqty", "purreceiveunit", "returnbillno", "returnqty", "returnunit", "poid", "refundapplyno", "refundapplyqty", "refundapplyunit"});
        return purIn2PurReturnDataSet;
    }

    private DataSet getPurRefund2PurRetrun(QFilter startDateFilter) {
        QFilter po2PurReFundFilter = new QFilter("billentry.srcbillentity", "=", (Object)"pm_purorderbill");
        DataSet refundApply4PurOrder = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_purrefundapplybill", (String)PurApplyRptHelper.getSelectField2ReFundApply(), (QFilter[])new QFilter[]{this.auditFilter, po2PurReFundFilter, startDateFilter}, null);
        QFilter purRefund2PurRetrunFilter = new QFilter("billentry.srcbillentity", "=", (Object)"pm_purrefundapplybill");
        DataSet purRefund2PurRetrun = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_purinbill", (String)PurApplyRptHelper.getSelectField2returnorderbill(), (QFilter[])new QFilter[]{this.auditFilter, purRefund2PurRetrunFilter, this.qtyLessThanZeroFilter, this.isVirtualBillFilter, startDateFilter}, null);
        DataSet refund2PurReturnDataSet = refundApply4PurOrder.leftJoin(purRefund2PurRetrun).on("refunid", "srcbillid").select(new String[]{"refundapplyno", "refundapplyqty", "refundapplyunit", "returnbillno", "returnqty", "returnunit", "poid"}).finish();
        refund2PurReturnDataSet = refund2PurReturnDataSet.addNullField(new String[]{"purrecnocbillno", "purrecnocqty", "purrecnocunit"});
        refund2PurReturnDataSet = refund2PurReturnDataSet.addNullField(new String[]{"purinbillno", "purinqty", "purinunit"});
        refund2PurReturnDataSet = refund2PurReturnDataSet.addNullField(new String[]{"purreceivebillno", "purreceiveqty", "purreceiveunit"});
        refund2PurReturnDataSet = refund2PurReturnDataSet.select(new String[]{"purrecnocbillno", "purrecnocqty", "purrecnocunit", "purinbillno", "purinqty", "purinunit", "purreceivebillno", "purreceiveqty", "purreceiveunit", "returnbillno", "returnqty", "returnunit", "poid", "refundapplyno", "refundapplyqty", "refundapplyunit"});
        return refund2PurReturnDataSet;
    }

    private DataSet getPurRNPurRec2PurRetrun(QFilter startDateFilter) {
        QFilter PurPNFilter = new QFilter("billentry.srcbillentity", "=", (Object)"pm_purorderbill");
        DataSet purPurRN = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_receiptnotice", (String)PurApplyRptHelper.getSelectField2PurReceiveNotice(), (QFilter[])new QFilter[]{this.auditFilter, PurPNFilter, startDateFilter}, null);
        QFilter po2PurRecFilter = new QFilter("billentry.srcbillentity", "=", (Object)"pm_receiptnotice");
        DataSet po2PurRec = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_purreceivebill", (String)PurApplyRptHelper.getSelectField2PurReceivebill(), (QFilter[])new QFilter[]{this.auditFilter, po2PurRecFilter, startDateFilter}, null);
        QFilter purRec2PurInFilter = new QFilter("billentry.srcbillentity", "=", (Object)"im_purreceivebill");
        DataSet purRec2PurIn = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_purinbill", (String)PurApplyRptHelper.getSelectField2inorderbill(), (QFilter[])new QFilter[]{this.auditFilter, purRec2PurInFilter, startDateFilter}, null);
        QFilter purIn2PurRetrunFilter = new QFilter("billentry.srcbillentity", "=", (Object)"im_purinbill");
        DataSet purIn2PurRetrun = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_purinbill", (String)PurApplyRptHelper.getSelectField2returnorderbill(), (QFilter[])new QFilter[]{this.auditFilter, purIn2PurRetrunFilter, this.qtyLessThanZeroFilter, this.isVirtualBillFilter, startDateFilter}, null);
        DataSet purRecNocLeftJoinPurInDataSet = purPurRN.leftJoin(po2PurRec).on("purrnid", "srcbillid").select(new String[]{"purrecnocbillno", "purrecnocqty", "purrecnocunit", "purreceivebillno", "purreceiveqty", "purreceiveunit", "purreceiveid", "poid"}).finish();
        DataSet purRecLeftJoinPurInDataSet = purRecNocLeftJoinPurInDataSet.leftJoin(purRec2PurIn).on("purreceiveid", "pojoinpurrecid").select(new String[]{"purrecnocbillno", "purrecnocqty", "purrecnocunit", "purinbillno", "purinqty", "purinunit", "purreceivebillno", "purreceiveqty", "purreceiveunit", "purinid", "poid"}).finish();
        DataSet purRec2PurReturnDataSet = purRecLeftJoinPurInDataSet.leftJoin(purIn2PurRetrun).on("purinid", "srcbillid").select(new String[]{"purrecnocbillno", "purrecnocqty", "purrecnocunit", "purinbillno", "purinqty", "purinunit", "purreceivebillno", "purreceiveqty", "purreceiveunit", "returnbillno", "returnqty", "returnunit", "poid"}).finish();
        purRec2PurReturnDataSet = purRec2PurReturnDataSet.addNullField(new String[]{"refundapplyno", "refundapplyqty", "refundapplyunit"});
        purRec2PurReturnDataSet = purRec2PurReturnDataSet.select(new String[]{"purrecnocbillno", "purrecnocqty", "purrecnocunit", "purinbillno", "purinqty", "purinunit", "purreceivebillno", "purreceiveqty", "purreceiveunit", "returnbillno", "returnqty", "returnunit", "poid", "refundapplyno", "refundapplyqty", "refundapplyunit"});
        return purRec2PurReturnDataSet;
    }

    private DataSet getPurRec2PurRetrun(QFilter startDateFilter) {
        QFilter po2PurRecFilter = new QFilter("billentry.srcbillentity", "=", (Object)"pm_purorderbill");
        DataSet po2PurRec = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_purreceivebill", (String)PurApplyRptHelper.getSelectField2PurReceivebill(), (QFilter[])new QFilter[]{this.auditFilter, po2PurRecFilter, startDateFilter}, null);
        QFilter purRec2PurInFilter = new QFilter("billentry.srcbillentity", "=", (Object)"im_purreceivebill");
        DataSet purRec2PurIn = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_purinbill", (String)PurApplyRptHelper.getSelectField2inorderbill(), (QFilter[])new QFilter[]{this.auditFilter, purRec2PurInFilter, startDateFilter}, null);
        QFilter purIn2PurRetrunFilter = new QFilter("billentry.srcbillentity", "=", (Object)"im_purinbill");
        DataSet purIn2PurRetrun = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"im_purinbill", (String)PurApplyRptHelper.getSelectField2returnorderbill(), (QFilter[])new QFilter[]{this.auditFilter, purIn2PurRetrunFilter, this.qtyLessThanZeroFilter, this.isVirtualBillFilter, startDateFilter}, null);
        DataSet purRecLeftJoinPurInDataSet = po2PurRec.leftJoin(purRec2PurIn).on("purreceiveid", "pojoinpurrecid").select(new String[]{"purinbillno", "purinqty", "purinunit", "purreceivebillno", "purreceiveqty", "purreceiveunit", "purinid", "poid"}).finish().select(new String[]{"purinbillno", "purinqty", "purinunit", "purreceivebillno", "purreceiveqty", "purreceiveunit", "purinid", "poid"});
        DataSet purRec2PurReturnDataSet = purRecLeftJoinPurInDataSet.leftJoin(purIn2PurRetrun).on("purinid", "srcbillid").select(new String[]{"purinbillno", "purinqty", "purinunit", "purreceivebillno", "purreceiveqty", "purreceiveunit", "returnbillno", "returnqty", "returnunit", "poid"}).finish();
        purRec2PurReturnDataSet = purRec2PurReturnDataSet.addNullField(new String[]{"purrecnocbillno", "purrecnocqty", "purrecnocunit"});
        purRec2PurReturnDataSet = purRec2PurReturnDataSet.addNullField(new String[]{"refundapplyno", "refundapplyqty", "refundapplyunit"});
        purRec2PurReturnDataSet = purRec2PurReturnDataSet.select(new String[]{"purrecnocbillno", "purrecnocqty", "purrecnocunit", "purinbillno", "purinqty", "purinunit", "purreceivebillno", "purreceiveqty", "purreceiveunit", "returnbillno", "returnqty", "returnunit", "poid", "refundapplyno", "refundapplyqty", "refundapplyunit"});
        return purRec2PurReturnDataSet;
    }

    private DataSet getAllPr2PoDataSet(List<QFilter> filters, QFilter startDateFilter) {
        String algoKey = ((Object)((Object)this)).getClass().getName();
        DataSet purApply = QueryServiceHelper.queryDataSet((String)algoKey, (String)"pm_purapplybill", (String)PurApplyRptHelper.getPurApplyFields(), (QFilter[])filters.toArray(new QFilter[filters.size()]), null);
        QFilter fromPRFilter = new QFilter("billentry.srcbillentity", "=", (Object)"pm_purapplybill");
        DataSet pr2Conm = QueryServiceHelper.queryDataSet((String)algoKey, (String)"conm_purcontract", (String)PurApplyRptHelper.getSelectField2Conm(), (QFilter[])new QFilter[]{this.auditFilter, fromPRFilter, startDateFilter}, null);
        QFilter fromConmFilter = new QFilter("billentry.srcbillentity", "=", (Object)"conm_purcontract");
        String selectField2orderbill = PurApplyRptHelper.getSelectField2orderbill();
        DataSet conm2PO = QueryServiceHelper.queryDataSet((String)algoKey, (String)"pm_purorderbill", (String)selectField2orderbill, (QFilter[])new QFilter[]{this.auditFilter, fromConmFilter, startDateFilter}, null);
        DataSet pr2Conm2Po = pr2Conm.join(conm2PO, JoinType.LEFT).on("conmid", "srcbillid").select(new String[]{"pobillno", "poqty", "pounit", "pobiztime", "posupplier", "conmbillno", "conmbiztime", "conmqty", "conmunit", "srcbillid", "conmid", "poid"}).finish();
        DataSet pr2PO = QueryServiceHelper.queryDataSet((String)algoKey, (String)"pm_purorderbill", (String)selectField2orderbill, (QFilter[])new QFilter[]{this.auditFilter, fromPRFilter, startDateFilter}, null);
        pr2PO = pr2PO.addNullField(new String[]{"conmbillno", "conmbiztime", "conmqty", "conmunit", "conmid"});
        pr2PO = pr2PO.select(new String[]{"pobillno", "poqty", "pounit", "pobiztime", "posupplier", "conmbillno", "conmbiztime", "conmqty", "conmunit", "srcbillid", "conmid", "poid"});
        pr2Conm2Po = pr2Conm2Po.union(pr2PO);
        DataSet allPr2Po = purApply.join(pr2Conm2Po, JoinType.LEFT).on("purapplyid", "srcbillid").select(new String[]{"id", "org", "billno", "auxpty", "billtype", "biztime", "dept", "bizuser", "materialmasterid", "unit", "applyqty", "qty", "project"}, new String[]{"pobillno", "poqty", "pounit", "pobiztime", "posupplier as supplier", "conmbillno", "conmbiztime", "conmqty", "conmunit", "poid"}).finish();
        return allPr2Po;
    }

    private String getShowField() {
        return "org, billno, billtype, biztime, dept, bizuser, materialmasterid,auxpty,unit, applyqty, qty, project, conmbillno as conmno, conmunit, conmqty,  conmbiztime, pobillno as purorderbillno, pounit as orderunit, poqty as purorderqty, pobiztime as purorderbizdate, supplier, purinbillno, purinunit, purinqty, returnbillno, returnunit, returnqty * -1 as returnqty, refundapplyno, refundapplyunit, refundapplyqty, purreceivebillno, purreceiveunit, purreceiveqty,purrecnocbillno,purrecnocqty,purrecnocunit";
    }
}

