/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.scmc.pm.business.helper.OrgHelper;
import kd.scmc.pm.enums.StatusEnum;

public class PurResourceAnalyzeRptPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final String QUOTA_ASSIGN = "pm_quotaassign";
    private static final String QUOTA_ASSIGN_ORG = "org";
    private static final String QUOTA_ASSIGN_MATERIAL = "material";
    private static final String QUOTA_ASSIGN_QUOTA = "quota";
    private static final String QUOTA_SCHEME_SUB_ENTRY_ENTITY = "subentryentity";
    private static final String PUR_PRICE_ORG = "org";
    private static final String PUR_PRICE_STATUS = "status";
    private static final String PUR_PRICE_MATERIAL = "priceentryentity.material";
    private static final String PUR_PRICE_EFFECT_DATE = "priceentryentity.priceeffectdate";
    private static final String PUR_PRICE_EXPIRY_DATE = "priceentryentity.priceexpirydate";

    public void registerListener(EventObject e) {
        BasedataEdit materiel;
        super.registerListener(e);
        IFormView view = this.getView();
        BasedataEdit org = (BasedataEdit)view.getControl("orgfield");
        if (org != null) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((materiel = (BasedataEdit)view.getControl("materielfield")) != null) {
            materiel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Long defaultOrg;
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("orgfield");
        if (org == null && (defaultOrg = OrgHelper.getDefaultOrg((String)this.getView().getFormShowParameter().getFormId(), (String)OrgViewTypeEnum.IS_PURCHASE.getViewType())) != null) {
            model.setValue("orgfield", (Object)defaultOrg);
        }
        QFilter filter = new QFilter("org", "=", null);
        FilterParameter nullFilterParameter = new FilterParameter();
        nullFilterParameter.setFilter(filter);
        BillList sourceList = (BillList)this.getView().getControl("sourcelist");
        sourceList.setFilterParameter(nullFilterParameter);
        sourceList.refresh();
        BillList quota = (BillList)this.getControl("quotascheme");
        quota.setEntryEntity(QUOTA_SCHEME_SUB_ENTRY_ENTITY);
        quota.setFilterParameter(nullFilterParameter);
        quota.refresh();
        BillList purchasePrice = (BillList)this.getView().getControl("purchaseprice");
        purchasePrice.setFilterParameter(nullFilterParameter);
        purchasePrice.refresh();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        switch (fieldKey) {
            case "orgfield": {
                List orgList = OrgHelper.getHasPermissionOrg((String)"pm_purresanalyze", (String)OrgViewTypeEnum.IS_PURCHASE.getViewType());
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", (Object)orgList));
                break;
            }
            case "materielfield": {
                if (this.getModel().getValue("orgfield") == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurResourceAnalyzeRptPlugin_0", (String)"scmc-pm-report", (Object[])new Object[0]));
                    beforeF7SelectEvent.setCancel(true);
                }
                showParameter.setShowApproved(false);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String key = afterDoOperationEventArgs.getOperateKey();
        if ("searchbtn".equals(key)) {
            DynamicObject org = (DynamicObject)model.getValue("orgfield");
            DynamicObject materiel = (DynamicObject)model.getValue("materielfield");
            Date startDate = (Date)model.getValue("startdate");
            Date endDate = (Date)model.getValue("enddate");
            QFilter sourceListFilter = new QFilter(PUR_PRICE_STATUS, "=", (Object)StatusEnum.AUDIT.getValue());
            sourceListFilter.and("org", "=", org.getPkValue()).and("entryentity.material", "=", materiel.getPkValue()).and("entryentity.effectdate", "<=", (Object)endDate).and("entryentity.expirydate", ">=", (Object)startDate);
            FilterParameter sourceListFilterParameter = new FilterParameter();
            sourceListFilterParameter.setFilter(sourceListFilter);
            BillList sourceList = (BillList)view.getControl("sourcelist");
            sourceList.setFilterParameter(sourceListFilterParameter);
            sourceList.refresh();
            Map quotaAssignMap = BusinessDataServiceHelper.loadFromCache((String)QUOTA_ASSIGN, (QFilter[])new QFilter("org", "=", org.getPkValue()).and(QUOTA_ASSIGN_MATERIAL, "=", materiel.getPkValue()).toArray());
            BillList quotaScheme = (BillList)view.getControl("quotascheme");
            if (quotaAssignMap.size() > 0) {
                List idList = quotaAssignMap.values().stream().filter(dynamicObject -> dynamicObject.getDynamicObject(QUOTA_ASSIGN_QUOTA) != null).map(dynamicObject -> dynamicObject.getDynamicObject(QUOTA_ASSIGN_QUOTA).getPkValue()).collect(Collectors.toList());
                if (idList.size() == 0) {
                    quotaScheme.clearData();
                } else {
                    QFilter quotaSchemeFilter = new QFilter(PUR_PRICE_STATUS, "=", (Object)StatusEnum.AUDIT.getValue());
                    quotaSchemeFilter.and("id", "in", idList).and("org", "=", org.getPkValue()).and("entryentity.effectdate", "<=", (Object)endDate).and("entryentity.expirydate", ">=", (Object)startDate);
                    FilterParameter quotaSchemeFilterParameter = new FilterParameter();
                    quotaSchemeFilterParameter.setFilter(quotaSchemeFilter);
                    quotaScheme.setFilterParameter(quotaSchemeFilterParameter);
                    quotaScheme.refresh();
                }
            } else {
                quotaScheme.clearData();
            }
            QFilter purchasePriceFilter = new QFilter(PUR_PRICE_STATUS, "=", (Object)StatusEnum.AUDIT.getValue());
            purchasePriceFilter.and("org", "=", org.getPkValue()).and(PUR_PRICE_MATERIAL, "=", materiel.getPkValue()).and(PUR_PRICE_EFFECT_DATE, "<=", (Object)endDate).and(PUR_PRICE_EXPIRY_DATE, ">=", (Object)startDate);
            FilterParameter purchasePriceFilterParameter = new FilterParameter();
            purchasePriceFilterParameter.setFilter(purchasePriceFilter);
            BillList purchasePrice = (BillList)view.getControl("purchaseprice");
            purchasePrice.setFilterParameter(purchasePriceFilterParameter);
            purchasePrice.refresh();
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (this.getModel().getValue("orgfield") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurResourceAnalyzeRptPlugin_0", (String)"scmc-pm-report", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (this.getModel().getValue("materielfield") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u3002", (String)"PurResourceAnalyzeRptPlugin_1", (String)"scmc-pm-report", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        Date startDate = (Date)this.getModel().getValue("startdate");
        Date endDate = (Date)this.getModel().getValue("enddate");
        if (startDate == null && endDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f00\u59cb\u4e0e\u622a\u6b62\u65e5\u671f\u3002", (String)"PurResourceAnalyzeRptPlugin_2", (String)"scmc-pm-report", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (startDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5f00\u59cb\u65e5\u671f\u3002", (String)"PurResourceAnalyzeRptPlugin_5", (String)"scmc-pm-report", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (endDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u622a\u6b62\u65e5\u671f\u3002", (String)"PurResourceAnalyzeRptPlugin_6", (String)"scmc-pm-report", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
        if (startDate.getTime() > endDate.getTime()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u622a\u6b62\u65e5\u671f\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"PurResourceAnalyzeRptPlugin_3", (String)"scmc-pm-report", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String field = e.getProperty().getName();
        if ("orgfield".equals(field)) {
            this.getModel().setValue("materielfield", null);
        }
    }
}

