/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report.helper;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.pm.business.helper.AppParameterHelper;
import kd.scmc.pm.report.helper.PurReceivingRptHelper;
import kd.scmc.pm.utils.DateUtil;

public class PmReceivingTimeRptHelper {
    public static List<QFilter> getFilters(FilterInfo filterInfo) {
        List<Long> bizoperatorgroupIds;
        Object operatorGroupIsolate;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        Long purOrgValue = null;
        Date startDate = filterInfo.getDate("startdate");
        filters.add(new QFilter("billentry.deliverdate", ">=", (Object)DateUtil.getStartOrEndDate((Date)startDate, (boolean)false)));
        Date endDate = filterInfo.getDate("enddate");
        filters.add(new QFilter("billentry.deliverdate", "<=", (Object)DateUtil.getStartOrEndDate((Date)endDate, (boolean)true)));
        DynamicObject purOrg = filterInfo.getDynamicObject("purorg");
        if (purOrg != null) {
            purOrgValue = (Long)purOrg.getPkValue();
            filters.add(new QFilter("org", "=", (Object)purOrgValue));
        }
        DynamicObjectCollection cusColl = filterInfo.getDynamicObjectCollection("supplier");
        ArrayList<Long> supplierList = new ArrayList<Long>(16);
        List<Long> cuss = PmReceivingTimeRptHelper.getBaseDataPkIds(cusColl);
        if (cuss != null && cuss.size() > 0) {
            for (int i = 0; i < cuss.size(); ++i) {
                supplierList.add(cuss.get(i));
            }
            filters.add(new QFilter("supplier", "in", supplierList));
        }
        DynamicObjectCollection operatorgroups = filterInfo.getDynamicObjectCollection("operategroup");
        long userId = UserServiceHelper.getCurrentUserId();
        List<Long> orgGrpList = null;
        if (purOrgValue != null) {
            orgGrpList = PurReceivingRptHelper.getOperatorGroupByOrg(purOrgValue);
        }
        if ((operatorGroupIsolate = AppParameterHelper.getPmAppParameter((Long)purOrgValue, (String)"foperatorgroupisolate")) instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue()) {
            bizoperatorgroupIds = PmReceivingTimeRptHelper.getBaseDataPkIds(operatorgroups);
            if (bizoperatorgroupIds != null && bizoperatorgroupIds.size() > 0) {
                filters.add(new QFilter("operatorgroup", "in", (Object)bizoperatorgroupIds.toArray()));
            } else {
                List<Long> userGrpList = PurReceivingRptHelper.getOperatorGroupByUser(userId);
                List<Long> grpList = PurReceivingRptHelper.getValidOperatorGroup(orgGrpList, userGrpList);
                if (grpList != null && grpList.size() > 0) {
                    filters.add(new QFilter("operatorgroup", "in", (Object)grpList.toArray()));
                } else {
                    filters.add(new QFilter("operatorgroup", "=", (Object)0));
                }
            }
        } else {
            bizoperatorgroupIds = PmReceivingTimeRptHelper.getBaseDataPkIds(operatorgroups);
            if (bizoperatorgroupIds != null && bizoperatorgroupIds.size() > 0) {
                filters.add(new QFilter("operatorgroup", "in", (Object)bizoperatorgroupIds.toArray()));
            }
        }
        DynamicObjectCollection operators = filterInfo.getDynamicObjectCollection("operator");
        List<Long> bizoperatorgroupIds2 = PmReceivingTimeRptHelper.getBaseDataPkIds(operators);
        if (bizoperatorgroupIds2 != null && bizoperatorgroupIds2.size() > 0) {
            filters.add(new QFilter("operator", "in", bizoperatorgroupIds2));
        }
        return filters;
    }

    public static List<QFilter> getTodayFilters(FilterInfo filterInfo) {
        List<Long> bizoperatorgroupIds;
        Object operatorGroupIsolate;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        Long purOrgValue = null;
        DynamicObject purOrg = filterInfo.getDynamicObject("purorg");
        if (purOrg != null) {
            purOrgValue = (Long)purOrg.getPkValue();
            filters.add(new QFilter("org", "=", (Object)purOrgValue));
        }
        DynamicObjectCollection cusColl = filterInfo.getDynamicObjectCollection("supplier");
        ArrayList<Long> supplierList = new ArrayList<Long>(16);
        List<Long> cuss = PmReceivingTimeRptHelper.getBaseDataPkIds(cusColl);
        if (cuss != null && cuss.size() > 0) {
            for (int i = 0; i < cuss.size(); ++i) {
                supplierList.add(cuss.get(i));
            }
            filters.add(new QFilter("supplier", "in", supplierList));
        }
        DynamicObjectCollection operatorgroups = filterInfo.getDynamicObjectCollection("operategroup");
        long userId = UserServiceHelper.getCurrentUserId();
        List<Long> orgGrpList = null;
        if (purOrgValue != null) {
            orgGrpList = PurReceivingRptHelper.getOperatorGroupByOrg(purOrgValue);
        }
        if ((operatorGroupIsolate = AppParameterHelper.getPmAppParameter((Long)purOrgValue, (String)"foperatorgroupisolate")) instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue()) {
            bizoperatorgroupIds = PmReceivingTimeRptHelper.getBaseDataPkIds(operatorgroups);
            if (bizoperatorgroupIds != null && bizoperatorgroupIds.size() > 0) {
                filters.add(new QFilter("operatorgroup", "in", (Object)bizoperatorgroupIds.toArray()));
            } else {
                List<Long> userGrpList = PurReceivingRptHelper.getOperatorGroupByUser(userId);
                List<Long> grpList = PurReceivingRptHelper.getValidOperatorGroup(orgGrpList, userGrpList);
                if (grpList != null && grpList.size() > 0) {
                    filters.add(new QFilter("operatorgroup", "in", (Object)grpList.toArray()));
                } else {
                    filters.add(new QFilter("operatorgroup", "=", (Object)0));
                }
            }
        } else {
            bizoperatorgroupIds = PmReceivingTimeRptHelper.getBaseDataPkIds(operatorgroups);
            if (bizoperatorgroupIds != null && bizoperatorgroupIds.size() > 0) {
                filters.add(new QFilter("operatorgroup", "in", (Object)bizoperatorgroupIds.toArray()));
            }
        }
        DynamicObjectCollection operators = filterInfo.getDynamicObjectCollection("operator");
        List<Long> bizoperatorgroupIds2 = PmReceivingTimeRptHelper.getBaseDataPkIds(operators);
        if (bizoperatorgroupIds2 != null && bizoperatorgroupIds2.size() > 0) {
            filters.add(new QFilter("operator", "in", bizoperatorgroupIds2));
        }
        return filters;
    }

    public static String getSelectField(ReportQueryParam param) {
        ArrayList<String> select = new ArrayList<String>(16);
        select.add("supplier as entry_supplier");
        select.add("org as entry_purorg");
        select.add("operatorgroup as entry_operategroup");
        select.add("operator as entry_operator");
        select.add("id");
        select.add("closestatus");
        select.add("billentry.id as entryid");
        select.add("billentry.deliverdate as deliverydate");
        select.add("billentry.invqty as invqty");
        select.add("billentry.qty as qty");
        select.add("billentry.rowclosestatus as rowclosestatus");
        select.add("billentry.rowterminatestatus as rowterminatestatus");
        select.add("case when billentry.invqty < billentry.qty and billentry.rowclosestatus = 'A' and billentry.rowterminatestatus = 'A' and closestatus = 'A' then 1 else 0 end as todaynum");
        select.add("case when closestatus = 'A' and billentry.rowclosestatus = 'A' and billentry.rowterminatestatus = 'A' and billentry.invqty < billentry.qty then 1 else 0 end as overduenum");
        return String.join((CharSequence)",", select);
    }

    public static String getImSalOutSelectField() {
        ArrayList<String> select = new ArrayList<String>(16);
        select.add("biztime");
        select.add("bizoperatorgroup");
        select.add("bizoperator");
        select.add("billentry.mainbillid as srcbillid");
        select.add("billentry.mainbillentryid as srcbillentryid");
        return String.join((CharSequence)",", select);
    }

    public static List<QFilter> expireFilter(ReportQueryParam reportQueryParam) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(16);
        List<Date> searchDate = PmReceivingTimeRptHelper.getSearchDate(reportQueryParam);
        if (searchDate.size() > 1) {
            QFilter dates = new QFilter("billentry.deliverdate", ">=", (Object)searchDate.get(0));
            QFilter datee = new QFilter("billentry.deliverdate", "<=", (Object)searchDate.get(1));
            filters.add(dates);
            filters.add(datee);
        }
        return filters;
    }

    public static List<QFilter> todayFilter() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        QFilter date = new QFilter("billentry.deliverdate", "=", (Object)DateUtil.getDate((Date)TimeServiceHelper.today()));
        filters.add(date);
        return filters;
    }

    public static List<Date> getSearchDate(ReportQueryParam param) {
        ArrayList<Date> dateList = new ArrayList<Date>();
        Date date = null;
        FilterInfo filter = param.getFilter();
        List filterItems = filter.getFilterItems();
        for (FilterItemInfo itemInfo : filterItems) {
            String propName = itemInfo.getPropName();
            if (!"startdate".equals(propName) && !"enddate".equals(propName) || (date = (Date)itemInfo.getValue()) == null) continue;
            dateList.add(date);
        }
        return dateList;
    }

    public static Date getStartOrEndDate(Date date, boolean isEnd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (isEnd) {
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
        } else {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        }
        return cal.getTime();
    }

    public static String getStringDate1(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(date);
    }

    public static String getStringDate2(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(date);
    }

    public static List<Long> getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        ArrayList<Long> pkIds = new ArrayList<Long>(col.size());
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds.add((Long)baseData.getPkValue());
        }
        return pkIds;
    }
}

