/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report.helper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;
import kd.scmc.pm.enums.StatusEnum;
import kd.scmc.pm.utils.DateUtil;

public class PurApplyRptHelper {
    public static List<QFilter> getFilters(FilterInfo filterInfo) {
        Date endDate;
        Date startDate;
        DynamicObjectCollection purOrderBillNo;
        DynamicObject project;
        DynamicObjectCollection material;
        DynamicObjectCollection bizUser;
        DynamicObjectCollection dept;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObject org = filterInfo.getDynamicObject("headorg");
        if (org != null) {
            filters.add(new QFilter("org", "=", org.getPkValue()));
        }
        if ((dept = filterInfo.getDynamicObjectCollection("headdept")) != null) {
            Object[] deptIds = PurApplyRptHelper.getBaseDataPkIds(dept);
            filters.add(new QFilter("dept", "in", (Object)deptIds));
        }
        if ((bizUser = filterInfo.getDynamicObjectCollection("headbizuser")) != null) {
            Object[] bizUserIds = PurApplyRptHelper.getBaseDataPkIds(bizUser);
            filters.add(new QFilter("bizuser", "in", (Object)bizUserIds));
        }
        if ((material = filterInfo.getDynamicObjectCollection("material")) != null) {
            Object[] materialIds = PurApplyRptHelper.getBaseDataPkIds(material);
            filters.add(new QFilter("billentry.material", "in", (Object)materialIds));
        }
        if ((project = filterInfo.getDynamicObject("headproject")) != null) {
            filters.add(new QFilter("billentry.project", "=", project.getPkValue()));
        }
        if ((purOrderBillNo = filterInfo.getDynamicObjectCollection("selectbill")) != null && purOrderBillNo.size() > 0) {
            Object[] billNo = PurApplyRptHelper.getBaseDataPkIds(purOrderBillNo);
            filters.add(new QFilter("id", "in", (Object)billNo));
        }
        if ((startDate = filterInfo.getDate("startdate")) != null) {
            filters.add(new QFilter("biztime", ">=", (Object)DateUtil.getStartOrEndDate((Date)startDate, (boolean)false)));
        }
        if ((endDate = filterInfo.getDate("enddate")) != null) {
            filters.add(new QFilter("biztime", "<=", (Object)DateUtil.getStartOrEndDate((Date)endDate, (boolean)true)));
        }
        filters.add(new QFilter("billstatus", "=", (Object)StatusEnum.AUDIT.getValue()));
        return filters;
    }

    public static String getPurApplyFields() {
        ArrayList<String> selectorSet = new ArrayList<String>(13);
        selectorSet.add("id");
        selectorSet.add("org");
        selectorSet.add("billno");
        selectorSet.add("billtype");
        selectorSet.add("biztime");
        selectorSet.add("dept");
        selectorSet.add("bizuser");
        selectorSet.add("billentry.material.masterid as materialmasterid");
        selectorSet.add("billentry.auxpty as auxpty");
        selectorSet.add("billentry.unit as unit");
        selectorSet.add("billentry.project as project");
        selectorSet.add("billentry.applyqty as applyqty");
        selectorSet.add("billentry.qty as qty");
        selectorSet.add("concat(to_char(id),to_char(billentry.id)) as purapplyid");
        return String.join((CharSequence)",", selectorSet);
    }

    public static String getSelectField2Conm() {
        ArrayList<String> selectorSet = new ArrayList<String>(6);
        selectorSet.add("billno as conmbillno");
        selectorSet.add("biztime as conmbiztime");
        selectorSet.add("billentry.qty as conmqty");
        selectorSet.add("billentry.unit as conmunit");
        selectorSet.add("concat(to_char(billentry.srcbillid), to_char(billentry.srcbillentryid)) as srcbillid");
        selectorSet.add("concat(to_char(id), to_char(billentry.id)) as conmid");
        return String.join((CharSequence)",", selectorSet);
    }

    public static String getSelectField2orderbill() {
        ArrayList<String> selectorSet = new ArrayList<String>(7);
        selectorSet.add("billno as pobillno");
        selectorSet.add("billentry.qty as poqty");
        selectorSet.add("billentry.unit as pounit");
        selectorSet.add("biztime as pobiztime");
        selectorSet.add("supplier as posupplier");
        selectorSet.add("concat(to_char(id),to_char(billentry.id)) as poid");
        selectorSet.add("concat(to_char(billentry.srcbillid), to_char(billentry.srcbillentryid)) as srcbillid");
        return String.join((CharSequence)",", selectorSet);
    }

    public static String getSelectField2ReFundApply() {
        ArrayList<String> selectorSet = new ArrayList<String>(5);
        selectorSet.add("billno as refundapplyno");
        selectorSet.add("billentry.qty as refundapplyqty");
        selectorSet.add("billentry.unit as refundapplyunit");
        selectorSet.add("concat(to_char(id),to_char(billentry.id)) as refunid");
        selectorSet.add("concat(to_char(billentry.srcbillid), to_char(billentry.srcbillentryid)) as poid");
        return String.join((CharSequence)",", selectorSet);
    }

    public static String getSelectField2inorderbill() {
        ArrayList<String> selectorSet = new ArrayList<String>(6);
        selectorSet.add("billno as purinbillno");
        selectorSet.add("billentry.qty as purinqty");
        selectorSet.add("billentry.unit as purinunit");
        selectorSet.add("concat(to_char(id),to_char(billentry.id)) as purinid");
        selectorSet.add("concat(to_char(billentry.srcbillid), to_char(billentry.srcbillentryid)) as pojoinpurrecid");
        selectorSet.add("concat(to_char(billentry.srcbillid), to_char(billentry.srcbillentryid)) as poid");
        return String.join((CharSequence)",", selectorSet);
    }

    public static String getSelectField2PurReceiveNotice() {
        ArrayList<String> selectorSet = new ArrayList<String>(5);
        selectorSet.add("billno as purrecnocbillno");
        selectorSet.add("billentry.qty as purrecnocqty");
        selectorSet.add("billentry.unit as purrecnocunit");
        selectorSet.add("concat(to_char(id),to_char(billentry.id)) as purrnid");
        selectorSet.add("concat(to_char(billentry.srcbillid), to_char(billentry.srcbillentryid)) as poid");
        return String.join((CharSequence)",", selectorSet);
    }

    public static String getSelectField2PurReceivebill() {
        ArrayList<String> selectorSet = new ArrayList<String>(5);
        selectorSet.add("billno as purreceivebillno");
        selectorSet.add("billentry.qty as purreceiveqty");
        selectorSet.add("billentry.unit as purreceiveunit");
        selectorSet.add("concat(to_char(id),to_char(billentry.id)) as purreceiveid");
        selectorSet.add("concat(to_char(billentry.srcbillid), to_char(billentry.srcbillentryid)) as srcbillid");
        selectorSet.add("concat(to_char(billentry.srcbillid), to_char(billentry.srcbillentryid)) as poid");
        return String.join((CharSequence)",", selectorSet);
    }

    public static String getSelectField2returnorderbill() {
        ArrayList<String> selectorSet = new ArrayList<String>(4);
        selectorSet.add("billno as returnbillno");
        selectorSet.add("billentry.qty as returnqty");
        selectorSet.add("billentry.unit as returnunit");
        selectorSet.add("concat(to_char(billentry.srcbillid), to_char(billentry.srcbillentryid)) as srcbillid");
        return String.join((CharSequence)",", selectorSet);
    }

    public static String getSelectField2returnBill() {
        ArrayList<String> selectorSet = new ArrayList<String>(4);
        selectorSet.add("billno as purinbillno");
        selectorSet.add("billentry.qty as purinqty");
        selectorSet.add("billentry.unit as purinunit");
        selectorSet.add("concat(to_char(id), to_char(billentry.id)) as purinid");
        selectorSet.add("concat(to_char(billentry.srcbillid), to_char(billentry.srcbillentryid)) as srcbillid");
        selectorSet.add("concat(to_char(billentry.srcbillid), to_char(billentry.srcbillentryid)) as poid");
        return String.join((CharSequence)",", selectorSet);
    }

    private static Object[] getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        Object[] pkIds = new Object[col.size()];
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds[i] = baseData.getPkValue();
        }
        return pkIds;
    }
}

