/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report.helper;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.pm.enums.OperatorGrpTypeEnum;

public class PurReceivingRptHelper {
    public static String getSelectField() {
        ArrayList<String> selectorSet = new ArrayList<String>();
        selectorSet.add("supplier as entry_supplier");
        selectorSet.add("supplier.name as suppliername");
        selectorSet.add("billentry.material.masterid.id as entry_material");
        selectorSet.add("billentry.material.masterid.name as materialname");
        selectorSet.add("operator as entry_operator");
        selectorSet.add("operatorgroup as entry_operategroup");
        selectorSet.add("case when (closestatus = 'A' and (billentry.rowclosestatus = 'B' or billentry.rowterminatestatus = 'B') and billentry.purbillentry_deliver.planreceiveqty = 0 and billentry.purbillentry_deliver.planreceivedate is null) or (closestatus = 'B' and billentry.purbillentry_deliver.planreceiveqty = 0 and billentry.purbillentry_deliver.planreceivedate is null) or (closestatus = 'A' and (billentry.rowclosestatus = 'B' or billentry.rowterminatestatus = 'B') and billentry.purbillentry_deliver.planreceivedate <= billentry.purbillentry_deliver.plandeliverdate) or (closestatus = 'B' and billentry.purbillentry_deliver.planreceivedate <= billentry.purbillentry_deliver.plandeliverdate) or (closestatus = 'A' and billentry.rowclosestatus = 'A' and billentry.rowterminatestatus = 'A' and billentry.purbillentry_deliver.planreceivedate <= billentry.purbillentry_deliver.plandeliverdate and billentry.purbillentry_deliver.planreceiveqty >= billentry.purbillentry_deliver.planqty) then 1 else 0 end as ontimenum");
        selectorSet.add("case when (closestatus = 'A' and (billentry.rowclosestatus = 'B' or billentry.rowterminatestatus = 'B') and billentry.purbillentry_deliver.planreceivedate > billentry.purbillentry_deliver.plandeliverdate) or (closestatus = 'B'and billentry.purbillentry_deliver.planreceivedate > billentry.purbillentry_deliver.plandeliverdate)or (closestatus = 'A' and billentry.rowclosestatus = 'A' and billentry.rowterminatestatus = 'A' and billentry.purbillentry_deliver.planreceivedate > billentry.purbillentry_deliver.plandeliverdate and billentry.purbillentry_deliver.planreceiveqty >= billentry.purbillentry_deliver.planqty) then 1 else 0 end as overduenum");
        selectorSet.add("case when closestatus = 'A' and billentry.rowclosestatus = 'A' and billentry.rowterminatestatus = 'A' and billentry.purbillentry_deliver.planreceiveqty < billentry.purbillentry_deliver.planqty then 1 else 0 end as unfinishnum");
        return String.join((CharSequence)",", selectorSet);
    }

    public static List<QFilter> getFilters(FilterInfo filterInfo) {
        DynamicObjectCollection operators;
        DynamicObjectCollection operatorgroups;
        DynamicObjectCollection bizdepts;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        DynamicObject org = filterInfo.getDynamicObject("purorg");
        filters.add(new QFilter("org", "=", org.getPkValue()));
        DynamicObjectCollection materials = filterInfo.getDynamicObjectCollection("material");
        if (materials != null && materials.size() > 0) {
            List<Long> materialIdS = PurReceivingRptHelper.getBaseDataPkIds(materials);
            filters.add(new QFilter("billentry.material.masterid", "in", materialIdS));
        } else {
            filters.add(QFilter.isNotNull((String)"billentry.material.masterid"));
        }
        Date startDate = filterInfo.getDate("startdate");
        filters.add(new QFilter("billentry.purbillentry_deliver.plandeliverdate", ">=", (Object)PurReceivingRptHelper.getStartOrEndDate(startDate, false)));
        Date endDate = filterInfo.getDate("enddate");
        filters.add(new QFilter("billentry.purbillentry_deliver.plandeliverdate", "<=", (Object)PurReceivingRptHelper.getStartOrEndDate(endDate, true)));
        DynamicObjectCollection cusColl = filterInfo.getDynamicObjectCollection("supplier");
        ArrayList<Long> supplierList = new ArrayList<Long>(16);
        List<Long> cuss = PurReceivingRptHelper.getBaseDataPkIds(cusColl);
        if (cuss != null && cuss.size() > 0) {
            for (int i = 0; i < cuss.size(); ++i) {
                supplierList.add(cuss.get(i));
            }
            filters.add(new QFilter("supplier", "in", supplierList));
        }
        if ((bizdepts = filterInfo.getDynamicObjectCollection("dept")) != null && bizdepts.size() > 0) {
            List<Long> bizdeptsIds = PurReceivingRptHelper.getBaseDataPkIds(bizdepts);
            filters.add(new QFilter("dept", "in", bizdeptsIds));
        }
        if ((operatorgroups = filterInfo.getDynamicObjectCollection("operategroup")) != null && operatorgroups.size() > 0) {
            List<Long> bizoperatorgroupIds = PurReceivingRptHelper.getBaseDataPkIds(operatorgroups);
            filters.add(new QFilter("operatorgroup", "in", bizoperatorgroupIds));
        }
        if ((operators = filterInfo.getDynamicObjectCollection("operator")) != null && operators.size() > 0) {
            List<Long> bizoperatorgroupIds = PurReceivingRptHelper.getBaseDataPkIds(operators);
            filters.add(new QFilter("operator", "in", bizoperatorgroupIds));
        }
        return filters;
    }

    public static List<Long> getValidOperatorGroup(List<Long> orgGrpList, List<Long> userGrpList) {
        ArrayList<Long> grpList = new ArrayList<Long>();
        if (orgGrpList == null || orgGrpList.size() == 0) {
            return userGrpList;
        }
        if (userGrpList == null || userGrpList.size() == 0) {
            return null;
        }
        for (Long orgGrp : orgGrpList) {
            if (!userGrpList.contains(orgGrp)) continue;
            grpList.add(orgGrp);
        }
        return grpList;
    }

    public static List<Long> getOperatorGroupByUser(long userID) {
        QFilter q2;
        ArrayList<Long> longs = new ArrayList<Long>();
        QFilter q1 = new QFilter("operatorid", "=", (Object)userID);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"bd_operator", (String)"id,operatorid,opergrptype,operatorgrpid", (QFilter[])new QFilter[]{q1, q2 = new QFilter("opergrptype", "=", (Object)OperatorGrpTypeEnum.PURCHASEGRP.getValue())}, null);
        if (load != null && load.length > 0) {
            for (int i = 0; i < load.length; ++i) {
                longs.add(load[i].getLong("operatorgrpid"));
            }
        }
        return longs;
    }

    public static List<Long> getOperatorGroupByOrg(long orgId) {
        QFilter q2;
        ArrayList<Long> operatorGroupList = null;
        QFilter q1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)orgId);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id,createorg,operatorgrouptype,enable", (QFilter[])new QFilter[]{q1, q2 = new QFilter("operatorgrouptype", "in", (Object)OperatorGrpTypeEnum.PURCHASEGRP.getValue())});
        if (map != null && map.size() > 0) {
            operatorGroupList = new ArrayList<Long>(map.size());
            for (DynamicObject dyn : map.values()) {
                if (dyn == null) continue;
                operatorGroupList.add((Long)dyn.getPkValue());
            }
        }
        return operatorGroupList;
    }

    public static List<Long> getOperatorGroupByOrgs(List<Long> orgIds) {
        QFilter q2;
        ArrayList<Long> operatorGroupList = null;
        QFilter q1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", orgIds, (boolean)true);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (String)"id,createorg,operatorgrouptype,enable", (QFilter[])new QFilter[]{q1, q2 = new QFilter("operatorgrouptype", "in", (Object)OperatorGrpTypeEnum.PURCHASEGRP.getValue())});
        if (map != null && map.size() > 0) {
            operatorGroupList = new ArrayList<Long>(map.size());
            for (DynamicObject dyn : map.values()) {
                if (dyn == null) continue;
                operatorGroupList.add((Long)dyn.getPkValue());
            }
        }
        return operatorGroupList;
    }

    public static List<Long> getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        ArrayList<Long> pkIds = new ArrayList<Long>(col.size());
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds.add((Long)baseData.getPkValue());
        }
        return pkIds;
    }

    public static Date getStartOrEndDate(Date date, boolean isEnd) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (isEnd) {
            cal.set(11, 23);
            cal.set(12, 59);
            cal.set(13, 59);
        } else {
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
        }
        return cal.getTime();
    }
}

