/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report.openorder;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.scmc.pm.report.helper.PurRptHelper;

public class OpenOrderBillFunction
extends GroupReduceFunction {
    boolean isCountByUnit;
    String openCalcStandard;
    String filterCondition;
    BigDecimal zero = new BigDecimal(0);

    OpenOrderBillFunction(boolean isCountByUnit, String openCalcStandard, String filterCondition) {
        this.isCountByUnit = isCountByUnit;
        this.openCalcStandard = openCalcStandard;
        this.filterCondition = filterCondition;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        RowMeta rowMeta = this.getSourceRowMeta();
        Iterator<RowX> iterator = iterable.iterator();
        if (this.openCalcStandard != null) {
            String openQtyOrBaseQtyStr;
            String minuend;
            String openSubtraction = "";
            if ("A".equals(this.openCalcStandard)) {
                openSubtraction = "receive";
            } else if ("B".equals(this.openCalcStandard)) {
                openSubtraction = "inv";
            }
            boolean qtyEQ0 = false;
            boolean qtyUnder0 = false;
            if (this.filterCondition != null) {
                Set<String> conditionSet = PurRptHelper.multipleChoiceStrToSetExcludeEmpty(this.filterCondition, ",");
                if (conditionSet.contains("A")) {
                    qtyEQ0 = true;
                }
                if (conditionSet.contains("B")) {
                    qtyUnder0 = true;
                }
            }
            if (this.isCountByUnit) {
                openSubtraction = openSubtraction + "qty";
                minuend = "qty";
                openQtyOrBaseQtyStr = "openqty";
            } else {
                minuend = "baseqty";
                openSubtraction = openSubtraction + "baseqty";
                openQtyOrBaseQtyStr = "openbaseqty";
            }
            int openQtyOrBaseQtyIndex = rowMeta.getFieldIndex(openQtyOrBaseQtyStr);
            int openSubtractionIndex = rowMeta.getFieldIndex(openSubtraction);
            int minuendIndex = rowMeta.getFieldIndex(minuend);
            while (iterator.hasNext()) {
                RowX rowX = iterator.next();
                BigDecimal openSubtractionObj = rowX.getBigDecimal(openSubtractionIndex);
                BigDecimal minuendIndexObj = rowX.getBigDecimal(minuendIndex);
                if (minuendIndexObj == null) {
                    minuendIndexObj = BigDecimal.ZERO;
                }
                if (openSubtractionObj == null) {
                    openSubtractionObj = BigDecimal.ZERO;
                }
                BigDecimal openQtyOrBaseQtyObj = minuendIndexObj.subtract(openSubtractionObj);
                rowX.set(openQtyOrBaseQtyIndex, (Object)openQtyOrBaseQtyObj);
                if (!qtyEQ0 && !qtyUnder0) {
                    collector.collect(rowX);
                }
                if (qtyEQ0 && qtyUnder0 && openQtyOrBaseQtyObj.compareTo(this.zero) > 0) {
                    collector.collect(rowX);
                    continue;
                }
                if (qtyEQ0 && !qtyUnder0 && openQtyOrBaseQtyObj.compareTo(this.zero) != 0) {
                    collector.collect(rowX);
                    continue;
                }
                if (!qtyUnder0 || qtyEQ0 || openQtyOrBaseQtyObj.compareTo(this.zero) < 0) continue;
                collector.collect(rowX);
            }
        }
    }

    public RowMeta getResultRowMeta() {
        return this.getSourceRowMeta();
    }
}

