/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report.openorder;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.IPageCache;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.scmc.pm.business.helper.OrgHelper;
import kd.scmc.pm.report.helper.PurRptHelper;
import kd.scmc.pm.utils.DateUtil;

public class OpenOrderBillRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setShowAndSumKeyValue();
        ReportShowParameter showParameter = (ReportShowParameter)this.getView().getFormShowParameter();
        if (showParameter.getReportQueryParam() != null && "1".equals(showParameter.getReportQueryParam().getCustomParam().get("isFormBill"))) {
            FilterInfo filterInfo = showParameter.getReportQueryParam().getFilter();
            if (!filterInfo.containProp("showkeycols")) {
                String showkeycols = (String)this.getModel().getValue("showkeycols");
                showParameter.getReportQueryParam().getFilter().addFilterItem("showkeycols", (Object)showkeycols, CompareTypeEnum.MULTICOMBOBOXLIKE.getId());
            }
            if (!filterInfo.containProp("showqtycols")) {
                String showqtycols = (String)this.getModel().getValue("showqtycols");
                showParameter.getReportQueryParam().getFilter().addFilterItem("showqtycols", (Object)showqtycols, CompareTypeEnum.MULTICOMBOBOXLIKE.getId());
            }
            if (!filterInfo.containProp("sumkeycols")) {
                String sumkeycols = (String)this.getModel().getValue("sumkeycols");
                showParameter.getReportQueryParam().getFilter().addFilterItem("sumkeycols", (Object)sumkeycols, CompareTypeEnum.MULTICOMBOBOXLIKE.getId());
            }
            if (!filterInfo.containProp("showtotalqty")) {
                Boolean showtotalqty = (Boolean)this.getModel().getValue("showtotalqty");
                showParameter.getReportQueryParam().getFilter().addFilterItem("showtotalqty", (Object)showtotalqty, CompareTypeEnum.CHECKBOXEQUAL.getId());
            }
        }
    }

    public void registerListener(EventObject e) {
        BasedataEdit bizType;
        BasedataEdit project;
        BasedataEdit material;
        BasedataEdit supplier;
        IReportView view = this.getView();
        BasedataEdit org = (BasedataEdit)view.getControl("headorg");
        if (org != null) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplier = (BasedataEdit)view.getControl("headsupplier")) != null) {
            supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((material = (BasedataEdit)view.getControl("headmaterial")) != null) {
            material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((project = (BasedataEdit)view.getControl("project")) != null) {
            project.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((bizType = (BasedataEdit)view.getControl("headbiztype")) != null) {
            bizType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        this.setDefaultValue();
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
        String keyName = beforeF7SelectEvent.getProperty().getName();
        DynamicObjectCollection org = (DynamicObjectCollection)this.getModel().getValue("headorg");
        switch (keyName) {
            case "headorg": {
                List<Long> hasPermissionOrgList = this.getHasPermissionOrgListFromCache();
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", hasPermissionOrgList));
                break;
            }
            case "headsupplier": {
                List<Long> listOrgId;
                QFilter bd_supplier;
                if (this.checkOrgIsNull(org)) {
                    beforeF7SelectEvent.setCancel(true);
                }
                if ((bd_supplier = PurRptHelper.getBaseDataFilter("bd_supplier", listOrgId = PurRptHelper.getAllOrg(org, false))) != null) {
                    showParameter.getListFilterParameter().setFilter(bd_supplier);
                }
                showParameter.setShowApproved(false);
                break;
            }
            case "headmaterial": {
                List<Long> listOrgIdMaterial;
                QFilter material;
                if (this.checkOrgIsNull(org)) {
                    beforeF7SelectEvent.setCancel(true);
                }
                if ((material = PurRptHelper.getBaseDataFilter("bd_materialpurchaseinfo", listOrgIdMaterial = PurRptHelper.getAllOrg(org, false))) != null) {
                    showParameter.getListFilterParameter().setFilter(material);
                }
                showParameter.setShowApproved(false);
                break;
            }
            case "project": {
                List<Long> listOrgIdProject;
                QFilter bd_project;
                if (this.checkOrgIsNull(org)) {
                    beforeF7SelectEvent.setCancel(true);
                }
                if ((bd_project = PurRptHelper.getBaseDataFilter("bd_project", listOrgIdProject = PurRptHelper.getAllOrg(org, false))) != null) {
                    showParameter.getListFilterParameter().setFilter(bd_project);
                }
                showParameter.setShowApproved(false);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String keyName = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        Object oldValue = changeData[0].getOldValue();
        switch (keyName) {
            case "headorg": {
                this.orgChangeEvent();
                break;
            }
            case "showkeycols": {
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo == null || filterInfo.getValue("headorg") == null) {
            this.showOrgTip();
            return false;
        }
        String calcStandard = filterInfo.getString("opencalcstandard");
        if (calcStandard == null || "".equals(calcStandard)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5728\u9014\u8ba1\u7b97\u6807\u51c6\u3002", (String)"OpenOrderBillRptPlugin_0", (String)"scmc-pm-report", (Object[])new Object[0]));
            return false;
        }
        if (filterInfo.getDate("startdate") == null || filterInfo.getDate("enddate") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"OpenOrderBillRptPlugin_4", (String)"scmc-pm-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        queryParam.getCustomParam().put("headorg", filterInfo.getValue("headorg"));
        queryParam.getCustomParam().put("startdate", filterInfo.getValue("startdate"));
        queryParam.getCustomParam().put("enddate", filterInfo.getValue("enddate"));
        queryParam.getCustomParam().put("headsupplier", filterInfo.getValue("headsupplier"));
        queryParam.getCustomParam().put("headmaterial", filterInfo.getValue("headmaterial"));
        queryParam.getCustomParam().put("headrecorg", filterInfo.getValue("headrecorg"));
        queryParam.getCustomParam().put("headreqorg", filterInfo.getValue("headreqorg"));
        queryParam.getCustomParam().put("headbiztype", filterInfo.getValue("headbiztype"));
        queryParam.getCustomParam().put("project", filterInfo.getValue("project"));
        queryParam.getCustomParam().put("changestatus", filterInfo.getValue("changestatus"));
        queryParam.getCustomParam().put("countbyunit", filterInfo.getValue("countbyunit"));
        queryParam.getCustomParam().put("sumfoundation", filterInfo.getValue("sumfoundation"));
        queryParam.getCustomParam().put("opencalcstandard", filterInfo.getValue("opencalcstandard"));
        queryParam.getCustomParam().put("filtercondition", filterInfo.getValue("filtercondition"));
        queryParam.getCustomParam().put("sumkeycols", filterInfo.getValue("sumkeycols"));
        queryParam.getCustomParam().put("showtotalqty", filterInfo.getValue("showtotalqty"));
        this.showColumns(this.getShowFields(filterInfo));
    }

    protected void showColumns(Set<String> toShowColumnSet) {
        if (toShowColumnSet == null || toShowColumnSet.size() == 0) {
            return;
        }
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        if (reportList == null) {
            return;
        }
        List columns = reportList.getColumns();
        for (AbstractReportColumn abstractReportColumn : columns) {
            ReportColumn column;
            String fieldKey;
            if (!(abstractReportColumn instanceof ReportColumn) || !toShowColumnSet.contains(fieldKey = (column = (ReportColumn)abstractReportColumn).getFieldKey())) continue;
            column.setHide(false);
        }
    }

    protected void setDefaultValue() {
        String openCalcStandard;
        Date startDate;
        Date endDate;
        IDataModel model = this.getModel();
        DynamicObjectCollection org = (DynamicObjectCollection)model.getValue("headorg");
        if (org == null || org.size() == 0) {
            long orgId = RequestContext.get().getOrgId();
            List<Long> hasPermissionOrgList = this.getHasPermissionOrgListFromCache();
            Long defaultOrg = PurRptHelper.getDefaultOrg(hasPermissionOrgList, orgId);
            if (defaultOrg != null) {
                this.setValue("headorg", new Object[]{defaultOrg});
            }
        }
        if ((endDate = (Date)model.getValue("enddate")) == null) {
            endDate = new Date();
            this.setValue("enddate", endDate);
        }
        if ((startDate = (Date)model.getValue("startdate")) == null) {
            this.setValue("startdate", DateUtil.localDateToDate((LocalDate)DateUtil.getStartOfYear((int)DateUtil.dateToLocalDate((Date)endDate).getYear())));
        }
        if ((openCalcStandard = (String)model.getValue("opencalcstandard")) == null) {
            this.setValue("opencalcstandard", "A");
        }
    }

    protected List<Long> getHasPermissionOrgListFromCache() {
        IPageCache pageCache = this.getPageCache();
        if (pageCache == null) {
            List hasPermissionOrgListNew = OrgHelper.getHasPermissionOrg((String)"pm_openorderbillrpt_new", (String)OrgViewTypeEnum.IS_PURCHASE.getViewType());
            return hasPermissionOrgListNew;
        }
        String hasPermissionPurOrgKey = "hasPermissionPurOrg";
        String permissionOrgStr = pageCache.get(hasPermissionPurOrgKey);
        if (permissionOrgStr == null) {
            List hasPermissionOrgListNew = OrgHelper.getHasPermissionOrg((String)"pm_openorderbillrpt_new", (String)OrgViewTypeEnum.IS_PURCHASE.getViewType());
            if (hasPermissionOrgListNew != null) {
                StringJoiner joiner = new StringJoiner(",", "", "");
                for (Long orgId : hasPermissionOrgListNew) {
                    joiner.add(orgId.toString());
                }
                pageCache.put(hasPermissionPurOrgKey, joiner.toString());
            }
            return hasPermissionOrgListNew;
        }
        return this.splitStringAndPutIdList(permissionOrgStr);
    }

    protected List<Long> splitStringAndPutIdList(String str) {
        String[] split = str.split(",");
        if (split.length == 0) {
            return null;
        }
        ArrayList<Long> idList = new ArrayList<Long>(split.length);
        for (String orgIdStr : split) {
            idList.add(Long.valueOf(orgIdStr));
        }
        return idList;
    }

    protected Set<String> getShowFields(FilterInfo filterInfo) {
        if (filterInfo == null) {
            return null;
        }
        HashSet<String> showFieldSet = new HashSet<String>(16);
        boolean isCountByUnit = filterInfo.getBoolean("countbyunit");
        if (isCountByUnit) {
            showFieldSet.add("unit");
            showFieldSet.add("qty");
            showFieldSet.add("receiveqty");
            showFieldSet.add("invqty");
            showFieldSet.add("openqty");
        } else {
            showFieldSet.add("baseunit");
            showFieldSet.add("baseqty");
            showFieldSet.add("receivebaseqty");
            showFieldSet.add("invbaseqty");
            showFieldSet.add("openbaseqty");
        }
        String sumFoundations = filterInfo.getString("sumfoundation");
        if (sumFoundations != null && sumFoundations.length() > 0) {
            Set<String> sumFoundationSet = PurRptHelper.multipleChoiceStrToSetExcludeEmpty(sumFoundations, ",");
            for (String sumFoundation : sumFoundationSet) {
                showFieldSet.add(sumFoundation.substring(sumFoundation.indexOf(46) + 1));
            }
        }
        return showFieldSet;
    }

    protected void orgChangeEvent() {
        this.setValue("headsupplier", null);
        this.setValue("headmaterial", null);
        this.setValue("project", null);
    }

    protected void showOrgTip() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"OpenOrderBillRptPlugin_1", (String)"scmc-pm-report", (Object[])new Object[0]));
    }

    private boolean checkOrgIsNull(DynamicObjectCollection org) {
        if (org == null || org.size() == 0) {
            this.showOrgTip();
            return true;
        }
        return false;
    }

    private void setValue(String key, Object value) {
        this.getModel().setValue(key, value);
    }

    private void setShowAndSumKeyValue() {
        this.getModel().setValue("showkeycols", null);
        this.getModel().setValue("showkeycols", (Object)"material");
        ComboEdit sumKeyCols = (ComboEdit)this.getView().getControl("sumkeycols");
        ArrayList<ComboItem> sumKeyColsList = new ArrayList<ComboItem>();
        sumKeyColsList.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u7269\u6599", (String)"OpenOrderBillRptPlugin_8", (String)"scmc-pm-report", (Object[])new Object[0])), "material"));
        sumKeyCols.setComboItems(sumKeyColsList);
    }

    private void showKeyChange(Object newValue) {
    }
}

