/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report.receiverate;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ReceiveMaxTimeFunction
extends GroupReduceFunction {
    public void reduce(Iterable<RowX> iterable, Collector collector) {
        Iterator<RowX> iterator = iterable.iterator();
        Algo algo = Algo.create((String)"getMaxReceiveTime");
        RowMeta rowMeta = this.getSourceRowMeta();
        String[] fieldNames = rowMeta.getFieldNames();
        int length = fieldNames.length;
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        int entryIdIndex = rowMeta.getFieldIndex("entryid");
        HashSet<Object> entryIds = new HashSet<Object>();
        while (iterator.hasNext()) {
            Object[] obj = new Object[length];
            RowX rowX = iterator.next();
            for (int i = 0; i < length; ++i) {
                obj[i] = rowX.get(i);
                if (entryIdIndex != i) continue;
                entryIds.add(obj[i]);
            }
            list.add(obj);
        }
        DataSet orderDataSet = algo.createDataSet(list.iterator(), rowMeta);
        QFilter billStatus = new QFilter("billstatus", "=", (Object)"C");
        QFilter bizType = new QFilter("biztype.number", "in", (Object)new String[]{"110", "130"});
        DataSet salOutDataSet = QueryServiceHelper.queryDataSet((String)"queryReceiveMaxBizTime", (String)"im_purinbill", (String)"biztime,billentry.mainbillentryid as srcbillentryid", (QFilter[])new QFilter[]{new QFilter("billentry.mainbillentryid", "in", entryIds), billStatus, bizType}, null);
        DataSet finish1 = orderDataSet.copy().join(salOutDataSet, JoinType.LEFT).on("entryid", "srcbillentryid").select(new String[]{"biztime", "entryid", "srcbillentryid", "suppliernumber", "suppliername", "org"}).finish();
        DataSet maxBizTimeDataSet = finish1.groupBy(new String[]{"srcbillentryid"}).max("biztime").finish();
        DataSet finish = orderDataSet.join(maxBizTimeDataSet, JoinType.LEFT).on("entryid", "srcbillentryid").select(fieldNames, new String[]{"biztime"}).finish();
        while (finish.hasNext()) {
            Row row = finish.next();
            RowX rowX = new RowX(length + 1);
            for (int i = 0; i < length; ++i) {
                String fieldName = fieldNames[i];
                Object value = row.get(fieldName);
                rowX.set(i, value);
            }
            rowX.set(length, (Object)row.getDate("biztime"));
            collector.collect(rowX);
        }
    }

    public RowMeta getResultRowMeta() {
        RowMeta sourceRowMeta = this.getSourceRowMeta();
        Field[] fields = sourceRowMeta.getFields();
        Field[] newFields = new Field[fields.length + 1];
        System.arraycopy(fields, 0, newFields, 0, fields.length);
        newFields[fields.length] = new Field("biztime", (DataType)DataType.DateType);
        RowMeta rowMeta = new RowMeta(newFields);
        return rowMeta;
    }
}

