/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report.recplan;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;

public class RecPlanGroupMapFunc
extends MapFunction {
    private static final long serialVersionUID = -575927404129022346L;
    private final RowMeta rowMeta;
    private static final String PLAN_FIELD = "planfield";
    private static final String ON_TIME_FILED = "ontimefield";
    private static final String OUT_TIME_FILED = "outtimefield";
    private static final String FINISH_RATE_FILED = "finishratefield";

    public RowX map(RowX rowX) {
        int finishRateIndex = this.rowMeta.getFieldIndex(FINISH_RATE_FILED, false);
        if (finishRateIndex == -1) {
            return rowX;
        }
        rowX.set(finishRateIndex, (Object)this.calcFinishRate(rowX));
        return rowX;
    }

    private BigDecimal calcFinishRate(RowX rowX) {
        Integer outTimeNum;
        int outTimeIndex;
        Integer onTimeNum;
        int planIndex = this.rowMeta.getFieldIndex(PLAN_FIELD, false);
        if (planIndex == -1) {
            return BigDecimal.ZERO;
        }
        Integer planNum = rowX.getInteger(planIndex);
        int finishedNum = 0;
        if (planNum == null || planNum == 0) {
            return BigDecimal.ZERO;
        }
        int onTimeIndex = this.rowMeta.getFieldIndex(ON_TIME_FILED, false);
        if (onTimeIndex != -1 && (onTimeNum = rowX.getInteger(onTimeIndex)) != null) {
            finishedNum += onTimeNum.intValue();
        }
        if ((outTimeIndex = this.rowMeta.getFieldIndex(OUT_TIME_FILED, false)) != -1 && (outTimeNum = rowX.getInteger(outTimeIndex)) != null) {
            finishedNum += outTimeNum.intValue();
        }
        if (finishedNum == 0) {
            return BigDecimal.ZERO;
        }
        return new BigDecimal(finishedNum).movePointRight(2).divide(new BigDecimal(planNum), 2, RoundingMode.HALF_UP);
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }

    public RecPlanGroupMapFunc(RowMeta rowMeta) {
        this.rowMeta = rowMeta;
    }
}

