/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report.recplan;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.scmc.pm.report.helper.PurReceivingRptHelper;
import kd.scmc.pm.report.helper.PurRptHelper;
import kd.scmc.pm.report.helper.transform.OrderByTransform;
import kd.scmc.pm.report.recplan.RecPlanGroupTransform;
import kd.scmc.pm.report.recplan.RecPlanTransform;

public class RecPlanRptHandle
implements IReportDataHandle {
    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        for (SrcBlockConf blockConf : blockCollector) {
            QFilter dataFs = blockConf.getDataFs();
            if (dataFs == null) {
                blockConf.setDataFs(this.getFilter(ctx.getParams()));
                continue;
            }
            dataFs.and(this.getFilter(ctx.getParams()));
        }
    }

    private QFilter getFilter(Map<String, Object> param) {
        DynamicObjectCollection operators;
        DynamicObjectCollection operatorGroups;
        DynamicObjectCollection bizdepts;
        DynamicObjectCollection materials;
        QFilter filter = QFilter.of((String)"1=1", (Object[])new Object[0]);
        DynamicObjectCollection org = (DynamicObjectCollection)param.get("purorg");
        if (org != null) {
            filter.and("org", "in", org.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        }
        if ((materials = (DynamicObjectCollection)param.get("material")) != null && !materials.isEmpty()) {
            filter.and("billentry.material.masterid", "in", (Object)PurRptHelper.getMaterialMasterIds(materials));
        }
        Date startDate = (Date)param.get("startdate");
        filter.and("billentry.purbillentry_deliver.plandeliverdate", ">=", (Object)PurReceivingRptHelper.getStartOrEndDate(startDate, false));
        Date endDate = (Date)param.get("enddate");
        filter.and("billentry.purbillentry_deliver.plandeliverdate", "<=", (Object)PurReceivingRptHelper.getStartOrEndDate(endDate, true));
        DynamicObjectCollection suppliers = (DynamicObjectCollection)param.get("supplier");
        if (suppliers != null && !suppliers.isEmpty()) {
            filter.and("supplier.masterid", "in", (Object)PurRptHelper.getMasterIds(suppliers));
        }
        if ((bizdepts = (DynamicObjectCollection)param.get("dept")) != null && !bizdepts.isEmpty()) {
            filter.and("dept", "in", PurReceivingRptHelper.getBaseDataPkIds(bizdepts));
        }
        if ((operatorGroups = (DynamicObjectCollection)param.get("operategroup")) != null && !operatorGroups.isEmpty()) {
            filter.and("operatorgroup", "in", PurReceivingRptHelper.getBaseDataPkIds(operatorGroups));
        }
        if ((operators = (DynamicObjectCollection)param.get("operator")) != null && !operators.isEmpty()) {
            filter.and("operator", "in", PurReceivingRptHelper.getBaseDataPkIds(operators));
        }
        return filter;
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new RecPlanTransform());
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("billclosestatusfield");
        repoColFilter.add("rowclosestatusfield");
        repoColFilter.add("rowtermstatusfield");
        repoColFilter.add("planrecdatefield");
        repoColFilter.add("recdatefield");
        repoColFilter.add("planrecqtyfield");
        repoColFilter.add("recqtyfield");
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        ArrayList<String> orderByFieldList = new ArrayList<String>();
        orderByFieldList.add("supplierfield");
        orderByFieldList.add("materialfield");
        orderByFieldList.add("operatorfield");
        transCollector.add(new OrderByTransform(orderByFieldList, ctx.getSumKeyCols()));
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        transCollector.add(new RecPlanGroupTransform());
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> cols, ReportDataCtx ctx) {
        ArrayList<AbstractReportColumn> columnList = new ArrayList<AbstractReportColumn>(cols.size());
        ReportColumnGroup columnGroup = new ReportColumnGroup();
        columnGroup.setFieldKey("finishedgroup");
        columnGroup.setCaption(new LocaleString(ResManager.loadKDString((String)"\u5b9e\u9645\u5b8c\u6210", (String)"RecPlanRptHandle_2", (String)"scmc-pm-report", (Object[])new Object[0])));
        for (AbstractReportColumn abstractReportColumn : cols) {
            if (abstractReportColumn instanceof ReportColumn) {
                ReportColumn reportCol = (ReportColumn)abstractReportColumn;
                String fieldKey = reportCol.getFieldKey();
                if ("supplierfield_ref_name".equals(fieldKey)) {
                    reportCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u8ba2\u8d27\u4f9b\u5e94\u5546\u540d\u79f0", (String)"RecPlanRptHandle_0", (String)"scmc-pm-report", (Object[])new Object[0])));
                } else if ("materialfield".equals(fieldKey)) {
                    reportCol.setHide(true);
                } else if ("materialfield_ref_masterid.number".equals(fieldKey)) {
                    reportCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"RecPlanRptHandle_3", (String)"scmc-pm-report", (Object[])new Object[0])));
                } else if ("materialfield_ref_masterid.name".equals(fieldKey)) {
                    reportCol.setCaption(new LocaleString(ResManager.loadKDString((String)"\u7269\u6599\u540d\u79f0", (String)"RecPlanRptHandle_1", (String)"scmc-pm-report", (Object[])new Object[0])));
                } else if ("ontimefield".equals(fieldKey) || "outtimefield".equals(fieldKey)) {
                    columnGroup.getChildren().add(reportCol);
                    reportCol = null;
                } else if ("finishratefield".equals(fieldKey)) {
                    reportCol.setNoDisplayScaleZero(false);
                    reportCol.setScale(2);
                }
                columnList.add((AbstractReportColumn)reportCol);
                continue;
            }
            columnList.add(abstractReportColumn);
        }
        if (!columnGroup.getChildren().isEmpty()) {
            int insertIndex = this.getInsertIndex(columnList);
            if (insertIndex == -1) {
                columnList.add((AbstractReportColumn)columnGroup);
            } else {
                columnList.set(insertIndex, (AbstractReportColumn)columnGroup);
            }
        }
        return columnList.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    private int getInsertIndex(List<AbstractReportColumn> columnList) {
        for (int i = 0; i < columnList.size(); ++i) {
            if (columnList.get(i) != null) continue;
            return i;
        }
        return -1;
    }
}

