/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report.recplan;

import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.scmc.pm.business.helper.OrgHelper;
import kd.scmc.pm.enums.OperatorGrpTypeEnum;
import kd.scmc.pm.report.helper.PurRptHelper;

public class RecPlanRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final String HAS_PERMISSION_PUR_ORG = "hasPermissionPurOrg";

    public void registerListener(EventObject e) {
        BasedataEdit dept;
        BasedataEdit operatorGroup;
        BasedataEdit operator;
        BasedataEdit material;
        BasedataEdit supplier;
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getView().getControl("purorg");
        if (org != null) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplier = (BasedataEdit)this.getView().getControl("supplier")) != null) {
            supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((material = (BasedataEdit)this.getView().getControl("material")) != null) {
            material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((operator = (BasedataEdit)this.getView().getControl("operator")) != null) {
            operator.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((operatorGroup = (BasedataEdit)this.getView().getControl("operategroup")) != null) {
            operatorGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((dept = (BasedataEdit)this.getView().getControl("dept")) != null) {
            dept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        long orgId = RequestContext.get().getOrgId();
        List purOrgList = OrgHelper.getHasPermissionOrg((String)this.getView().getFormShowParameter().getFormId(), (String)OrgViewTypeEnum.IS_PURCHASE.getViewType());
        if (purOrgList != null && !purOrgList.isEmpty()) {
            if (purOrgList.contains(orgId)) {
                model.setValue("purorg", (Object)new Object[]{orgId});
            } else {
                model.setValue("purorg", (Object)new Object[]{purOrgList.get(0)});
            }
            this.getPageCache().put(HAS_PERMISSION_PUR_ORG, SerializationUtils.toJsonString((Object)purOrgList));
            Object startDate = model.getValue("startdate");
            Object endDate = model.getValue("enddate");
            if (startDate == null && endDate == null) {
                this.setDefaultDate();
            }
        } else {
            this.getPageCache().put(HAS_PERMISSION_PUR_ORG, "");
        }
    }

    public void afterBindData(EventObject e) {
        DynamicObjectCollection operateGroup = (DynamicObjectCollection)this.getModel().getValue("operategroup");
        if (operateGroup == null || operateGroup.isEmpty()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"operator"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"operator"});
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObjectCollection orgHead = (DynamicObjectCollection)this.getModel().getValue("purorg");
        switch (fieldKey) {
            case "purorg": {
                List<Long> permissionOrgIds = this.getPermissionOrgFromCache();
                if (permissionOrgIds == null || permissionOrgIds.isEmpty()) {
                    showParameter.getListFilterParameter().setFilter(QFilter.of((String)"1!=1", (Object[])new Object[0]));
                    break;
                }
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", permissionOrgIds));
                break;
            }
            case "supplier": {
                if (orgHead == null || orgHead.isEmpty()) {
                    this.showOrgTips();
                    e.setCancel(true);
                    return;
                }
                showParameter.getListFilterParameter().setFilter(PurRptHelper.getBaseDataFilter("bd_supplier", PurRptHelper.getAllOrg(orgHead, false)));
                showParameter.setShowApproved(false);
                break;
            }
            case "material": {
                if (orgHead == null || orgHead.isEmpty()) {
                    this.showOrgTips();
                    e.setCancel(true);
                    return;
                }
                showParameter.getListFilterParameter().setFilter(PurRptHelper.getBaseDataFilter("bd_materialpurchaseinfo", PurRptHelper.getAllOrg(orgHead, false)));
                showParameter.setShowApproved(false);
                break;
            }
            case "operategroup": {
                if (orgHead == null || orgHead.isEmpty()) {
                    this.showOrgTips();
                    e.setCancel(true);
                    return;
                }
                QFilter q1 = PurRptHelper.getBaseDataFilter("bd_operatorgroup", PurRptHelper.getAllOrg(orgHead, false));
                QFilter q2 = new QFilter("operatorgrouptype", "=", (Object)OperatorGrpTypeEnum.PURCHASEGRP.getValue());
                showParameter.getListFilterParameter().setFilter(q1.and(q2));
                break;
            }
            case "operator": {
                if (orgHead == null || orgHead.isEmpty()) {
                    this.showOrgTips();
                    e.setCancel(true);
                    return;
                }
                DynamicObjectCollection operateGroup = (DynamicObjectCollection)this.getModel().getValue("operategroup");
                if (operateGroup == null || operateGroup.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u3002", (String)"RecPlanRptPlugin_2", (String)"scmc-pm-report", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                showParameter.getListFilterParameter().setFilter(this.getOperatorGroupFilter(operateGroup));
                break;
            }
            case "dept": {
                if (orgHead == null || orgHead.isEmpty()) {
                    this.showOrgTips();
                    e.setCancel(true);
                    return;
                }
                showParameter.getListFilterParameter().setFilter(PurRptHelper.getBaseDataFilter("bos_adminorg", PurRptHelper.getAllOrg(orgHead, false)));
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        switch (key) {
            case "purorg": {
                this.changeOrg();
                break;
            }
            case "operategroup": {
                this.changeOperatorGroup((DynamicObjectCollection)newValue);
                break;
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        DynamicObjectCollection org = filter.getDynamicObjectCollection("purorg");
        if (org == null || org.isEmpty()) {
            this.showOrgTips();
            return false;
        }
        Date startDate = filter.getDate("startdate");
        Date endDate = filter.getDate("enddate");
        if (startDate != null && endDate != null) {
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"RecPlanRptPlugin_1", (String)"scmc-pm-report", (Object[])new Object[0]));
        return false;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        this.transParam(queryParam);
    }

    private void transParam(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        Map customParam = queryParam.getCustomParam();
        customParam.put("purorg", filterInfo.getValue("purorg"));
        customParam.put("material", filterInfo.getValue("material"));
        customParam.put("startdate", filterInfo.getValue("startdate"));
        customParam.put("enddate", filterInfo.getValue("enddate"));
        customParam.put("supplier", filterInfo.getValue("supplier"));
        customParam.put("dept", filterInfo.getValue("dept"));
        customParam.put("operategroup", filterInfo.getValue("operategroup"));
        customParam.put("operator", filterInfo.getValue("operator"));
    }

    private List<Long> getPermissionOrgFromCache() {
        String orgIdStr = this.getPageCache().get(HAS_PERMISSION_PUR_ORG);
        if (orgIdStr == null) {
            List orgList = OrgHelper.getHasPermissionOrg((String)this.getView().getFormShowParameter().getFormId(), (String)OrgViewTypeEnum.IS_PURCHASE.getViewType());
            if (orgList == null || orgList.isEmpty()) {
                this.getPageCache().put(HAS_PERMISSION_PUR_ORG, "");
            }
            return orgList;
        }
        if ("".equals(orgIdStr)) {
            return null;
        }
        return (List)SerializationUtils.fromJsonString((String)orgIdStr, List.class);
    }

    private void showOrgTips() {
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"RecPlanRptPlugin_0", (String)"scmc-pm-report", (Object[])new Object[0]));
    }

    private QFilter getOperatorGroupFilter(DynamicObjectCollection operatorGroup) {
        List<Long> groupIdList = PurRptHelper.getAllOrg(operatorGroup, false);
        if (groupIdList.isEmpty()) {
            return QFilter.of((String)"1=1", (Object[])new Object[0]);
        }
        return new QFilter("operatorgrpid", "in", groupIdList);
    }

    private void setDefaultDate() {
        IDataModel model = this.getModel();
        Date today = Date.from(LocalDate.now().atStartOfDay(ZoneId.systemDefault()).toInstant());
        model.setValue("startdate", (Object)today);
        model.setValue("enddate", (Object)today);
    }

    private void changeOrg() {
        IDataModel model = this.getModel();
        model.setValue("material", null);
        model.setValue("supplier", null);
        model.setValue("operator", null);
        model.setValue("operategroup", null);
        model.setValue("dept", null);
    }

    private void changeOperatorGroup(DynamicObjectCollection operatorGroup) {
        if (operatorGroup == null || operatorGroup.isEmpty()) {
            this.getModel().setValue("operator", null);
            this.getView().setEnable(Boolean.FALSE, new String[]{"operator"});
        } else {
            this.getModel().setValue("operator", null);
            this.getView().setEnable(Boolean.TRUE, new String[]{"operator"});
        }
    }
}

