/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report.supplierabc;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import java.util.LinkedList;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;

public class SupplierABCFunction
extends GroupReduceFunction {
    private BigDecimal PROPORTIONA = new BigDecimal(0);
    private BigDecimal PROPORTIONB = new BigDecimal(0);

    public SupplierABCFunction(BigDecimal proportionA, BigDecimal proportionB) {
        this.PROPORTIONA = proportionA;
        this.PROPORTIONB = proportionB;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        BigDecimal allAmount = BigDecimal.ZERO;
        Iterator<RowX> iterator = iterable.iterator();
        RowMeta rowMeta = this.getResultRowMeta();
        String[] fieldNames = rowMeta.getFieldNames();
        LinkedList<Object[]> list = new LinkedList<Object[]>();
        int curAmountAndTaxIndex = rowMeta.getFieldIndex("curamountandtax");
        while (iterator.hasNext()) {
            RowX rowX = iterator.next();
            BigDecimal curAmountAndTax = rowX.getBigDecimal(curAmountAndTaxIndex);
            allAmount = allAmount.add(curAmountAndTax);
            Object[] values = new Object[fieldNames.length];
            for (int i = 0; i < fieldNames.length; ++i) {
                values[i] = rowX.get(i);
            }
            list.add(values);
        }
        BigDecimal purproportion = BigDecimal.ZERO;
        int purProportionIndex = rowMeta.getFieldIndex("purproportion");
        int groupIndex = rowMeta.getFieldIndex("group");
        for (Object[] value : list) {
            BigDecimal curAmountAndTax = (BigDecimal)value[curAmountAndTaxIndex];
            BigDecimal rowPurProportion = BigDecimal.ZERO;
            if (allAmount.compareTo(BigDecimal.ZERO) != 0) {
                rowPurProportion = curAmountAndTax.divide(allAmount, 4, RoundingMode.HALF_UP).multiply(BigDecimal.valueOf(100L));
                value[purProportionIndex] = rowPurProportion;
            }
            value[groupIndex] = (purproportion = purproportion.add(rowPurProportion)).compareTo(this.PROPORTIONA) < 0 ? "A" : (purproportion.compareTo(this.PROPORTIONA) >= 0 && purproportion.subtract(rowPurProportion).compareTo(this.PROPORTIONA) < 0 ? "A" : (purproportion.compareTo(this.PROPORTIONA) >= 0 && purproportion.subtract(rowPurProportion).compareTo(this.PROPORTIONB.add(this.PROPORTIONA)) < 0 ? "B" : "C"));
            collector.collect(new RowX(value));
        }
    }

    public RowMeta getResultRowMeta() {
        RowMeta sourceRowMeta = this.getSourceRowMeta();
        return sourceRowMeta;
    }
}

