/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.report.supplierabc;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.org.OrgViewServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.scmc.pm.utils.CommonUtils;

public class SupplierABCRptPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener {
    private static final String HAS_PERMISSION_PUR_ORG = "hasPermissionPurOrg";
    private static final String ORG = "org_h";
    private static final String PROPORTIONA = "proportiona_h";
    private static final String PROPORTIONB = "proportionb_h";
    private static final String PROPORTIONC = "proportionc_h";

    public void registerListener(EventObject e) {
        BasedataEdit org = (BasedataEdit)this.getView().getControl(ORG);
        if (org != null) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        long orgId = RequestContext.get().getOrgId();
        String formId = this.getView().getFormShowParameter().getFormId();
        List<Long> purorgList = SupplierABCRptPlugin.getHasPermissionOrg(formId, OrgViewTypeEnum.IS_PURCHASE.getViewType());
        if (purorgList != null && !purorgList.isEmpty()) {
            if (purorgList.contains(orgId)) {
                model.setValue(ORG, (Object)new Object[]{orgId});
            } else {
                model.setValue(ORG, (Object)new Object[]{purorgList.get(0)});
            }
            Object startdate = model.getValue("startdate");
            Object enddate = model.getValue("enddate");
            if (startdate == null && enddate == null) {
                this.setdefaultDate();
            }
        }
    }

    private void setdefaultDate() {
        IDataModel model = this.getModel();
        Calendar cal = Calendar.getInstance();
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        model.setValue("startdate", (Object)cal.getTime());
        model.setValue("enddate", (Object)cal.getTime());
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (fieldKey) {
            case "org_h": {
                String purpkSet = this.getPageCache().get(HAS_PERMISSION_PUR_ORG);
                if (purpkSet == null || purpkSet.length() < 1) {
                    List<Long> orgList = SupplierABCRptPlugin.getHasPermissionOrg("pm_supplier_abc_new", OrgViewTypeEnum.IS_PURCHASE.getViewType());
                    showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", orgList));
                    break;
                }
                showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", SerializationUtils.fromJsonString((String)purpkSet, List.class)));
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filter = queryParam.getFilter();
        DynamicObjectCollection org = filter.getDynamicObjectCollection(ORG);
        if (org == null || org != null && org.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"SupplierABCRptPlugin_0", (String)"scmc-pm-report", (Object[])new Object[0]));
            return false;
        }
        BigDecimal proportionA = filter.getBigDecimal(PROPORTIONA);
        BigDecimal proportionB = filter.getBigDecimal(PROPORTIONB);
        BigDecimal proportionC = filter.getBigDecimal(PROPORTIONC);
        if (proportionA.add(proportionB).add(proportionC).compareTo(new BigDecimal(100)) != 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"ABC\u7c7b\u6bd4\u4f8b\u4e4b\u548c\u5fc5\u987b\u7b49\u4e8e100\u3002", (String)"SupplierABCRptPlugin_4", (String)"scmc-pm-report", (Object[])new Object[0]));
            return false;
        }
        Date startdate = filter.getDate("startdate");
        Date enddate = filter.getDate("enddate");
        if (startdate != null && enddate != null) {
            return true;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65e5\u671f\u3002", (String)"SupplierABCRptPlugin_5", (String)"scmc-pm-report", (Object[])new Object[0]));
        return false;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        Map customParam = queryParam.getCustomParam();
        DynamicObject dataEntity = this.getModel().getDataEntity();
        DynamicObjectCollection org = dataEntity.getDynamicObjectCollection(ORG);
        if (org != null) {
            customParam.put("org", SupplierABCRptPlugin.getBaseDataPkIds(org));
        } else {
            customParam.put("org", null);
        }
        customParam.put("proportiona", dataEntity.getBigDecimal(PROPORTIONA));
        customParam.put("proportionb", dataEntity.getBigDecimal(PROPORTIONB));
        customParam.put("proportionc", dataEntity.getBigDecimal(PROPORTIONC));
        customParam.put("startdate", dataEntity.getDate("startdate"));
        customParam.put("enddate", dataEntity.getDate("enddate"));
    }

    private static List<Long> getBaseDataPkIds(DynamicObjectCollection col) {
        if (col == null || col.size() < 1) {
            return null;
        }
        ArrayList<Long> pkIds = new ArrayList<Long>(col.size());
        for (int i = 0; i < col.size(); ++i) {
            DynamicObject baseData = (DynamicObject)col.get(i);
            pkIds.add((Long)baseData.get("fbasedataid_id"));
        }
        return pkIds;
    }

    public static List<Long> getHasPermissionOrg(String entityName, String orgViewType) {
        List hasPermissionOrgs = OrgViewServiceHelper.getAllPermissionOrgs((String)entityName, (String)orgViewType);
        if (CommonUtils.isNull((Object)hasPermissionOrgs)) {
            return null;
        }
        ArrayList<Long> orgs = new ArrayList<Long>(hasPermissionOrgs.size());
        for (Map tempOrg : hasPermissionOrgs) {
            Long tempOrgId = Long.valueOf((String)tempOrg.get("id"));
            orgs.add(tempOrgId);
        }
        return orgs;
    }
}

