/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pmp.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.pmp.report.helper.PurHistoricalPriceRptHelper;
import kd.scmc.pmp.report.pojo.PurHistoricalPriceInfo;

public class PurHistoricalPriceRptQuery
extends AbstractReportListDataPlugin {
    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        QFilter billStatus = new QFilter("billstatus", "=", (Object)"C");
        QFilter priceAndTax = new QFilter("billentry.priceandtax", "!=", (Object)BigDecimal.ZERO);
        QFilter changeStatus = new QFilter("changestatus", "!=", (Object)"B");
        FilterInfo filter = reportQueryParam.getFilter();
        List<QFilter> allFilters = PurHistoricalPriceRptHelper.getFilters(filter);
        allFilters.add(billStatus);
        allFilters.add(priceAndTax);
        allFilters.add(changeStatus);
        boolean isvirtual = filter.getBoolean("virtualfield");
        if (!isvirtual) {
            allFilters.add(new QFilter("isvirtualbill", "=", (Object)Boolean.FALSE));
        }
        String selectField = PurHistoricalPriceRptHelper.getSelectField();
        DataSet price = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_purorderbill", (String)selectField, (QFilter[])allFilters.toArray(new QFilter[allFilters.size()]), (String)"billentry.material desc, biztime desc");
        price = price.where("baseqty != 0").where("curamountandtax != 0");
        DataSet hisPrice = price.copy().select(new String[]{"amountandtax/qty as historyprice", "curamountandtax/baseqty as curhistoryprice", "material", "entryid", "auxpty", "id", "curamountandtax", "baseqty", "currency", "settlecurrency"});
        hisPrice = hisPrice.where("curhistoryprice != 0");
        DataSet recordHighPrice = hisPrice.groupBy(new String[]{"material"}).max("curhistoryprice").finish();
        recordHighPrice = recordHighPrice.select(new String[]{"material", "curhistoryprice as recordhighprice"});
        DataSet recordLowPrice = hisPrice.groupBy(new String[]{"material"}).min("curhistoryprice").finish();
        recordLowPrice = recordLowPrice.select(new String[]{"material", "curhistoryprice as recordlowprice"});
        DataSet recordAvgPrice = hisPrice.groupBy(new String[]{"material"}).sum("curamountandtax").sum("baseqty").finish();
        recordAvgPrice = recordAvgPrice.select(new String[]{"material", "curamountandtax/baseqty as recordavgprice"});
        DataSet dataSet = hisPrice.join(recordHighPrice, JoinType.LEFT).on("material", "material").select(new String[]{"material", "entryid", "id", "historyprice", "curhistoryprice", "currency", "settlecurrency", "auxpty", "curamountandtax", "baseqty"}, new String[]{"recordhighprice"}).finish();
        dataSet = dataSet.join(recordLowPrice, JoinType.LEFT).on("material", "material").select(new String[]{"material", "entryid", "id", "historyprice", "curhistoryprice", "currency", "settlecurrency", "auxpty", "curamountandtax", "baseqty", "recordhighprice"}, new String[]{"recordlowprice"}).finish();
        DataSet allSet = dataSet.join(recordAvgPrice, JoinType.LEFT).on("material", "material").select(new String[]{"material", "entryid", "id", "historyprice", "curhistoryprice", "currency", "settlecurrency", "auxpty", "curamountandtax", "baseqty", "recordhighprice", "recordlowprice"}, new String[]{"recordavgprice"}).finish();
        allSet = allSet.where("curhistoryprice != 0");
        ArrayList<PurHistoricalPriceInfo> infos = new ArrayList<PurHistoricalPriceInfo>(16);
        Map currencyMap = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (String)"id, priceprecision, amtprecision", (QFilter[])new QFilter[]{QFilter.of((String)"1=1", (Object[])new Object[0])});
        for (Row row : allSet) {
            PurHistoricalPriceInfo priceInfo = new PurHistoricalPriceInfo();
            priceInfo.setMaterial(row.getLong("material"));
            priceInfo.setEntryId(row.getLong("entryid"));
            priceInfo.setId(row.getLong("id"));
            Long currencyID = row.getLong("currency");
            Long settleCurrencyID = row.getLong("settlecurrency");
            int pricePrecision = 2;
            int priceSettlePrecision = 2;
            if (currencyMap != null) {
                DynamicObject settleCurrency;
                DynamicObject currency = (DynamicObject)currencyMap.get(currencyID);
                if (currency != null) {
                    pricePrecision = currency.getInt("priceprecision");
                }
                if ((settleCurrency = (DynamicObject)currencyMap.get(settleCurrencyID)) != null) {
                    priceSettlePrecision = settleCurrency.getInt("priceprecision");
                }
            }
            BigDecimal curHistoryprice = row.getBigDecimal("curhistoryprice").setScale(pricePrecision, 4);
            BigDecimal recordhighprice = row.getBigDecimal("recordhighprice").setScale(pricePrecision, 4);
            BigDecimal recordlowprice = row.getBigDecimal("recordlowprice").setScale(pricePrecision, 4);
            BigDecimal recordavgprice = row.getBigDecimal("recordavgprice").setScale(pricePrecision, 4);
            BigDecimal historyprice = row.getBigDecimal("historyprice").setScale(priceSettlePrecision, 4);
            if (curHistoryprice.compareTo(recordavgprice) == 0) {
                priceInfo.setCompare("C");
            } else if (curHistoryprice.compareTo(recordhighprice) >= 0) {
                priceInfo.setCompare("A");
            } else if (curHistoryprice.compareTo(recordlowprice) <= 0) {
                priceInfo.setCompare("B");
            } else if (curHistoryprice.compareTo(recordavgprice) > 0) {
                priceInfo.setCompare("D");
            } else {
                priceInfo.setCompare("E");
            }
            priceInfo.setHistoryPrice(historyprice);
            priceInfo.setCurHistoryPrice(curHistoryprice);
            infos.add(priceInfo);
        }
        DataSet buildSet = this.createDataSet(infos);
        DataSet finish = price.join(buildSet, JoinType.LEFT).on("material", "material").on("entryid", "entryid").on("id", "id").select(new String[]{"material", "modelnum", "auxpty", "org", "supplier", "dept", "operatorgroup", "operator", "biztime", "billno", "rowseq", "currency", "exchangerate", "settlecurrency", "unit", "qty", "priceandtax", "discounttype", "discountrate"}, new String[]{"compare", "historyprice", "curhistoryprice"}).finish();
        return finish.where("historyprice != 0").orderBy(new String[]{"material desc", "biztime desc", "billno desc", "rowseq asc"});
    }

    private DataSet createDataSet(List<PurHistoricalPriceInfo> list) {
        List<Object[]> rows = this.createRow(list);
        Algo algo = Algo.create((String)(((Object)((Object)this)).getClass().getName() + ".query"));
        DataSetBuilder builder = algo.createDataSetBuilder(this.getRowMeta());
        if (rows != null && rows.size() > 0) {
            for (Object[] values : rows) {
                builder.append(values);
            }
        }
        return builder.build();
    }

    private List<Object[]> createRow(List<PurHistoricalPriceInfo> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>(16);
        for (int i = 0; i < list.size(); ++i) {
            PurHistoricalPriceInfo info = list.get(i);
            Object[] row = new Object[]{info.getMaterial(), info.getEntryId(), info.getId(), info.getCompare(), info.getHistoryPrice(), info.getCurHistoryPrice()};
            rows.add(row);
        }
        return rows;
    }

    private RowMeta getRowMeta() {
        List<Field> fields = this.getRowMetaField();
        return new RowMeta(fields.toArray(new Field[0]));
    }

    private List<Field> getRowMetaField() {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("material", (DataType)DataType.LongType));
        fields.add(new Field("entryid", (DataType)DataType.LongType));
        fields.add(new Field("id", (DataType)DataType.LongType));
        fields.add(new Field("compare", (DataType)DataType.StringType));
        fields.add(new Field("historyprice", (DataType)DataType.BigDecimalType));
        fields.add(new Field("curhistoryprice", (DataType)DataType.BigDecimalType));
        return fields;
    }
}

