/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pmp.report.pureshistoricalprice;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;

public class ComputAvgPriceFunction
extends GroupReduceFunction {
    private Map<Object, DynamicObject> currencyMap;

    public ComputAvgPriceFunction() {
    }

    public ComputAvgPriceFunction(Map<Object, DynamicObject> currencyMap) {
        this.currencyMap = currencyMap;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        Iterator<RowX> iterator = iterable.iterator();
        RowMeta rowMeta = this.getSourceRowMeta();
        String[] fieldNames = rowMeta.getFieldNames();
        int curamountandtaxIndex = rowMeta.getFieldIndex("curamountandtax");
        int baseqtyIndex = rowMeta.getFieldIndex("baseqty");
        int currencyIndex = rowMeta.getFieldIndex("currency");
        while (iterator.hasNext()) {
            DynamicObject currency;
            RowX x = new RowX(fieldNames.length + 1);
            RowX next = iterator.next();
            for (int index = 0; index < fieldNames.length; ++index) {
                String fieldName = fieldNames[index];
                Object value = next.get(rowMeta.getFieldIndex(fieldName));
                x.set(index, value);
            }
            int curhistorypriceIndex = fieldNames.length;
            BigDecimal curamountandtax = next.getBigDecimal(curamountandtaxIndex);
            BigDecimal baseqty = next.getBigDecimal(baseqtyIndex);
            Long currencyID = next.getLong(currencyIndex);
            int pricePrecision = 2;
            if (this.currencyMap != null && (currency = this.currencyMap.get(currencyID)) != null) {
                pricePrecision = currency.getInt("priceprecision");
            }
            if (curamountandtax != null && baseqty != null && curamountandtax.compareTo(BigDecimal.ZERO) != 0 && baseqty.compareTo(BigDecimal.ZERO) != 0) {
                BigDecimal historyprice = curamountandtax.divide(baseqty, pricePrecision, 4);
                x.set(curhistorypriceIndex, (Object)historyprice);
            } else {
                x.set(curhistorypriceIndex, (Object)BigDecimal.ZERO);
            }
            collector.collect(x);
        }
    }

    public RowMeta getResultRowMeta() {
        RowMeta sourceRowMeta = this.getSourceRowMeta();
        Field[] fields = sourceRowMeta.getFields();
        Field[] newFields = new Field[fields.length + 1];
        System.arraycopy(fields, 0, newFields, 0, fields.length);
        newFields[fields.length] = new Field("recordavgprice", (DataType)DataType.BigDecimalType);
        RowMeta rowMeta = new RowMeta(newFields);
        return rowMeta;
    }
}

