/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pmp.report.pureshistoricalprice;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.RowX;
import kd.bos.dataentity.entity.DynamicObject;

public class PurHistPriceFunction
extends GroupReduceFunction {
    private Map<Object, DynamicObject> currencyMap;

    public PurHistPriceFunction() {
    }

    public PurHistPriceFunction(Map<Object, DynamicObject> currencyMap) {
        this.currencyMap = currencyMap;
    }

    public void reduce(Iterable<RowX> iterable, Collector collector) {
        Iterator<RowX> iterator = iterable.iterator();
        RowMeta rowMeta = this.getSourceRowMeta();
        String[] fieldNames = rowMeta.getFieldNames();
        int amountandtaxIndex = rowMeta.getFieldIndex("amountandtax");
        int qtyIndex = rowMeta.getFieldIndex("qty");
        int curamountandtaxIndex = rowMeta.getFieldIndex("curamountandtax");
        int baseqtyIndex = rowMeta.getFieldIndex("baseqty");
        int settleCurrencyIndex = rowMeta.getFieldIndex("settlecurrency");
        int currencyIndex = rowMeta.getFieldIndex("currency");
        while (iterator.hasNext()) {
            RowX next = iterator.next();
            BigDecimal amountandtax = next.getBigDecimal(amountandtaxIndex);
            BigDecimal qty = next.getBigDecimal(qtyIndex);
            BigDecimal curamountandtax = next.getBigDecimal(curamountandtaxIndex);
            BigDecimal baseqty = next.getBigDecimal(baseqtyIndex);
            Long currencyID = next.getLong(currencyIndex);
            Long settleCurrencyID = next.getLong(settleCurrencyIndex);
            int pricePrecision = 2;
            int priceSettlePrecision = 2;
            if (this.currencyMap != null) {
                DynamicObject settleCurrency;
                DynamicObject currency = this.currencyMap.get(currencyID);
                if (currency != null) {
                    pricePrecision = currency.getInt("priceprecision");
                }
                if ((settleCurrency = this.currencyMap.get(settleCurrencyID)) != null) {
                    priceSettlePrecision = settleCurrency.getInt("priceprecision");
                }
            }
            for (int index = 0; index < fieldNames.length; ++index) {
                String fieldName = fieldNames[index];
                if (fieldName.equalsIgnoreCase("historyprice")) {
                    if (amountandtax != null && qty != null && amountandtax.compareTo(BigDecimal.ZERO) != 0 && qty.compareTo(BigDecimal.ZERO) != 0) {
                        BigDecimal historyprice = amountandtax.divide(qty, priceSettlePrecision, 4);
                        next.set(index, (Object)historyprice);
                        continue;
                    }
                    next.set(index, (Object)BigDecimal.ZERO);
                    continue;
                }
                if (fieldName.equalsIgnoreCase("curhistoryprice")) {
                    if (curamountandtax != null && baseqty != null && curamountandtax.compareTo(BigDecimal.ZERO) != 0 && baseqty.compareTo(BigDecimal.ZERO) != 0) {
                        BigDecimal curhistoryprice = curamountandtax.divide(baseqty, pricePrecision, 4);
                        next.set(index, (Object)curhistoryprice);
                        continue;
                    }
                    next.set(index, (Object)BigDecimal.ZERO);
                    continue;
                }
                Object value = next.get(rowMeta.getFieldIndex(fieldName));
                next.set(index, value);
            }
            collector.collect(next);
        }
    }

    public RowMeta getResultRowMeta() {
        RowMeta sourceRowMeta = this.getSourceRowMeta();
        return sourceRowMeta;
    }
}

