/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pmp.report.pureshistoricalprice;

import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.algox.Collector;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.RowX;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.scmc.pmp.report.pureshistoricalprice.ComputAvgPriceFunction;
import kd.scmc.pmp.report.pureshistoricalprice.ComputHistoryPriceFunction;
import kd.scmc.pmp.report.pureshistoricalprice.PurHistPriceFunction;

public class PurHistPriceTransform
implements IDataXTransform {
    public DataSetX doTransform(DataSetX srcData) {
        if (this.hasField(srcData.getRowMeta(), new String[]{"material", "settlecurrency", "currency", "biztime", "amountandtax", "qty", "curamountandtax", "baseqty", "historyprice", "curhistoryprice", "entryid", "auxpty", "id", "billno", "rowseq", "compare"})) {
            srcData = srcData.orderBy(new String[]{"material desc", "biztime desc"});
            Map currencyMap = BusinessDataServiceHelper.loadFromCache((String)"bd_currency", (String)"id, priceprecision, amtprecision", (QFilter[])new QFilter[]{QFilter.of((String)"1=1", (Object[])new Object[0])});
            DataSetX resData = srcData.reduceGroup((GroupReduceFunction)new PurHistPriceFunction(currencyMap));
            DataSetX hisPrice = resData.select(new String[]{"historyprice", "curhistoryprice", "material", "currency", "entryid", "auxpty", "id", "curamountandtax", "baseqty"});
            hisPrice = hisPrice.filter("curhistoryprice != 0");
            DataSetX recordHighPrice = hisPrice.groupBy(new String[]{"material"}).max("curhistoryprice", "recordhighprice");
            recordHighPrice = recordHighPrice.select(new String[]{"material", "recordhighprice"});
            DataSetX recordLowPrice = hisPrice.groupBy(new String[]{"material"}).min("curhistoryprice", "recordlowprice");
            recordLowPrice = recordLowPrice.select(new String[]{"material", "recordlowprice"});
            DataSetX recordAvgPrice = hisPrice.groupBy(new String[]{"material", "currency"}).sum("curamountandtax").sum("baseqty");
            recordAvgPrice = recordAvgPrice.reduceGroup((GroupReduceFunction)new ComputAvgPriceFunction(currencyMap)).select(new String[]{"material", "recordavgprice"});
            JoinDataSetX dataSet = hisPrice.leftJoin(recordHighPrice).on("material", "material").select(new String[]{"material", "entryid", "id", "curhistoryprice", "auxpty", "curamountandtax", "baseqty"}, new String[]{"recordhighprice"});
            dataSet = dataSet.leftJoin(recordLowPrice).on("material", "material").select(new String[]{"material", "entryid", "id", "curhistoryprice", "auxpty", "curamountandtax", "baseqty", "recordhighprice"}, new String[]{"recordlowprice"});
            JoinDataSetX allSet = dataSet.leftJoin(recordAvgPrice).on("material", "material").select(new String[]{"material", "entryid", "id", "curhistoryprice", "auxpty", "curamountandtax", "baseqty", "recordhighprice", "recordlowprice"}, new String[]{"recordavgprice"});
            allSet = allSet.filter("curhistoryprice != 0");
            DataSetX buildSet = allSet.reduceGroup((GroupReduceFunction)new ComputHistoryPriceFunction()).select(new String[]{"material", "entryid", "id", "compared"});
            String[] fieldNames = srcData.getRowMeta().getFieldNames();
            JoinDataSetX finish = resData.leftJoin(buildSet).on("material", "material").on("entryid", "entryid").on("id", "id").select(fieldNames, new String[]{"compared"});
            finish = finish.reduceGroup(new GroupReduceFunction(){

                public void reduce(Iterable<RowX> iterable, Collector collector) {
                    Iterator<RowX> iterator = iterable.iterator();
                    RowMeta rowMeta = this.getSourceRowMeta();
                    int comparedIndex = rowMeta.getFieldIndex("compared");
                    int compareIndex = rowMeta.getFieldIndex("compare");
                    while (iterator.hasNext()) {
                        RowX next = iterator.next();
                        String historyprice = next.getString(comparedIndex);
                        next.set(compareIndex, (Object)historyprice);
                        collector.collect(next);
                    }
                }

                public RowMeta getResultRowMeta() {
                    return this.sourceRowMeta;
                }
            });
            DataSetX finalData = finish.filter("historyprice!= 0").orderBy(new String[]{"material desc", "biztime desc", "billno desc", "rowseq asc"});
            return finalData;
        }
        return srcData;
    }

    private boolean hasField(RowMeta rowMeta, String[] fields) {
        for (String field : fields) {
            Field metaField = rowMeta.getField(field, false);
            if (metaField != null) continue;
            return false;
        }
        return true;
    }
}

