/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.apply;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.InitImportDataEventArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.msbd.changemodel.common.enums.BatChangeStatusEnum;
import kd.scmc.pm.business.helper.BillImportHelper;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.helper.OrgHelper;
import kd.scmc.pm.enums.StatusEnum;

public class BatXPurApplyBillImportPlugin
extends AbstractFormPlugin {
    private Map<String, Object> tempCache = new HashMap<String, Object>();
    private static final String[] selectedProps = new String[]{"id", "billno", "billentry.id billentryid", "billentry.seq billentryseq", "billentry.material material", "billentry.materialname materialname", "billentry.entryoperatorgroup entryoperatorgroup", "billentry.entryoperator entryoperator", "billentry.supplier supplier", "billentry.auxpty auxpty", "billentry.baseunit baseunit", "billentry.baseqty baseqty", "billentry.unit unit", "billentry.qty qty", "billentry.reqdate reqdate"};
    private static final String[] selectedKeys = new String[]{"id", "billno", "billentryid", "billentryseq", "material", "entryoperatorgroup", "entryoperator", "supplier", "materialname", "auxpty", "baseunit", "baseqty", "unit", "qty", "reqdate"};

    public void initImportData(InitImportDataEventArgs e) {
        IDataModel model = (IDataModel)e.getSource();
        IPageCache pageCache = this.getPageCache();
        List sourceDataList = e.getSourceDataList();
        if (sourceDataList.isEmpty()) {
            return;
        }
        BillImportHelper.billCreTypeFlag((IPageCache)pageCache, (List)sourceDataList);
        List hasPermissionOrg = (List)this.tempCache.get("hasPermissionOrg");
        if (hasPermissionOrg == null) {
            hasPermissionOrg = OrgHelper.getHasPermissionOrg((String)model.getDataEntityType().getName(), (String)"02");
            this.tempCache.put("hasPermissionOrg", hasPermissionOrg);
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        Map data = e.getSourceData();
        DynamicObject org = this.getBaseDataFromCache(data, "org", "bos_org", null, null);
        if (org == null) {
            return;
        }
        List hasPermissionOrg = (List)this.tempCache.get("hasPermissionOrg");
        if (hasPermissionOrg == null || !hasPermissionOrg.contains(org.getPkValue())) {
            Object orgs = data.get("org");
            Map propMap = BillImportHelper.format4ImportAndApi(orgs);
            e.setCancel(true);
            e.setCancelMessage(String.format(ResManager.loadKDString((String)"\u91c7\u8d2d\u7ec4\u7ec7\u3010%1$s\u3011\u4e0d\u5728\u7528\u6237\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"BatXPurApplyBillImportPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]), propMap.get(propMap.get("importprop"))));
            e.setFireAfterImportData(false);
            return;
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        DynamicObject org;
        IDataModel model = this.getModel();
        Date changeDate = (Date)model.getValue("changedate");
        if (changeDate == null) {
            this.getModel().setValue("changedate", (Object)System.currentTimeMillis());
        }
        if ((org = (DynamicObject)model.getValue("org")) == null) {
            return;
        }
        model.setValue("billstatus", (Object)StatusEnum.SAVE.getValue());
        DynamicObjectCollection billEntries = (DynamicObjectCollection)model.getValue("entryentity");
        if (billEntries != null) {
            HashSet<String> srcBillNos = new HashSet<String>(8);
            HashSet<Integer> srcEntrySeqs = new HashSet<Integer>(8);
            for (DynamicObject entry : billEntries) {
                Integer xsbillEntrySeq;
                String xsbillNo = entry.getString("xsbillno");
                if (StringUtils.isNotBlank((CharSequence)xsbillNo)) {
                    srcBillNos.add(xsbillNo);
                }
                if ((long)(xsbillEntrySeq = Integer.valueOf(entry.getInt("xsbillentryseq"))).intValue() == 0L) continue;
                srcEntrySeqs.add(xsbillEntrySeq);
            }
            if (srcEntrySeqs.size() > 0 && srcBillNos.size() > 0) {
                HashMap<String, Map> valueMap = new HashMap<String, Map>(8);
                QFilter q1 = new QFilter("billno", "in", srcBillNos);
                QFilter q2 = new QFilter("billentry.seq", "in", srcEntrySeqs);
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)this.getPluginName(), (String)"pm_purapplybill", (String)String.join((CharSequence)",", selectedProps), (QFilter[])new QFilter[]{q1, q2}, null);){
                    if (ds != null) {
                        for (Row row : ds) {
                            String billno = row.getString("billno");
                            String billentryseq = row.getString("billentryseq");
                            Map map = valueMap.computeIfAbsent(billno + billentryseq, k -> new HashMap(8));
                            for (String key : selectedKeys) {
                                map.put(key, row.get(key));
                            }
                        }
                    }
                }
                HashSet<Long> materialIds = new HashSet<Long>(8);
                HashSet<Long> baseUnitIds = new HashSet<Long>(8);
                for (int i = 0; i < billEntries.size(); ++i) {
                    String xsbillNo = (String)model.getValue("xsbillno", i);
                    Integer xsbillEntrySeq = (Integer)model.getValue("xsbillentryseq", i);
                    Map map = (Map)valueMap.get(xsbillNo + xsbillEntrySeq);
                    if (map == null) continue;
                    model.setValue("xsbillid", map.get("id"), i);
                    model.setValue("xsbillentryid", map.get("billentryid"), i);
                    model.setValue("supplier", map.get("supplier"), i);
                    model.setValue("entryoperatorgroup", map.get("entryoperatorgroup"), i);
                    model.setValue("entryoperator", map.get("entryoperator"), i);
                    DynamicObject material = (DynamicObject)model.getValue("material", i);
                    if (material == null) {
                        Long materialId = (Long)map.get("material");
                        materialIds.add(materialId);
                        model.setValue("material", (Object)materialId, i);
                    }
                    Long unitId = (Long)map.get("unit");
                    Long baseUnitId = (Long)map.get("baseunit");
                    if (baseUnitId != null && baseUnitId != 0L) {
                        baseUnitIds.add(baseUnitId);
                    }
                    model.setValue("unit", (Object)unitId, i);
                    model.setValue("baseunit", (Object)baseUnitId, i);
                    model.setValue("qty", map.get("qty"), i);
                    model.setValue("materialname", map.get("materialname"), i);
                    model.setValue("auxpty", map.get("auxpty"), i);
                    model.setValue("baseqty", map.get("baseqty"), i);
                    BigDecimal afterQty = (BigDecimal)model.getValue("afterqty", i);
                    if (afterQty == null || afterQty.compareTo(BigDecimal.ZERO) == 0) {
                        afterQty = (BigDecimal)map.get("qty");
                        model.setValue("afterqty", (Object)afterQty, i);
                    }
                    model.setValue("reqdate", map.get("reqdate"), i);
                    Date afterReqDate = (Date)model.getValue("afterreqdate", i);
                    if (afterReqDate == null) {
                        model.setValue("afterreqdate", map.get("reqdate"), i);
                    }
                    model.setValue("changestatus", (Object)BatChangeStatusEnum.NORMAL.getValue(), i);
                }
                Map materialMap = BusinessDataServiceHelper.loadFromCache((String)"bd_materialpurchaseinfo", (String)"masterid", (QFilter[])new QFilter[]{new QFilter("id", "in", materialIds)});
                Map baseUnitIdsMap = BusinessDataServiceHelper.loadFromCache((String)"bd_measureunits", (String)"id,precision,precisionaccount", (QFilter[])new QFilter[]{new QFilter("id", "in", baseUnitIds)});
                for (int i = 0; i < billEntries.size(); ++i) {
                    DynamicObject material = (DynamicObject)model.getValue("material", i);
                    DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", i);
                    DynamicObject unit = (DynamicObject)model.getValue("unit", i);
                    BigDecimal afterQty = (BigDecimal)model.getValue("afterqty", i);
                    if (material == null || unit == null || baseUnit == null || afterQty == null) continue;
                    DynamicObject master = material.getDynamicObject("masterid");
                    if (master == null && (material = (DynamicObject)materialMap.get(material.getPkValue())) != null) {
                        master = material.getDynamicObject("masterid");
                    }
                    if (master == null || (baseUnit = (DynamicObject)baseUnitIdsMap.get(baseUnit.getPkValue())) == null) continue;
                    BigDecimal afterBaseQty = BillQtyAndUnitHelper.getDesQtyConv((Long)((Long)master.getPkValue()), (Long)((Long)unit.getPkValue()), (BigDecimal)afterQty, (DynamicObject)baseUnit);
                    model.setValue("afterbaseqty", (Object)afterBaseQty, i);
                }
            }
        }
    }

    private DynamicObject getBaseDataFromCache(Map<String, Object> sourceData, String propName, String propEntityName, String select, QFilter[] qFilters) {
        if (sourceData == null) {
            return null;
        }
        Map propMap = BillImportHelper.format4ImportAndApi((Object)sourceData.get(propName));
        if (propMap != null) {
            String importProp = (String)propMap.get("importprop");
            DynamicObject value = (DynamicObject)this.tempCache.get(propName + "_" + propMap.get(importProp));
            if (value == null && !"id".equals(importProp)) {
                if (select == null) {
                    select = "id";
                }
                if (qFilters == null) {
                    qFilters = new QFilter[]{new QFilter(importProp, "=", (Object)((String)propMap.get(importProp)))};
                }
                value = BusinessDataServiceHelper.loadSingleFromCache((String)propEntityName, (String)select, (QFilter[])qFilters);
            }
            return value;
        }
        return null;
    }
}

