/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.apply;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IPageCache;
import kd.mpscmm.msbd.business.helper.SysParamHelper;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.mpscmm.msbd.formplugin.AbstractAutoQuotePlugin;
import kd.scmc.pm.business.helper.AmountHelper;
import kd.scmc.pm.business.pojo.AmountPropertyKey;

public class PurApplyAutoQuoteBillPlugin
extends AbstractAutoQuotePlugin {
    protected String getMainOrgKey() {
        return "org";
    }

    protected String getQuoteBillEntryNumber() {
        return "billentry";
    }

    protected boolean isAutoQuote() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return false;
        }
        Boolean iSAutoQuote = (Boolean)SysParamHelper.getSysParam4pm((Long)((Long)org.getPkValue()), (String)"isautoquote");
        if (iSAutoQuote == null) {
            return false;
        }
        return iSAutoQuote;
    }

    protected void afterUpdateView() {
        String stopChangeKey = "stopChange";
        String taxRateKey = "taxrate";
        IDataModel model = this.getModel();
        IPageCache pageCache = this.getPageCache();
        int entryRowCount = model.getEntryRowCount("billentry");
        pageCache.put(stopChangeKey, "true");
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject taxRate = (DynamicObject)model.getValue("taxrateid", i);
            BigDecimal taxRateValue = taxRate != null ? taxRate.getBigDecimal(taxRateKey) : BigDecimalUtil.ZERO;
            model.setValue("taxrate", (Object)taxRateValue, i);
        }
        Map totalAmountMap = AmountHelper.calcAllAmount((DynamicObject)model.getDataEntity(true), (AmountPropertyKey)this.getPurApplyPropertyKey());
        pageCache.put(stopChangeKey, "false");
        this.getView().updateView("billentry");
        for (Map.Entry entry : totalAmountMap.entrySet()) {
            model.setValue((String)entry.getKey(), entry.getValue());
        }
    }

    private AmountPropertyKey getPurApplyPropertyKey() {
        AmountPropertyKey propertyKey = AmountPropertyKey.getInstance();
        propertyKey.setTotalAmount(null);
        propertyKey.setTotalTaxAmount(null);
        return propertyKey;
    }
}

