/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.apply;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.scmc.pm.business.helper.AmountHelper;
import kd.scmc.pm.business.helper.BillImportHelper;
import kd.scmc.pm.enums.ChangeTypeEnum;

public class XPurApplyBillPlugin
extends AbstractBillPlugIn
implements RowClickEventListener,
ClickListener,
EntryGridBindDataListener {
    private static final String MODIFYROW = "modifyrow";
    private static final String CONFIRM_LINETYPE = "confirm_linetype";
    private static final String CACHE_LINETYPE = "cache_linetype";

    public void registerListener(EventObject e) {
        EntryGrid entryGrid;
        super.registerListener(e);
        Toolbar payEntrytoolbar = (Toolbar)this.getView().getControl("tbmainentry");
        if (payEntrytoolbar != null) {
            payEntrytoolbar.addItemClickListener((ItemClickListener)this);
        }
        if ((entryGrid = (EntryGrid)this.getView().getControl("billentry")) != null) {
            entryGrid.addRowClickListener((RowClickEventListener)this);
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String stopChange = this.getPageCache().get("stopChange");
        if ("true".equals(stopChange)) {
            return;
        }
        String billcretype = this.getPageCache().get("billcretype");
        if (BillImportHelper.isSkip((String)billcretype)) {
            return;
        }
        if (BillImportHelper.isImport((String)billcretype)) {
            return;
        }
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        block8: for (int i = 0; i < changeSet.length; ++i) {
            ChangeData changeData = changeSet[i];
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            int rowIndex = changeData.getRowIndex();
            if (newValue == null && oldValue == null) {
                return;
            }
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                return;
            }
            if (oldValue instanceof BigDecimal && newValue instanceof BigDecimal && ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) == 0) {
                return;
            }
            switch (fieldKey) {
                case "entrychangetype": {
                    this.changeEntryChangeType(newValue, rowIndex);
                    continue block8;
                }
                case "linetype": {
                    this.changeLineType(oldValue, newValue, rowIndex);
                    continue block8;
                }
            }
        }
    }

    private void changeLineType(Object oldValue, Object newValue, int rowIndex) {
        if (oldValue != null && newValue == null) {
            this.getPageCache().put("stopChange", "true");
            this.getModel().setValue("linetype", ((DynamicObject)oldValue).getPkValue(), rowIndex);
            this.getPageCache().put("stopChange", "false");
            return;
        }
        if (ChangeTypeEnum.ADDNEW.getValue().equals(this.getModel().getValue("entrychangetype", rowIndex))) {
            ConfirmCallBackListener callBack = new ConfirmCallBackListener(CONFIRM_LINETYPE, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u201c\u884c\u7c7b\u578b\u201d\u5c06\u6e05\u9664\u5f53\u524d\u5206\u5f55\u7269\u6599\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"XPurApplyBillPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, callBack, null, String.valueOf(rowIndex));
            this.getView().getPageCache().put(CACHE_LINETYPE, oldValue == null ? null : ((DynamicObject)oldValue).getPkValue().toString());
        }
    }

    private void changeEntryChangeType(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        HashMap<String, String> fieldMapping = new HashMap<String, String>(2);
        fieldMapping.put("totalallamount", "amountandtax");
        for (Map.Entry entry : AmountHelper.calcTotalAmount((DynamicObject)model.getDataEntity(true), fieldMapping).entrySet()) {
            model.setValue((String)entry.getKey(), entry.getValue());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (key = messageBoxClosedEvent.getCallBackId()) {
            case "confirm_linetype": {
                String customVaule = messageBoxClosedEvent.getCustomVaule();
                if (StringUtils.isBlank((CharSequence)customVaule)) {
                    return;
                }
                int rowIndex = Integer.parseInt(customVaule);
                if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                    this.getModel().setValue("material", null, rowIndex);
                    break;
                }
                String lineTypeId = this.getView().getPageCache().get(CACHE_LINETYPE);
                this.getModel().beginInit();
                this.getModel().setValue("linetype", (Object)(lineTypeId == null ? null : Long.valueOf(Long.parseLong(lineTypeId))), rowIndex);
                this.getModel().endInit();
                this.getView().updateView("linetype", rowIndex);
                this.getView().getPageCache().remove(CACHE_LINETYPE);
            }
        }
    }
}

