/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.basedata;

import java.util.EventObject;
import java.util.List;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.scmc.pm.business.helper.OrgHelper;

public class QuotaAssignPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit quotaEdit = (BasedataEdit)this.getView().getControl("quota");
        if (quotaEdit != null) {
            quotaEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            String formId = this.getView().getEntityId();
            List hasPermOrgs = OrgHelper.getHasPermissionOrg((String)formId, (String)OrgViewTypeEnum.IS_PURCHASE.getViewType());
            if (hasPermOrgs != null && hasPermOrgs.size() > 0) {
                model.setValue("org", hasPermOrgs.get(0));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u6709\u6743\u9650\u7684\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"QuotaAssignPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterBindData(EventObject e) {
        this.initMulMaterial();
        this.getView().updateView("mulmaterial");
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        Long orgId = (Long)org.getPkValue();
        switch (fieldKey) {
            case "quota": {
                QFilter orgFilter = new QFilter("org", "=", (Object)orgId);
                showParameter.getListFilterParameter().getQFilters().add(orgFilter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = valueSet[0].getNewValue();
        switch (propName) {
            case "mulmaterial": {
                if (!(newValue instanceof MulBasedataDynamicObjectCollection)) break;
                MulBasedataDynamicObjectCollection mulMaterial = (MulBasedataDynamicObjectCollection)newValue;
                if (mulMaterial == null || mulMaterial.isEmpty()) {
                    this.getModel().setValue("material", null);
                    break;
                }
                DynamicObject material = (DynamicObject)((DynamicObject)mulMaterial.get(0)).get("fbasedataid");
                if (material == null) break;
                this.getModel().setValue("material", material.getPkValue());
                if (material.getDynamicObject("masterid") == null) break;
                this.getModel().setValue("materialmasterid", material.getDynamicObject("masterid").getPkValue());
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        super.afterImportData(e);
        this.initMulMaterial();
    }

    private void initMulMaterial() {
        IDataModel model = this.getModel();
        DynamicObject material = (DynamicObject)model.getValue("material");
        DynamicObjectCollection mulMaterial = (DynamicObjectCollection)model.getValue("mulmaterial");
        if (material != null && (mulMaterial == null || mulMaterial.isEmpty())) {
            Object[] ids = new Object[]{material.getPkValue()};
            this.getModel().beginInit();
            model.setValue("mulmaterial", (Object)ids);
            this.getModel().endInit();
        }
    }
}

