/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.basedata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterParameter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeBindDataEvent;
import kd.bos.form.events.BeforeBindDataListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.bos.util.StringUtils;
import kd.scmc.pm.business.helper.OrgHelper;
import kd.scmc.pm.business.helper.QuotaHelper;
import kd.scmc.pm.business.service.quotamodel.QuotaStrategyImpl;
import kd.scmc.pm.business.service.quotamodel.pojo.QuotaCalculateDTO;
import kd.scmc.pm.business.service.quotamodel.quotacalculateservice.QuotaCalculateService;
import kd.scmc.pm.enums.BizCloseStatusEnum;
import kd.scmc.pm.enums.RowCloseStatusEnum;
import kd.scmc.pm.enums.RowTerminateStatusEnum;
import kd.scmc.pm.enums.StatusEnum;
import kd.scmc.pm.utils.CommonUtils;
import kd.scmc.pm.utils.DateUtil;

public class QuotaOrderPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
BeforeBindDataListener {
    private static final Log log = LogFactory.getLog(QuotaOrderPlugin.class);
    private static final String ISQUOTACONTROL = "isquotacontrol";
    private static final String CREATION = "creation";
    private static final String CREATEORDER = "createorder";
    private static final String SUCCESSLIST = "successlist";
    private static final String ENTRYID = "entryid";
    public static final String PM_QUOTAPUSHORDER = "pm_quotapushorder";
    public static final String PM_QUOTAPURORDER = "pm_quotapurorder";

    public void initialize() {
        super.initialize();
        BillList billList = (BillList)this.getControl("billlistap");
        billList.getListUserOption().setMergeRow(false);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl("billlistap");
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        MulBasedataEdit querymaterial = (MulBasedataEdit)this.getControl("querymaterial");
        if (org != null) {
            org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (billList != null) {
            billList.addBeforeBindDataListener((BeforeBindDataListener)this);
        }
        if (querymaterial != null) {
            querymaterial.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        Object purchaseorg;
        String fieldKey = arg0.getProperty().getName();
        String formId = this.getView().getEntityId();
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        if ("org".equals(fieldKey)) {
            List hasPermissionOrg = OrgHelper.getHasPermissionOrg((String)formId, (String)OrgViewTypeEnum.IS_PURCHASE.getViewType());
            QFilter filterOrg = new QFilter("id", "in", (Object)hasPermissionOrg);
            showParameter.getListFilterParameter().setFilter(filterOrg);
        }
        if ("querymaterial".equals(fieldKey) && (purchaseorg = this.getModel().getValue("org")) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"QuotaOrderPlugin_11", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            arg0.setCancel(true);
            return;
        }
    }

    public void afterCreateNewData(EventObject e) {
        Object ispurapplybill;
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        BillList billList = (BillList)this.getControl("billlistap");
        String quotaParam = this.getPageCache().get("pm_quotaParam");
        if (StringUtils.isEmpty((String)quotaParam)) {
            try {
                quotaParam = QuotaHelper.queryQuotaParam();
                this.getPageCache().put("pm_quotaParam", quotaParam);
            }
            catch (Exception ee) {
                log.error(Arrays.toString(ee.getStackTrace()));
            }
        }
        if ("A".equals(quotaParam) || StringUtils.isEmpty((String)quotaParam)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"quotascheme"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"quotascheme"});
        }
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        if (customParams != null && !customParams.isEmpty() && (ispurapplybill = customParams.get("ispurapplybill")) != null && ((Boolean)ispurapplybill).booleanValue()) {
            Object org = customParams.get("org");
            Object billtype = customParams.get("billtype");
            Object billids = customParams.get("billids");
            model.setValue("org", org);
            model.setValue("billtype", billtype);
            model.setValue("applydate_startdate", null);
            model.setValue("applydate_enddate", null);
            QFilter qFilter = new QFilter("id", "in", billids);
            FilterParameter filterParameter = new FilterParameter();
            filterParameter.setFilter(qFilter.and(this.getQFilter()));
            billList.setFilterParameter(filterParameter);
            return;
        }
        Date startDate = QuotaCalculateDTO.getStartOrEndDate((boolean)false);
        Date endDate = QuotaCalculateDTO.getStartOrEndDate((boolean)true);
        model.setValue("applydate_startdate", (Object)startDate);
        model.setValue("applydate_enddate", (Object)endDate);
        Long defaultOrg = OrgHelper.getDefaultOrg((String)this.getView().getEntityId(), (String)OrgViewTypeEnum.IS_PURCHASE.getViewType());
        if (defaultOrg == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u91c7\u8d2d\u7ec4\u7ec7\u6743\u9650\u3002", (String)"QuotaOrderPlugin_7", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            billList.clearData();
            return;
        }
        model.setValue("org", (Object)defaultOrg);
        QFilter qFilter = this.getQFilter();
        FilterParameter filterParameter = new FilterParameter();
        filterParameter.setFilter(qFilter);
        billList.setFilterParameter(filterParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (oldValue == null) {
            return;
        }
        if (newValue == null) {
            if ("org".equals(propName)) {
                model.setValue("querymaterial", null);
                return;
            }
        } else if ("org".equals(propName) && !oldValue.equals(newValue)) {
            model.setValue("querymaterial", null);
            return;
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String key = ((AbstractOperate)args.getSource()).getOperateKey();
        DynamicObject purOrg = (DynamicObject)this.getModel().getValue("org");
        switch (key) {
            case "importapply": {
                if (purOrg == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"QuotaOrderPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                List<Object> queryMaterialIds = this.getQueryMaterialIds();
                if (queryMaterialIds == null || queryMaterialIds.size() <= 500000) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7269\u6599\u67e5\u8be2\u8303\u56f4\u8fc7\u5927\uff0c\u8bf7\u7f29\u5c0f\u8303\u56f4\u3002", (String)"QuotaOrderPlugin_13", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            case "quotacalculate": {
                DynamicObject quotaScheme;
                if ("B".equals(this.getPageCache().get("pm_quotaParam")) && (quotaScheme = (DynamicObject)this.getModel().getValue("quotascheme")) == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u914d\u989d\u5e94\u7528\u65b9\u6848\u3002", (String)"QuotaOrderPlugin_3", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection selectedRow = billList.getSelectedRows();
                if (selectedRow == null || selectedRow.isEmpty()) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u3002", (String)"QuotaOrderPlugin_2", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                if (selectedRow == null || selectedRow.size() <= 5000) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u91cf\u8fc7\u5927\uff0c\u8bf7\u7f29\u5c0f\u6570\u636e\u8303\u56f4\u3002", (String)"QuotaOrderPlugin_1", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        BillList billList = (BillList)this.getControl("billlistap");
        DynamicObject purOrg = (DynamicObject)this.getModel().getValue("org");
        switch (key) {
            case "importapply": {
                QFilter qFilter = this.getQFilter();
                FilterParameter filterParameter = new FilterParameter();
                filterParameter.setFilter(qFilter);
                billList.setFilterParameter(filterParameter);
                billList.clearSelection();
                billList.refresh();
                break;
            }
            case "quotacalculate": {
                if ("B".equals(this.getPageCache().get("pm_quotaParam"))) {
                    this.openCreateOrder();
                    break;
                }
                ListSelectedRowCollection selectedRow = billList.getSelectedRows();
                if (selectedRow == null || selectedRow.isEmpty()) break;
                HashSet<Long> purApplyBillId = new HashSet<Long>(selectedRow.size());
                for (ListSelectedRow listSelectedRow : selectedRow) {
                    if (listSelectedRow == null || listSelectedRow.getPrimaryKeyValue() == null) continue;
                    Long entryId = (Long)listSelectedRow.getEntryPrimaryKeyValue();
                    purApplyBillId.add(entryId);
                }
                QuotaCalculateService invokeQuotaServiceImpl = QuotaStrategyImpl.invokeQuotaServiceImpl();
                String errorMsg = invokeQuotaServiceImpl.validateQuotas(purApplyBillId, purOrg);
                if (errorMsg != null && errorMsg.isEmpty()) {
                    this.openCreateOrder();
                    break;
                }
                this.openConfirmDialog(errorMsg);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        BillList billList = (BillList)this.getControl("billlistap");
        String actionId = closedCallBackEvent.getActionId();
        if (actionId.equals(CREATION)) {
            FilterParameter filterParameter = new FilterParameter();
            filterParameter.setFilter(this.getQFilter());
            billList.setFilterParameter(filterParameter);
            billList.refresh();
            billList.clearSelection();
            Object returnDataObj = closedCallBackEvent.getReturnData();
            log.info("\u914d\u989d\u4e0b\u5355\u751f\u6210\u7684\u91c7\u8d2d\u8ba2\u5355ID" + returnDataObj);
            if (returnDataObj instanceof Map) {
                Map returnData = (Map)returnDataObj;
                List successList = (List)returnData.get(SUCCESSLIST);
                ListShowParameter lsp = new ListShowParameter();
                lsp.setBillFormId(PM_QUOTAPURORDER);
                lsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                QFilter qFilter = new QFilter("id", "in", (Object)successList);
                ListFilterParameter lfp = new ListFilterParameter();
                lfp.setFilter(qFilter);
                lsp.setListFilterParameter(lfp);
                lsp.setUseOrgId(((Long)org.getPkValue()).longValue());
                this.getView().showForm((FormShowParameter)lsp);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (CREATEORDER.equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.openCreateOrder();
        }
    }

    public void beforeBindData(BeforeBindDataEvent paramBeforeBindDataEvent) {
        Object ispurapplybill;
        BillList param = (BillList)paramBeforeBindDataEvent.getSource();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        Object billids = null;
        if (customParams != null && !customParams.isEmpty() && (ispurapplybill = customParams.get("ispurapplybill")) != null && ((Boolean)ispurapplybill).booleanValue()) {
            billids = customParams.get("billids");
        }
        QFilter qFilter = this.getQFilter();
        FilterParameter filterParameter = new FilterParameter();
        if (CommonUtils.isNull(billids)) {
            filterParameter.setFilter(qFilter);
        } else {
            filterParameter.setFilter(qFilter.and(new QFilter("id", "in", billids)));
        }
        param.setFilterParameter(filterParameter);
    }

    private void openCreateOrder() {
        BillList billList = (BillList)this.getControl("billlistap");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject quotaScheme = (DynamicObject)this.getModel().getValue("quotascheme");
        ListSelectedRowCollection selectedRow = billList.getSelectedRows();
        HashSet<Long> purApplyBillId = new HashSet<Long>(selectedRow.size());
        for (ListSelectedRow listSelectedRow : selectedRow) {
            if (listSelectedRow == null || listSelectedRow.getPrimaryKeyValue() == null) continue;
            Long entryId = (Long)listSelectedRow.getEntryPrimaryKeyValue();
            purApplyBillId.add(entryId);
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId(PM_QUOTAPUSHORDER);
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam(ENTRYID, purApplyBillId);
        fsp.setCustomParam("org", org.getPkValue());
        fsp.setCustomParam("quotaPattern", (Object)this.getPageCache().get("pm_quotaParam"));
        if (quotaScheme != null && "B".equals(this.getPageCache().get("pm_quotaParam"))) {
            fsp.setCustomParam("quotascheme", quotaScheme.getPkValue());
        }
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CREATION));
        this.getView().showForm(fsp);
    }

    private void openConfirmDialog(String errorMsg) {
        String msg = ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u91c7\u8d2d\u7533\u8bf7\u5355\u4e2d\u4ee5\u4e0b\u5185\u5bb9\u4e0d\u7b26\u5408\u914d\u989d\u8ba1\u7b97\u8981\u6c42\uff0c\u662f\u5426\u7ee7\u7eed\u8ba1\u7b97?", (String)"QuotaOrderPlugin_12", (String)"scmc-pm-formplugin", (Object[])new Object[0]);
        MessageBoxOptions options = MessageBoxOptions.YesNo;
        ConfirmTypes confirmTypes = ConfirmTypes.Default;
        ConfirmCallBackListener callBack = new ConfirmCallBackListener(CREATEORDER, (IFormPlugin)this);
        this.getView().showConfirm(msg, errorMsg, options, confirmTypes, callBack);
    }

    private QFilter getQFilter() {
        List<Object> queryMaterialIds;
        DynamicObject bizUser;
        DynamicObject dept;
        DynamicObject currency;
        Date endDate;
        Date startDate;
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        QFilter qFilter = new QFilter("org", "in", org.getPkValue());
        qFilter.and(new QFilter("billstatus", "in", (Object)StatusEnum.AUDIT.getValue()));
        qFilter.and(new QFilter("closestatus", "in", (Object)BizCloseStatusEnum.UNCLOSE.getValue()));
        qFilter.and(new QFilter("billentry.material.isquotacontrol", "in", (Object)Boolean.TRUE));
        qFilter.and(new QFilter("billentry.supplier", "=", (Object)0));
        qFilter.and(new QFilter("billentry.rowclosestatus", "in", (Object)RowCloseStatusEnum.UNROWCLOSE.getValue()));
        qFilter.and(new QFilter("billentry.rowterminatestatus", "in", (Object)RowTerminateStatusEnum.UNROWTERMINATE.getValue()));
        qFilter.and(new QFilter("billentry.qty", ">", (Object)"billentry.joinqty", true));
        DynamicObject billType = (DynamicObject)model.getValue("billtype");
        if (billType != null) {
            qFilter.and(new QFilter("billtype", "in", billType.getPkValue()));
        }
        if ((startDate = (Date)model.getValue("applydate_startdate")) != null) {
            qFilter.and(new QFilter("biztime", ">=", (Object)startDate));
        }
        if ((endDate = (Date)model.getValue("applydate_enddate")) != null) {
            qFilter.and(new QFilter("biztime", "<=", (Object)DateUtil.getStartOrEndDate((Date)endDate, (boolean)true)));
        }
        if ((currency = (DynamicObject)model.getValue("currency")) != null) {
            qFilter.and(new QFilter("currency", "in", currency.getPkValue()));
        }
        if ((dept = (DynamicObject)model.getValue("querydept")) != null) {
            qFilter.and(new QFilter("dept", "in", dept.getPkValue()));
        }
        if ((bizUser = (DynamicObject)model.getValue("querybizuser")) != null) {
            qFilter.and(new QFilter("bizuser", "in", bizUser.getPkValue()));
        }
        if ((queryMaterialIds = this.getQueryMaterialIds()) != null && !queryMaterialIds.isEmpty()) {
            qFilter.and(new QFilter("billentry.material", "in", queryMaterialIds));
        }
        return qFilter;
    }

    private List<Object> getQueryMaterialIds() {
        DynamicObjectCollection materials = (DynamicObjectCollection)this.getModel().getValue("querymaterial");
        ArrayList<Object> materialIds = new ArrayList<Object>(16);
        if (materials != null && materials.size() > 0) {
            for (int i = 0; i < materials.size(); ++i) {
                DynamicObject material = (DynamicObject)materials.get(i);
                materialIds.add(((DynamicObject)material.get("fbasedataid")).getPkValue());
            }
        }
        return materialIds;
    }
}

