/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.basedata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.pm.business.helper.QuotaHelper;
import kd.scmc.pm.utils.CommonUtils;

public class QuotaPatternPlugin
extends AbstractFormPlugin {
    private static final int batchSizeNum = 1000;
    private static final Log log = LogFactory.getLog(QuotaPatternPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btndatasync", "btnsave"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        try {
            String param = QuotaHelper.queryQuotaParam();
            if (!CommonUtils.isNull((Object)param.trim())) {
                model.setValue("quotapattern", (Object)param);
            }
        }
        catch (Exception e1) {
            log.error(Arrays.toString(e1.getStackTrace()));
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        super.beforeClick(evt);
        super.click((EventObject)evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if ("btndatasync".equalsIgnoreCase(key)) {
            DynamicObject[] purquotaDOs = BusinessDataServiceHelper.load((String)"pm_purquota", (String)"id", null);
            if (purquotaDOs.length == 0) {
                this.getView().showConfirm(this.isToContinue(), MessageBoxOptions.YesNo, new ConfirmCallBackListener(key));
                evt.setCancel(true);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u91c7\u8d2d\u914d\u989d\u4e2d\u5df2\u6709\u6570\u636e\uff0c\u65e0\u6cd5\u6267\u884c\u914d\u989d\u5206\u914d\u6a21\u5f0f\u57fa\u7840\u6570\u636e\u7684\u540c\u6b65\u3002", (String)"QuotaPatternPlugin_4", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if ("btnsave".equalsIgnoreCase(key)) {
            String quotapattern = this.getModel().getValue("quotapattern").toString();
            if (quotapattern.equals("")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u914d\u989d\u6a21\u5f0f\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u4fdd\u5b58\u3002", (String)"QuotaPatternPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            } else {
                long currentUserId = UserServiceHelper.getCurrentUserId();
                Date date = new Date(System.currentTimeMillis());
                Object[] param = new Object[]{1673226188031524864L, quotapattern, currentUserId, date};
                try {
                    String delSql = "delete  from t_pm_quotapattern";
                    this.executeSql(delSql, null);
                    String savSql = "insert into t_pm_quotapattern(fid,fquotapattern,fcreatorid,fcreatetime) values(?,?,?,?) ";
                    Boolean issuccess = this.executeSql(savSql, param);
                    if (issuccess.booleanValue()) {
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"QuotaPatternPlugin_1", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    } else {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\u3002", (String)"QuotaPatternPlugin_2", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    }
                }
                catch (Exception e) {
                    log.error(Arrays.toString(e.getStackTrace()));
                }
            }
        }
    }

    private String isToContinue() {
        return ResManager.loadKDString((String)"1.\u201c\u914d\u989d\u65b9\u6848\u201d\u5982\u6709\u4e8c\u5f00\u6269\u5c55\uff0c\u540c\u6b65\u6570\u636e\u524d\u8bf7\u5904\u7406\u5b8c\u201c\u91c7\u8d2d\u914d\u989d\u201d\u5143\u6570\u636e\u7684\u5904\u7406\uff1b2.\u540c\u6b65\u6570\u636e\u524d\u4f1a\u5148\u6e05\u7a7a\u201c\u91c7\u8d2d\u914d\u989d\u201d\u4e2d\u7684\u6570\u636e\u3002", (String)"QuotaPatternPlugin_3", (String)"scmc-pm-formplugin", (Object[])new Object[0]);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (e.getResult() != MessageBoxResult.Yes) {
            return;
        }
        this.datasync();
    }

    private void datasync() {
        String quotaPattern = "";
        try {
            quotaPattern = QuotaHelper.queryQuotaParam();
        }
        catch (Exception e) {
            log.error(Arrays.toString(e.getStackTrace()));
        }
        if (!quotaPattern.equals("") && quotaPattern.equals("B")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u540c\u6b65\u6570\u636e\u5931\u8d25\uff0c\u5f53\u524d\u4e3a\u91c7\u8d2d\u914d\u989d\u6a21\u5f0f\u3002", (String)"QuotaPatternPlugin_7", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
        } else {
            this.delPurQuota();
            DynamicObject[] idsAssign = BusinessDataServiceHelper.load((String)"pm_quotaassign", (String)"quota,material", null);
            if (idsAssign.length != 0) {
                MainEntityType meta = MetadataServiceHelper.getDataEntityType((String)"pm_purquota");
                Map allFields = meta.getAllFields();
                HashMap<String, String> headMap = new HashMap<String, String>(16);
                HashMap<String, String> entryMap = new HashMap<String, String>(16);
                for (Map.Entry str : allFields.entrySet()) {
                    if (((IDataEntityProperty)allFields.get(str.getKey())).getParent() instanceof MainEntityType) {
                        headMap.put((String)str.getKey(), (String)str.getKey());
                        continue;
                    }
                    if (!(((IDataEntityProperty)allFields.get(str.getKey())).getParent() instanceof EntryType)) continue;
                    entryMap.put((String)str.getKey(), (String)str.getKey());
                }
                headMap.put("masterid", "masterid");
                headMap.put("id", "id");
                entryMap.put("seq", "seq");
                MainEntityType objType = MetadataServiceHelper.getDataEntityType((String)"pm_quota");
                HashMap<Long, List<Long>> quotaMaterialMap = new HashMap<Long, List<Long>>(16);
                for (int j = 0; j < idsAssign.length; ++j) {
                    DynamicObject quota = (DynamicObject)idsAssign[j].get("quota");
                    DynamicObject material = (DynamicObject)idsAssign[j].get("material");
                    if (quota == null || material == null) continue;
                    if (quotaMaterialMap.get(quota.getPkValue()) == null) {
                        ArrayList<Long> materialLst = new ArrayList<Long>(16);
                        materialLst.add((Long)material.getPkValue());
                        quotaMaterialMap.put((Long)quota.getPkValue(), materialLst);
                    } else {
                        ((List)quotaMaterialMap.get(quota.getPkValue())).add((Long)material.getPkValue());
                    }
                    if (j != 1000) continue;
                    this.updatePurQuotaByAssign(quotaMaterialMap, (DynamicObjectType)objType, headMap, entryMap);
                    quotaMaterialMap.clear();
                }
                if (quotaMaterialMap.size() > 0) {
                    this.updatePurQuotaByAssign(quotaMaterialMap, (DynamicObjectType)objType, headMap, entryMap);
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6570\u636e\u540c\u6b65\u5b8c\u6210\u3002", (String)"QuotaPatternPlugin_5", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u9700\u8981\u540c\u6b65\u7684\u6570\u636e\u3002", (String)"QuotaPatternPlugin_6", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private void delPurQuota() {
        DynamicObject[] quotaIds = BusinessDataServiceHelper.load((String)"pm_quota", (String)"id", null);
        HashSet<Long> quotaIdsSet = new HashSet<Long>(16);
        QFilter delQFilter = new QFilter("id", "in", quotaIdsSet);
        for (int i = 0; i < quotaIds.length; ++i) {
            quotaIdsSet.add((Long)quotaIds[i].get("id"));
            if (quotaIdsSet.size() <= 1000) continue;
            DeleteServiceHelper.delete((String)"pm_purquota", (QFilter[])new QFilter[]{delQFilter});
            quotaIdsSet.clear();
        }
        if (quotaIdsSet.size() > 0) {
            DeleteServiceHelper.delete((String)"pm_purquota", (QFilter[])new QFilter[]{delQFilter});
        }
    }

    private void updatePurQuotaByAssign(Map<Long, List<Long>> quotaMaterialMap, DynamicObjectType objType, Map<String, String> headMap, Map<String, String> entryMap) {
        MainEntityType purquotaET = MetadataServiceHelper.getDataEntityType((String)"pm_purquota");
        EntityType purquotaEntryET = (EntityType)purquotaET.getAllEntities().get("entryentity");
        DynamicObject[] quotaObjs = BusinessDataServiceHelper.load((Object[])quotaMaterialMap.keySet().toArray(), (DynamicObjectType)objType);
        DynamicObject[] newPurQuotaObjs = new DynamicObject[quotaObjs.length];
        for (int m = 0; m < quotaObjs.length; ++m) {
            DynamicObject oldQuota = quotaObjs[m];
            DynamicObject newPurQuota = new DynamicObject((DynamicObjectType)purquotaET);
            for (String headKey : headMap.keySet()) {
                if (headKey.equals("quotacategory")) {
                    newPurQuota.set(headKey, (Object)1655002785558592512L);
                    continue;
                }
                if (headKey.equals("id")) {
                    newPurQuota.set("id", quotaObjs[m].getPkValue());
                    continue;
                }
                newPurQuota.set(headKey, quotaObjs[m].get(headKey));
            }
            DynamicObjectCollection newPurQuotaEntryCol = newPurQuota.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection oldQuotaEntryCol = oldQuota.getDynamicObjectCollection("entryentity");
            int seq = 0;
            for (DynamicObject oldEntry : oldQuotaEntryCol) {
                for (Long mat : quotaMaterialMap.get(oldQuota.getPkValue())) {
                    DynamicObjectCollection oldSubEntryCol = oldEntry.getDynamicObjectCollection("subentryentity");
                    for (DynamicObject oldSubEntry : oldSubEntryCol) {
                        DynamicObject newPurQuotaEntry = new DynamicObject((DynamicObjectType)purquotaEntryET);
                        for (String entryKey : entryMap.keySet()) {
                            if (entryKey.equals("material")) {
                                newPurQuotaEntry.set(entryKey, (Object)mat);
                                continue;
                            }
                            if (entryKey.equals("effectdate") || entryKey.equals("expirydate") || entryKey.equals("entrymodifier") || entryKey.equals("entrymodifytime") || entryKey.equals("entrycreator") || entryKey.equals("entrycreatetime")) {
                                newPurQuotaEntry.set(entryKey, oldEntry.get(entryKey));
                                continue;
                            }
                            if (entryKey.equals("description")) {
                                newPurQuotaEntry.set(entryKey, oldEntry.get("comment"));
                                continue;
                            }
                            if (entryKey.equals("seq")) {
                                newPurQuotaEntry.set("seq", (Object)seq);
                                continue;
                            }
                            if (entryKey.equals("procedure")) continue;
                            newPurQuotaEntry.set(entryKey, oldSubEntry.get(entryKey));
                        }
                        ++seq;
                        newPurQuotaEntryCol.add((Object)newPurQuotaEntry);
                    }
                }
            }
            newPurQuotaObjs[m] = newPurQuota;
        }
        SaveServiceHelper.save((DynamicObject[])newPurQuotaObjs);
    }

    private Boolean executeSql(String sql, Object[] param) throws Exception {
        try {
            DBRoute scmcRoute = new DBRoute("scm");
            return DB.execute((DBRoute)scmcRoute, (String)sql, (Object[])param);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }
}

