/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.basedata;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.scmc.pm.business.helper.SupplierHelper;
import kd.scmc.pm.business.service.quotamodel.pojo.QuotaCalculateDTO;

public class QuotaPlugin
extends AbstractBasePlugIn
implements RowClickEventListener,
ClickListener,
BeforeF7SelectListener {
    public static final String SAVE = "save";
    protected static final String[] ALLFIELD = new String[]{"calculatecycle", "startday", "startweekday", "startmonthday", "startseasonone", "startseasontwo", "startseasonthree", "startseasonfour", "startyearday", "startotherday"};
    protected static final String[] PARTFIELD = new String[]{"startday", "startweekday", "startmonthday", "startseasonone", "startseasontwo", "startseasonthree", "startseasonfour", "startyearday", "startotherday"};
    public static final String ENTRYENTITY = "entryentity";
    public static final String NEWSUBENTRY = "newsubentry";

    public void registerListener(EventObject e) {
        BasedataEdit supplier;
        super.registerListener(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        if (entryGrid != null) {
            entryGrid.addRowClickListener((RowClickEventListener)this);
        }
        if ((supplier = (BasedataEdit)this.getView().getControl("supplier")) != null) {
            supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        if (fieldKey != null && fieldKey.equals("supplier")) {
            IFormView view = this.getView();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"QuotaPlugin_10", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            QFilter filter = SupplierHelper.getBizfunctionAndHoldFilter((String)"supplier");
            if (filter != null) {
                ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
                showParameter.getListFilterParameter().getQFilters().add(filter);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Calendar c1 = Calendar.getInstance();
        Date now = c1.getTime();
        String effectdate = sdf.format(now);
        Calendar c2 = Calendar.getInstance();
        c2.set(2099, 11, 31);
        Date lasttime = c2.getTime();
        String expirydate = sdf.format(lasttime);
        int entryRowCount = this.getModel().getEntryRowCount(ENTRYENTITY);
        if (entryRowCount >= 1) {
            this.getModel().setValue("effectdate", (Object)effectdate, 0);
            this.getModel().setValue("expirydate", (Object)expirydate, 0);
        }
        this.getView().setVisible(Boolean.FALSE, ALLFIELD);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String quotatype = (String)model.getValue("quotatype");
        if ("C".equals(quotatype)) {
            String calculatecycle = (String)model.getValue("calculatecycle");
            view.setVisible(Boolean.TRUE, new String[]{"calculatecycle"});
            if ("A".equals(calculatecycle)) {
                view.setVisible(Boolean.TRUE, new String[]{"startday"});
            }
            if ("B".equals(calculatecycle)) {
                view.setVisible(Boolean.TRUE, new String[]{"startweekday"});
            }
            if ("C".equals(calculatecycle)) {
                view.setVisible(Boolean.TRUE, new String[]{"startmonthday"});
            }
            if ("F".equals(calculatecycle)) {
                view.setVisible(Boolean.TRUE, new String[]{"startotherday"});
            }
            if ("D".equals(calculatecycle)) {
                int currentSeason = QuotaCalculateDTO.getCurrentSeason();
                if (currentSeason == 1) {
                    view.setVisible(Boolean.TRUE, new String[]{"startseasonone"});
                }
                if (currentSeason == 2) {
                    view.setVisible(Boolean.TRUE, new String[]{"startseasontwo"});
                }
                if (currentSeason == 3) {
                    view.setVisible(Boolean.TRUE, new String[]{"startseasonthree"});
                }
                if (currentSeason == 4) {
                    view.setVisible(Boolean.TRUE, new String[]{"startseasonfour"});
                }
            }
            if ("E".equals(calculatecycle)) {
                view.setVisible(Boolean.TRUE, new String[]{"startyearday"});
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String operationKey = evt.getOperationKey();
        if (operationKey != null && "submit".equals(operationKey)) {
            Date startday;
            Object start;
            String quotatype = (String)model.getValue("quotatype");
            if (!"C".equals(quotatype)) {
                return;
            }
            String calculatecycle = (String)model.getValue("calculatecycle");
            if (calculatecycle == null || "".equals(calculatecycle)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u914d\u989d\u7b97\u6cd5\u662f\u52a8\u6001\u6bd4\u4f8b\u65f6\uff0c\u8ba1\u7b97\u5468\u671f\u662f\u5fc5\u586b\u9879\u3002", (String)"QuotaPlugin_5", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if ("A".equals(calculatecycle) && (start = (Date)model.getValue("startday")) == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8ba1\u7b97\u5468\u671f\u662f\u65e5\u65f6\uff0c\u65e5\u671f\u5b57\u6bb5\u662f\u5fc5\u586b\u9879\u3002", (String)"QuotaPlugin_6", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if ("B".equals(calculatecycle) && ((start = (String)model.getValue("startweekday")) == null || "".equals(start))) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8ba1\u7b97\u5468\u671f\u662f\u5468\u65f6\uff0c\u8d77\u59cb\u65e5\u671f\u5b57\u6bb5\u662f\u5fc5\u586b\u9879\u3002", (String)"QuotaPlugin_7", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if ("C".equals(calculatecycle) && ((start = (String)model.getValue("startmonthday")) == null || "".equals(start))) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8ba1\u7b97\u5468\u671f\u662f\u6708\u65f6\uff0c\u8d77\u59cb\u65e5\u671f\u5b57\u6bb5\u662f\u5fc5\u586b\u9879\u3002", (String)"QuotaPlugin_8", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if ("F".equals(calculatecycle) && (startday = (Date)model.getValue("startotherday")) == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u8ba1\u7b97\u5468\u671f\u662f\u5176\u4ed6\u65f6\uff0c\u8d77\u59cb\u65e5\u671f\u5b57\u6bb5\u662f\u5fc5\u586b\u9879\u3002", (String)"QuotaPlugin_9", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if ("D".equals(calculatecycle)) {
                int currentSeason = QuotaCalculateDTO.getCurrentSeason();
                this.setupEmptyField(currentSeason);
            }
            if ("E".equals(calculatecycle)) {
                this.setupEmptyField();
            }
        }
    }

    private void setupEmptyField(int currentSeason) {
        IDataModel model = this.getModel();
        model.setValue("startyearday", null);
    }

    private void setupEmptyField() {
        IDataModel model = this.getModel();
        model.setValue("startseasonone", null);
        model.setValue("startseasontwo", null);
        model.setValue("startseasonthree", null);
        model.setValue("startseasonfour", null);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        int[] selectRows;
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if (NEWSUBENTRY.equals(operateKey) && ((selectRows = ((EntryGrid)this.getControl(ENTRYENTITY)).getSelectRows()) == null || selectRows.length < 1)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u671f\u5206\u5f55\u884c\u3002", (String)"QuotaPlugin_12", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        String entryName = e.getEntryProp().getName();
        RowDataEntity[] rows = e.getRowDataEntities();
        if (ENTRYENTITY.equals(entryName)) {
            for (RowDataEntity row : rows) {
                this.getView().setEnable(Boolean.TRUE, row.getRowIndex(), new String[]{"effectdate"});
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String stopChange = this.getPageCache().get("stopChange");
        if ("true".equals(stopChange)) {
            return;
        }
        String propName = e.getProperty().getName();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (ObjectUtils.isEmpty((Object)newValue)) {
            return;
        }
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        switch (propName) {
            case "effectdate": {
                Date effDate = (Date)newValue;
                Date expDate = (Date)this.getModel().getValue("expirydate", rowIndex);
                if (expDate != null && effDate.compareTo(expDate) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u9700\u5c0f\u4e8e\u5931\u6548\u65e5\u671f\u3002", (String)"QuotaPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    this.getPageCache().put("stopChange", "true");
                    this.getModel().setValue("effectdate", oldValue, rowIndex);
                    this.getPageCache().put("stopChange", "false");
                    break;
                }
                this.checkDateRange(propName, oldValue, rowIndex, this.getModel().getEntryRowEntity(ENTRYENTITY, rowIndex));
                break;
            }
            case "expirydate": {
                Date effDate1 = (Date)this.getModel().getValue("effectdate", rowIndex);
                Date expDate1 = (Date)newValue;
                if (effDate1 != null && effDate1.compareTo(expDate1) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f\u9700\u5927\u4e8e\u7b49\u4e8e\u751f\u6548\u65e5\u671f\u3002", (String)"QuotaPlugin_1", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    this.getPageCache().put("stopChange", "true");
                    this.getModel().setValue("expirydate", oldValue, rowIndex);
                    this.getPageCache().put("stopChange", "false");
                    break;
                }
                this.checkDateRange(propName, oldValue, rowIndex, this.getModel().getEntryRowEntity(ENTRYENTITY, rowIndex));
                break;
            }
            case "supplier": {
                this.checkSupplier(propName, newValue, rowIndex);
                break;
            }
            case "calculatecycle": {
                this.switchCalauteCycle();
                break;
            }
            case "quotatype": {
                this.switchQuotaType();
                break;
            }
            case "material": {
                DynamicObject material = (DynamicObject)newValue;
                if (material.getDynamicObject("masterid") == null) break;
                this.getModel().setValue("materialmasterid", material.getDynamicObject("masterid").getPkValue());
                break;
            }
        }
    }

    private void switchQuotaType() {
        String quotatype = (String)this.getModel().getValue("quotatype");
        IFormView formView = this.getView();
        IDataModel model = this.getModel();
        if ("C".equals(quotatype)) {
            formView.setVisible(Boolean.TRUE, new String[]{"calculatecycle", "startmonthday"});
            model.setValue("calculatecycle", (Object)"C");
            model.setValue("startmonthday", (Object)"A");
        }
        if ("B".equals(quotatype) || "A".equals(quotatype)) {
            formView.setVisible(Boolean.FALSE, ALLFIELD);
            QuotaCalculateDTO.getAllFieldList().forEach(value -> model.setValue(value, null));
        }
    }

    private void switchCalauteCycle() {
        String calculatecycle = (String)this.getModel().getValue("calculatecycle");
        IFormView formView = this.getView();
        IDataModel model = this.getModel();
        LocalDate localDate = LocalDate.now();
        formView.setVisible(Boolean.FALSE, PARTFIELD);
        QuotaCalculateDTO.getPartFieldList().forEach(value -> model.setValue(value, null));
        switch (calculatecycle) {
            case "A": {
                formView.setVisible(Boolean.TRUE, new String[]{"startday"});
                break;
            }
            case "B": {
                formView.setVisible(Boolean.TRUE, new String[]{"startweekday"});
                break;
            }
            case "C": {
                formView.setVisible(Boolean.TRUE, new String[]{"startmonthday"});
                model.setValue("startmonthday", (Object)"A");
                break;
            }
            case "D": {
                formView.setVisible(Boolean.TRUE, new String[]{"startseasonone", "startseasontwo", "startseasonthree", "startseasonfour"});
                model.setValue("startseasonone", (Object)LocalDate.of(localDate.getYear(), 1, 1));
                model.setValue("startseasontwo", (Object)LocalDate.of(localDate.getYear(), 4, 1));
                model.setValue("startseasonthree", (Object)LocalDate.of(localDate.getYear(), 7, 1));
                model.setValue("startseasonfour", (Object)LocalDate.of(localDate.getYear(), 10, 1));
                break;
            }
            case "E": {
                formView.setVisible(Boolean.TRUE, new String[]{"startyearday"});
                model.setValue("startyearday", (Object)LocalDate.of(localDate.getYear(), 1, 1));
                break;
            }
            case "F": {
                formView.setVisible(Boolean.TRUE, new String[]{"startotherday"});
                break;
            }
        }
    }

    private void checkSupplier(String propName, Object newValue, int rowIndex) {
        DynamicObjectCollection subEntry = this.getModel().getEntryEntity("subentryentity");
        if (subEntry.size() > 1) {
            HashSet<Long> set = new HashSet<Long>();
            DynamicObject newSupplier = (DynamicObject)newValue;
            set.add((Long)newSupplier.getPkValue());
            for (DynamicObject subRow : subEntry) {
                DynamicObject supplier = subRow.getDynamicObject("supplier");
                if (supplier == null || subRow.getInt("seq") - 1 == rowIndex || set.add((Long)supplier.getPkValue())) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6709\u6548\u671f\u5185\u8be5\u4f9b\u5e94\u5546\u5df2\u5b58\u5728\u3002", (String)"QuotaPlugin_2", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue(propName, null, rowIndex);
                return;
            }
        }
    }

    private void checkDateRange(String propName, Object oldValue, int rowIndex, DynamicObject curRow) {
        if (curRow.getDate("effectdate") != null && curRow.getDate("expirydate") != null) {
            DynamicObjectCollection entrys = this.getModel().getEntryEntity(ENTRYENTITY);
            for (DynamicObject entry : entrys) {
                if (entry.getDate("effectdate") == null || entry.getDate("expirydate") == null || rowIndex == entry.getInt("seq") - 1 || curRow.getDate("effectdate").after(entry.getDate("expirydate")) || curRow.getDate("expirydate").before(entry.getDate("effectdate"))) continue;
                this.getModel().beginInit();
                this.getModel().setValue(propName, oldValue, rowIndex);
                this.getModel().endInit();
                this.getView().updateView(propName, rowIndex);
                int seq = entry.getInt("seq");
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u8f93\u5165\u7684\u884c\u4e0e\u7b2c%1$s\u884c\u6709\u6548\u671f\u91cd\u53e0\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"QuotaPlugin_3", (String)"scmc-pm-formplugin", (Object[])new Object[0]), seq));
                return;
            }
        }
    }
}

