/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.basedata;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.util.JSONUtils;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.helper.BotpHepler;
import kd.scmc.pm.business.helper.QuotaCalculImpHelper;
import kd.scmc.pm.business.pojo.ReturnResultInfo;
import kd.scmc.pm.business.service.quotamodel.QuotaStrategyImpl;
import kd.scmc.pm.business.service.quotamodel.pojo.QuotaCalculateDTO;
import kd.scmc.pm.business.service.quotamodel.pojo.QuotaCalculateResultDTO;
import kd.scmc.pm.business.service.quotamodel.quotacalculateservice.QuotaCalculateService;
import kd.scmc.pm.enums.UnitConvertDirEnum;
import kd.scmc.pm.utils.CommonUtils;
import kd.sdk.scmc.pm.extpoint.IPurQuotaCasePlugin;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.ArrayListValuedHashMap;

public class QuotaPushOrderPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(QuotaPushOrderPlugin.class);
    private static final String ORG = "org";
    private static final String ENTRYID = "entryid";
    private static final String BILLENTRY = "billentry";
    private static final String SAVE = "save";
    private static final String SUCCESSLIST = "successlist";
    private static final String ISQUOTA = "isquota";
    private static final String QUOTA = "quota";

    public void afterCreateNewData(EventObject evt) {
        this.ruleDefValue();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String quotaParam = (String)formShowParameter.getCustomParam("quotaPattern");
        if ("A".equals(quotaParam) || StringUtils.isEmpty((CharSequence)quotaParam)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"purquotanum", "purquotaname", "quotacalrule"});
            IDataModel model = this.getModel();
            List applyBillEntryId = (List)formShowParameter.getCustomParam(ENTRYID);
            Object orgId = formShowParameter.getCustomParam(ORG);
            Date bizTime = (Date)this.getModel().getValue("biztime");
            QuotaCalculateService invokeQuotaServiceImpl = QuotaStrategyImpl.invokeQuotaServiceImpl();
            QuotaCalculateDTO quotaCalculateRawdata = null;
            try {
                quotaCalculateRawdata = invokeQuotaServiceImpl.queryQuotaCalculateRawdata(applyBillEntryId, orgId, bizTime, this.getView());
            }
            catch (Exception e) {
                log.error("\u914d\u989d\u8ba1\u7b97\u65f6\u67e5\u8be2\u539f\u59cb\u6570\u636e\u51fa\u73b0\u5982\u4e0b\u5f02\u5e38\uff1a", (Throwable)e);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u914d\u989d\u8ba1\u7b97\u65f6\u67e5\u8be2\u539f\u59cb\u6570\u636e\u51fa\u73b0\u5982\u4e0b\u5f02\u5e38\uff1a", (String)"QuotaPushOrderPlugin_7", (String)"scmc-pm-formplugin", (Object[])new Object[0]).concat(e.getLocalizedMessage()));
                return;
            }
            QuotaCalculateDTO quotaCalculate = null;
            try {
                quotaCalculate = invokeQuotaServiceImpl.quotaCalculateService(quotaCalculateRawdata);
            }
            catch (Exception e) {
                log.error("\u914d\u989d\u903b\u8f91\u51fa\u73b0\u5982\u4e0b\u5f02\u5e38\uff1a", (Throwable)e);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u914d\u989d\u903b\u8f91\u51fa\u73b0\u5982\u4e0b\u5f02\u5e38\uff1a", (String)"QuotaPushOrderPlugin_8", (String)"scmc-pm-formplugin", (Object[])new Object[0]).concat(e.getLocalizedMessage()));
                return;
            }
            if (!quotaCalculate.isSuccess()) {
                log.info("\u914d\u989d\u8ba1\u7b97\u5931\u8d25\uff0c\u8bf7\u60a8\u6838\u5b9e\uff01\uff01\uff01\uff01");
                return;
            }
            List calculateResult = quotaCalculate.getCalculateResult();
            if (calculateResult != null && calculateResult.size() > 0) {
                model.batchCreateNewEntryRow("resultentryentity", calculateResult.size());
                for (int rowId = 0; rowId < calculateResult.size(); ++rowId) {
                    QuotaCalculateResultDTO dto = (QuotaCalculateResultDTO)calculateResult.get(rowId);
                    model.setValue("resultmaterial", (Object)dto.getMaterial(), rowId);
                    model.setValue("resultsupplier", (Object)dto.getSupplier(), rowId);
                    model.setValue("quotaqty", (Object)dto.getQuotaqty(), rowId);
                    model.setValue("resultunit", (Object)dto.getResultunit(), rowId);
                    model.setValue("auxqty", (Object)dto.getAuxqty(), rowId);
                    model.setValue("auxunit", (Object)dto.getAuxunit(), rowId);
                    model.setValue("quotasrcbillno", (Object)dto.getQuotasrcbillno(), rowId);
                    model.setValue("quotarate", (Object)dto.getQuotarate(), rowId);
                    model.setValue("supplyrank", (Object)dto.getSupplyrank(), rowId);
                    model.setValue("allotqty", (Object)dto.getAllotqty(), rowId);
                    model.setValue("srcbillid", (Object)dto.getSrcbillid(), rowId);
                    model.setValue("srcbillentryid", (Object)dto.getSrcbillentryid(), rowId);
                    model.setValue("baseqty", (Object)dto.getBaseqty(), rowId);
                    model.setValue("baseunit", (Object)dto.getBaseunit(), rowId);
                    model.setValue("maxbillqty", (Object)dto.getMaxbillqty(), rowId);
                    model.setValue("minbillqty", (Object)dto.getMinbillqty(), rowId);
                    BigDecimal packagebatchqty = dto.getPackagebatchqty();
                    long packQtyLong = 0L;
                    BigDecimal packingQty = BigDecimal.ZERO;
                    if (packagebatchqty != null && packagebatchqty.compareTo(BigDecimal.ZERO) != 0) {
                        DynamicObject masterid;
                        DynamicObject material = dto.getMaterial();
                        if (material == null || (masterid = (DynamicObject)material.get("masterid")) == null || dto.getResultunit() == null || dto.getResultunit() == null) continue;
                        packingQty = BaseDataServiceHelper.getDesmuCount((Long)((Long)masterid.getPkValue()), (Long)((Long)dto.getBaseunit().getPkValue()), (BigDecimal)packagebatchqty, (Long)((Long)dto.getResultunit().getPkValue()));
                        packQtyLong = packingQty.compareTo(BigDecimal.ZERO) > 0 && packingQty.compareTo(BigDecimal.ONE) < 0 ? 1L : packingQty.setScale(0, RoundingMode.DOWN).longValue();
                    }
                    model.setValue("packagebatchqty", (Object)packQtyLong, rowId);
                    model.setValue("packingqty", (Object)packingQty, rowId);
                }
                String result = String.format(ResManager.loadKDString((String)"\u6309\u7167\u914d\u989d\u65b9\u6848\u8ba1\u7b97\uff0c%1$s\u5f20\uff08\u5171%2$s\u884c\uff09\u91c7\u8d2d\u7533\u8bf7\u5355\u88ab\u62c6\u5206\u4e3a%3$s\u884c\u3002", (String)"QuotaPushOrderPlugin_3", (String)"scmc-pm-formplugin", (Object[])new Object[0]), quotaCalculate.getBillNum(), quotaCalculate.getBillEntryNum(), quotaCalculate.getBillLineNum());
                Label labelAp = (Label)this.getView().getControl("labelap");
                labelAp.setText(result);
            } else {
                Label labelAp = (Label)this.getView().getControl("labelap");
                labelAp.setText(ResManager.loadKDString((String)"\u6309\u7167\u914d\u989d\u65b9\u6848\u8ba1\u7b97\uff0c0\u5f20\uff08\u51710\u884c\uff09\u91c7\u8d2d\u7533\u8bf7\u5355\u88ab\u62c6\u5206\u4e3a0\u884c\u3002", (String)"QuotaPushOrderPlugin_9", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        IFormView view = this.getView();
        BasedataEdit botpRuleEdit = (BasedataEdit)view.getControl("botprule");
        if (botpRuleEdit != null) {
            botpRuleEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        QFilter enable = new QFilter("enabled", "=", (Object)"1");
        switch (fieldKey) {
            case "botprule": {
                QFilter sourceentitynumber = new QFilter("sourceentitynumber", "=", (Object)"pm_purapplybill");
                QFilter targetentitynumber = new QFilter("targetentitynumber", "=", (Object)"pm_purorderbill");
                showParameter.getListFilterParameter().getQFilters().addAll(Arrays.asList(enable, sourceentitynumber, targetentitynumber));
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        Date biztime = (Date)model.getValue("biztime");
        if (biztime == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u5355\u65e5\u671f\u3002", (String)"QuotaPushOrderPlugin_4", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
            return;
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        IDataModel model = this.getModel();
        for (int i = 0; i < changeSet.length; ++i) {
            ChangeData changeData = changeSet[i];
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            DynamicObject dataEntity = changeData.getDataEntity();
            int rowIndex = changeData.getRowIndex();
            if (newValue == null && oldValue == null) {
                return;
            }
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                return;
            }
            if (oldValue instanceof BigDecimal && newValue instanceof BigDecimal && ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) == 0) {
                return;
            }
            if (!"quotaqty".equals(fieldKey)) continue;
            DynamicObject auxUnit = dataEntity.getDynamicObject("auxunit");
            DynamicObject material = dataEntity.getDynamicObject("resultmaterial");
            DynamicObject masterid = material.getDynamicObject("masterid");
            Long materialmasterid = (Long)masterid.getPkValue();
            DynamicObject baseUnit = dataEntity.getDynamicObject("baseunit");
            DynamicObject resultUnit = dataEntity.getDynamicObject("resultunit");
            BigDecimal resultQty = (BigDecimal)newValue;
            BigDecimal baseUnitQty = BillQtyAndUnitHelper.getDesQtyConv((Long)materialmasterid, (DynamicObject)resultUnit, (BigDecimal)resultQty, (DynamicObject)baseUnit);
            model.setValue("baseqty", (Object)baseUnitQty, rowIndex);
            String unitConvertDir = masterid.getString("unitconvertdir");
            if (!UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) && !UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) continue;
            BigDecimal changeAuxQty = QuotaCalculImpHelper.changeAuxQty((DynamicObject)material, (DynamicObject)auxUnit, (DynamicObject)resultUnit, (BigDecimal)resultQty);
            model.setValue("auxqty", (Object)changeAuxQty, rowIndex);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if ("generateorder".equals(key)) {
            Object ruleObj = model.getValue("botprule");
            if (CommonUtils.isNull((Object)ruleObj)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5339\u914d\u89c4\u5219\u3002", (String)"QuotaPushOrderPlugin_10", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObject bill = model.getDataEntity(true);
            DynamicObjectCollection entryRow = bill.getDynamicObjectCollection("resultentryentity");
            ArrayList<Integer> qtyEmptyRow = new ArrayList<Integer>();
            EntryGrid entry = (EntryGrid)this.getControl("resultentryentity");
            int[] selectRows = entry.getSelectRows();
            int size = selectRows.length > entryRow.size() ? entryRow.size() : selectRows.length;
            for (int selRow : selectRows) {
                DynamicObject row = (DynamicObject)entryRow.get(selRow);
                BigDecimal quotaqty = row.getBigDecimal("quotaqty");
                if (BigDecimal.ZERO.compareTo(quotaqty) != 0) continue;
                int rowNum = selRow + 1;
                qtyEmptyRow.add(rowNum);
            }
            if (qtyEmptyRow.size() > 0) {
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u6570\u5b57\u884c%1$s\uff0c\u8bf7\u586b\u5199\u201c\u914d\u989d\u6570\u91cf\u201d\u3002", (String)"QuotaPushOrderPlugin_5", (String)"scmc-pm-formplugin", (Object[])new Object[0]), qtyEmptyRow));
                return;
            }
            if (selectRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u3002", (String)"QuotaPushOrderPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            } else {
                ArrayListValuedHashMap rowSupplier = new ArrayListValuedHashMap(selectRows.length);
                for (int i = 0; i < selectRows.length; ++i) {
                    int rowIndex = selectRows[i];
                    DynamicObject supplier = (DynamicObject)this.getModel().getValue("resultsupplier", rowIndex);
                    Long supplierId = (Long)supplier.getPkValue();
                    DynamicObject row = this.getModel().getEntryRowEntity("resultentryentity", rowIndex);
                    rowSupplier.put((Object)supplierId, (Object)row);
                }
                this.createOrder(selectRows, (MultiValuedMap<Long, DynamicObject>)rowSupplier);
            }
        }
    }

    protected void createOrder(int[] selectRows, MultiValuedMap<Long, DynamicObject> rowSupplier) {
        HashMap<Long, Long> sourceIdMap = new HashMap<Long, Long>(selectRows.length);
        HashMap<String, String> param = new HashMap<String, String>(selectRows.length);
        HashMap<String, Object> subParam = new HashMap<String, Object>(16);
        HashMap<Boolean, String> isSuccess = new HashMap<Boolean, String>(rowSupplier.size());
        ArrayList successList = new ArrayList(selectRows.length);
        Date bizTime = (Date)this.getModel().getValue("biztime");
        DynamicObject botpRule = (DynamicObject)this.getModel().getValue("botprule");
        for (Long groupKey : rowSupplier.keySet()) {
            param.put("biztime", String.valueOf(bizTime.getTime()));
            param.put(ISQUOTA, QUOTA);
            Collection groupValue = rowSupplier.get((Object)groupKey);
            PluginProxy pluginProxy = PluginProxy.create(null, IPurQuotaCasePlugin.class, (String)"SCMC_PM_PURQUOTA", null);
            List retCustomParam = pluginProxy.callReplace(p -> p.getCustomPushOrderInfos(groupValue));
            Map customParam = new HashMap(16);
            if (retCustomParam != null && retCustomParam.size() > 0) {
                customParam = (Map)retCustomParam.get(0);
            }
            Iterator iterator = groupValue.iterator();
            while (iterator.hasNext()) {
                DynamicObject entryRow = (DynamicObject)iterator.next();
                BigDecimal baseQty = entryRow.getBigDecimal("baseqty");
                if (baseQty != null && baseQty.compareTo(BigDecimal.ZERO) == 0) continue;
                subParam.put("supplier", entryRow.getDynamicObject("resultsupplier").getPkValue());
                subParam.put("qty", entryRow.getBigDecimal("quotaqty"));
                subParam.put("baseqty", baseQty);
                subParam.put("auxqty", entryRow.getBigDecimal("auxqty"));
                try {
                    if (customParam != null && customParam.size() > 0) {
                        String srcEntryIdStr = entryRow.get("srcbillentryid").toString();
                        String cusSubParam = (String)customParam.get(srcEntryIdStr);
                        HashMap castFields = (HashMap)JSONUtils.cast((String)cusSubParam, HashMap.class);
                        subParam.putAll(castFields);
                    }
                    param.put(entryRow.get("srcbillentryid").toString(), JSONUtils.toString(subParam));
                }
                catch (IOException e) {
                    log.error((Throwable)e);
                    throw new KDBizException(ResManager.loadKDString((String)"JOSN\u8f6c\u6362\u5f02\u5e38\u3002", (String)"QuotaPushOrderPlugin_1", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                }
                Long billEntryID = entryRow.getLong("srcbillentryid");
                Long billID = entryRow.getLong("srcbillid");
                sourceIdMap.put(billEntryID, billID);
                subParam.clear();
            }
            ReturnResultInfo resultInfo = null;
            if (botpRule != null && botpRule.getPkValue() != null) {
                resultInfo = BotpHepler.botpGenerateTargetBill(sourceIdMap, (String)((String)botpRule.getPkValue()), (String)"pm_purapplybill", (String)BILLENTRY, (String)"pm_purorderbill", (String)BILLENTRY, (String)SAVE, param, (boolean)false);
            }
            if (resultInfo != null && resultInfo.isSuccess()) {
                successList.addAll(resultInfo.getSuccessList());
                isSuccess.put(resultInfo.isSuccess(), resultInfo.getMessage());
            }
            param.clear();
            sourceIdMap.clear();
        }
        boolean flag = true;
        String message = null;
        for (Map.Entry entryInfo : isSuccess.entrySet()) {
            if (entryInfo.getKey() == null || !((Boolean)entryInfo.getKey()).equals(Boolean.FALSE)) continue;
            message = (String)entryInfo.getValue();
            flag = false;
            break;
        }
        if (flag) {
            HashMap<String, Cloneable> returnData = new HashMap<String, Cloneable>(2);
            returnData.put("biztime", bizTime);
            returnData.put(SUCCESSLIST, successList);
            this.getView().returnDataToParent(returnData);
            this.getView().close();
        } else {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6240\u9009\u6570\u636e%1$s", (String)"QuotaPushOrderPlugin_2", (String)"scmc-pm-formplugin", (Object[])new Object[0]), message));
        }
    }

    private void ruleDefValue() {
        String ruleId = null;
        List loadRules = ConvertMetaServiceHelper.loadRules((String)"pm_purapplybill", (String)"pm_purorderbill");
        if (loadRules != null && loadRules.size() > 0) {
            for (int i = 0; i < loadRules.size(); ++i) {
                ConvertRuleElement loadRule = (ConvertRuleElement)loadRules.get(i);
                boolean enabled = loadRule.isEnabled();
                if (!enabled) continue;
                if (loadRule.isDefRule()) {
                    ruleId = loadRule.getId();
                    break;
                }
                if (!StringUtils.isBlank(ruleId)) continue;
                ruleId = loadRule.getId();
            }
        }
        if (!CommonUtils.isNull(ruleId)) {
            this.getModel().setValue("botprule", (Object)Long.valueOf(ruleId));
        }
    }
}

