/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.botp;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.pm.business.helper.AmountHelper;
import kd.scmc.pm.enums.ExchangeTypeEnum;

public class PurAcceptBillToApConverPlugin
extends AbstractConvertPlugIn {
    private static final BigDecimal HUNDRED = new BigDecimal(100);
    private static final BigDecimal ZERO = BigDecimal.ZERO;

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] dataEntities;
        ExtendedDataEntitySet targetExtDataEntitySet = e.getTargetExtDataEntitySet();
        for (ExtendedDataEntity dataEntity : dataEntities = targetExtDataEntitySet.FindByEntityKey(this.getTgtMainType().toString())) {
            HashMap<Object, BigDecimal> srcEntryIdAndTarEntryAmtMap = new HashMap<Object, BigDecimal>();
            DynamicObject fiBill = dataEntity.getDataEntity();
            DynamicObjectCollection entrys = null;
            BigDecimal fiTotalAmount = fiBill.getBigDecimal("amount");
            if ("ap_busbill".equals(this.getTgtMainType().toString())) {
                entrys = fiBill.getDynamicObjectCollection("entry");
            } else if ("ap_finapbill".equals(this.getTgtMainType().toString())) {
                entrys = fiBill.getDynamicObjectCollection("detailentry");
            }
            if (entrys == null) {
                return;
            }
            ArrayList<Long> srcIDs = new ArrayList<Long>(10);
            HashSet<Long> srcEntryIDs = new HashSet<Long>(10);
            for (DynamicObject entry : entrys) {
                Long srcbillid = 0L;
                Long srcentryid = 0L;
                if ("ap_busbill".equals(this.getTgtMainType().toString())) {
                    srcbillid = entry.getLong("e_srcbillid");
                    srcentryid = entry.getLong("e_srcentryid");
                } else if ("ap_finapbill".equals(this.getTgtMainType().toString())) {
                    srcbillid = entry.getLong("e_sourcebillid");
                    srcentryid = entry.getLong("e_sourcebillentryid");
                }
                BigDecimal amount = entry.getBigDecimal("e_amount");
                if (!srcIDs.contains(srcbillid)) {
                    srcIDs.add(srcbillid);
                }
                srcEntryIDs.add(srcentryid);
                srcEntryIdAndTarEntryAmtMap.put(srcentryid, amount);
            }
            QFilter qFilter = new QFilter("id", "in", (Object)srcIDs.toArray());
            QFilter qFilterId = new QFilter("billentry.id", "in", (Object)srcEntryIDs.toArray());
            DynamicObject[] purAccBills = BusinessDataServiceHelper.load((String)"pm_puracceptbill", (String)this.getProperties(), (QFilter[])new QFilter[]{qFilter, qFilterId});
            if (purAccBills.length == 0) {
                return;
            }
            if (purAccBills.length == 1) {
                this.oneForOne(fiTotalAmount, purAccBills, fiBill);
                continue;
            }
            this.manyForOne(fiTotalAmount, purAccBills, fiBill, srcEntryIdAndTarEntryAmtMap, srcIDs);
        }
    }

    private void oneForOne(BigDecimal fiTotalAmount, DynamicObject[] acceptBills, DynamicObject finApBill) {
        DynamicObject acceptBill = acceptBills[0];
        DynamicObjectCollection aPAllocationEntrys = finApBill.getDynamicObjectCollection("allocationentry");
        DynamicObject currency = finApBill.getDynamicObject("currency");
        DynamicObject bascur = finApBill.getDynamicObject("basecurrency");
        BigDecimal exchangerate = BigDecimalUtil.getNotNull((Object)finApBill.getBigDecimal("exchangerate"));
        boolean isIndirectRate = ExchangeTypeEnum.isIndirectRate((Object)finApBill.getString("quotation"));
        int baseprecision = bascur == null ? 10 : bascur.getInt("amtprecision");
        int amtprecision = currency == null ? 10 : currency.getInt("amtprecision");
        BigDecimal sumAmount = BigDecimal.ZERO;
        BigDecimal sumPer = BigDecimal.ZERO;
        BigDecimal srcTotalAmount = acceptBill.getBigDecimal("totalamount");
        DynamicObjectCollection srcallocationentrys = acceptBill.getDynamicObjectCollection("allocationentry");
        Boolean isallocbyper = acceptBill.getBoolean("isallocbyper");
        for (int i = 0; i < srcallocationentrys.size(); ++i) {
            DynamicObject allocationentry = (DynamicObject)srcallocationentrys.get(i);
            BigDecimal allocationper = allocationentry.getBigDecimal("a_allocationper");
            BigDecimal allocationamt = allocationentry.getBigDecimal("a_allocationamt");
            if (i == srcallocationentrys.size() - 1) {
                allocationamt = fiTotalAmount.subtract(sumAmount);
                allocationper = new BigDecimal(100).subtract(sumPer);
            } else if (fiTotalAmount.compareTo(BigDecimal.ZERO) != 0) {
                if (isallocbyper.booleanValue()) {
                    allocationamt = fiTotalAmount.multiply(allocationper.divide(HUNDRED, 10, RoundingMode.HALF_UP)).setScale(amtprecision, RoundingMode.HALF_UP);
                    sumAmount = sumAmount.add(allocationamt);
                    sumPer = sumPer.add(allocationper);
                } else {
                    if (ZERO.compareTo(srcTotalAmount) == 0) continue;
                    allocationamt = allocationentry.getBigDecimal("a_allocationamt");
                    allocationamt = fiTotalAmount.multiply(allocationamt).divide(srcTotalAmount, amtprecision, RoundingMode.HALF_UP);
                    allocationper = allocationamt.divide(fiTotalAmount, 10, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP);
                    sumPer = sumPer.add(allocationper);
                    sumAmount = sumAmount.add(allocationamt);
                }
            } else {
                sumPer = sumPer.add(allocationper);
                sumAmount = sumAmount.add(allocationamt);
            }
            DynamicObject entry = aPAllocationEntrys.addNew();
            entry.set("a_allocationamt", (Object)allocationamt);
            entry.set("a_allocationper", (Object)allocationper);
            entry.set("a_localamt", (Object)AmountHelper.convertByExRate((BigDecimal)allocationamt, (BigDecimal)exchangerate, (boolean)isIndirectRate, (int)baseprecision));
            entry.set("a_expenseitem", (Object)allocationentry.getDynamicObject("a_expenseitem"));
            entry.set("a_costcenter", (Object)allocationentry.getDynamicObject("a_costcenter"));
        }
    }

    private void manyForOne(BigDecimal fiTotalAmount, DynamicObject[] acceptBills, DynamicObject fiBill, Map<Object, BigDecimal> srcEntryIdAndTarEntryAmtMap, ArrayList<Long> srcIDs) {
        int count = 0;
        BigDecimal sumTarAllocbyper = BigDecimal.ZERO;
        BigDecimal sumTarAmount = BigDecimal.ZERO;
        HashMap acceptIDAndaccetpDymMap = new HashMap(10);
        Arrays.asList(acceptBills).forEach(acceptBill -> acceptIDAndaccetpDymMap.put((Long)acceptBill.getPkValue(), acceptBill));
        for (Long srcID : srcIDs) {
            DynamicObject acceptBill2 = (DynamicObject)acceptIDAndaccetpDymMap.get(srcID);
            if (acceptBill2 == null) continue;
            ++count;
            if (!acceptBill2.getBoolean("isexpensealloc")) {
                return;
            }
            DynamicObject acceptSettleCurrency = acceptBill2.getDynamicObject("settlecurrency");
            int acceptSettlePrecision = acceptSettleCurrency == null ? 10 : acceptSettleCurrency.getInt("amtprecision");
            DynamicObjectCollection acceptBillentrys = acceptBill2.getDynamicObjectCollection("billentry");
            DynamicObjectCollection srcallocationentrys = acceptBill2.getDynamicObjectCollection("allocationentry");
            DynamicObjectCollection fiAllocationEntrys = fiBill.getDynamicObjectCollection("allocationentry");
            DynamicObject fiBaseCurrency = fiBill.getDynamicObject("basecurrency");
            int fiBasePrecision = fiBaseCurrency == null ? 10 : fiBaseCurrency.getInt("amtprecision");
            BigDecimal exchangerate = BigDecimalUtil.getNotNull((Object)fiBill.getBigDecimal("exchangerate"));
            boolean isIndirectRate = ExchangeTypeEnum.isIndirectRate((Object)fiBill.getString("quotation"));
            BigDecimal fiAllAmount = ZERO;
            BigDecimal srcTotalAmount = acceptBill2.getBigDecimal("totalamount");
            for (DynamicObject acceptbillentry : acceptBillentrys) {
                BigDecimal fiAmount = srcEntryIdAndTarEntryAmtMap.get(acceptbillentry.getPkValue());
                if (fiAmount == null) continue;
                fiAllAmount = fiAllAmount.add(fiAmount);
            }
            if (fiAllAmount.compareTo(ZERO) == 0) continue;
            for (int i = 0; i < srcallocationentrys.size(); ++i) {
                DynamicObject srcAllocationentry = (DynamicObject)srcallocationentrys.get(i);
                BigDecimal allocationamt = BigDecimal.ZERO;
                BigDecimal allocationper = BigDecimal.ZERO;
                if (count == acceptBills.length && i == srcallocationentrys.size() - 1) {
                    allocationamt = fiTotalAmount.subtract(sumTarAmount);
                    allocationper = new BigDecimal(100).subtract(sumTarAllocbyper);
                } else if (fiTotalAmount.compareTo(BigDecimal.ZERO) != 0 || srcTotalAmount.compareTo(BigDecimal.ZERO) != 0) {
                    if (acceptBill2.getBoolean("isallocbyper")) {
                        allocationper = srcAllocationentry.getBigDecimal("a_allocationper");
                        allocationamt = fiAllAmount.multiply(allocationper.divide(HUNDRED, 10, RoundingMode.HALF_UP)).setScale(acceptSettlePrecision, RoundingMode.HALF_UP);
                    } else {
                        if (ZERO.compareTo(srcTotalAmount) == 0) continue;
                        allocationamt = fiAllAmount.multiply(srcAllocationentry.getBigDecimal("a_allocationamt")).divide(srcTotalAmount, acceptSettlePrecision, RoundingMode.HALF_UP);
                    }
                    allocationper = allocationamt.divide(fiTotalAmount, 10, RoundingMode.HALF_UP).multiply(HUNDRED).setScale(2, RoundingMode.HALF_UP);
                    sumTarAmount = sumTarAmount.add(allocationamt);
                    sumTarAllocbyper = sumTarAllocbyper.add(allocationper);
                } else {
                    allocationper = srcAllocationentry.getBigDecimal("a_allocationper");
                    allocationamt = srcAllocationentry.getBigDecimal("a_allocationamt");
                    sumTarAmount = sumTarAmount.add(allocationamt);
                    sumTarAllocbyper = sumTarAllocbyper.add(allocationper);
                }
                DynamicObject entry = fiAllocationEntrys.addNew();
                entry.set("a_allocationamt", (Object)allocationamt);
                entry.set("a_allocationper", (Object)allocationper);
                entry.set("a_localamt", (Object)AmountHelper.convertByExRate((BigDecimal)allocationamt, (BigDecimal)exchangerate, (boolean)isIndirectRate, (int)fiBasePrecision));
                entry.set("a_expenseitem", (Object)srcAllocationentry.getDynamicObject("a_expenseitem"));
                entry.set("a_costcenter", (Object)srcAllocationentry.getDynamicObject("a_costcenter"));
            }
        }
    }

    private String getProperties() {
        return "id,isexpensealloc,isallocbyper,totalamount,billentry.id,billentry.amount,billentry.qty,billentry.joinpayablepriceqty,settlecurrency,billentry.payablepriceqty,allocationentry.a_expenseitem,allocationentry.a_costcenter,allocationentry.a_allocationper,allocationentry,a_allocationamt";
    }
}

