/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.botp;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterGetSourceDataEventArgs;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.JSONUtils;
import kd.scmc.pm.formplugin.botp.Bill2PurOrderConvertPlugin;

public class PurApply2OrderConvertPlugin
extends Bill2PurOrderConvertPlugin {
    private static final Log log = LogFactory.getLog(PurApply2OrderConvertPlugin.class);

    public void afterGetSourceData(AfterGetSourceDataEventArgs e) {
        super.afterGetSourceData(e);
        Map fldProperties = e.getFldProperties();
        List sourceRows = e.getSourceRows();
        Map variables = this.getOption().getVariables();
        log.info("\u91c7\u8d2d\u7533\u8bf7\u5355\u4e0b\u63a8\u91c7\u8d2d\u8ba2\u5355\u7684\u53c2\u6570\u4e3a \uff1a" + variables);
        if (variables != null && "quota".equals(variables.get("isquota"))) {
            HashSet<String> fields = new HashSet<String>(16);
            Map<Long, Map<String, Object>> dataMap = this.parseCustomerVariables(variables, fields);
            for (DynamicObject bill : sourceRows) {
                this.updateEntryInfoFromVar(bill, dataMap, fldProperties);
            }
        }
    }

    @Override
    public void afterConvert(AfterConvertEventArgs e) {
        super.afterConvert(e);
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entities = entitySet.FindByEntityKey(this.getTgtMainType().toString());
        Map variables = this.getOption().getVariables();
        log.info("\u91c7\u8d2d\u7533\u8bf7\u5355\u4e0b\u63a8\u91c7\u8d2d\u8ba2\u5355\u7684\u53c2\u6570\u4e3a \uff1a" + variables);
        if (variables != null && "quota".equals(variables.get("isquota"))) {
            Date bizTime = null;
            Object obj = variables.get("biztime");
            if (obj != null) {
                String bizDate = (String)variables.get("biztime");
                bizTime = new Date(Long.parseLong(bizDate));
            }
            for (ExtendedDataEntity entity : entities) {
                DynamicObject bill = entity.getDataEntity();
                DynamicObject org = bill.getDynamicObject("org");
                if (org == null) {
                    return;
                }
                if (bizTime == null) continue;
                bill.set("biztime", (Object)bizTime);
            }
        }
    }

    private Map<Long, Map<String, Object>> parseCustomerVariables(Map<String, String> variables, Set<String> fields) {
        HashMap<Long, Map<String, Object>> allDataMap = new HashMap<Long, Map<String, Object>>(16);
        variables.remove("isquota");
        variables.remove("biztime");
        try {
            String data = variables.entrySet().iterator().next().getValue();
            HashMap castFields = (HashMap)JSONUtils.cast((String)data, HashMap.class);
            fields.addAll(castFields.keySet());
            Map<String, Class<?>> propMap = this.getFieldsProp(fields);
            for (Map.Entry<String, String> entry : variables.entrySet()) {
                String dataJson = entry.getValue();
                Long billEntryId = Long.valueOf(entry.getKey());
                HashMap dataMap = (HashMap)JSONUtils.cast((String)dataJson, HashMap.class);
                if (dataMap == null) continue;
                for (Map.Entry entry2 : dataMap.entrySet()) {
                    String key = (String)entry2.getKey();
                    Object jsonValue = entry2.getValue();
                    if (propMap.get(key) == null) continue;
                    Object value = JSONUtils.cast((String)jsonValue.toString(), propMap.get(key));
                    entry2.setValue(value);
                }
                dataMap.put("billcretype", "10");
                allDataMap.put(billEntryId, dataMap);
            }
        }
        catch (IOException e) {
            log.error(e.fillInStackTrace());
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u63a8\u65f6JSON\u89e3\u6790\u9519\u8bef\u3002", (String)"PurApply2OrderConvertPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
        }
        return allDataMap;
    }

    private Map<String, Class<?>> getFieldsProp(Set<String> fields) {
        BillEntityType srcMainType = this.getSrcMainType();
        HashMap map = new HashMap(fields.size());
        for (String field : fields) {
            IDataEntityProperty property = srcMainType.findProperty(field);
            if (property == null) continue;
            if (property instanceof BasedataProp) {
                map.put(field, Long.class);
                continue;
            }
            if (property instanceof DecimalProp) {
                map.put(field, BigDecimal.class);
                continue;
            }
            if (!(property instanceof BooleanProp)) continue;
            map.put(field, Boolean.class);
        }
        return map;
    }

    private void updateEntryInfoFromVar(DynamicObject bill, Map<Long, Map<String, Object>> dataMap, Map<String, DynamicProperty> fldProperties) {
        Long entryId = (Long)bill.get((IDataEntityProperty)fldProperties.get("billentry.id"));
        BigDecimal joinQty = (BigDecimal)bill.get((IDataEntityProperty)fldProperties.get("joinqty"));
        BigDecimal joinBaseQty = (BigDecimal)bill.get((IDataEntityProperty)fldProperties.get("joinbaseqty"));
        Map<String, Object> map = dataMap.get(entryId);
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                DynamicProperty dynamicProperty = fldProperties.get(key);
                if (dynamicProperty == null) continue;
                String name = dynamicProperty.getName();
                if (key.equals("qty")) {
                    BigDecimal resultQty = joinQty.add((BigDecimal)value);
                    bill.set(name, (Object)resultQty);
                    continue;
                }
                if (key.equals("baseqty")) {
                    BigDecimal resultBaseQty = joinBaseQty.add((BigDecimal)value);
                    bill.set(name, (Object)resultBaseQty);
                    continue;
                }
                bill.set(name, value);
            }
        }
    }
}

