/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.botp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class PurOrder2PaybillConvertPlugin
extends AbstractConvertPlugIn {
    public void beforeBuildRowCondition(BeforeBuildRowConditionEventArgs e) {
        List selectedRows = e.getSelectedRows();
        if (selectedRows.isEmpty()) {
            return;
        }
        HashSet<Long> billIds = new HashSet<Long>(8);
        selectedRows.forEach(row -> billIds.add((Long)row.getPrimaryKeyValue()));
        this.checkPreTimePoint(billIds, e);
        this.checkPOEntrySettleOrg(billIds, e);
    }

    private void checkPOEntrySettleOrg(Set<Long> billIds, BeforeBuildRowConditionEventArgs e) {
        if (billIds.isEmpty()) {
            return;
        }
        QFilter idFilter = new QFilter("id", "in", billIds);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"pm_purorderbill", (String)"id,billentry.entrysettleorg as entrysettleorg", (QFilter[])new QFilter[]{idFilter}, null);
        int settleOrgCount = dataSet.groupBy(new String[]{"entrysettleorg"}).finish().count("entrysettleorg", true);
        if (settleOrgCount > 1) {
            QFilter noPushIdFilter = QFilter.of((String)"1=-1", (Object[])new Object[0]);
            e.getCustQFilters().add(noPushIdFilter);
            String noPushIdFilterExpression = noPushIdFilter.toCurrentString();
            e.setCustFilterExpression(noPushIdFilterExpression);
            e.setCustFilterDesc(ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355\u7ed3\u7b97\u7ec4\u7ec7\u4e0d\u540c\uff0c\u65e0\u6cd5\u4e00\u8d77\u4e0b\u63a8\u4ed8\u6b3e\u5904\u7406\uff0c\u8bf7\u5206\u522b\u4e0b\u63a8\u3002", (String)"PurOrder2PaybillConvertPlugin_2", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
        }
    }

    private void checkPreTimePoint(Set<Long> billIds, BeforeBuildRowConditionEventArgs e) {
        QFilter idFilter = new QFilter("id", "in", billIds);
        QFilter payEntryIsPrePayFilter = new QFilter("purbillentry_pay.isprepay", "=", (Object)Boolean.TRUE);
        QFilter payEntryPreTimePointFilter = new QFilter("purbillentry_pay.pretimepoint", "=", (Object)" ");
        DynamicObjectCollection idCol = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"pm_purorderbill", (String)"id", (QFilter[])new QFilter[]{idFilter, payEntryIsPrePayFilter, payEntryPreTimePointFilter}, null);
        if (idCol == null || idCol.isEmpty()) {
            return;
        }
        HashSet hasPrePayAndPreTimePointIsBlankPOIds = new HashSet(10);
        idCol.forEach(id -> hasPrePayAndPreTimePointIsBlankPOIds.add(id.getLong("id")));
        QFilter hasPrePayAndPreTimePointIsBlankPOIdsFilter = new QFilter("id", "in", hasPrePayAndPreTimePointIsBlankPOIds);
        QFilter hasConbillIdFiter = new QFilter("billentry.conbillid", "!=", (Object)0L);
        DynamicObjectCollection query = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"pm_purorderbill", (String)"id,billentry.conbillid", (QFilter[])new QFilter[]{hasPrePayAndPreTimePointIsBlankPOIdsFilter, hasConbillIdFiter}, null);
        HashMap conBillIdAndPoBillIdMap = new HashMap(10);
        if (query == null || query.isEmpty()) {
            return;
        }
        query.forEach(row -> conBillIdAndPoBillIdMap.put(row.getLong("billentry.conbillid"), row.getLong("id")));
        QFilter hasJoinPayAmountFiter = new QFilter("payentry.joinpayamount", ">", (Object)BigDecimal.ZERO);
        QFilter conBillIdFilter = new QFilter("id", "in", conBillIdAndPoBillIdMap.keySet());
        DynamicObjectCollection queryConm = QueryServiceHelper.query((String)((Object)((Object)this)).getClass().getName(), (String)"conm_purcontract", (String)"id", (QFilter[])new QFilter[]{hasJoinPayAmountFiter, conBillIdFilter}, null);
        if (queryConm == null || queryConm.isEmpty()) {
            return;
        }
        HashSet hasJoinAmountConId = new HashSet(10);
        queryConm.forEach(row -> hasJoinAmountConId.add(row.getLong("id")));
        if (!hasJoinAmountConId.isEmpty()) {
            HashSet noPushIdSet = new HashSet(10);
            for (Map.Entry entry : conBillIdAndPoBillIdMap.entrySet()) {
                Long conid = (Long)entry.getKey();
                if (!hasJoinAmountConId.contains(conid)) continue;
                noPushIdSet.add(entry.getValue());
            }
            QFilter noPushIdFilter = new QFilter("id", "not in", noPushIdSet);
            e.getCustQFilters().add(noPushIdFilter);
            String noPushIdFilterExpression = noPushIdFilter.toCurrentString();
            e.setCustFilterExpression(noPushIdFilterExpression);
            e.setCustFilterDesc(ResManager.loadKDString((String)"\u91c7\u8d2d\u8ba2\u5355\u5173\u8054\u7684\u5408\u540c\u5df2\u7ecf\u53d1\u751f\u9884\u4ed8\u6b3e\uff0c\u8ba2\u5355\u4e0d\u80fd\u6267\u884c\u9884\u4ed8\u3002", (String)"PurOrder2PaybillConvertPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
        }
    }

    public void afterConvert(AfterConvertEventArgs e) {
        Map<Long, List<DynamicObject>> targetHeadMap = this.getTargetHeadMap(e);
        if (targetHeadMap.isEmpty()) {
            return;
        }
        Map<Long, List<DynamicObject>> targetRowMap = this.getTargetRowMap(e);
        if (targetRowMap.isEmpty()) {
            return;
        }
        Map<Long, DynamicObject> srcBillData = this.getSrcBillData(targetRowMap.keySet());
        if (srcBillData.isEmpty()) {
            return;
        }
        this.addHeadFields(targetHeadMap, srcBillData);
        this.addFields(targetRowMap, srcBillData);
    }

    private void addHeadFields(Map<Long, List<DynamicObject>> targetHeadMap, Map<Long, DynamicObject> srcBillData) {
        for (Map.Entry<Long, DynamicObject> headMap : srcBillData.entrySet()) {
            DynamicObject billField = headMap.getValue();
            List<DynamicObject> list = targetHeadMap.get(headMap.getKey());
            if (list == null) continue;
            this.batchHeadFieldSet(list, billField);
        }
    }

    private void batchHeadFieldSet(List<DynamicObject> list, DynamicObject billField) {
        String org = "org";
        DynamicObject payOrg = billField.getDynamicObject("entrypayorg");
        for (DynamicObject dynamicObject : list) {
            dynamicObject.set(org, (Object)payOrg);
        }
    }

    private void addFields(Map<Long, List<DynamicObject>> targetRowMap, Map<Long, DynamicObject> srcBillData) {
        for (Map.Entry<Long, DynamicObject> entry : srcBillData.entrySet()) {
            List<DynamicObject> list = targetRowMap.get(entry.getKey());
            if (list == null) continue;
            this.batchSet(list, entry.getValue());
        }
    }

    private void batchSet(List<DynamicObject> list, DynamicObject row) {
        String payBillSettleOrgKey = "settleorg";
        String conBillEntityKey = "conbillentity";
        String conBillIdKey = "conbillid";
        String conBillNumberKey = "conbillnumber";
        for (DynamicObject dynamicObject : list) {
            if (dynamicObject.getDynamicObject(payBillSettleOrgKey) == null) {
                dynamicObject.set(payBillSettleOrgKey, row.get("entrysettleorg"));
            }
            if (dynamicObject.getDynamicObject(conBillEntityKey) == null) {
                dynamicObject.set(conBillEntityKey, row.get("conbillentity"));
            }
            if (0L == dynamicObject.getLong(conBillIdKey)) {
                dynamicObject.set(conBillIdKey, row.get("conbillid"));
            }
            if (!StringUtils.isEmpty((CharSequence)dynamicObject.getString(conBillNumberKey))) continue;
            dynamicObject.set(conBillNumberKey, row.get("conbillnumber"));
        }
    }

    private Map<Long, DynamicObject> getSrcBillData(Set<Long> billIds) {
        QFilter qFilter = new QFilter("id", "in", billIds);
        DynamicObject[] loadBills = BusinessDataServiceHelper.load((String)"pm_purorderbill", (String)"id,billentry.entrysettleorg,billentry.entrypayorg,billentry.conbillentity,billentry.conbillid,billentry.conbillnumber", (QFilter[])qFilter.toArray());
        if (loadBills == null) {
            return Collections.emptyMap();
        }
        HashMap<Long, DynamicObject> srcBillData = new HashMap<Long, DynamicObject>(loadBills.length << 1);
        for (DynamicObject loadBill : loadBills) {
            Long billId = (Long)loadBill.getPkValue();
            DynamicObjectCollection entry = loadBill.getDynamicObjectCollection("billentry");
            if (entry == null || entry.isEmpty()) continue;
            srcBillData.put(billId, (DynamicObject)entry.get(0));
        }
        return srcBillData;
    }

    private Map<Long, List<DynamicObject>> getTargetRowMap(AfterConvertEventArgs e) {
        ExtendedDataEntity[] dataEntities;
        String payBillEntryName = "entry";
        String payMainBillIdKey = "e_sourcebillid";
        HashMap<Long, List<DynamicObject>> map = new HashMap<Long, List<DynamicObject>>(16);
        for (ExtendedDataEntity extendedDataEntity : dataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(this.getTgtMainType().toString())) {
            DynamicObject bill = extendedDataEntity.getDataEntity();
            DynamicObjectCollection entry = bill.getDynamicObjectCollection(payBillEntryName);
            if (entry == null) continue;
            for (DynamicObject row : entry) {
                long mainBillId = row.getLong(payMainBillIdKey);
                if (mainBillId == 0L) continue;
                ArrayList<DynamicObject> rowList = (ArrayList<DynamicObject>)map.get(mainBillId);
                if (rowList == null) {
                    rowList = new ArrayList<DynamicObject>();
                }
                rowList.add(row);
                map.put(mainBillId, rowList);
            }
        }
        return map;
    }

    private Map<Long, List<DynamicObject>> getTargetHeadMap(AfterConvertEventArgs e) {
        ExtendedDataEntity[] dataEntities;
        String payBillEntryName = "org";
        String payMainBillIdKey = "sourcebillid";
        HashMap<Long, List<DynamicObject>> map = new HashMap<Long, List<DynamicObject>>(16);
        for (ExtendedDataEntity extendedDataEntity : dataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(this.getTgtMainType().toString())) {
            DynamicObject bill = extendedDataEntity.getDataEntity();
            long mainBillId = bill.getLong(payMainBillIdKey);
            ArrayList<DynamicObject> list = (ArrayList<DynamicObject>)map.get(mainBillId);
            if (list == null) {
                list = new ArrayList<DynamicObject>();
            }
            list.add(bill);
            map.put(mainBillId, list);
        }
        return map;
    }
}

