/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.botp;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.BillAmountHelper;
import kd.mpscmm.msbd.common.pojo.BillAmountInfo;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;

public class PurOrderPurAcceptBillConvertPlugin
extends AbstractConvertPlugIn {
    private static final BigDecimal ONE = BigDecimal.ONE;

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(this.getTgtMainType().toString());
        DynamicObject userInfo = this.getCurrentUserInfo();
        DynamicObject userDept = this.getUserDept(userInfo);
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject bill = entity.getDataEntity();
            DynamicObject recOperator = bill.getDynamicObject("recoperator");
            DynamicObject recDept = bill.getDynamicObject("recdept");
            if (recDept == null && userDept != null) {
                bill.set("recdept", (Object)userDept);
            }
            if (recOperator == null && userInfo != null) {
                bill.set("recoperator", (Object)userInfo);
            }
            this.calQtyInfo(bill);
            this.calAmountInfo(bill);
        }
    }

    private void calQtyInfo(DynamicObject bill) {
        DynamicObjectCollection billentrys = bill.getDynamicObjectCollection("billentry");
        if (billentrys.isEmpty()) {
            return;
        }
        for (DynamicObject entry : billentrys) {
            DynamicObject material = (DynamicObject)entry.get("material");
            if (material == null) continue;
            DynamicObject unit = entry.getDynamicObject("unit");
            BigDecimal qty = entry.getBigDecimal("qty");
            DynamicObject baseUnit = entry.getDynamicObject("baseunit");
            BigDecimal baseQty = entry.getBigDecimal("baseqty");
            if (unit == null || baseUnit == null) continue;
            if (BigDecimalUtil.isNotBlank((BigDecimal)baseQty) && BigDecimalUtil.isBlank((BigDecimal)qty)) {
                qty = BillQtyAndUnitHelper.getDesQtyConv((Long)((Long)material.getPkValue()), (DynamicObject)baseUnit, (BigDecimal)qty, (DynamicObject)unit);
                entry.set("qty", (Object)qty);
                continue;
            }
            if (!BigDecimalUtil.isNotBlank((BigDecimal)qty) || !BigDecimalUtil.isBlank((BigDecimal)baseQty)) continue;
            baseQty = BillQtyAndUnitHelper.getDesQtyConv((Long)((Long)material.getPkValue()), (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
            entry.set("baseqty", (Object)baseQty);
        }
    }

    private void calAmountInfo(DynamicObject bill) {
        DynamicObject settleCurrency = bill.getDynamicObject("settlecurrency");
        boolean inputAmount = bill.getBoolean("inputamount");
        int settleAmtPrecision = settleCurrency == null ? 10 : settleCurrency.getInt("amtprecision");
        int settlePricePrecision = 10;
        boolean isTax = (Boolean)bill.get("istax");
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalTaxAmount = BigDecimal.ZERO;
        BigDecimal totalAllAmount = BigDecimal.ZERO;
        DynamicObjectCollection billentrys = bill.getDynamicObjectCollection("billentry");
        if (billentrys.isEmpty()) {
            return;
        }
        for (DynamicObject entry : billentrys) {
            DynamicObject material = entry.getDynamicObject("material");
            if (material == null) continue;
            BigDecimal price = entry.getBigDecimal("price");
            BigDecimal qty = entry.getBigDecimal("qty");
            BigDecimal priceAndTax = entry.getBigDecimal("priceandtax");
            BigDecimal taxRate = entry.getBigDecimal("taxrate");
            String discountType = entry.getString("discounttype");
            BigDecimal discountRate = entry.getBigDecimal("discountrate");
            BillAmountInfo billAmountInfo = new BillAmountInfo();
            billAmountInfo.setInputamount(inputAmount);
            billAmountInfo.setTax(isTax);
            billAmountInfo.setDiscountType(discountType);
            billAmountInfo.setDiscountRate(discountRate);
            billAmountInfo.setQty(qty);
            billAmountInfo.setPrice(price);
            billAmountInfo.setPriceAndTax(priceAndTax);
            billAmountInfo.setTaxRate(taxRate);
            billAmountInfo.setSettlePricePrecision(settlePricePrecision);
            billAmountInfo.setSettleAmtPrecision(settleAmtPrecision);
            billAmountInfo.setAmountAndTax(entry.getBigDecimal("amountandtax"));
            billAmountInfo.setAmount(entry.getBigDecimal("amount"));
            billAmountInfo.setTaxAmount(entry.getBigDecimal("taxamount"));
            Map amountInfoMap = BillAmountHelper.calAmount((BillAmountInfo)billAmountInfo);
            BigDecimal amount = (BigDecimal)amountInfoMap.get("amount");
            BigDecimal taxAmount = (BigDecimal)amountInfoMap.get("taxamount");
            BigDecimal amountAndTax = (BigDecimal)amountInfoMap.get("amountandtax");
            entry.set("price", amountInfoMap.get("price"));
            entry.set("priceandtax", amountInfoMap.get("priceandtax"));
            entry.set("discountamount", amountInfoMap.get("discountamount"));
            entry.set("amount", amountInfoMap.get("amount"));
            entry.set("taxamount", amountInfoMap.get("taxamount"));
            entry.set("amountandtax", amountInfoMap.get("amountandtax"));
            if (amount != null) {
                totalAmount = totalAmount.add(amount);
            }
            if (taxAmount != null) {
                totalTaxAmount = totalTaxAmount.add(taxAmount);
            }
            if (amountAndTax == null) continue;
            totalAllAmount = totalAllAmount.add(amountAndTax);
        }
        bill.set("totalamount", (Object)totalAmount);
        bill.set("totaltaxamount", (Object)totalTaxAmount);
        bill.set("totalallamount", (Object)totalAllAmount);
    }

    private DynamicObject getCurrentUserInfo() {
        DynamicObject userInfo = null;
        long userId = UserServiceHelper.getCurrentUserId();
        QFilter qFilter = new QFilter("id", "=", (Object)userId);
        DynamicObject[] userArray = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,number,dpt,ispartjob", (QFilter[])new QFilter[]{qFilter});
        if (userArray != null && userArray.length > 0) {
            userInfo = userArray[0];
        }
        return userInfo;
    }

    private DynamicObject getUserDept(DynamicObject userInfo) {
        if (userInfo == null) {
            return null;
        }
        DynamicObjectCollection entryEntity = userInfo.getDynamicObjectCollection("entryentity");
        if (!entryEntity.isEmpty()) {
            for (DynamicObject entry : entryEntity) {
                Boolean ispartjob = entry.getBoolean("ispartjob");
                if (ispartjob.booleanValue()) continue;
                return entry.getDynamicObject("dpt");
            }
        }
        return userInfo;
    }
}

