/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.notice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.pm.business.helper.AmountHelper;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.helper.OperatorGroupHelper;
import kd.scmc.pm.business.helper.OrgHelper;
import kd.scmc.pm.enums.DiscountTypeEnum;
import kd.scmc.pm.enums.EnableStatusEnum;
import kd.scmc.pm.enums.OperatorGrpTypeEnum;
import kd.scmc.pm.enums.OwnerTypeEnum;
import kd.scmc.pm.enums.StatusEnum;

public class PurReceiptNoticeBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
EntryGridBindDataListener {
    private static final String LOT_ENABLE = "lotenable";
    private static final String DT_LOT = "billentry.lot";
    private static final String ADDRESSF7 = "addressf7";
    private static final String PROVIDERADDRESSF7 = "provideraddressf7";
    private static final Log log = LogFactory.getLog(PurReceiptNoticeBillPlugin.class);

    public void registerListener(EventObject e) {
        BasedataEdit lot;
        BasedataEdit providerAddressF7;
        BasedataEdit addressF7;
        Toolbar toolbar;
        BasedataEdit owner;
        BasedataEdit warehouse;
        BasedataEdit receiveOrg;
        BasedataEdit receiveDept;
        BasedataEdit receiveClerk;
        super.registerListener(e);
        IFormView view = this.getView();
        BasedataEdit receiveGroup = (BasedataEdit)view.getControl("receivegroup");
        if (receiveGroup != null) {
            receiveGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((receiveClerk = (BasedataEdit)view.getControl("receiveclerk")) != null) {
            receiveClerk.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((receiveDept = (BasedataEdit)view.getControl("receivedept")) != null) {
            receiveDept.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((receiveOrg = (BasedataEdit)view.getControl("receiveorg")) != null) {
            receiveOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((warehouse = (BasedataEdit)this.getView().getControl("warehouse")) != null) {
            warehouse.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((owner = (BasedataEdit)this.getView().getControl("owner")) != null) {
            owner.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((toolbar = (Toolbar)this.getView().getControl("tbmainentry")) != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
        if (view.getControl("address") != null) {
            this.addClickListeners(new String[]{"address"});
        }
        if (view.getControl("provideraddress") != null) {
            this.addClickListeners(new String[]{"provideraddress"});
        }
        if ((addressF7 = (BasedataEdit)view.getControl(ADDRESSF7)) != null) {
            addressF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((providerAddressF7 = (BasedataEdit)view.getControl(PROVIDERADDRESSF7)) != null) {
            providerAddressF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((lot = (BasedataEdit)this.getView().getControl("lot")) != null) {
            lot.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{"lotnumber"});
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject operator;
        long userId;
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("receiveorg");
        if (org == null) {
            return;
        }
        Long orgId = (Long)org.getPkValue();
        Map operatorAndGroup = OperatorGroupHelper.getDefaultOperatorAndGroupByOrg((Long)orgId, (Long)(userId = UserServiceHelper.getCurrentUserId()));
        if (!operatorAndGroup.isEmpty() && (operator = (DynamicObject)operatorAndGroup.get("receiveclerk")) != null) {
            model.setValue("receiveclerk", operator.getPkValue());
            model.setValue("receivegroup", operator.get("operatorgrpid"));
            Long deptId = UserServiceHelper.getUserMainOrgId((long)userId);
            model.setValue("receivedept", (Object)deptId);
        }
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        IDataModel model = this.getModel();
        int entryCount = model.getEntryRowCount("billentry");
        if (entryCount > 0) {
            ArrayList<Integer> rowIndex = new ArrayList<Integer>(entryCount);
            for (int i = 0; i < entryCount; ++i) {
                rowIndex.add(i);
            }
            this.setLotEnable(rowIndex);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        int entryCount = model.getEntryRowCount("billentry");
        if (entryCount > 0) {
            ArrayList<Integer> rowIndex = new ArrayList<Integer>(entryCount);
            for (int i = 0; i < entryCount; ++i) {
                rowIndex.add(i);
            }
            this.setLotEnable(rowIndex);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        block25: for (int i = 0; i < changeSet.length; ++i) {
            ChangeData changeData = changeSet[i];
            int rowIndex = changeData.getRowIndex();
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            if (newValue == null && oldValue == null) {
                return;
            }
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                return;
            }
            if (oldValue instanceof BigDecimal && newValue instanceof BigDecimal && ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) == 0) {
                return;
            }
            switch (fieldName) {
                case "istax": {
                    int entryCount = this.getModel().getEntryRowCount("billentry");
                    if (entryCount <= 0) continue block25;
                    ArrayList<Integer> rowIndexs = new ArrayList<Integer>(entryCount);
                    for (int x = 0; x < entryCount; ++x) {
                        rowIndexs.add(x);
                    }
                    this.setLotEnable(rowIndexs);
                    continue block25;
                }
                case "receiveclerk": {
                    this.changeOperator(newValue);
                    continue block25;
                }
                case "entryreqorg": {
                    this.changeEntryReqOrg(rowIndex);
                    continue block25;
                }
                case "lot": {
                    this.setLotReturnInfo(rowIndex);
                    this.getView().updateView("billentry");
                    int entryCount2 = this.getModel().getEntryRowCount("billentry");
                    if (entryCount2 <= 0) continue block25;
                    ArrayList<Integer> rowIndexs2 = new ArrayList<Integer>(entryCount2);
                    for (int j = 0; j < entryCount2; ++j) {
                        rowIndexs2.add(j);
                    }
                    this.setLotEnable(rowIndexs2);
                    continue block25;
                }
                case "lotnumber": {
                    this.getModel().beginInit();
                    this.getModel().setValue("lot", null, rowIndex);
                    this.getModel().endInit();
                    this.getView().updateView("lot", rowIndex);
                    continue block25;
                }
                case "qty": {
                    this.changeQty(newValue, rowIndex);
                    continue block25;
                }
                case "addressf7": {
                    DynamicObject addressF7 = (DynamicObject)newValue;
                    if (addressF7 == null) continue block25;
                    this.getModel().setValue("address", (Object)addressF7.getString("detailaddress"));
                    continue block25;
                }
                case "provideraddressf7": {
                    DynamicObject providerAddressF7 = (DynamicObject)newValue;
                    if (providerAddressF7 == null) continue block25;
                    this.getModel().setValue("provideraddress", (Object)providerAddressF7.getString("detailaddress"));
                    continue block25;
                }
                case "price": 
                case "priceandtax": {
                    boolean isPresent = (Boolean)this.getModel().getValue("ispresent", rowIndex);
                    if (!isPresent) continue block25;
                    BigDecimal price = (BigDecimal)newValue;
                    if (BigDecimalUtil.isZero((BigDecimal)price)) {
                        this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), rowIndex);
                        this.getModel().setValue("discountrate", (Object)BigDecimal.ZERO, rowIndex);
                        continue block25;
                    }
                    this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue(), rowIndex);
                    this.getModel().setValue("discountrate", (Object)new BigDecimal(100), rowIndex);
                    continue block25;
                }
                case "ispresent": {
                    this.changeIsPresent(newValue, rowIndex);
                    continue block25;
                }
            }
        }
    }

    private void changeIsPresent(Object newValue, int rowIndex) {
        if (newValue instanceof Boolean) {
            IDataModel model = this.getModel();
            boolean isPresent = (Boolean)newValue;
            boolean isTax = (Boolean)this.getModel().getValue("istax");
            if (isPresent) {
                this.getPageCache().put("stopChange", "true");
                BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
                BigDecimal priceAndTax = (BigDecimal)model.getValue("priceandtax", rowIndex);
                if (isTax) {
                    if (priceAndTax.compareTo(BigDecimal.ZERO) > 0) {
                        this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue(), rowIndex);
                        this.getModel().setValue("discountrate", (Object)new BigDecimal(100), rowIndex);
                    } else if (priceAndTax.compareTo(BigDecimal.ZERO) == 0) {
                        this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), rowIndex);
                        this.getModel().setValue("discountrate", (Object)BigDecimal.ZERO, rowIndex);
                    }
                } else if (price.compareTo(BigDecimal.ZERO) > 0) {
                    this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue(), rowIndex);
                    this.getModel().setValue("discountrate", (Object)new BigDecimal(100), rowIndex);
                } else if (price.compareTo(BigDecimal.ZERO) == 0) {
                    this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), rowIndex);
                    this.getModel().setValue("discountrate", (Object)BigDecimal.ZERO, rowIndex);
                }
                model.setValue("amount", (Object)BigDecimalUtil.ZERO, rowIndex);
                model.setValue("taxamount", (Object)BigDecimalUtil.ZERO, rowIndex);
                model.setValue("discountamount", (Object)BigDecimalUtil.ZERO, rowIndex);
                model.setValue("amountandtax", (Object)BigDecimalUtil.ZERO, rowIndex);
                model.setValue("curamount", (Object)BigDecimalUtil.ZERO, rowIndex);
                model.setValue("curtaxamount", (Object)BigDecimalUtil.ZERO, rowIndex);
                model.setValue("curamountandtax", (Object)BigDecimalUtil.ZERO, rowIndex);
                this.getPageCache().put("stopChange", "false");
                this.calcTotalAmount();
            } else {
                model.setValue("discountrate", (Object)BigDecimal.ZERO, rowIndex);
                model.setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), rowIndex);
            }
        }
    }

    public void click(EventObject evt) {
        BasedataEdit addressF7;
        String key = ((Control)evt.getSource()).getKey();
        if (key.equalsIgnoreCase("provideraddress")) {
            BasedataEdit providerAddressF7 = (BasedataEdit)this.getView().getControl(PROVIDERADDRESSF7);
            if (providerAddressF7 != null) {
                providerAddressF7.click();
            }
        } else if (key.equalsIgnoreCase("address") && (addressF7 = (BasedataEdit)this.getControl(ADDRESSF7)) != null) {
            addressF7.click();
        }
        if ("lotnumber".equals(key)) {
            if (PurReceiptNoticeBillPlugin.isUseLot()) {
                BasedataEdit lotf7 = (BasedataEdit)this.getControl("lot");
                if (lotf7 != null) {
                    lotf7.click();
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u542f\u7528\u6279\u53f7\u4e3b\u6863\u3002", (String)"PurReceiptNoticeBillPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        IDataModel model = this.getModel();
        int row = e.getRow();
        DynamicObject receiveOrg = (DynamicObject)model.getValue("receiveorg");
        if (!"receiveorg".equals(fieldKey)) {
            if (receiveOrg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6536\u8d27\u7ec4\u7ec7\u3002", (String)"PurReceiptNoticeBillPlugin_1", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        } else {
            return;
        }
        Long receiveOrgId = (Long)receiveOrg.getPkValue();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (fieldKey) {
            case "receiveclerk": {
                QFilter q1 = new QFilter("invalid", "=", (Object)Boolean.FALSE);
                try {
                    QFilter q3 = new QFilter("operatorgrpid", "in", (Object)OperatorGroupHelper.getOperatorGroupByOrg((Long)receiveOrgId, (String)OperatorGrpTypeEnum.INVENTORYGRP.getValue()));
                    showParameter.getListFilterParameter().getQFilters().add(q1.and(q3));
                }
                catch (Exception ee) {
                    log.error(ee.getMessage());
                    showParameter.getListFilterParameter().getQFilters().add(q1);
                }
                break;
            }
            case "owner": {
                QFilter filter;
                String ownerType = (String)model.getValue("ownertype", row);
                if (!OwnerTypeEnum.OWNERTYPE_ORG.getValue().equals(ownerType)) break;
                List<Long> orgIds = new ArrayList();
                Long recOrgId = null;
                recOrgId = (Long)receiveOrg.getPkValue();
                Map orgRelation = OrgHelper.getOrgRelation((Long)recOrgId, (String)"10", (String)"05", (String)"fromorg");
                if (orgRelation != null && orgRelation.get("orgId") != null) {
                    orgIds = (List)orgRelation.get("orgId");
                }
                if (orgIds == null || orgIds.isEmpty()) {
                    filter = new QFilter("fisaccounting", "=", (Object)Boolean.TRUE);
                } else {
                    Long recSettleOrg = this.getSettleOrg(recOrgId);
                    if (recOrgId.equals(recSettleOrg)) {
                        orgIds.add(recOrgId);
                    }
                    filter = new QFilter("id", "in", orgIds);
                }
                showParameter.getListFilterParameter().getQFilters().add(filter);
                break;
            }
            case "lot": {
                DynamicObject selectEntry = this.getModel().getEntryRowEntity("billentry", row);
                QFilter qFilter = (QFilter)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"getLotMainfFileFilter", (Object[])new Object[]{this.getModel().getDataEntity(true), selectEntry, DT_LOT});
                if (qFilter != null) {
                    showParameter.getListFilterParameter().getQFilters().add(qFilter);
                    break;
                }
                showParameter.getListFilterParameter().getQFilters().add(QFilter.of((String)"1!=1", (Object[])new Object[0]));
                break;
            }
            case "addressf7": {
                DynamicObject supplier = (DynamicObject)model.getValue("supplier");
                if (supplier == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f9b\u5e94\u5546\u3002", (String)"PurReceiptNoticeBillPlugin_3", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                QFilter id1 = new QFilter("supplierid", "in", (Object)supplier.getPkValue().toString());
                QFilter id2 = new QFilter("invalid", "=", (Object)Boolean.FALSE);
                showParameter.getListFilterParameter().setQFilters(Arrays.asList(id1, id2));
                break;
            }
            case "provideraddressf7": {
                DynamicObject providerSupplier = (DynamicObject)model.getValue("providersupplier");
                if (providerSupplier == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9001\u8d27\u65b9\u3002", (String)"PurReceiptNoticeBillPlugin_4", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                QFilter id1 = new QFilter("supplierid", "in", (Object)providerSupplier.getPkValue().toString());
                QFilter id2 = new QFilter("invalid", "=", (Object)Boolean.FALSE);
                showParameter.getListFilterParameter().setQFilters(Arrays.asList(id1, id2));
                break;
            }
            case "receivedept": {
                DynamicObject user;
                List deptIDs = OrgHelper.getAllToOrg((String)"15", (String)"01", (Long)((Long)receiveOrg.getPkValue()), (boolean)true);
                if (deptIDs == null || deptIDs.isEmpty()) {
                    return;
                }
                DynamicObject operator = (DynamicObject)model.getValue("receiveclerk");
                if (operator != null && (user = operator.getDynamicObject("operatorid")) != null) {
                    Long userID = (Long)user.getPkValue();
                    Long deptID = UserServiceHelper.getUserMainOrgId((long)userID);
                    deptIDs.add(deptID);
                }
                QFilter q6 = new QFilter("id", "in", (Object)deptIDs);
                showParameter.getListFilterParameter().getQFilters().add(q6);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate) {
            FormOperate operate = (FormOperate)args.getSource();
            String key = operate.getOperateKey();
            EntryGrid entryGrid = (EntryGrid)this.getControl("billentry");
            int[] selectRows = entryGrid.getSelectRows();
            switch (key) {
                case "rowclose": 
                case "rowunclose": {
                    if (selectRows == null || selectRows.length == 0) {
                        String tip = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5206\u5f55\u884c\u3002", (String)"PurReceiptNoticeBillPlugin_2", (String)"scmc-pm-formplugin", (Object[])new Object[0]);
                        this.getView().showTipNotification(tip);
                        args.setCancel(true);
                        return;
                    }
                    StringBuilder rowStr = new StringBuilder(String.valueOf(selectRows[0]));
                    for (int i = 1; i < selectRows.length; ++i) {
                        rowStr.append(',').append(String.valueOf(selectRows[i]));
                    }
                    operate.getOption().setVariableValue("selectRows", rowStr.toString());
                    break;
                }
                case "batchfillentry": {
                    Object value;
                    EntryGrid entry = (EntryGrid)this.getControl("billentry");
                    String focusField = entry.getEntryState().getFocusField();
                    int focusRow = entry.getEntryState().getFocusRow();
                    List<String> fields = Arrays.asList("discounttype", "discountrate");
                    if (focusRow <= -1 || !fields.contains(focusField) || (value = this.getModel().getValue(focusField, focusRow)) == null) break;
                    for (int i = focusRow; i < this.getModel().getEntryRowCount("billentry"); ++i) {
                        boolean isPresent = (Boolean)this.getModel().getValue("ispresent", i);
                        if (isPresent) continue;
                        this.getModel().setValue(focusField, value, i);
                    }
                    args.setCancel(true);
                    break;
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs a) {
        super.afterDoOperation(a);
        if (a.getSource() instanceof FormOperate) {
            String key;
            FormOperate operate = (FormOperate)a.getSource();
            switch (key = operate.getOperateKey()) {
                case "rowclose": 
                case "rowunclose": {
                    this.getView().updateView();
                    break;
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        int entryCount;
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("bar_save".equals(itemKey) && (entryCount = this.getModel().getEntryRowCount("billentry")) > 0) {
            ArrayList<Integer> rowIndexs = new ArrayList<Integer>(entryCount);
            for (int j = 0; j < entryCount; ++j) {
                rowIndexs.add(j);
            }
            this.setLotEnable(rowIndexs);
        }
    }

    private void changeOperator(Object newValue) {
        Long deptID = null;
        this.getModel().beginInit();
        if (newValue instanceof DynamicObject) {
            Long userID;
            DynamicObject operator = (DynamicObject)newValue;
            this.getModel().setValue("receivegroup", operator.get("operatorgrpid"));
            Long l = userID = operator.get("operatorid") != null ? (Long)((DynamicObject)operator.get("operatorid")).getPkValue() : null;
            if (userID != null) {
                deptID = UserServiceHelper.getUserMainOrgId((long)userID);
            }
        } else {
            this.getModel().setValue("receivegroup", null);
        }
        this.getModel().endInit();
        this.getModel().setValue("receivedept", deptID);
        this.getView().updateView("receivegroup");
    }

    private Long getSettleOrg(Long orgId) {
        if (orgId != null) {
            String settleOrgValue = this.getPageCache().get(orgId + "settleorg");
            if (StringUtils.isNotBlank((CharSequence)settleOrgValue)) {
                return Long.valueOf(settleOrgValue);
            }
            Map map = OrgHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            if (map != null && map.get("id") != null) {
                Long settleOrgId = (Long)map.get("id");
                this.getPageCache().put(orgId + "settleorg", settleOrgId.toString());
                return settleOrgId;
            }
        }
        return null;
    }

    private void changeEntryReqOrg(int rowIndex) {
        DynamicObject org;
        IDataModel model = this.getModel();
        String ownerType = (String)model.getValue("ownertype", rowIndex);
        if (OwnerTypeEnum.OWNERTYPE_ORG.getValue().equals(ownerType) && (org = (DynamicObject)model.getValue("org")) != null) {
            Long orgOwner = this.getOrgOwner(rowIndex);
            model.setValue("owner", (Object)orgOwner, rowIndex);
        }
    }

    private Long getOrgOwner(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject entryReqOrg = (DynamicObject)model.getValue("entryreqorg", rowIndex);
        DynamicObject entryRecOrg = (DynamicObject)model.getValue("receiveorg");
        Long ownerId = null;
        if (entryReqOrg != null && entryRecOrg != null) {
            String owner;
            Long reqOrgId = (Long)entryReqOrg.getPkValue();
            Long recOrgId = (Long)entryRecOrg.getPkValue();
            String ownerCacheKey = reqOrgId + "_" + recOrgId + "owner";
            if (reqOrgId != null && recOrgId != null && StringUtils.isNotBlank((CharSequence)(owner = this.getPageCache().get(ownerCacheKey)))) {
                return Long.valueOf(owner);
            }
            Map orgRelation = OrgHelper.getOrgRelation((Long)recOrgId, (String)"10", (String)"05", (String)"fromorg");
            List orgIds = (List)orgRelation.get("orgId");
            Long reqSettleId = this.getSettleOrg(reqOrgId);
            if (orgIds != null && orgIds.contains(reqSettleId)) {
                ownerId = reqSettleId;
            } else {
                List detailList = (List)orgRelation.get("data");
                if (detailList != null) {
                    for (Map detailMap : detailList) {
                        Boolean isDefault = (Boolean)detailMap.get("isDefault");
                        if (isDefault == null || !isDefault.booleanValue()) continue;
                        ownerId = (Long)detailMap.get("orgId");
                        break;
                    }
                }
            }
            if (ownerId != null) {
                this.getPageCache().put(ownerCacheKey, ownerId.toString());
            }
        }
        return ownerId;
    }

    private static boolean isUseLot() {
        DynamicObject systemCallParam = BusinessDataServiceHelper.loadSingleFromCache((String)"sbs_scmcapplevelparam", (String)"enable", (QFilter[])new QFilter("number", "=", (Object)"INV0003").toArray());
        return systemCallParam != null && systemCallParam.getBoolean("enable");
    }

    private void setLotReturnInfo(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject bill = model.getDataEntity();
        DynamicObject lot = (DynamicObject)model.getValue("lot", rowIndex);
        if (lot == null) {
            model.beginInit();
            model.setValue("lotnumber", null, rowIndex);
            model.endInit();
            return;
        }
        DynamicObject selectEntry = model.getEntryRowEntity("billentry", rowIndex);
        Map returnMap = (Map)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"getReturnParamMapping", (Object[])new Object[]{bill, selectEntry, DT_LOT});
        if (returnMap == null || returnMap.isEmpty()) {
            return;
        }
        model.beginInit();
        for (Map.Entry<String, String> entry : returnMap.entrySet()) {
            PurReceiptNoticeBillPlugin.setParamField(entry, model, lot, rowIndex);
        }
        model.endInit();
    }

    private static void setParamField(Map.Entry<String, String> entry, IDataModel model, Object newValue, int rowIndex) {
        String param = entry.getValue();
        String[] paramNodes = param.split("\\.");
        if (paramNodes.length > 1) {
            model.setValue(paramNodes[paramNodes.length - 1], ((DynamicObject)newValue).get(entry.getKey()), rowIndex);
        } else {
            model.setValue(entry.getValue(), ((DynamicObject)newValue).get(entry.getKey()));
        }
    }

    private void changeQty(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject baseUnit = (DynamicObject)this.getModel().getValue("baseunit", rowIndex);
        DynamicObject unit = (DynamicObject)this.getModel().getValue("unit", rowIndex);
        if (newValue instanceof BigDecimal) {
            BigDecimal qty = (BigDecimal)newValue;
            BigDecimal baseQty = BigDecimalUtil.getNotNull((Object)model.getValue("baseqty", rowIndex));
            BigDecimal receiveRateUp = BigDecimalUtil.getNotNull((Object)model.getValue("receiverateup", rowIndex));
            BigDecimal receiveRateDown = BigDecimalUtil.getNotNull((Object)model.getValue("receiveratedown", rowIndex));
            BigDecimal receiveQtyUp = this.getReceiveQtyUp(qty, receiveRateUp, unit);
            BigDecimal receiveQtyDown = this.getReceiveQtyDown(qty, receiveRateDown, unit);
            BigDecimal receiveBaseQtyUp = this.getReceiveQtyUp(baseQty, receiveRateUp, baseUnit);
            BigDecimal receiveBaseQtyDown = this.getReceiveQtyDown(baseQty, receiveRateDown, baseUnit);
            model.setValue("receiveqtyup", (Object)receiveQtyUp, rowIndex);
            model.setValue("receiveqtydown", (Object)receiveQtyDown, rowIndex);
            model.setValue("receivebaseqtyup", (Object)receiveBaseQtyUp, rowIndex);
            model.setValue("receivebaseqtydown", (Object)receiveBaseQtyDown, rowIndex);
        }
    }

    private void calcTotalAmount() {
        IDataModel model = this.getModel();
        for (Map.Entry entry : AmountHelper.calcTotalAmount((DynamicObject)model.getDataEntity(true)).entrySet()) {
            model.setValue((String)entry.getKey(), entry.getValue());
        }
    }

    private BigDecimal getReceiveQtyUp(BigDecimal qty, BigDecimal receiveRateUp, DynamicObject unit) {
        return BigDecimalUtil.getByGrowRate((BigDecimal)qty, (BigDecimal)BigDecimalUtil.div100((BigDecimal)receiveRateUp)).setScale(BillQtyAndUnitHelper.getPrecision((DynamicObject)unit), BillQtyAndUnitHelper.getUnitRoundingMode((DynamicObject)unit));
    }

    private BigDecimal getReceiveQtyDown(BigDecimal qty, BigDecimal receiveRateDown, DynamicObject unit) {
        return BigDecimalUtil.getByReduceRate((BigDecimal)qty, (BigDecimal)BigDecimalUtil.div100((BigDecimal)receiveRateDown)).setScale(BillQtyAndUnitHelper.getPrecision((DynamicObject)unit), BillQtyAndUnitHelper.getUnitRoundingMode((DynamicObject)unit));
    }

    private void setLotEnable(List<Integer> rowIndex) {
        DynamicObject masterIdDy;
        Long materialID;
        Object masterObj;
        IDataModel model = this.getModel();
        String lotEnableCache = this.getPageCache().get(LOT_ENABLE);
        Map<Long, Boolean> lotCache = new HashMap();
        if (StringUtils.isNotEmpty((CharSequence)lotEnableCache)) {
            lotCache = (Map)SerializationUtils.fromJsonString((String)lotEnableCache, Map.class);
        }
        HashSet<Long> materialIDs = new HashSet<Long>();
        for (Integer index : rowIndex) {
            masterObj = model.getValue("material", index.intValue());
            if (!(masterObj instanceof DynamicObject) || lotCache.containsKey(materialID = (Long)(masterIdDy = ((DynamicObject)masterObj).getDynamicObject("masterid")).getPkValue())) continue;
            materialIDs.add(materialID);
        }
        if (materialIDs.size() > 0) {
            Map<Long, Boolean> LotEnable = this.getLotCache(materialIDs);
            lotCache.putAll(LotEnable);
            this.getPageCache().put(LOT_ENABLE, SerializationUtils.toJsonString(lotCache));
        }
        for (Integer index : rowIndex) {
            masterObj = model.getValue("material", index.intValue());
            if (!(masterObj instanceof DynamicObject)) continue;
            masterIdDy = ((DynamicObject)masterObj).getDynamicObject("masterid");
            materialID = (Long)masterIdDy.getPkValue();
            Boolean aBoolean = (Boolean)lotCache.get(materialID);
            if (Boolean.TRUE.equals(aBoolean)) {
                this.getView().setEnable(Boolean.TRUE, index.intValue(), new String[]{"lotnumber"});
                this.getView().setEnable(Boolean.TRUE, index.intValue(), new String[]{"lot"});
                continue;
            }
            this.getView().setEnable(Boolean.FALSE, index.intValue(), new String[]{"lotnumber"});
            this.getView().setEnable(Boolean.FALSE, index.intValue(), new String[]{"lot"});
        }
    }

    private Map<Long, Boolean> getLotCache(Set<Long> materialIDs) {
        if (materialIDs == null || materialIDs.size() == 0) {
            return new HashMap<Long, Boolean>();
        }
        QFilter materialFilter = new QFilter("masterid.id", "in", materialIDs);
        QFilter statusFilter = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
        QFilter enableFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        Map result = BusinessDataServiceHelper.loadFromCache((String)"bd_materialinventoryinfo", (String)"enablelot,masterid", (QFilter[])new QFilter[]{materialFilter, statusFilter, enableFilter});
        Set entrySet = result.entrySet();
        HashMap<Long, Boolean> materialEnableLot = new HashMap<Long, Boolean>(entrySet.size());
        for (Map.Entry entry : entrySet) {
            DynamicObject materialInvInfo = (DynamicObject)entry.getValue();
            Boolean enableLot = materialInvInfo.getBoolean("enablelot");
            Long materialPK = (Long)materialInvInfo.getDynamicObject("masterid").getPkValue();
            materialEnableLot.put(materialPK, enableLot);
        }
        return materialEnableLot;
    }
}

