/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.order;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeAddRowEventArgs;
import kd.bos.entity.datamodel.events.BeforeImportDataEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.ImportDataEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.mpscmm.msbd.business.helper.AmountPlanHelper;
import kd.mpscmm.msbd.business.helper.BizTypeHelper;
import kd.mpscmm.msbd.business.helper.SysParamHelper;
import kd.mpscmm.msbd.common.context.CommonContext;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.pm.business.helper.AmountHelper;
import kd.scmc.pm.business.helper.BillImportHelper;
import kd.scmc.pm.business.helper.BillParameterHelper;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.helper.BizCategoryHelper;
import kd.scmc.pm.business.helper.CurrencyHelper;
import kd.scmc.pm.business.helper.OrgHelper;
import kd.scmc.pm.business.helper.PurOrderBillHelper;
import kd.scmc.pm.business.pojo.AmountPropertyKey;
import kd.scmc.pm.enums.ChangeTypeEnum;
import kd.scmc.pm.enums.DiscountTypeEnum;
import kd.scmc.pm.enums.EnableStatusEnum;
import kd.scmc.pm.enums.ExchangeTypeEnum;
import kd.scmc.pm.enums.OwnerTypeEnum;
import kd.scmc.pm.enums.StatusEnum;
import kd.scmc.pm.enums.UnitConvertDirEnum;
import kd.scmc.pm.formplugin.helper.ConmBillHelper;
import kd.scmc.pm.utils.CommonUtils;

public class PurOrderBillPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
RowClickEventListener,
EntryGridBindDataListener {
    private final Map<String, Object> tempCache = new HashMap<String, Object>();
    private static final Log log = LogFactory.getLog(PurOrderBillPlugin.class);
    public static final String ENTRY_ITEMNAME = "itemname";
    public static final String ENTRY_ISPRE = "ispre";
    public static final String ENTRY_AMOUNT = "amount";
    public static final String ENTRY_RATE = "rate";
    private final String ADDRESSF7 = "addressf7";
    private final String PROVIDERADDRESSF7 = "provideraddressf7";
    private final String CUR_AMTPRECISION = "amtprecision";
    private final String CUR_PRICEPRECISION = "priceprecision";
    private static final String OPERMATERCTRL = "opermaterctrl";
    private static final String CONFIRM_LINETYPE = "confirm_linetype";
    private static final String CACHE_LINETYPE = "cache_linetype";
    private static final String PRETIMEPOINT_CONM = "A";
    private static final String CONM_PURCONTRACT = "conm_purcontract";

    public void registerListener(EventObject e) {
        BasedataEdit configuredCode;
        BasedataEdit material;
        BasedataEdit priceList;
        BasedataEdit providerAddressF7;
        BasedataEdit addressF7;
        Toolbar entryToolbar;
        Toolbar deliverToolbar;
        BasedataEdit owner;
        BasedataEdit supplier;
        BasedataEdit warehouse;
        super.registerListener(e);
        EntryGrid entry = (EntryGrid)this.getControl("billentry");
        if (entry != null) {
            entry.addRowClickListener((RowClickEventListener)this);
            entry.addDataBindListener((EntryGridBindDataListener)this);
        }
        if ((warehouse = (BasedataEdit)this.getView().getControl("warehouse")) != null) {
            warehouse.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplier = (BasedataEdit)this.getView().getControl("supplier")) != null) {
            supplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((owner = (BasedataEdit)this.getView().getControl("owner")) != null) {
            owner.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((deliverToolbar = (Toolbar)this.getView().getControl("toolbar_deliver")) != null) {
            deliverToolbar.addItemClickListener((ItemClickListener)this);
        }
        if ((entryToolbar = (Toolbar)this.getView().getControl("tbmainentry")) != null) {
            entryToolbar.addItemClickListener((ItemClickListener)this);
        }
        if (this.getControl("address") != null) {
            this.addClickListeners(new String[]{"address"});
        }
        if (this.getControl("provideraddress") != null) {
            this.addClickListeners(new String[]{"provideraddress"});
        }
        if ((addressF7 = (BasedataEdit)this.getControl("addressf7")) != null) {
            addressF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((providerAddressF7 = (BasedataEdit)this.getControl("provideraddressf7")) != null) {
            providerAddressF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((priceList = (BasedataEdit)this.getControl("pricelist")) != null) {
            priceList.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((material = (BasedataEdit)this.getControl("material")) != null) {
            material.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((configuredCode = (BasedataEdit)this.getControl("configuredcode")) != null) {
            configuredCode.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addClickListeners(new String[]{"conbillnumber"});
        BasedataEdit mftsupplier = (BasedataEdit)this.getControl("mftsupplier");
        if (mftsupplier != null) {
            mftsupplier.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        String billcretype = this.getPageCache().get("billcretype");
        if (BillImportHelper.isImport((String)billcretype)) {
            return;
        }
        if (BillImportHelper.isSkip((String)billcretype)) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            return;
        }
        Long orgId = (Long)org.getPkValue();
        int entryCount = model.getEntryRowCount("billentry");
        if (entryCount > 0) {
            DynamicObject supplier = (DynamicObject)model.getValue("supplier");
            Long supplierId = supplier == null ? null : (Long)supplier.getPkValue();
            for (int i = 0; i < entryCount; ++i) {
                this.initOwner(orgId, supplierId, i);
            }
        }
        this.setAllPreTimePoint();
    }

    public void beforeBindData(EventObject e) {
        DynamicObject bizType;
        String entity;
        super.beforeBindData(e);
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("purbillentry_pay");
        if (entryGrid != null) {
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
        if ("pm_purorderbill".equals(entity = this.getModel().getDataEntityType().getName())) {
            Boolean isEnableXSPurOrderBill = BillParameterHelper.getIsEnableXSPurOrderBill();
            if (isEnableXSPurOrderBill != null && isEnableXSPurOrderBill.booleanValue()) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_change"});
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_bizchange", "bar_bizchangelog", "bar_bizchangeresume"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"bar_change"});
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_bizchange", "bar_bizchangelog", "bar_bizchangeresume"});
            }
        }
        if ((bizType = (DynamicObject)this.getModel().getValue("biztype")) != null && BizCategoryHelper.isCredit((Long)((Long)bizType.getPkValue()))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"paymode"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"paymode"});
        }
    }

    public void afterBindData(EventObject e) {
        if (!"1".equals(this.getPageCache().get("inputamount"))) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"inputamount"});
        }
        this.setAllPreTimePoint();
        DynamicObjectCollection payentrys = (DynamicObjectCollection)this.getModel().getValue("purbillentry_pay");
        for (int i = 0; i < payentrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)payentrys.get(i);
            if (entry == null) continue;
            Boolean isprepay = entry.getBoolean("isprepay");
            String paysrcbillentity = entry.getString("paysrcbillentity");
            String pretimepoint = entry.getString("pretimepoint");
            if (!isprepay.booleanValue() || !PRETIMEPOINT_CONM.equals(pretimepoint) || !CONM_PURCONTRACT.equals(paysrcbillentity)) continue;
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"payrate"});
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"payamount"});
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"isprepay"});
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"pretimepoint"});
        }
    }

    public void beforeAddRow(BeforeAddRowEventArgs e) {
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        block11: {
            String entryName;
            RowDataEntity[] rowDataEntities;
            block12: {
                block10: {
                    super.afterAddRow(e);
                    rowDataEntities = e.getRowDataEntities();
                    if (rowDataEntities == null || rowDataEntities.length < 1) {
                        return;
                    }
                    DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                    if (org == null) {
                        return;
                    }
                    Long orgId = (Long)org.getPkValue();
                    entryName = e.getEntryProp().getName();
                    if (!"billentry".equals(entryName)) break block10;
                    DynamicObject supplier = (DynamicObject)this.getModel().getValue("supplier");
                    Long supplierId = supplier == null ? null : (Long)supplier.getPkValue();
                    for (RowDataEntity rowDataEntity : rowDataEntities) {
                        int rowIndex = rowDataEntity.getRowIndex();
                        this.initOwner(orgId, supplierId, rowIndex);
                    }
                    break block11;
                }
                if (!"purbillentry_deliver".equals(entryName)) break block12;
                AbstractGrid entry = (AbstractGrid)this.getControl("billentry");
                int focusRow = entry.getEntryState().getFocusRow();
                if (focusRow <= -1) break block11;
                IDataModel model = this.getModel();
                DynamicObject unit = (DynamicObject)model.getValue("unit", focusRow);
                BigDecimal qty = BigDecimalUtil.getNotNull((Object)model.getValue("qty", focusRow));
                if (unit != null) {
                    for (RowDataEntity rowDataEntity : rowDataEntities) {
                        int rowIndex = rowDataEntity.getRowIndex();
                        int entryRowCount = model.getEntryRowCount("purbillentry_deliver");
                        for (int i = 0; i < entryRowCount - 1; ++i) {
                            if (rowIndex <= i) continue;
                            String changeType = (String)model.getValue("delentrychangetype", i);
                            if (ChangeTypeEnum.CANCEL.getValue().equals(changeType)) continue;
                            BigDecimal plantQty = BigDecimalUtil.getNotNull((Object)model.getValue("planqty", i));
                            qty = qty.subtract(plantQty);
                        }
                        model.setValue("planunit", unit.getPkValue(), rowIndex);
                        if (BigDecimalUtil.lessThan((BigDecimal)qty, (BigDecimal)BigDecimalUtil.ZERO)) {
                            qty = BigDecimalUtil.ZERO;
                        }
                        model.setValue("planqty", (Object)qty, rowIndex);
                        model.updateCache();
                    }
                }
                break block11;
            }
            if ("purbillentry_pay".equals(entryName)) {
                AmountPlanHelper.calAmountPlanForView((CommonContext)PurOrderBillHelper.getPayPlanCommonText((String)this.getView().getEntityId()), (IFormView)this.getView());
                if (rowDataEntities != null && rowDataEntities.length > 0) {
                    for (RowDataEntity rowDataEntity : rowDataEntities) {
                        int rowIndex = rowDataEntity.getRowIndex();
                        Boolean isprepay = (Boolean)this.getModel().getValue("isprepay", rowIndex);
                        this.setPreTimePointEnable(isprepay, rowIndex);
                        this.setPreTimePointValue(isprepay, rowIndex);
                    }
                }
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        if ("purbillentry_pay".equals(entryName)) {
            AmountPlanHelper.calAmountPlanForView((CommonContext)PurOrderBillHelper.getPayPlanCommonText((String)this.getView().getEntityId()), (IFormView)this.getView());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        String stopChange = this.getPageCache().get("stopChange");
        if ("true".equals(stopChange)) {
            return;
        }
        String billcretype = this.getPageCache().get("billcretype");
        if (BillImportHelper.isImport((String)billcretype)) {
            return;
        }
        if (BillImportHelper.isSkip((String)billcretype)) {
            return;
        }
        String fieldKey = e.getProperty().getName();
        block53: for (ChangeData changeData : changeSet = e.getChangeSet()) {
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            int rowIndex = changeData.getRowIndex();
            if (newValue == null && oldValue == null) {
                return;
            }
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                return;
            }
            if (!"totalallamount".equals(fieldKey) && oldValue instanceof BigDecimal && newValue instanceof BigDecimal && BigDecimalUtil.equals((BigDecimal)((BigDecimal)oldValue), (BigDecimal)((BigDecimal)newValue))) {
                return;
            }
            switch (fieldKey) {
                case "totalallamount": {
                    this.changeTotalAllAmount(newValue);
                    continue block53;
                }
                case "paycondition": {
                    this.changePayCondition(newValue);
                    continue block53;
                }
                case "payrate": {
                    this.changePayRate(newValue, rowIndex);
                    continue block53;
                }
                case "payamount": {
                    this.changePayAmount(newValue, rowIndex);
                    continue block53;
                }
                case "entryrecorg": {
                    this.changeEntryRecOrg(rowIndex);
                }
                case "entryreqorg": {
                    this.changeEntryReqOrg(rowIndex);
                    continue block53;
                }
                case "supplier": {
                    this.changeSupplier(newValue);
                    continue block53;
                }
                case "material": {
                    this.changeMaterial(oldValue, newValue, rowIndex);
                    this.changeDeliverUnit(rowIndex, true);
                    continue block53;
                }
                case "qty": {
                    this.changeQty(newValue, rowIndex);
                    continue block53;
                }
                case "unit": {
                    this.changeUnit(rowIndex);
                    this.changeDeliverUnit(rowIndex, false);
                    continue block53;
                }
                case "auxqty": {
                    this.changeAuxQty(newValue, rowIndex);
                    continue block53;
                }
                case "price": 
                case "priceandtax": {
                    boolean isPresent = (Boolean)this.getModel().getValue("ispresent", rowIndex);
                    if (!isPresent) continue block53;
                    BigDecimal price = (BigDecimal)newValue;
                    if (BigDecimalUtil.isZero((BigDecimal)price)) {
                        this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), rowIndex);
                        this.getModel().setValue("discountrate", (Object)BigDecimal.ZERO, rowIndex);
                        continue block53;
                    }
                    this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue(), rowIndex);
                    this.getModel().setValue("discountrate", (Object)new BigDecimal(100), rowIndex);
                    continue block53;
                }
                case "ispresent": {
                    this.getPageCache().put("ispresent", "true");
                    for (int i = 0; i < changeSet.length; ++i) {
                        int index = changeSet[i].getRowIndex();
                        this.changeIsPresent(newValue, index);
                    }
                    this.calcAllAmount();
                    this.getPageCache().remove("ispresent");
                    continue block53;
                }
                case "iscontrolqty": {
                    this.changeIsControlQty(newValue, rowIndex);
                    continue block53;
                }
                case "iscontrolday": {
                    this.changeIsControlDay(newValue, rowIndex);
                    continue block53;
                }
                case "iscontrolamountup": {
                    this.changeIsControlAmount(newValue, rowIndex);
                    continue block53;
                }
                case "receiverateup": {
                    this.changeReceiveRateUp(newValue, rowIndex);
                    continue block53;
                }
                case "receiveratedown": {
                    this.changeIsReceiveRateDown(newValue, rowIndex);
                    continue block53;
                }
                case "addressf7": {
                    DynamicObject addressF7 = (DynamicObject)changeSet[0].getNewValue();
                    this.getModel().setValue("address", (Object)addressF7.getString("detailaddress"));
                    continue block53;
                }
                case "provideraddressf7": {
                    DynamicObject providerAddressF7 = (DynamicObject)changeSet[0].getNewValue();
                    this.getModel().setValue("provideraddress", (Object)providerAddressF7.getString("detailaddress"));
                    continue block53;
                }
                case "settlecurrency": {
                    this.changeSettleCurrency(oldValue, newValue);
                    continue block53;
                }
                case "linetype": {
                    String entityId = this.getView().getEntityId();
                    if ("pm_xpurorderbill".equals(entityId) || "pm_xspurorderbill".equals(entityId)) continue block53;
                    this.changeLineType(oldValue, newValue, rowIndex);
                    continue block53;
                }
                case "isprepay": {
                    if (newValue == null) continue block53;
                    Boolean isprepay = (Boolean)newValue;
                    this.setPreTimePointEnable(isprepay, rowIndex);
                    this.setPreTimePointValue(isprepay, rowIndex);
                    continue block53;
                }
                case "mftdirect": {
                    Boolean mftdirect;
                    if (newValue == null || (mftdirect = (Boolean)newValue).booleanValue()) continue block53;
                    this.getModel().setValue("mftsupplier", null, rowIndex);
                    continue block53;
                }
            }
        }
    }

    private void changeLineType(Object oldValue, Object newValue, int rowIndex) {
        if (oldValue != null && newValue == null) {
            this.getPageCache().put("stopChange", "true");
            this.getModel().setValue("linetype", ((DynamicObject)oldValue).getPkValue(), rowIndex);
            this.getPageCache().put("stopChange", "false");
            return;
        }
        Long srcBillId = (Long)this.getModel().getValue("srcbillid", rowIndex);
        Long srcBillEntryId = (Long)this.getModel().getValue("srcbillentryid", rowIndex);
        if (srcBillId != null && !srcBillId.equals(0L) || srcBillEntryId != null && !srcBillEntryId.equals(0L)) {
            return;
        }
        ConfirmCallBackListener callBack = new ConfirmCallBackListener(CONFIRM_LINETYPE, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u201c\u884c\u7c7b\u578b\u201d\u5c06\u6e05\u9664\u5f53\u524d\u5206\u5f55\u7269\u6599\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"PurOrderBillPlugin_37", (String)"scmc-pm-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, callBack, null, String.valueOf(rowIndex));
        this.getView().getPageCache().put(CACHE_LINETYPE, oldValue == null ? null : ((DynamicObject)oldValue).getPkValue().toString());
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        int row = e.getRow();
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (!"org".equals(fieldKey) && org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"BillTplPlugin_25", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        DynamicObject supplier = (DynamicObject)model.getValue("supplier");
        DynamicObject providerSupplier = (DynamicObject)model.getValue("providersupplier");
        DynamicObject entryRecOrg = (DynamicObject)model.getValue("entryrecorg", row);
        switch (fieldKey) {
            case "supplier": {
                showParameter.getListFilterParameter().getQFilters().add(new QFilter("purchasehold", "=", (Object)Boolean.FALSE));
                break;
            }
            case "warehouse": {
                if (entryRecOrg != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6536\u8d27\u7ec4\u7ec7\u3002", (String)"PurOrderBillPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            case "owner": {
                QFilter filter;
                Map orgRelation;
                String ownerType = (String)model.getValue("ownertype", row);
                if (!OwnerTypeEnum.OWNERTYPE_ORG.getValue().equals(ownerType)) break;
                List<Long> orgIds = new ArrayList<Long>();
                Long recOrgId = null;
                if (entryRecOrg != null && (orgRelation = OrgHelper.getOrgRelation((Long)(recOrgId = (Long)entryRecOrg.getPkValue()), (String)"10", (String)"05", (String)"fromorg")) != null && orgRelation.get("orgId") != null) {
                    orgIds = (List)orgRelation.get("orgId");
                }
                if (orgIds == null || orgIds.isEmpty()) {
                    filter = new QFilter("fisaccounting", "=", (Object)Boolean.TRUE);
                } else {
                    Long recSettleOrg;
                    if (recOrgId != null && recOrgId.equals(recSettleOrg = this.getSettleOrg(recOrgId))) {
                        orgIds.add(recOrgId);
                    }
                    filter = new QFilter("id", "in", orgIds);
                }
                showParameter.getListFilterParameter().getQFilters().add(filter);
                break;
            }
            case "addressf7": {
                if (supplier == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u8d27\u4f9b\u5e94\u5546\u3002", (String)"PurOrderBillPlugin_29", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                QFilter id1 = new QFilter("supplierid", "in", (Object)supplier.getPkValue().toString());
                QFilter id2 = new QFilter("invalid", "=", (Object)Boolean.FALSE);
                showParameter.getListFilterParameter().setQFilters(Arrays.asList(id1, id2));
                break;
            }
            case "provideraddressf7": {
                if (providerSupplier == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f9b\u8d27\u4f9b\u5e94\u5546\u3002", (String)"PurOrderBillPlugin_28", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                QFilter id1 = new QFilter("supplierid", "in", (Object)providerSupplier.getPkValue().toString());
                QFilter id2 = new QFilter("invalid", "=", (Object)Boolean.FALSE);
                showParameter.getListFilterParameter().setQFilters(Arrays.asList(id1, id2));
                break;
            }
            case "pricelist": {
                QFilter q6;
                Date bizTime;
                QFilter q5;
                Long[] supplierIds;
                QFilter q4;
                QFilter q3;
                QFilter q2;
                if (supplier == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u8d27\u4f9b\u5e94\u5546\u3002", (String)"PurOrderBillPlugin_29", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                QFilter q1 = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
                Map loadFromCache = BusinessDataServiceHelper.loadFromCache((String)"pm_purpricelist", (String)"id,org,supplierid", (QFilter[])new QFilter[]{q1, q2 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()), q3 = new QFilter("org", "=", org.getPkValue()), q4 = new QFilter("supplierid", "in", (Object)(supplierIds = new Long[]{(Long)supplier.getPkValue(), 0L})), q5 = new QFilter("priceentryentity.priceeffectdate", "<=", (Object)(bizTime = (Date)model.getValue("biztime"))), q6 = new QFilter("priceentryentity.priceexpirydate", ">=", (Object)bizTime)});
                if (loadFromCache == null) break;
                QFilter q = new QFilter("id", "in", loadFromCache.keySet());
                showParameter.getListFilterParameter().getQFilters().add(q);
                break;
            }
            case "material": {
                QFilter allowMaterialQFilter;
                Boolean operMatControl = (Boolean)SysParamHelper.getSysParam4pm((Long)((Long)org.getPkValue()), (String)OPERMATERCTRL);
                if (!Boolean.TRUE.equals(operMatControl) || (allowMaterialQFilter = (QFilter)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msbd", (String)"DataCtrlService", (String)"getQfilter", (Object[])new Object[]{this.getModel().getDataEntity(false), "pm_purorderbill", "billentry.material.masterid"})) == null) break;
                showParameter.getListFilterParameter().getQFilters().add(allowMaterialQFilter);
                break;
            }
            case "configuredcode": {
                DynamicObject material = (DynamicObject)this.getModel().getValue("material", row);
                if (material != null && material.getDynamicObject("masterid") != null) {
                    QFilter qFilter = new QFilter("material", "=", material.getDynamicObject("masterid").getPkValue());
                    showParameter.getListFilterParameter().getQFilters().add(qFilter);
                    break;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u4fe1\u606f\u3002", (String)"PurOrderBillPlugin_35", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        DynamicObject org;
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey();
        if ((key.equals("provideraddress") || key.equals("address") || key.equals("conbillnumber")) && (org = (DynamicObject)this.getModel().getValue("org")) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurOrderBillPlugin_5", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            return;
        }
        if (key.equalsIgnoreCase("provideraddress")) {
            BasedataEdit providerAddressF7 = (BasedataEdit)this.getControl("provideraddressf7");
            providerAddressF7.click();
        } else if (c.getKey().equalsIgnoreCase("address")) {
            BasedataEdit addressF7 = (BasedataEdit)this.getControl("addressf7");
            addressF7.click();
        } else if (c.getKey().equalsIgnoreCase("conbillnumber")) {
            this.showCoreBillF7();
        }
    }

    private void showCoreBillF7() {
        int currrow = this.getModel().getEntryCurrentRowIndex("billentry");
        String billtype = "conm_purcontractf7_1";
        ConmBillHelper.showConmBillF7(billtype, this.getView(), this.getPluginName(), currrow);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String entity;
        super.beforeDoOperation(e);
        FormOperate operate = (FormOperate)e.getSource();
        String operateKey = operate.getOperateKey();
        IDataModel model = this.getModel();
        OperateOption option = operate.getOption();
        if ("gainprice".equals(operateKey)) {
            if (this.isBackCalculate()) {
                return;
            }
            this.getPageCache().put("gainprice", "1");
            DynamicObject org = (DynamicObject)model.getValue("org");
            if (org == null) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurOrderBillPlugin_5", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if ("batchfillentry".equals(operateKey)) {
            Object value;
            EntryGrid entry = (EntryGrid)this.getControl("billentry");
            String focusField = entry.getEntryState().getFocusField();
            int focusRow = entry.getEntryState().getFocusRow();
            Object fields = Arrays.asList("discounttype", "discountrate");
            if (focusRow > -1 && fields.contains(focusField) && (value = this.getModel().getValue(focusField, focusRow)) != null) {
                for (int i = focusRow; i < this.getModel().getEntryRowCount("billentry"); ++i) {
                    boolean isPresent = (Boolean)this.getModel().getValue("ispresent", i);
                    if (isPresent) continue;
                    this.getModel().setValue(focusField, value, i);
                }
                e.setCancel(true);
            }
        }
        if ("pm_purorderbill".equals(entity = this.getModel().getDataEntityType().getName()) && "deleteentry_pay".equals(operateKey)) {
            EntryGrid entry = (EntryGrid)this.getControl("purbillentry_pay");
            int[] selectRows = entry.getEntryState().getSelectedRows();
            for (int row : selectRows) {
                String preTimePoint = (String)this.getModel().getValue("pretimepoint", row);
                String paysrcbillentity = (String)this.getModel().getValue("paysrcbillentity", row);
                if (StringUtils.isEmpty((CharSequence)preTimePoint) || !PRETIMEPOINT_CONM.equals(preTimePoint) || StringUtils.isEmpty((CharSequence)paysrcbillentity) || !CONM_PURCONTRACT.equals(paysrcbillentity)) continue;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u9884\u4ed8\u65f6\u70b9\u4e3a\u91c7\u8d2d\u5408\u540c\u4e0d\u80fd\u5220\u884c\u3002", (String)"PurOrderBillPlugin_38", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
        if ("payaccordsetting".equals(operateKey)) {
            DynamicObject bill = this.getModel().getDataEntity();
            Object pkValue = bill.getPkValue();
            boolean isFromDataBase = bill.getDataEntityState().getFromDatabase();
            boolean dataChanged = this.getModel().getDataChanged();
            if (pkValue == null || pkValue.equals(0L) || !isFromDataBase || dataChanged) {
                e.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4fdd\u5b58\u6216\u5237\u65b0\u5355\u636e\u3002", (String)"PurOrderBillPlugin_41", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!"true".equals(option.getVariableValue("payaccordsetting", ""))) {
                boolean isOverPay = (Boolean)this.getModel().getValue("isallowoverpay");
                String billNo = (String)this.getModel().getValue("billno");
                String msg = isOverPay ? String.format(ResManager.loadKDString((String)"%1$s\u5355\u636e\u201c\u6309\u5c65\u7ea6\u652f\u4ed8\u201d\u5c06\u7531\u201c\u662f\u201d\u66f4\u6539\u4e3a\u201c\u5426\u201d\uff0c\u4e25\u683c\u63a7\u5236\u4ed8\u6b3e\u91d1\u989d\u4e0d\u5141\u8bb8\u8d85\u8fc7\u5355\u636e\u4ef7\u7a0e\u5408\u8ba1\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PurOrderBillPlugin_39", (String)"scmc-pm-formplugin", (Object[])new Object[0]), billNo) : String.format(ResManager.loadKDString((String)"%1$s\u5355\u636e\u201c\u6309\u5c65\u7ea6\u652f\u4ed8\u201d\u5c06\u7531\u201c\u5426\u201d\u66f4\u6539\u4e3a\u201c\u662f\u201d\uff0c\u5141\u8bb8\u4ed8\u6b3e\u91d1\u989d\u8d85\u8fc7\u5355\u636e\u4ef7\u7a0e\u5408\u8ba1\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PurOrderBillPlugin_40", (String)"scmc-pm-formplugin", (Object[])new Object[0]), billNo);
                ConfirmCallBackListener listener = new ConfirmCallBackListener("payaccordsetting", (IFormPlugin)this);
                this.getView().showConfirm(msg, MessageBoxOptions.YesNo, ConfirmTypes.Default, listener);
                e.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        String operateKey = e.getOperateKey();
        if ("gainprice".equals(operateKey)) {
            this.getPageCache().put("gainprice", "0");
            DynamicObject bill = this.getModel().getDataEntity(true);
            DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("billentry");
            for (int i = 0; i < billEntry.size(); ++i) {
                DynamicObject entry = (DynamicObject)billEntry.get(i);
                DynamicObject taxRate = entry.getDynamicObject("taxrateid");
                BigDecimal taxRateValue = taxRate != null ? taxRate.getBigDecimal("taxrate") : BigDecimalUtil.ZERO;
                entry.set("taxrate", (Object)taxRateValue);
            }
            this.gainPriceChangeIsPresent(bill);
        } else if ("payaccordsetting".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
        } else if ("save".equals(operateKey) || "unsubmit".equals(operateKey) || "unaudit".equals(operateKey)) {
            int entryCount = this.getModel().getEntryRowCount("purbillentry_pay");
            for (int i = 0; i < entryCount; ++i) {
                Boolean isprepay = (Boolean)this.getModel().getValue("isprepay", i);
                String pretimepoint = (String)this.getModel().getValue("pretimepoint", i);
                String paysrcbillentity = (String)this.getModel().getValue("paysrcbillentity", i);
                this.setPreTimePointEnable(isprepay, i);
                if (!CONM_PURCONTRACT.equals(paysrcbillentity) || !isprepay.booleanValue() || !PRETIMEPOINT_CONM.equals(pretimepoint)) continue;
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"payrate"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"payamount"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"isprepay"});
                this.getView().setEnable(Boolean.FALSE, i, new String[]{"pretimepoint"});
            }
        }
    }

    private void gainPriceChangeIsPresent(DynamicObject bill) {
        bill = this.getModel().getDataEntity(true);
        boolean isTax = bill.getBoolean("istax");
        DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("billentry");
        for (int i = 0; i < billEntry.size(); ++i) {
            DynamicObject entry = (DynamicObject)billEntry.get(i);
            BigDecimal price = entry.getBigDecimal("price");
            boolean isPresent = entry.getBoolean("ispresent");
            BigDecimal priceAndTax = entry.getBigDecimal("priceandtax");
            if (!isPresent) continue;
            if (isTax) {
                if (BigDecimalUtil.isZero((BigDecimal)priceAndTax)) {
                    entry.set("discounttype", (Object)DiscountTypeEnum.NULL.getValue());
                    entry.set("discountrate", (Object)BigDecimal.ZERO);
                    continue;
                }
                entry.set("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue());
                entry.set("discountrate", (Object)new BigDecimal(100));
                continue;
            }
            if (BigDecimalUtil.isZero((BigDecimal)price)) {
                entry.set("discounttype", (Object)DiscountTypeEnum.NULL.getValue());
                entry.set("discountrate", (Object)BigDecimal.ZERO);
                continue;
            }
            entry.set("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue());
            entry.set("discountrate", (Object)new BigDecimal(100));
        }
        this.calcAllAmount();
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        String itemKey = e.getItemKey();
        if ("gendeliverplan".equals(itemKey)) {
            int[] selectRows = ((EntryGrid)this.getControl("billentry")).getSelectRows();
            if (selectRows == null || selectRows.length < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u660e\u7ec6\u3002", (String)"PurOrderBillPlugin_20", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                return;
            }
            IDataModel model = this.getModel();
            DynamicObject dataEntity = model.getDataEntity(true);
            DynamicObjectCollection billentrys = dataEntity.getDynamicObjectCollection("billentry");
            boolean hasNullValue = false;
            ArrayList<Integer> rowIndexList = new ArrayList<Integer>(16);
            for (int i = 0; i < selectRows.length; ++i) {
                int rowIndex = selectRows[i];
                DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
                BigDecimal qty = (BigDecimal)model.getValue("qty", rowIndex);
                Date deliverDate = (Date)model.getValue("deliverdate", rowIndex);
                if (unit != null && !BigDecimalUtil.isBlank((BigDecimal)qty) && deliverDate != null) continue;
                rowIndexList.add(rowIndex + 1);
                hasNullValue = true;
            }
            if (hasNullValue && rowIndexList.size() > 0) {
                String rowIndexStr = ((Object)rowIndexList).toString().replaceAll("\\[|\\]", "");
                rowIndexStr = rowIndexStr.replaceAll("\\,", "\u3001").replaceAll(" ", "");
                String tip = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u7684\u7269\u6599\u7f16\u7801\u3001\u8ba1\u91cf\u5355\u4f4d\u3001\u6570\u91cf\u548c\u4ea4\u8d27\u65e5\u671f\u5b58\u5728\u7a7a\u503c\u3002", (String)"PurOrderBillPlugin_21", (String)"scmc-pm-formplugin", (Object[])new Object[0]), rowIndexStr);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801\u3001\u8ba1\u91cf\u5355\u4f4d\u3001\u6570\u91cf\u548c\u4ea4\u8d27\u65e5\u671f\u5b58\u5728\u7a7a\u503c\u3002", (String)"PurOrderBillPlugin_23", (String)"scmc-pm-formplugin", (Object[])new Object[0]), tip, MessageBoxOptions.OK, ConfirmTypes.Default, null);
                return;
            }
            boolean deliverEntryisNotEmpty = false;
            for (int i = 0; i < selectRows.length; ++i) {
                int rowIndex = selectRows[i];
                DynamicObject billentry = (DynamicObject)billentrys.get(rowIndex);
                DynamicObjectCollection deliverEntry = billentry.getDynamicObjectCollection("purbillentry_deliver");
                if (deliverEntry == null || deliverEntry.size() <= 0) continue;
                deliverEntryisNotEmpty = true;
                rowIndexList.add(rowIndex + 1);
            }
            if (deliverEntryisNotEmpty && rowIndexList.size() > 0) {
                String rowIndexStr = ((Object)rowIndexList).toString().replaceAll("\\[|\\]", "");
                rowIndexStr = rowIndexStr.replaceAll("\\,", "\u3001").replaceAll(" ", "");
                String tip = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c%1$s\u884c\u5df2\u5b58\u5728\u4ea4\u8d27\u8ba1\u5212\u3002", (String)"PurOrderBillPlugin_24", (String)"scmc-pm-formplugin", (Object[])new Object[0]), rowIndexStr);
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(itemKey, (IFormPlugin)this);
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5206\u5f55\u884c\u7269\u6599\u5df2\u7ecf\u5b58\u5728\u4ea4\u8d27\u8ba1\u5212\uff0c\u662f\u5426\u91cd\u65b0\u751f\u6210\uff1f", (String)"PurOrderBillPlugin_25", (String)"scmc-pm-formplugin", (Object[])new Object[0]), tip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                return;
            }
            this.generateDeliverPlan();
        }
        if ("bar_logistics".equals(itemKey)) {
            Long orderId = (Long)this.getModel().getValue("id");
            BillShowParameter fsp = new BillShowParameter();
            fsp.setFormId("pm_logisticsinfo");
            QFilter filter = new QFilter("id", "=", (Object)orderId);
            DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)"pm_logisticsinfo", (String)"id", (QFilter[])new QFilter[]{filter});
            if (object == null) {
                fsp.setStatus(OperationStatus.ADDNEW);
                fsp.setCustomParam("id", (Object)orderId);
                fsp.setCustomParam("billno", this.getModel().getValue("billno"));
            } else {
                fsp.setStatus(OperationStatus.EDIT);
                fsp.setPkId(object.getPkValue());
            }
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm((FormShowParameter)fsp);
        }
        if ("biz_billexecquery".equals(itemKey)) {
            this.showBillExecForm();
        }
        if ("biz_hispricequery".equals(itemKey)) {
            this.showHistoryPriceForm();
        }
    }

    public void beforeImportData(BeforeImportDataEventArgs e) {
        super.beforeImportData(e);
        String billcretype = this.getPageCache().get("billcretype");
        if (!BillImportHelper.isImport((String)billcretype) && !BillImportHelper.isAPI((String)billcretype)) {
            return;
        }
        Map materialMap = BillImportHelper.format4ImportAndApi(e.getSourceData().get("billentry"));
        if (materialMap != null) {
            List billentrys = (List)materialMap.get("sourceData");
            ArrayList<String> errLists = new ArrayList<String>();
            if (billentrys == null) {
                return;
            }
            for (int i = 0; i < billentrys.size(); ++i) {
                Map entry = (Map)billentrys.get(i);
                if (entry == null || entry.get("mftdirect") == null) continue;
                Boolean mftdirect = (Boolean)entry.get("mftdirect");
                if (mftdirect != null && mftdirect.booleanValue() && entry.get("mftsupplier") == null) {
                    errLists.add(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u59d4\u5916\u76f4\u9001\u4e3a\u662f\uff0c\u8bf7\u586b\u5199\u59d4\u5916\u52a0\u5de5\u5546\u3002", (String)"PurOrderBillPlugin_26", (String)"scmc-pm-formplugin", (Object[])new Object[0]), i + 1));
                }
                if (mftdirect == null || mftdirect.booleanValue() || entry.get("mftsupplier") == null) continue;
                errLists.add(String.format(ResManager.loadKDString((String)"\u7b2c\u201c%1$s\u201d\u884c\u59d4\u5916\u76f4\u9001\u4e3a\u5426\uff0c\u59d4\u5916\u52a0\u5de5\u5546\u5e94\u4e3a\u7a7a\u3002", (String)"PurOrderBillPlugin_27", (String)"scmc-pm-formplugin", (Object[])new Object[0]), i + 1));
            }
            if (errLists != null && errLists.size() > 0) {
                e.setCancel(true);
                e.setCancelMessages(Integer.valueOf(0), Integer.valueOf(0), errLists);
                e.setFireAfterImportData(false);
                return;
            }
        }
    }

    public void afterImportData(ImportDataEventArgs e) {
        IDataModel model = this.getModel();
        String billcretype = this.getPageCache().get("billcretype");
        if (BillImportHelper.isImport((String)billcretype)) {
            Long lineTypeId;
            DynamicObject billType = (DynamicObject)model.getValue("billtype");
            DynamicObject bizType = (DynamicObject)model.getValue("biztype");
            if (billType != null && bizType == null) {
                Long bizTypeId = (Long)this.tempCache.get(billType.getPkValue() + "-biztype");
                if (bizTypeId == null && (bizTypeId = BizTypeHelper.getDefaultBizType((String)"pm_purorderbill", (Long)((Long)billType.getPkValue()), (String)"pm_billtypeparameter")) != null) {
                    this.tempCache.put(billType.getPkValue() + "-biztype", bizTypeId);
                }
                if (bizTypeId != null) {
                    model.setValue("biztype", (Object)bizTypeId);
                }
            }
            DynamicObject defaultLineType = null;
            bizType = (DynamicObject)model.getValue("biztype");
            if (bizType != null && (lineTypeId = BizTypeHelper.getDefaultLineType((Long)((Long)bizType.getPkValue()))) != null) {
                defaultLineType = BusinessDataServiceHelper.loadSingleFromCache((Object)lineTypeId, (String)"bd_linetype");
            }
            DynamicObjectCollection billentrys = (DynamicObjectCollection)model.getValue("billentry");
            DynamicObject org = (DynamicObject)model.getValue("org");
            if (org == null) {
                return;
            }
            Calendar instance = Calendar.getInstance();
            instance.set(11, 0);
            instance.set(12, 0);
            instance.set(13, 0);
            instance.set(14, 0);
            Date time = instance.getTime();
            Date biztime = (Date)model.getValue("biztime");
            Map totalAmountMap = null;
            if (billentrys != null) {
                for (int i = 0; i < billentrys.size(); ++i) {
                    Date deliverdate;
                    DynamicObject billentry = (DynamicObject)billentrys.get(i);
                    DynamicObject unit = billentry.getDynamicObject("unit");
                    DynamicObject owner = billentry.getDynamicObject("owner");
                    DynamicObject lineType = billentry.getDynamicObject("linetype");
                    if (lineType == null && defaultLineType != null) {
                        billentry.set("linetype", (Object)defaultLineType);
                    }
                    if (bizType != null) {
                        if (BizCategoryHelper.isVMI((Long)((Long)bizType.getPkValue()))) {
                            model.setValue("ownertype", (Object)OwnerTypeEnum.OWNERTYPE_SUPPLIER.getValue(), i);
                            model.setValue("owner", model.getValue("supplier"), i);
                        } else {
                            model.setValue("ownertype", (Object)OwnerTypeEnum.OWNERTYPE_ORG.getValue(), i);
                            if (owner == null) {
                                model.setValue("owner", (Object)this.getOrgOwner(i), i);
                            }
                        }
                    }
                    if ((deliverdate = (Date)billentry.get("deliverdate")) == null) {
                        billentry.set("deliverdate", (Object)biztime);
                    }
                    BigDecimal qty = billentry.getBigDecimal("qty");
                    BigDecimal baseQty = billentry.getBigDecimal("baseqty");
                    Boolean isControlQty = (Boolean)billentry.get("iscontrolqty");
                    DynamicObject baseUnit = billentry.getDynamicObject("baseunit");
                    if (isControlQty.booleanValue()) {
                        BigDecimal receiveRateUp = billentry.getBigDecimal("receiverateup");
                        BigDecimal receiveRateDown = billentry.getBigDecimal("receiveratedown");
                        if (receiveRateUp != null && receiveRateDown != null) {
                            BigDecimal receiveQtyUp = this.getReceiveQtyUp(qty, receiveRateUp, unit);
                            BigDecimal receiveQtyDown = this.getReceiveQtyDown(qty, receiveRateDown, unit);
                            BigDecimal receiveBaseQtyUp = this.getReceiveQtyUp(baseQty, receiveRateUp, baseUnit);
                            BigDecimal receiveBaseQtyDown = this.getReceiveQtyDown(baseQty, receiveRateDown, baseUnit);
                            billentry.set("iscontrolqty", (Object)Boolean.TRUE);
                            billentry.set("receiverateup", (Object)receiveRateUp);
                            billentry.set("receiveratedown", (Object)receiveRateDown);
                            billentry.set("receiveqtyup", (Object)receiveQtyUp);
                            billentry.set("receiveqtydown", (Object)receiveQtyDown);
                            billentry.set("receivebaseqtyup", (Object)receiveBaseQtyUp);
                            billentry.set("receivebaseqtydown", (Object)receiveBaseQtyDown);
                        }
                    } else {
                        billentry.set("receiverateup", (Object)BigDecimalUtil.ZERO);
                        billentry.set("receiveratedown", (Object)BigDecimalUtil.ZERO);
                        billentry.set("receiveqtyup", (Object)qty);
                        billentry.set("receiveqtydown", (Object)qty);
                        billentry.set("receivebaseqtyup", (Object)baseQty);
                        billentry.set("receivebaseqtydown", (Object)baseQty);
                    }
                    boolean isPresent = (Boolean)billentry.get("ispresent");
                    boolean isTax = (Boolean)this.getModel().getValue("istax");
                    if (!isPresent) continue;
                    if (isTax) {
                        BigDecimal priceAndTax = billentry.getBigDecimal("priceandtax");
                        if (priceAndTax.compareTo(BigDecimal.ZERO) > 0) {
                            billentry.set("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue());
                            billentry.set("discountrate", (Object)new BigDecimal("100"));
                        } else {
                            billentry.set("discounttype", (Object)DiscountTypeEnum.NULL.getValue());
                            billentry.set("discountrate", (Object)BigDecimal.ZERO);
                        }
                    } else {
                        BigDecimal price = billentry.getBigDecimal("price");
                        if (price.compareTo(BigDecimal.ZERO) > 0) {
                            billentry.set("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue());
                            billentry.set("discountrate", (Object)new BigDecimal("100"));
                        } else {
                            billentry.set("discounttype", (Object)DiscountTypeEnum.NULL.getValue());
                            billentry.set("discountrate", (Object)BigDecimal.ZERO);
                        }
                    }
                    billentry.set(ENTRY_AMOUNT, (Object)BigDecimalUtil.ZERO);
                    billentry.set("curamount", (Object)BigDecimalUtil.ZERO);
                    billentry.set("taxamount", (Object)BigDecimalUtil.ZERO);
                    billentry.set("curtaxamount", (Object)BigDecimalUtil.ZERO);
                    billentry.set("amountandtax", (Object)BigDecimalUtil.ZERO);
                    billentry.set("curamountandtax", (Object)BigDecimalUtil.ZERO);
                }
                totalAmountMap = AmountHelper.calcAllAmount((DynamicObject)model.getDataEntity(true), (AmountPropertyKey)AmountPropertyKey.getInstance());
            }
            if (totalAmountMap == null) {
                model.setValue("totalamount", (Object)BigDecimalUtil.ZERO);
                model.setValue("totaltaxamount", (Object)BigDecimalUtil.ZERO);
                model.setValue("totalallamount", (Object)BigDecimalUtil.ZERO);
            } else {
                for (Map.Entry entry : totalAmountMap.entrySet()) {
                    model.setValue((String)entry.getKey(), entry.getValue());
                }
            }
            int payPlanRowCount = model.getEntryRowCount("purbillentry_pay");
            BigDecimal totalallamount = (BigDecimal)model.getValue("totalallamount");
            if (totalallamount != null && totalallamount.compareTo(BigDecimal.ZERO) > 0) {
                AmountPlanHelper.changeAmountConditionForDynamicObject((CommonContext)PurOrderBillHelper.getPayPlanCommonText((String)"pm_purorderbill"), (DynamicObject)this.getModel().getDataEntity(true));
                DynamicObjectCollection payEntrys = (DynamicObjectCollection)model.getValue("purbillentry_pay");
                for (DynamicObject entry : payEntrys) {
                    if (entry == null) continue;
                    entry.set("payentrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue());
                    Boolean isPreRec = entry.getBoolean("isprepay");
                    if (isPreRec == null) {
                        entry.set("isprepay", (Object)Boolean.FALSE);
                    }
                    if (isPreRec != null && !isPreRec.booleanValue()) {
                        entry.set("pretimepoint", (Object)"");
                        continue;
                    }
                    String pretimepoint = entry.getString("pretimepoint");
                    if (!kd.bos.util.StringUtils.isEmpty((String)pretimepoint)) continue;
                    entry.set("pretimepoint", (Object)"B");
                }
            }
        } else if (BillImportHelper.isAPI((String)billcretype)) {
            DynamicObject bill = model.getDataEntity(true);
            PurOrderBillHelper.completeBillInfo(Collections.singletonList(bill));
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String id = e.getActionId();
        Map varMap = e.getVarMap();
        Object returnData = e.getReturnData();
        switch (id) {
            case "conmBill": {
                String msg = ConmBillHelper.closeConmBillF7(this.getModel(), "billentry", returnData);
                if ("success".equalsIgnoreCase(msg)) {
                    this.getView().updateView("billentry");
                    break;
                }
                if (!"error".equalsIgnoreCase(msg)) break;
                String tip = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u884c\u6570\u636e\u3002", (String)"PurOrderBillPlugin_36", (String)"scmc-pm-formplugin", (Object[])new Object[0]), new Object[0]);
                this.getView().showTipNotification(tip);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (key = messageBoxClosedEvent.getCallBackId()) {
            case "gendeliverplan": {
                if (messageBoxClosedEvent.getResult() != MessageBoxResult.Yes) break;
                this.generateDeliverPlan();
                break;
            }
            case "switchsettlecurrency": {
                DynamicObject newSettleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
                if ("Yes".equals(messageBoxClosedEvent.getResultValue())) {
                    this.confirmSettleCurrency(newSettleCurrency);
                    break;
                }
                if (Integer.parseInt(this.getPageCache().get("oldAmtprecision")) == newSettleCurrency.getInt("amtprecision") && Integer.parseInt(this.getPageCache().get("oldPriceprecision")) == newSettleCurrency.getInt("priceprecision")) {
                    return;
                }
                this.calcAllAmount();
                break;
            }
            case "confirm_linetype": {
                String customVaule = messageBoxClosedEvent.getCustomVaule();
                if (StringUtils.isBlank((CharSequence)customVaule)) {
                    return;
                }
                int rowIndex = Integer.parseInt(customVaule);
                if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                    this.getModel().setValue("material", null, rowIndex);
                    this.getModel().setValue("expenseitem", null, rowIndex);
                    break;
                }
                String lineTypeId = this.getView().getPageCache().get(CACHE_LINETYPE);
                this.getModel().beginInit();
                this.getModel().setValue("linetype", (Object)(lineTypeId == null ? null : Long.valueOf(Long.parseLong(lineTypeId))), rowIndex);
                this.getModel().endInit();
                this.getView().updateView("linetype", rowIndex);
                this.getView().getPageCache().remove(CACHE_LINETYPE);
                break;
            }
            case "payaccordsetting": {
                if (!messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) break;
                OperateOption option = OperateOption.create();
                option.setVariableValue("payaccordsetting", "true");
                this.getView().invokeOperation("payaccordsetting", option);
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        String itemKey = e.getItemKey();
        IDataModel model = this.getModel();
        switch (itemKey) {
            case "addrow_deliver": {
                AbstractGrid entryGrid = (AbstractGrid)this.getControl("billentry");
                int focusRow = entryGrid.getEntryState().getFocusRow();
                if (focusRow != -1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u660e\u7ec6\u3002", (String)"PurOrderBillPlugin_1", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            case "draw": {
                DynamicObject org = (DynamicObject)model.getValue("org");
                if (org != null) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurOrderBillPlugin_2", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        DynamicObject payCondition = (DynamicObject)this.getModel().getValue("paycondition");
        if (payCondition != null) {
            this.changePayCondition(payCondition);
        }
    }

    private void setAllPreTimePoint() {
        DynamicObjectCollection payentrys = (DynamicObjectCollection)this.getModel().getValue("purbillentry_pay");
        for (int i = 0; i < payentrys.size(); ++i) {
            DynamicObject entry = (DynamicObject)payentrys.get(i);
            if (entry == null) continue;
            Boolean isprepay = entry.getBoolean("isprepay");
            this.setPreTimePointValue(isprepay, i);
            this.setPreTimePointEnable(isprepay, i);
        }
    }

    private void setPreTimePointValue(Boolean isprepay, int rowIndex) {
        if (isprepay != null && !isprepay.booleanValue()) {
            this.getModel().setValue("pretimepoint", (Object)"", rowIndex);
        } else {
            String pretimepoint = (String)this.getModel().getValue("pretimepoint", rowIndex);
            if (StringUtils.isEmpty((CharSequence)pretimepoint)) {
                this.getModel().setValue("pretimepoint", (Object)"B", rowIndex);
            }
        }
    }

    private void setPreTimePointEnable(Boolean isprepay, int rowIndex) {
        if (isprepay != null && !isprepay.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"pretimepoint"});
        } else {
            this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"pretimepoint"});
        }
    }

    private boolean isBackCalculate() {
        return (Boolean)this.getModel().getValue("inputamount");
    }

    private void changeSettleCurrency(Object oldValue, Object newValue) {
        if (this.isBackCalculate()) {
            return;
        }
        DynamicObject oldSettleCurrency = (DynamicObject)oldValue;
        DynamicObject newSettleCurrency = (DynamicObject)newValue;
        String entityName = this.getModel().getDataEntityType().getName();
        if (oldSettleCurrency == null || newSettleCurrency == null || !entityName.equals("pm_purorderbill") || this.getPageCache().get("changeSupplier") != null && !this.getPageCache().get("changeSupplier").equals("0") || this.getPageCache().get("gainprice") != null && !this.getPageCache().get("gainprice").equals("0")) {
            this.getPageCache().put("changeSupplier", "0");
            this.getPageCache().put("gainprice", "0");
            if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject && oldSettleCurrency.getInt("priceprecision") == newSettleCurrency.getInt("priceprecision") && oldSettleCurrency.getInt("amtprecision") == newSettleCurrency.getInt("amtprecision")) {
                return;
            }
            this.calcAllAmount();
            return;
        }
        this.getPageCache().put("oldSettleCurrency", String.valueOf(oldSettleCurrency.getPkValue()));
        this.getPageCache().put("oldAmtprecision", String.valueOf(oldSettleCurrency.getInt("priceprecision")));
        this.getPageCache().put("oldPriceprecision", String.valueOf(oldSettleCurrency.getInt("amtprecision")));
        this.getPageCache().put("oldSettleCurrencyName", oldSettleCurrency.getString("name"));
        ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener("switchsettlecurrency", PurOrderBillPlugin.class.getTypeName());
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u7ed3\u7b97\u5e01\u540e\uff0c\u201c\u5355\u4ef7\u201d\u548c\u201c\u91d1\u989d\u201d\u662f\u5426\u91cd\u65b0\u8ba1\u7b97\uff08\u6309\u7167\u65b0\u65e7\u5e01\u79cd\u95f4\u7684\u6c47\u7387\uff09\uff1f", (String)"PurOrderBillPlugin_31", (String)"scmc-pm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBack);
    }

    private void confirmSettleCurrency(DynamicObject newSettleCurrency) {
        DynamicObject exRateTable = (DynamicObject)this.getModel().getValue("exratetable");
        Date bizTime = (Date)this.getModel().getValue("exratedate");
        BigDecimal exchange = BigDecimalUtil.ZERO;
        boolean isIndirectRate = false;
        if (exRateTable != null) {
            Map exRateMap = CurrencyHelper.getExRateMap((Long)Long.valueOf(this.getPageCache().get("oldSettleCurrency")), (Long)((Long)newSettleCurrency.getPkValue()), (Long)((Long)exRateTable.getPkValue()), (Date)bizTime);
            exchange = (BigDecimal)exRateMap.get("exchangerate");
            isIndirectRate = ExchangeTypeEnum.isIndirectRate(exRateMap.get("exchangetype"));
        }
        if (BigDecimalUtil.isBlank((BigDecimal)exchange)) {
            String oldName = this.getPageCache().get("oldSettleCurrencyName");
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6c47\u7387\u8868\u4e2d\u672a\u67e5\u8be2\u5230\u201c%1$s\u201d\u548c\u201c%2$s\u201d\u95f4\u7684\u6709\u6548\u6c47\u7387\uff0c\u5355\u4ef7\u3001\u91d1\u989d\u4fe1\u606f\u672a\u66f4\u65b0\u3002", (String)"PurOrderBillPlugin_32", (String)"scmc-pm-formplugin", (Object[])new Object[0]), oldName, newSettleCurrency.getString("name")));
            if (Integer.parseInt(this.getPageCache().get("oldAmtprecision")) == newSettleCurrency.getInt("amtprecision") && Integer.parseInt(this.getPageCache().get("oldPriceprecision")) == newSettleCurrency.getInt("priceprecision")) {
                return;
            }
            this.calcAllAmount();
            return;
        }
        Boolean isTax = (Boolean)this.getModel().getValue("istax");
        int pricePrecision = newSettleCurrency == null ? 10 : newSettleCurrency.getInt("priceprecision");
        int amtPrecision = newSettleCurrency == null ? 10 : newSettleCurrency.getInt("amtprecision");
        String priceKey = isTax != false ? "priceandtax" : "price";
        this.setPriceAndDisCountRateByExRate(priceKey, exchange, isIndirectRate, pricePrecision, amtPrecision);
        int entryRowCount = this.getModel().getEntryRowCount("purbillentry_pay");
        boolean isPayRate = (Boolean)this.getModel().getValue("ispayrate");
        if (!isPayRate) {
            for (int i = 0; i < entryRowCount; ++i) {
                BigDecimal payAmount = BigDecimalUtil.getNotNull((Object)this.getModel().getValue("payamount", i));
                payAmount = AmountHelper.convertByExRate((BigDecimal)payAmount, (BigDecimal)exchange, (boolean)isIndirectRate, (int)amtPrecision);
                this.getModel().setValue("payamount", (Object)payAmount, i);
            }
        }
        this.calcAllAmount();
    }

    private void setPriceAndDisCountRateByExRate(String priceKey, BigDecimal exchange, boolean isIndirectRate, int pricePrecision, int amtPrecision) {
        int entryRowCount = this.getModel().getEntryRowCount("billentry");
        this.getModel().beginInit();
        for (int i = 0; i < entryRowCount; ++i) {
            BigDecimal price = BigDecimalUtil.getNotNull((Object)this.getModel().getValue(priceKey, i));
            price = AmountHelper.convertByExRate((BigDecimal)price, (BigDecimal)exchange, (boolean)isIndirectRate, (int)pricePrecision);
            this.getModel().setValue(priceKey, (Object)price, i);
            String discountType = (String)this.getModel().getValue("discounttype", i);
            if (!DiscountTypeEnum.UNITDIS.getValue().equals(discountType) && !DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType)) continue;
            BigDecimal disCountRate = BigDecimalUtil.getNotNull((Object)this.getModel().getValue("discountrate", i));
            disCountRate = AmountHelper.convertByExRate((BigDecimal)disCountRate, (BigDecimal)exchange, (boolean)isIndirectRate, (int)pricePrecision);
            this.getModel().setValue("discountrate", (Object)disCountRate, i);
        }
        this.getModel().endInit();
    }

    private void initOwner(Long orgId, Long supplierId, int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        if (bizType != null && BizCategoryHelper.isVMI((Long)((Long)bizType.getPkValue()))) {
            model.setValue("ownertype", (Object)OwnerTypeEnum.OWNERTYPE_SUPPLIER.getValue(), rowIndex);
            this.getView().setEnable(Boolean.FALSE, rowIndex, new String[]{"ownertype", "owner"});
        }
        String ownerType = (String)model.getValue("ownertype", rowIndex);
        if (OwnerTypeEnum.OWNERTYPE_SUPPLIER.getValue().equals(ownerType)) {
            model.setValue("owner", (Object)supplierId, rowIndex);
        } else if (OwnerTypeEnum.OWNERTYPE_ORG.getValue().equals(ownerType)) {
            model.setValue("owner", (Object)this.getOrgOwner(rowIndex), rowIndex);
        }
    }

    private void changeEntryReqOrg(int rowIndex) {
        DynamicObject org;
        IDataModel model = this.getModel();
        String ownerType = (String)model.getValue("ownertype", rowIndex);
        if (OwnerTypeEnum.OWNERTYPE_ORG.getValue().equals(ownerType) && (org = (DynamicObject)model.getValue("org")) != null) {
            Long orgOwner = this.getOrgOwner(rowIndex);
            model.setValue("owner", (Object)orgOwner, rowIndex);
        }
    }

    private void changeEntryRecOrg(int rowIndex) {
        DynamicObject org;
        IDataModel model = this.getModel();
        model.setValue("warehouse", null, rowIndex);
        String ownerType = (String)model.getValue("ownertype", rowIndex);
        if (OwnerTypeEnum.OWNERTYPE_ORG.getValue().equals(ownerType) && (org = (DynamicObject)model.getValue("org")) != null) {
            Long orgOwner = this.getOrgOwner(rowIndex);
            model.setValue("owner", (Object)orgOwner, rowIndex);
        }
    }

    private void changeSupplier(Object newValue) {
        DynamicObjectCollection entrys;
        IDataModel model = this.getModel();
        DynamicObject supplier = newValue instanceof DynamicObject ? (DynamicObject)newValue : null;
        model.setValue("pricelist", null);
        if (supplier != null) {
            DynamicObject payCondtion = supplier.getDynamicObject("paycond");
            if (payCondtion == null) {
                model.setValue("paycondition", null);
            } else {
                model.setValue("paycondition", payCondtion.getPkValue());
            }
            this.changePayCondition(payCondtion);
        }
        if ((entrys = model.getDataEntity(true).getDynamicObjectCollection("billentry")) != null && !entrys.isEmpty()) {
            DataEntityPropertyCollection properties = ((DynamicObject)entrys.get(0)).getDynamicObjectType().getProperties();
            DynamicProperty ownerTypeP = (DynamicProperty)properties.get((Object)"ownertype");
            DynamicProperty ownerP = (DynamicProperty)properties.get((Object)"owner");
            model.beginInit();
            for (DynamicObject entry : entrys) {
                String ownerType = (String)ownerTypeP.getValueFast((Object)entry);
                if (!OwnerTypeEnum.OWNERTYPE_SUPPLIER.getValue().equals(ownerType)) continue;
                ownerP.setValueFast((Object)entry, (Object)supplier);
            }
            model.endInit();
            this.getView().updateView("billentry");
        }
    }

    private void changeMaterial(Object oldValue, Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        this.getPageCache().put("stopChange", "true");
        if (oldValue != null) {
            model.setValue("conbillnumber", null, rowIndex);
            model.setValue("conbillrownum", null, rowIndex);
            model.setValue("conbillid", (Object)0, rowIndex);
            model.setValue("conbillentryid", (Object)0, rowIndex);
            model.setValue("configuredcode", null, rowIndex);
        }
        if (newValue instanceof DynamicObject) {
            DynamicObject material = (DynamicObject)newValue;
            model.setValue("iscontrolqty", (Object)Boolean.FALSE, rowIndex);
            model.setValue("receiverateup", (Object)BigDecimal.ZERO, rowIndex);
            model.setValue("receiveratedown", (Object)BigDecimal.ZERO, rowIndex);
            model.setValue("receiveqtyup", (Object)BigDecimalUtil.ZERO, rowIndex);
            model.setValue("receiveqtydown", (Object)BigDecimalUtil.ZERO, rowIndex);
            model.setValue("receivebaseqtyup", (Object)BigDecimalUtil.ZERO, rowIndex);
            model.setValue("receivebaseqtydown", (Object)BigDecimalUtil.ZERO, rowIndex);
            boolean isControlQty = material.getBoolean("iscontrolqty");
            if (isControlQty) {
                BigDecimal receiveRateUp = material.getBigDecimal("receiverateup");
                BigDecimal receiveRateDown = material.getBigDecimal("receiveratedown");
                model.setValue("iscontrolqty", (Object)isControlQty, rowIndex);
                model.setValue("receiverateup", (Object)receiveRateUp, rowIndex);
                model.setValue("receiveratedown", (Object)receiveRateDown, rowIndex);
            }
            model.setValue("iscontrolday", (Object)Boolean.FALSE, rowIndex);
            model.setValue("receivedayup", (Object)0, rowIndex);
            model.setValue("receivedaydown", (Object)0, rowIndex);
            boolean isControlDay = material.getBoolean("iscontrolday");
            if (isControlDay) {
                int receiveDayUp = material.getInt("receivedayup");
                int receiveDayDown = material.getInt("receivedaydown");
                model.setValue("iscontrolday", (Object)isControlDay, rowIndex);
                model.setValue("receivedayup", (Object)receiveDayUp, rowIndex);
                model.setValue("receivedaydown", (Object)receiveDayDown, rowIndex);
            }
        }
        model.setValue("mftdirect", null, rowIndex);
        model.setValue("mftsupplier", null, rowIndex);
        this.getPageCache().put("stopChange", "false");
    }

    private void changeAuxQty(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        if (newValue instanceof BigDecimal) {
            DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
            DynamicObject auxUnit = (DynamicObject)model.getValue("auxunit", rowIndex);
            if (material == null || auxUnit == null) {
                return;
            }
            DynamicObject master = material.getDynamicObject("masterid");
            if (master != null) {
                String unitConvertDir = master.getString("unitconvertdir");
                if (UnitConvertDirEnum.U2ND_UINV.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                    DynamicObject baseUnit = (DynamicObject)this.getModel().getValue("baseunit", rowIndex);
                    DynamicObject unit = (DynamicObject)this.getModel().getValue("unit", rowIndex);
                    BigDecimal qty = BigDecimalUtil.getNotNull((Object)model.getValue("qty", rowIndex));
                    BigDecimal baseQty = BigDecimalUtil.getNotNull((Object)model.getValue("baseqty", rowIndex));
                    BigDecimal receiveRateUp = BigDecimalUtil.getNotNull((Object)model.getValue("receiverateup", rowIndex));
                    BigDecimal receiveRateDown = BigDecimalUtil.getNotNull((Object)model.getValue("receiveratedown", rowIndex));
                    BigDecimal receiveQtyUp = this.getReceiveQtyUp(qty, receiveRateUp, unit);
                    BigDecimal receiveQtyDown = this.getReceiveQtyDown(qty, receiveRateDown, unit);
                    BigDecimal receiveBaseQtyUp = this.getReceiveQtyUp(baseQty, receiveRateUp, baseUnit);
                    BigDecimal receiveBaseQtyDown = this.getReceiveQtyDown(baseQty, receiveRateDown, baseUnit);
                    model.setValue("receiveqtyup", (Object)receiveQtyUp, rowIndex);
                    model.setValue("receiveqtydown", (Object)receiveQtyDown, rowIndex);
                    model.setValue("receivebaseqtyup", (Object)receiveBaseQtyUp, rowIndex);
                    model.setValue("receivebaseqtydown", (Object)receiveBaseQtyDown, rowIndex);
                }
            }
        }
    }

    private void changeQty(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject baseUnit = (DynamicObject)this.getModel().getValue("baseunit", rowIndex);
        DynamicObject unit = (DynamicObject)this.getModel().getValue("unit", rowIndex);
        if (newValue instanceof BigDecimal) {
            BigDecimal qty = (BigDecimal)newValue;
            BigDecimal baseQty = BigDecimalUtil.getNotNull((Object)model.getValue("baseqty", rowIndex));
            BigDecimal receiveRateUp = BigDecimalUtil.getNotNull((Object)model.getValue("receiverateup", rowIndex));
            BigDecimal receiveRateDown = BigDecimalUtil.getNotNull((Object)model.getValue("receiveratedown", rowIndex));
            BigDecimal receiveQtyUp = this.getReceiveQtyUp(qty, receiveRateUp, unit);
            BigDecimal receiveQtyDown = this.getReceiveQtyDown(qty, receiveRateDown, unit);
            BigDecimal receiveBaseQtyUp = this.getReceiveQtyUp(baseQty, receiveRateUp, baseUnit);
            BigDecimal receiveBaseQtyDown = this.getReceiveQtyDown(baseQty, receiveRateDown, baseUnit);
            model.setValue("receiveqtyup", (Object)receiveQtyUp, rowIndex);
            model.setValue("receiveqtydown", (Object)receiveQtyDown, rowIndex);
            model.setValue("receivebaseqtyup", (Object)receiveBaseQtyUp, rowIndex);
            model.setValue("receivebaseqtydown", (Object)receiveBaseQtyDown, rowIndex);
        }
    }

    private void changeUnit(int rowIndex) {
        IDataModel model = this.getModel();
        DynamicObject baseUnit = (DynamicObject)this.getModel().getValue("baseunit", rowIndex);
        DynamicObject unit = (DynamicObject)this.getModel().getValue("unit", rowIndex);
        BigDecimal baseQty = BigDecimalUtil.getNotNull((Object)model.getValue("baseqty", rowIndex));
        BigDecimal qty = BigDecimalUtil.getNotNull((Object)model.getValue("qty", rowIndex));
        BigDecimal receiveRateUp = BigDecimalUtil.getNotNull((Object)model.getValue("receiverateup", rowIndex));
        BigDecimal receiveRateDown = BigDecimalUtil.getNotNull((Object)model.getValue("receiveratedown", rowIndex));
        BigDecimal receiveQtyUp = this.getReceiveQtyUp(qty, receiveRateUp, unit);
        BigDecimal receiveQtyDown = this.getReceiveQtyDown(qty, receiveRateDown, unit);
        BigDecimal receiveBaseQtyUp = this.getReceiveQtyUp(baseQty, receiveRateUp, baseUnit);
        BigDecimal receiveBaseQtyDown = this.getReceiveQtyDown(baseQty, receiveRateDown, baseUnit);
        model.setValue("receiveqtyup", (Object)receiveQtyUp, rowIndex);
        model.setValue("receiveqtydown", (Object)receiveQtyDown, rowIndex);
        model.setValue("receivebaseqtyup", (Object)receiveBaseQtyUp, rowIndex);
        model.setValue("receivebaseqtydown", (Object)receiveBaseQtyDown, rowIndex);
    }

    private void changeDeliverUnit(int rowIndex, boolean clearPlanQty) {
        IDataModel model = this.getModel();
        DynamicObjectCollection purBillEntryDeliver = (DynamicObjectCollection)model.getValue("purbillentry_deliver");
        if (purBillEntryDeliver == null || purBillEntryDeliver.size() == 0) {
            return;
        }
        DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
        this.getPageCache().put("stopChange", "true");
        for (int i = 0; i < purBillEntryDeliver.size(); ++i) {
            BigDecimal planQty;
            DynamicObject entry = (DynamicObject)purBillEntryDeliver.get(i);
            model.setValue("planunit", (Object)unit, i);
            if (clearPlanQty) {
                model.setValue("planqty", (Object)BigDecimal.ZERO, i);
                continue;
            }
            if (unit == null || !BigDecimalUtil.isNotBlank((BigDecimal)(planQty = entry.getBigDecimal("planqty")))) continue;
            planQty = planQty.setScale(BillQtyAndUnitHelper.getPrecision((DynamicObject)unit), BillQtyAndUnitHelper.getUnitRoundingMode((DynamicObject)unit));
            model.setValue("planqty", (Object)planQty, i);
        }
        this.getPageCache().put("stopChange", "false");
    }

    private void changeIsControlQty(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        if (newValue instanceof Boolean) {
            boolean isControlQty = (Boolean)newValue;
            BigDecimal qty = BigDecimalUtil.getNotNull((Object)model.getValue("qty", rowIndex));
            BigDecimal baseQty = BigDecimalUtil.getNotNull((Object)model.getValue("baseqty", rowIndex));
            DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
            DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
            if (unit == null || baseUnit == null) {
                return;
            }
            model.beginInit();
            if (isControlQty) {
                DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
                BigDecimal receiveRateUp = material.getBigDecimal("receiverateup");
                BigDecimal receiveRateDown = material.getBigDecimal("receiveratedown");
                BigDecimal receiveQtyUp = this.getReceiveQtyUp(qty, receiveRateUp, unit);
                BigDecimal receiveQtyDown = this.getReceiveQtyDown(qty, receiveRateDown, unit);
                BigDecimal receiveBaseQtyUp = this.getReceiveQtyUp(baseQty, receiveRateUp, baseUnit);
                BigDecimal receiveBaseQtyDown = this.getReceiveQtyDown(baseQty, receiveRateDown, baseUnit);
                model.setValue("receiverateup", (Object)receiveRateUp, rowIndex);
                model.setValue("receiveratedown", (Object)receiveRateDown, rowIndex);
                model.setValue("receiveqtyup", (Object)receiveQtyUp, rowIndex);
                model.setValue("receiveqtydown", (Object)receiveQtyDown, rowIndex);
                model.setValue("receivebaseqtyup", (Object)receiveBaseQtyUp, rowIndex);
                model.setValue("receivebaseqtydown", (Object)receiveBaseQtyDown, rowIndex);
            } else {
                model.setValue("receiverateup", (Object)BigDecimalUtil.ZERO, rowIndex);
                model.setValue("receiveratedown", (Object)BigDecimalUtil.ZERO, rowIndex);
                model.setValue("receiveqtyup", (Object)qty, rowIndex);
                model.setValue("receiveqtydown", (Object)qty, rowIndex);
                model.setValue("receivebaseqtyup", (Object)baseQty, rowIndex);
                model.setValue("receivebaseqtydown", (Object)baseQty, rowIndex);
            }
            model.endInit();
            IFormView view = this.getView();
            view.updateView("receiverateup", rowIndex);
            view.updateView("receiveratedown", rowIndex);
            view.updateView("receiveqtyup", rowIndex);
            view.updateView("receiveqtydown", rowIndex);
            view.updateView("receivebaseqtyup", rowIndex);
            view.updateView("receivebaseqtydown", rowIndex);
        }
    }

    private void changeIsControlAmount(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        if (newValue instanceof Boolean) {
            if (((Boolean)newValue).booleanValue()) {
                BigDecimal amountAndTax = (BigDecimal)model.getValue("amountandtax", rowIndex);
                model.setValue("amountup", (Object)amountAndTax, rowIndex);
            } else {
                model.setValue("amountup", (Object)BigDecimalUtil.ZERO, rowIndex);
            }
        }
    }

    private void changeIsControlDay(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        if (newValue instanceof Boolean) {
            boolean isControlDay = (Boolean)newValue;
            DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
            if (material == null) {
                return;
            }
            model.beginInit();
            if (isControlDay) {
                BigDecimal receiveDayUp = material.getBigDecimal("receivedayup");
                BigDecimal receiveDayDown = material.getBigDecimal("receivedaydown");
                model.setValue("receivedayup", (Object)receiveDayUp, rowIndex);
                model.setValue("receivedaydown", (Object)receiveDayDown, rowIndex);
            } else {
                model.setValue("receivedayup", (Object)0, rowIndex);
                model.setValue("receivedaydown", (Object)0, rowIndex);
            }
            model.endInit();
            IFormView view = this.getView();
            view.updateView("receivedayup", rowIndex);
            view.updateView("receivedaydown", rowIndex);
        }
    }

    private void changeIsReceiveRateDown(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        if (newValue instanceof BigDecimal) {
            BigDecimal receiveRateDown = (BigDecimal)newValue;
            BigDecimal qty = BigDecimalUtil.getNotNull((Object)model.getValue("qty", rowIndex));
            BigDecimal baseQty = BigDecimalUtil.getNotNull((Object)model.getValue("baseqty", rowIndex));
            DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
            DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
            if (unit == null || baseUnit == null) {
                return;
            }
            BigDecimal receiveQtyDown = this.getReceiveQtyDown(qty, receiveRateDown, unit);
            BigDecimal receiveBaseQtyDown = this.getReceiveQtyDown(baseQty, receiveRateDown, baseUnit);
            model.setValue("receiveqtydown", (Object)receiveQtyDown, rowIndex);
            model.setValue("receivebaseqtydown", (Object)receiveBaseQtyDown, rowIndex);
        }
    }

    private void changeReceiveRateUp(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        if (newValue instanceof BigDecimal) {
            BigDecimal receiveRateUp = (BigDecimal)newValue;
            BigDecimal qty = BigDecimalUtil.getNotNull((Object)model.getValue("qty", rowIndex));
            BigDecimal baseQty = BigDecimalUtil.getNotNull((Object)model.getValue("baseqty", rowIndex));
            DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
            DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
            if (unit == null || baseUnit == null) {
                return;
            }
            BigDecimal receiveQtyUp = this.getReceiveQtyUp(qty, receiveRateUp, unit);
            BigDecimal receiveBaseQtyUp = this.getReceiveQtyUp(baseQty, receiveRateUp, baseUnit);
            model.setValue("receiveqtyup", (Object)receiveQtyUp, rowIndex);
            model.setValue("receivebaseqtyup", (Object)receiveBaseQtyUp, rowIndex);
        }
    }

    private void changeIsPresent(Object newValue, int rowIndex) {
        if (newValue instanceof Boolean) {
            IDataModel model = this.getModel();
            boolean isPresent = (Boolean)newValue;
            boolean isTax = (Boolean)this.getModel().getValue("istax");
            model.beginInit();
            if (isPresent) {
                BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
                BigDecimal priceAndTax = (BigDecimal)model.getValue("priceandtax", rowIndex);
                if (isTax) {
                    if (priceAndTax.compareTo(BigDecimal.ZERO) > 0) {
                        this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue(), rowIndex);
                        this.getModel().setValue("discountrate", (Object)new BigDecimal(100), rowIndex);
                    } else if (priceAndTax.compareTo(BigDecimal.ZERO) == 0) {
                        this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), rowIndex);
                        this.getModel().setValue("discountrate", (Object)BigDecimal.ZERO, rowIndex);
                    }
                } else if (price.compareTo(BigDecimal.ZERO) > 0) {
                    this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.DISRATE.getValue(), rowIndex);
                    this.getModel().setValue("discountrate", (Object)new BigDecimal(100), rowIndex);
                } else if (price.compareTo(BigDecimal.ZERO) == 0) {
                    this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), rowIndex);
                    this.getModel().setValue("discountrate", (Object)BigDecimal.ZERO, rowIndex);
                }
            } else {
                model.setValue("discountrate", (Object)BigDecimal.ZERO, rowIndex);
                model.setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), rowIndex);
            }
            model.endInit();
        }
    }

    private void changeTotalAllAmount(Object newValue) {
        AmountPlanHelper.calAmountPlanForView((CommonContext)PurOrderBillHelper.getPayPlanCommonText((String)this.getView().getEntityId()), (IFormView)this.getView());
    }

    private void changePayCondition(Object newValue) {
        if (newValue == null) {
            return;
        }
        AmountPlanHelper.changeAmountConditionForView((CommonContext)PurOrderBillHelper.getPayPlanCommonText((String)this.getView().getEntityId()), (IFormView)this.getView());
        this.setAllPreTimePoint();
    }

    private void changePayRate(Object newValue, int rowIndex) {
        AmountPlanHelper.calAmountPlanForView((CommonContext)PurOrderBillHelper.getPayPlanCommonText((String)this.getView().getEntityId()), (IFormView)this.getView());
    }

    private void changePayAmount(Object newValue, int rowIndex) {
        AmountPlanHelper.calAmountPlanForView((CommonContext)PurOrderBillHelper.getPayPlanCommonText((String)this.getView().getEntityId()), (IFormView)this.getView());
    }

    private Long getOrgOwner(int rowIndex) {
        IDataModel model = this.getModel();
        Long ownerId = null;
        DynamicObject entryReqOrg = (DynamicObject)model.getValue("entryreqorg", rowIndex);
        DynamicObject entryRecOrg = (DynamicObject)model.getValue("entryrecorg", rowIndex);
        if (entryReqOrg != null && entryRecOrg != null && entryReqOrg.getPkValue() != null && entryRecOrg.getPkValue() != null) {
            Long reqOrgId = (Long)entryReqOrg.getPkValue();
            Long recOrgId = (Long)entryRecOrg.getPkValue();
            String ownerCacheKey = reqOrgId + "&" + recOrgId + "&owner";
            String ownerCache = this.getPageCache().get(ownerCacheKey);
            if (ownerCache != null) {
                if (StringUtils.isNotBlank((CharSequence)ownerCache)) {
                    return Long.valueOf(ownerCache);
                }
                return null;
            }
            Map orgRelation = OrgHelper.getOrgRelation((Long)recOrgId, (String)"10", (String)"05", (String)"fromorg");
            List orgIds = (List)orgRelation.get("orgId");
            Long reqSettleId = this.getSettleOrg(reqOrgId);
            if (reqSettleId != null && orgIds != null && orgIds.contains(reqSettleId)) {
                ownerId = reqSettleId;
            } else {
                List detailList = (List)orgRelation.get("data");
                if (detailList != null) {
                    for (Map detailMap : detailList) {
                        Boolean isDefault = (Boolean)detailMap.get("isDefault");
                        if (isDefault == null || !isDefault.booleanValue()) continue;
                        ownerId = (Long)detailMap.get("orgId");
                        break;
                    }
                }
            }
            if (ownerId != null) {
                this.getPageCache().put(ownerCacheKey, ownerId.toString());
            } else {
                this.getPageCache().put(ownerCacheKey, "");
            }
        }
        return ownerId;
    }

    private Long getPayOrg(Long settleOrgId) {
        Long payOrgId = null;
        if (settleOrgId != null) {
            String cacheKey = settleOrgId + "&payorg";
            String cacheValue = this.getPageCache().get(cacheKey);
            if (cacheValue == null) {
                payOrgId = OrgHelper.getToOrg((String)"10", (String)"08", (Long)settleOrgId, (boolean)true);
                if (payOrgId == null) {
                    this.getPageCache().put(cacheKey, "");
                } else {
                    this.getPageCache().put(cacheKey, payOrgId.toString());
                }
            } else if (StringUtils.isNotBlank((CharSequence)cacheValue)) {
                payOrgId = Long.valueOf(cacheValue);
            }
        }
        return payOrgId;
    }

    private Long getSettleOrg(Long orgId) {
        if (orgId != null) {
            String cacheKey = orgId + "&settleorg";
            String settleOrgCache = this.getPageCache().get(cacheKey);
            if (settleOrgCache != null) {
                if (StringUtils.isNotBlank((CharSequence)settleOrgCache)) {
                    return Long.valueOf(settleOrgCache);
                }
                return null;
            }
            Map map = OrgHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
            if (map != null && map.get("id") != null) {
                Long settleOrgId = (Long)map.get("id");
                this.getPageCache().put(cacheKey, settleOrgId.toString());
                return settleOrgId;
            }
            this.getPageCache().put(cacheKey, "");
            return null;
        }
        return null;
    }

    private QFilter getSettleOrgF7(Long orgId, Long reqOrgId) {
        QFilter qFilter1 = null;
        Long purSettleOrgId = this.getSettleOrg(orgId);
        if (purSettleOrgId != null) {
            qFilter1 = new QFilter("id", "=", (Object)purSettleOrgId);
        }
        QFilter qFilter2 = null;
        Long reqSettleOrgId = this.getSettleOrg(reqOrgId);
        if (reqSettleOrgId != null) {
            qFilter2 = new QFilter("id", "=", (Object)reqSettleOrgId);
        }
        if (qFilter1 == null) {
            return qFilter2;
        }
        if (qFilter2 == null) {
            return qFilter1;
        }
        return qFilter1.or(qFilter2);
    }

    private void generateDeliverPlan() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("billentry");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection billentrys = dataEntity.getDynamicObjectCollection("billentry");
        Date today = TimeServiceHelper.today();
        for (int i = 0; i < selectRows.length; ++i) {
            int rowIndex = selectRows[i];
            DynamicObject billEntry = (DynamicObject)billentrys.get(rowIndex);
            DynamicObject unit = billEntry.getDynamicObject("unit");
            BigDecimal qty = billEntry.getBigDecimal("qty");
            DynamicObjectCollection deliverEntry = billEntry.getDynamicObjectCollection("purbillentry_deliver");
            deliverEntry.clear();
            DynamicObject addNew = deliverEntry.addNew();
            addNew.set("seq", (Object)1);
            addNew.set("planqty", (Object)qty);
            addNew.set("planunit", (Object)unit);
            addNew.set("plandeliverdate", (Object)today);
            addNew.set("delentrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue());
        }
        this.getView().updateView("purbillentry_deliver");
    }

    private BigDecimal getReceiveQtyUp(BigDecimal qty, BigDecimal receiveRateUp, DynamicObject unit) {
        return BigDecimalUtil.getByGrowRate((BigDecimal)qty, (BigDecimal)BigDecimalUtil.div100((BigDecimal)receiveRateUp)).setScale(BillQtyAndUnitHelper.getPrecision((DynamicObject)unit), BillQtyAndUnitHelper.getUnitRoundingMode((DynamicObject)unit));
    }

    private BigDecimal getReceiveQtyDown(BigDecimal qty, BigDecimal receiveRateDown, DynamicObject unit) {
        return BigDecimalUtil.getByReduceRate((BigDecimal)qty, (BigDecimal)BigDecimalUtil.div100((BigDecimal)receiveRateDown)).setScale(BillQtyAndUnitHelper.getPrecision((DynamicObject)unit), BillQtyAndUnitHelper.getUnitRoundingMode((DynamicObject)unit));
    }

    private void calcAllAmount() {
        IDataModel model = this.getModel();
        Map totalAmountMap = AmountHelper.calcAllAmount((DynamicObject)model.getDataEntity(true), (AmountPropertyKey)AmountPropertyKey.getInstance());
        this.getView().updateView("billentry");
        for (Map.Entry entry : totalAmountMap.entrySet()) {
            model.setValue((String)entry.getKey(), entry.getValue());
        }
    }

    private void calcTotalAmount() {
        IDataModel model = this.getModel();
        for (Map.Entry entry : AmountHelper.calcTotalAmount((DynamicObject)model.getDataEntity(true)).entrySet()) {
            model.setValue((String)entry.getKey(), entry.getValue());
        }
    }

    private void showBillExecForm() {
        IDataModel model = this.getView().getModel();
        String billId = String.valueOf(model.getValue("id"));
        String org = String.valueOf(((DynamicObject)model.getValue("org")).get("id"));
        Object fromDate = model.getValue("biztime");
        ArrayList<Long> ids = new ArrayList<Long>(1);
        ids.add(Long.valueOf(billId));
        ReportShowParameter formParam = new ReportShowParameter();
        formParam.setFormId("pm_purorderbillrpt_new");
        formParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.getCustomParam().put("isFormBill", "1");
        FilterInfo filter = queryParam.getFilter();
        filter.addFilterItem("selectbill", ids);
        filter.addFilterItem("orgfield", (Object)org);
        filter.addFilterItem("startdate", fromDate);
        filter.addFilterItem("enddate", fromDate);
        filter.addFilterItem("billstatusfield", (Object)PRETIMEPOINT_CONM);
        filter.addFilterItem("rowstatusfield", (Object)"C");
        filter.addFilterItem("closestatusfield", (Object)"C");
        formParam.setQueryParam(queryParam);
        this.getView().showForm((FormShowParameter)formParam);
    }

    private void showHistoryPriceForm() {
        List<DynamicObject> rows = this.getSelectRow();
        if (CommonUtils.isNull(rows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u7269\u6599\u660e\u7ec6\u5206\u5f55\u884c\u3002", (String)"PurOrderBillPlugin_34", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            return;
        }
        ReportShowParameter formParam = new ReportShowParameter();
        if (!this.createShowFormParam(rows, formParam).booleanValue()) {
            return;
        }
        this.getView().showForm((FormShowParameter)formParam);
    }

    private Boolean createShowFormParam(List<DynamicObject> rows, ReportShowParameter formParam) {
        IDataModel model = this.getView().getModel();
        Date billDate = model.getDataEntity().getDate("biztime");
        if (billDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u201c\u8ba2\u5355\u65e5\u671f\u201d\u3002", (String)"PurOrderBillPlugin_33", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        formParam.setFormId("pur_historicalprice_new");
        formParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        ArrayList materialIds = new ArrayList(rows.size());
        rows.forEach(s -> {
            DynamicObject material = s.getDynamicObject("material");
            if (material != null) {
                materialIds.add(material.getLong("masterid.id"));
            }
        });
        Date fromDate = DateUtils.addYears((Date)billDate, (int)-1);
        fromDate = DateUtils.addDays((Date)fromDate, (int)1);
        ReportQueryParam queryParam = new ReportQueryParam();
        queryParam.getCustomParam().put("isFormBill", "1");
        FilterInfo filter = queryParam.getFilter();
        filter.addFilterItem("orgfield", this.getDynamicObjectId("org"));
        filter.addFilterItem("biztypefield", this.getDynamicObjectId("biztype"));
        filter.addFilterItem("supplierfield", this.getDynamicObjectId("supplier"));
        filter.addFilterItem("deptfield", this.getDynamicObjectId("dept"));
        filter.addFilterItem("operatorgroupfield", this.getDynamicObjectId("operatorgroup"));
        filter.addFilterItem("operatorfield", this.getDynamicObjectId("operator"));
        filter.addFilterItem("biztypefield", this.getDynamicObjectId("biztype"));
        filter.addFilterItem("virtualfield", (Object)Boolean.TRUE);
        filter.addFilterItem("startdate", (Object)fromDate);
        filter.addFilterItem("enddate", (Object)billDate);
        filter.addFilterItem("materialfield", materialIds.stream().distinct().collect(Collectors.toList()));
        filter.addFilterItem("pricesourceentityfield", (Object)BusinessDataServiceHelper.loadSingle((Object)this.getView().getEntityId(), (String)"bos_entityobject"));
        formParam.setQueryParam(queryParam);
        return Boolean.TRUE;
    }

    private Object getDynamicObjectId(String id) {
        IDataModel model = this.getView().getModel();
        DynamicObject obj = (DynamicObject)model.getValue(id);
        if (null == obj) {
            return null;
        }
        return obj.get("id");
    }

    public List<DynamicObject> getSelectRow() {
        int[] selectRows = ((EntryGrid)this.getControl("billentry")).getSelectRows();
        if (selectRows == null || selectRows.length < 1) {
            return null;
        }
        IDataModel model = this.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection billentrys = dataEntity.getDynamicObjectCollection("billentry");
        ArrayList<DynamicObject> rows = new ArrayList<DynamicObject>(selectRows.length);
        for (int i : selectRows) {
            DynamicObject dynamicObject = (DynamicObject)billentrys.get(i);
            DynamicObject material = dynamicObject.getDynamicObject("material");
            if (material == null) continue;
            rows.add(dynamicObject);
        }
        return rows;
    }
}

