/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.order;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.BeforeDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mpscmm.msbd.business.helper.AmountPlanHelper;
import kd.mpscmm.msbd.common.context.CommonContext;
import kd.scmc.pm.business.helper.BillImportHelper;
import kd.scmc.pm.business.helper.BillParameterHelper;
import kd.scmc.pm.business.helper.PurOrderBillHelper;
import kd.scmc.pm.enums.ChangeTypeEnum;

public class XSPurorderBillPlugin
extends AbstractBillPlugIn
implements RowClickEventListener,
ClickListener,
EntryGridBindDataListener {
    private static final String MODIFYROW = "modifyrow";
    private static final String MODIFYPAYROW = "modifyrow_pay";
    private static final String DELETEROW = "deleterow";
    private static final String ADDROW_DELIVER = "addrow_deliver";
    private static final String DELETEROW_DELIVER = "deleterow_deliver";
    private static final String MODIFYROW_DELIVER = "modifyrow_deliver";
    private static final String BIZVALID = "bizvalid";
    private static final String CONFIRM_LINETYPE = "confirm_linetype";
    private static final String CACHE_LINETYPE = "cache_linetype";
    private static final String PRETIMEPOINT_CONM = "A";
    private static final String CONM_PURCONTRACT = "conm_purcontract";
    private String[] entrybackfields = new String[]{"qty", "auxqty", "taxrateid", "entrycomment", "amount", "amountandtax", "iscontrolqty", "receiveratedown", "receiverateup", "discountrate", "discounttype"};

    public void registerListener(EventObject e) {
        EntryGrid deliverEntryGrid;
        EntryGrid payEntryGrid;
        EntryGrid entryGrid;
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getView().getControl("tbmainentry");
        Toolbar payEntrytoolbar = (Toolbar)this.getView().getControl("toolbar_pay");
        Toolbar deliverEntrytoolbar = (Toolbar)this.getView().getControl("toolbar_deliver");
        if (payEntrytoolbar != null) {
            payEntrytoolbar.addItemClickListener((ItemClickListener)this);
        }
        if (deliverEntrytoolbar != null) {
            deliverEntrytoolbar.addItemClickListener((ItemClickListener)this);
        }
        if (toolbar != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
        if ((entryGrid = (EntryGrid)this.getView().getControl("billentry")) != null) {
            entryGrid.addRowClickListener((RowClickEventListener)this);
            entryGrid.addDataBindListener((EntryGridBindDataListener)this);
        }
        if ((payEntryGrid = (EntryGrid)this.getView().getControl("purbillentry_pay")) != null) {
            payEntryGrid.addRowClickListener((RowClickEventListener)this);
        }
        if ((deliverEntryGrid = (EntryGrid)this.getView().getControl("purbillentry_deliver")) != null) {
            deliverEntryGrid.addRowClickListener((RowClickEventListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setEnable(Boolean.FALSE, new String[]{"billtype"});
        Object sourcebillid = this.getModel().getValue("sourcebillid");
        String sourcebillentity = (String)this.getModel().getValue("sourcebillentity");
        if (!sourcebillentity.isEmpty() && sourcebillid != null) {
            DynamicObject srcBill = BusinessDataServiceHelper.loadSingle((Object)sourcebillid, (String)sourcebillentity);
            boolean inputamount = srcBill.getBoolean("inputamount");
            if (inputamount) {
                this.getModel().setValue("inputamount", (Object)Boolean.TRUE);
                this.getView().setEnable(Boolean.FALSE, new String[]{"inputamount"});
            } else {
                this.getModel().setValue("inputamount", (Object)Boolean.FALSE);
                this.getView().setEnable(Boolean.FALSE, new String[]{"inputamount"});
            }
            int billEntryCount = this.getModel().getEntryRowCount("billentry");
            for (int i = 0; i < billEntryCount; ++i) {
                Boolean inputMount;
                if (!ChangeTypeEnum.UPDATE.getValue().equals(this.getModel().getValue("entrychangetype", i)) || !(inputMount = (Boolean)this.getModel().getValue("inputamount")).booleanValue() || !"1".equals(this.getPageCache().get("inputamount"))) continue;
                this.getView().setEnable(Boolean.TRUE, i, this.entrybackfields);
            }
            int payEntryCount = this.getModel().getEntryRowCount("purbillentry_pay");
            for (int i = 0; i < payEntryCount; ++i) {
                this.setPreTimePoint(i);
            }
        }
    }

    public void initialize() {
        EntryGrid entry = (EntryGrid)this.getControl("purbillentry_pay");
        if (entry != null) {
            entry.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int billEntryCount = this.getModel().getEntryRowCount("billentry");
        for (int i = 0; i < billEntryCount; ++i) {
            Boolean inputMount;
            if (!ChangeTypeEnum.UPDATE.getValue().equals(this.getModel().getValue("entrychangetype", i)) || !(inputMount = (Boolean)this.getModel().getValue("inputamount")).booleanValue() || !"1".equals(this.getPageCache().get("inputamount"))) continue;
            this.getView().setEnable(Boolean.TRUE, i, this.entrybackfields);
        }
        int row = evt.getRow();
        this.setPreTimePoint(row);
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        for (RowDataEntity row : e.getRows()) {
            Boolean inputMount;
            int i = row.getRowIndex() - 1;
            if (!ChangeTypeEnum.UPDATE.getValue().equals(this.getModel().getValue("entrychangetype", i)) || !(inputMount = (Boolean)this.getModel().getValue("inputamount")).booleanValue() || !"1".equals(this.getPageCache().get("inputamount"))) continue;
            this.getView().setEnable(Boolean.TRUE, i, this.entrybackfields);
        }
    }

    public void beforeDeleteRow(BeforeDeleteRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        int[] rowIndexs = e.getRowIndexs();
        if (rowIndexs != null && rowIndexs.length > 0 && "purbillentry_pay".equals(entryName)) {
            if (rowIndexs == null || rowIndexs.length == 0) {
                return;
            }
            AmountPlanHelper.calAmountPlanForView((CommonContext)PurOrderBillHelper.getPayPlanCommonText((String)this.getView().getEntityId()), (IFormView)this.getView());
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        ChangeData[] changeSet;
        String stopChange = this.getPageCache().get("stopChange");
        if ("true".equals(stopChange)) {
            return;
        }
        String billcretype = this.getPageCache().get("billcretype");
        if (BillImportHelper.isImport((String)billcretype)) {
            return;
        }
        if (BillImportHelper.isSkip((String)billcretype)) {
            return;
        }
        String fieldKey = e.getProperty().getName();
        block6: for (ChangeData changeData : changeSet = e.getChangeSet()) {
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            int rowIndex = changeData.getRowIndex();
            if (newValue == null && oldValue == null) {
                return;
            }
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                return;
            }
            switch (fieldKey) {
                case "linetype": {
                    this.changeLineType(oldValue, newValue, rowIndex);
                    continue block6;
                }
            }
        }
    }

    private void setPreTimePoint(int row) {
        Boolean isprepay = (Boolean)this.getModel().getValue("isprepay", row);
        String pretimepoint = (String)this.getModel().getValue("pretimepoint", row);
        String paysrcbillentity = (String)this.getModel().getValue("paysrcbillentity", row);
        if (CONM_PURCONTRACT.equals(paysrcbillentity)) {
            if (isprepay.booleanValue() && PRETIMEPOINT_CONM.equals(pretimepoint)) {
                this.getView().setEnable(Boolean.FALSE, row, new String[]{"payrate"});
                this.getView().setEnable(Boolean.FALSE, row, new String[]{"payamount"});
                this.getView().setEnable(Boolean.FALSE, row, new String[]{"isprepay"});
                this.getView().setEnable(Boolean.FALSE, row, new String[]{"pretimepoint"});
            } else if (!isprepay.booleanValue() || !PRETIMEPOINT_CONM.equals(pretimepoint)) {
                this.getView().setEnable(Boolean.FALSE, row, new String[]{"pretimepoint"});
            }
        }
    }

    private void changeLineType(Object oldValue, Object newValue, int rowIndex) {
        if (oldValue != null && newValue == null) {
            this.getPageCache().put("stopChange", "true");
            this.getModel().setValue("linetype", ((DynamicObject)oldValue).getPkValue(), rowIndex);
            this.getPageCache().put("stopChange", "false");
            return;
        }
        if (ChangeTypeEnum.ADDNEW.getValue().equals(this.getModel().getValue("entrychangetype", rowIndex))) {
            ConfirmCallBackListener callBack = new ConfirmCallBackListener(CONFIRM_LINETYPE, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u201c\u884c\u7c7b\u578b\u201d\u5c06\u6e05\u9664\u5f53\u524d\u5206\u5f55\u7269\u6599\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"XSPurorderBillPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, callBack, null, String.valueOf(rowIndex));
            this.getView().getPageCache().put(CACHE_LINETYPE, oldValue == null ? null : ((DynamicObject)oldValue).getPkValue().toString());
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        super.beforeItemClick(evt);
        String itemKey = evt.getItemKey();
        IDataModel bill = this.getModel();
        String cancelRowOpMsg = ResManager.loadKDString((String)"\u5f53\u524d\u7269\u6599\u660e\u7ec6\u884c\u7684\u53d8\u66f4\u65b9\u5f0f\u4e3a\u201c\u53d6\u6d88\u201d\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"XSPurorderBillPlugin_1", (String)"scmc-pm-formplugin", (Object[])new Object[0]);
        if (MODIFYROW.equalsIgnoreCase(itemKey)) {
            Boolean cancelDelete;
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
            int[] rows = entryGrid.getSelectRows();
            Boolean inputMount = (Boolean)this.getModel().getValue("inputamount");
            if (inputMount.booleanValue() && "1".equals(this.getPageCache().get("inputamount"))) {
                for (int i = 0; i < rows.length; ++i) {
                    this.getView().setEnable(Boolean.TRUE, rows[i], this.entrybackfields);
                }
            }
            if (!(cancelDelete = BillParameterHelper.getIsEnableDeleteLine((String)bill.getDataEntityType().getName())).booleanValue()) {
                return;
            }
            DynamicObjectCollection billEntryList = this.getModel().getDataEntity(true).getDynamicObjectCollection("billentry");
            for (int index : rows) {
                DynamicObject billEntry = (DynamicObject)billEntryList.get(index);
                DynamicObjectCollection purBillEntryDeliver = billEntry.getDynamicObjectCollection("purbillentry_deliver");
                if (purBillEntryDeliver == null || purBillEntryDeliver.isEmpty()) continue;
                for (DynamicObject subRow : purBillEntryDeliver) {
                    String delentrychangetype = subRow.getString("delentrychangetype");
                    if (delentrychangetype == null || ChangeTypeEnum.ADDNEW.getValue().equals(delentrychangetype)) continue;
                    subRow.set("delentrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue());
                }
            }
            this.getView().updateView("purbillentry_deliver");
        } else if (DELETEROW.equals(itemKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("billentry");
            DynamicObjectCollection billEntryList = this.getModel().getDataEntity(true).getDynamicObjectCollection("billentry");
            int[] rows = entryGrid.getSelectRows();
            Boolean cancelDelete = BillParameterHelper.getIsEnableDeleteLine((String)bill.getDataEntityType().getName());
            if (!cancelDelete.booleanValue()) {
                return;
            }
            HashSet<String> changeTypeNumber = new HashSet<String>(8);
            for (int rowIndex : rows) {
                String changeType = (String)this.getModel().getValue("entrychangetype", rowIndex);
                changeTypeNumber.add(changeType);
            }
            if (changeTypeNumber.size() > 1) {
                return;
            }
            Boolean isTax = (Boolean)bill.getValue("istax");
            Boolean inputAmount = (Boolean)bill.getValue("inputamount");
            for (int index : rows) {
                if (inputAmount == Boolean.TRUE) {
                    if (isTax == Boolean.TRUE) {
                        bill.setValue("amountandtax", (Object)BigDecimal.ZERO, index);
                        bill.setValue("qty", (Object)BigDecimal.ZERO, index);
                        bill.setValue("discountrate", (Object)BigDecimal.ZERO, index);
                    } else {
                        bill.setValue("amount", (Object)BigDecimal.ZERO, index);
                        bill.setValue("qty", (Object)BigDecimal.ZERO, index);
                        bill.setValue("discountrate", (Object)BigDecimal.ZERO, index);
                    }
                } else {
                    bill.setValue("qty", (Object)BigDecimal.ZERO, index);
                }
                DynamicObject billEntry = (DynamicObject)billEntryList.get(index);
                DynamicObjectCollection purBillEntryDeliver = billEntry.getDynamicObjectCollection("purbillentry_deliver");
                if (purBillEntryDeliver == null || purBillEntryDeliver.isEmpty()) continue;
                Iterator iterator = purBillEntryDeliver.iterator();
                while (iterator.hasNext()) {
                    DynamicObject subRow = (DynamicObject)iterator.next();
                    String delentrychangetype = subRow.getString("delentrychangetype");
                    if (delentrychangetype != null && ChangeTypeEnum.ADDNEW.getValue().equals(delentrychangetype)) {
                        iterator.remove();
                        continue;
                    }
                    subRow.set("delentrychangetype", (Object)ChangeTypeEnum.CANCEL.getValue());
                }
            }
            this.getView().updateView("purbillentry_deliver");
        } else if (ADDROW_DELIVER.equals(itemKey) || DELETEROW_DELIVER.equals(itemKey) || MODIFYROW_DELIVER.equals(itemKey)) {
            if (evt.isCancel()) {
                return;
            }
            int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
            String changeType = (String)this.getModel().getValue("entrychangetype", entryCurrentRowIndex);
            if (ChangeTypeEnum.CANCEL.getValue().equals(changeType)) {
                evt.setCancel(true);
                this.getView().showTipNotification(cancelRowOpMsg);
                return;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (MODIFYPAYROW.equals(itemKey)) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("purbillentry_pay");
            int[] rows = entryGrid.getSelectRows();
            if (rows == null || rows.length == 0) {
                return;
            }
            AmountPlanHelper.calAmountPlanForView((CommonContext)PurOrderBillHelper.getPayPlanCommonText((String)this.getView().getEntityId()), (IFormView)this.getView());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate source = (AbstractOperate)args.getSource();
        String operateKey = source.getOperateKey();
        if ("submit".equals(operateKey) || "unsubmit".equals(operateKey) || "unaudit".equals(operateKey)) {
            this.resetPurBillEntryPay(operateKey);
        }
        if ("save".equalsIgnoreCase(operateKey) || "submit".equalsIgnoreCase(operateKey)) {
            DynamicObject dataEntity = this.getModel().getDataEntity(true);
            DynamicObjectCollection billEntrys = dataEntity.getDynamicObjectCollection("billentry");
            if (billEntrys == null || billEntrys.isEmpty()) {
                return;
            }
            for (DynamicObject entry : billEntrys) {
                BigDecimal amountAndTax = entry.getBigDecimal("amountandtax");
                BigDecimal amountUp = entry.getBigDecimal("amountup");
                boolean isControlAmountUp = entry.getBoolean("iscontrolamountup");
                if (amountAndTax == null || amountUp == null || isControlAmountUp || amountUp.compareTo(amountAndTax) == 0) continue;
                entry.set("amountup", (Object)amountAndTax);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String key;
        super.confirmCallBack(messageBoxClosedEvent);
        switch (key = messageBoxClosedEvent.getCallBackId()) {
            case "confirm_linetype": {
                String customVaule = messageBoxClosedEvent.getCustomVaule();
                if (StringUtils.isBlank((CharSequence)customVaule)) {
                    return;
                }
                int rowIndex = Integer.parseInt(customVaule);
                if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                    this.getModel().setValue("material", null, rowIndex);
                    this.getModel().setValue("expenseitem", null, rowIndex);
                    break;
                }
                String lineTypeId = this.getView().getPageCache().get(CACHE_LINETYPE);
                this.getModel().beginInit();
                this.getModel().setValue("linetype", (Object)(lineTypeId == null ? null : Long.valueOf(Long.parseLong(lineTypeId))), rowIndex);
                this.getModel().endInit();
                this.getView().updateView("linetype", rowIndex);
                this.getView().getPageCache().remove(CACHE_LINETYPE);
            }
        }
    }

    private void resetPurBillEntryPay(String opSymbol) {
        DynamicObject bill = this.getModel().getDataEntity(true);
        Boolean rowCancel = BillParameterHelper.getIsEnableDeleteLine((String)bill.getDataEntityType().getName());
        if (rowCancel.booleanValue()) {
            DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("billentry");
            boolean flag = true;
            for (DynamicObject row : billEntry) {
                String entryChangeType = row.getString("entrychangetype");
                if ("C".equals(entryChangeType)) continue;
                flag = false;
                break;
            }
            if (flag) {
                DynamicObject entryPay;
                DynamicObjectCollection billEntryPay = bill.getDynamicObjectCollection("purbillentry_pay");
                int size = billEntryPay.size();
                if ("submit".equals(opSymbol)) {
                    for (int i = 0; i < size; ++i) {
                        entryPay = (DynamicObject)billEntryPay.get(i);
                        entryPay.set("payentrychangetype", (Object)ChangeTypeEnum.CANCEL.getValue());
                    }
                }
                if ("unsubmit".equals(opSymbol) || "unaudit".equals(opSymbol)) {
                    for (int i = 0; i < size; ++i) {
                        entryPay = (DynamicObject)billEntryPay.get(i);
                        entryPay.set("payentrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue());
                    }
                }
                this.getView().updateView("purbillentry_pay");
            }
        }
    }
}

