/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.plan;

import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.pm.utils.CommonUtils;

public class PurPlanBillPlugin
extends AbstractBillPlugIn
implements RowClickEventListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getView().getControl("tbmainentry");
        if (toolbar != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "batchsetting": {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                if (org == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurPlanBillPlugin_2", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    return;
                }
                int[] selectRows = ((EntryGrid)this.getControl("billentry")).getSelectRows();
                if (selectRows == null || selectRows.length < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"PurPlanBillPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    return;
                }
                FormShowParameter fsp = new FormShowParameter();
                fsp.setFormId("pm_batchsetting");
                fsp.getOpenStyle().setShowType(ShowType.Modal);
                fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "batchsetting"));
                this.getView().showForm(fsp);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof FormOperate) {
            FormOperate operate = (FormOperate)args.getSource();
            String key = operate.getOperateKey();
            EntryGrid entryGrid = (EntryGrid)this.getControl("billentry");
            int[] selectRows = entryGrid.getSelectRows();
            switch (key) {
                case "rowclose": 
                case "rowunclose": {
                    if (selectRows == null || selectRows.length == 0) {
                        String tip = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5904\u7406\u7684\u7269\u6599\u660e\u7ec6\u884c\u3002", (String)"PurPlanBillPlugin_1", (String)"scmc-pm-formplugin", (Object[])new Object[0]);
                        this.getView().showTipNotification(tip);
                        args.setCancel(true);
                        return;
                    }
                    StringBuilder rowStr = new StringBuilder(String.valueOf(selectRows[0]));
                    for (int i = 1; i < selectRows.length; ++i) {
                        rowStr.append(',').append(String.valueOf(selectRows[i]));
                    }
                    operate.getOption().setVariableValue("selectRows", rowStr.toString());
                    break;
                }
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs a) {
        super.afterDoOperation(a);
        if (a.getSource() instanceof FormOperate) {
            String key;
            FormOperate operate = (FormOperate)a.getSource();
            switch (key = operate.getOperateKey()) {
                case "rowclose": 
                case "rowunclose": {
                    this.getView().updateView();
                    break;
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("batchsetting".equals(actionId)) {
            Map returnData = (Map)e.getReturnData();
            if (returnData == null || returnData.size() == 0) {
                return;
            }
            this.setBatchSetValue(returnData);
            this.getView().updateView("billentry");
        }
    }

    private void setBatchSetValue(Map<String, Object> returnData) {
        Object date;
        Object purMethodObj;
        Long OperatorGroupId;
        Map<Object, DynamicObject> operatorGroupMap;
        int[] selectRows = ((EntryGrid)this.getControl("billentry")).getSelectRows();
        if (selectRows == null || selectRows.length < 1) {
            return;
        }
        DynamicObject entryOperator = null;
        DynamicObject operatorGroupDyObj = null;
        String purMethod = null;
        Date purDate = null;
        Object entryOperatorDy = returnData.get("entryoperator");
        if (!CommonUtils.isNull((Object)entryOperatorDy) && (operatorGroupMap = this.getOperatorGroup(OperatorGroupId = (Long)(entryOperator = (DynamicObject)entryOperatorDy).get("operatorgrpid"))) != null) {
            operatorGroupDyObj = operatorGroupMap.get(entryOperator.get("operatorgrpid"));
        }
        if (!CommonUtils.isNull((Object)(purMethodObj = returnData.get("purmethod")))) {
            purMethod = (String)purMethodObj;
        }
        if (!CommonUtils.isNull((Object)(date = returnData.get("purdate")))) {
            purDate = (Date)date;
        }
        if (entryOperator == null && purMethod == null && purDate == null) {
            return;
        }
        DynamicObject bill = this.getModel().getDataEntity(true);
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("billentry");
        for (int row : selectRows) {
            DynamicObject entryDyObj = (DynamicObject)entrys.get(row);
            if (entryOperator != null) {
                entryDyObj.set("entryoperator", (Object)entryOperator);
                if (operatorGroupDyObj != null) {
                    entryDyObj.set("entryoperatorgroup", (Object)operatorGroupDyObj);
                }
            }
            if (purMethod != null) {
                entryDyObj.set("purmethod", (Object)purMethod);
            }
            if (purDate == null) continue;
            entryDyObj.set("purdate", (Object)purDate);
        }
    }

    private Map<Object, DynamicObject> getOperatorGroup(Long OperatorGroupId) {
        if (OperatorGroupId == null) {
            return null;
        }
        QFilter qFilter2 = new QFilter("id", "=", (Object)OperatorGroupId);
        Map dyObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{qFilter2});
        if (dyObjectMap != null && dyObjectMap.size() > 0) {
            return dyObjectMap;
        }
        return null;
    }
}

