/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.tpl;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.BizTypeHelper;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.helper.CurrencyHelper;
import kd.scmc.pm.business.helper.MaterialHelper;
import kd.scmc.pm.enums.UnitConvertDirEnum;

public class BaseBillTplPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
AfterF7SelectListener {
    private final BigDecimal ZERO = BigDecimal.ZERO;
    private static final String CONFIRM_BIZTYPE = "confirm_biztype";
    private static final String CACHE_BIZTYPE = "cache_biztype";
    private static final String CONFIRM_LINETYPE = "confirm_linetype";
    private static final String CACHE_LINETYPE = "cache_linetype";

    public void registerListener(EventObject e) {
        BasedataEdit entryBizType;
        BasedataEdit taxRateIDEdit;
        BasedataEdit materialversionEdit;
        BasedataEdit unitEdit;
        BasedataEdit materialMasterEdit;
        BasedataEdit materialEdit;
        BasedataEdit bizTypeEdit;
        super.registerListener(e);
        IFormView view = this.getView();
        Toolbar toolbar = (Toolbar)view.getControl("tbmainentry");
        if (toolbar != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
        if ((bizTypeEdit = (BasedataEdit)view.getControl("biztype")) != null) {
            bizTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((materialEdit = (BasedataEdit)view.getControl("material")) != null) {
            materialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            materialEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
        if ((materialMasterEdit = (BasedataEdit)view.getControl("materialmasterid")) != null) {
            materialMasterEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((unitEdit = (BasedataEdit)view.getControl("unit")) != null) {
            unitEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((materialversionEdit = (BasedataEdit)view.getControl("materialversion")) != null) {
            materialversionEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((taxRateIDEdit = (BasedataEdit)view.getControl("taxrateid")) != null) {
            taxRateIDEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryBizType = (BasedataEdit)this.getView().getControl("linetype")) != null) {
            entryBizType.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        String formId;
        Long bizTypeId;
        IDataModel model = this.getModel();
        DynamicObject billType = (DynamicObject)model.getValue("billtype");
        if (billType != null && (bizTypeId = BizTypeHelper.getDefaultBizType((String)(formId = this.getView().getEntityId()), (Long)((Long)billType.getPkValue()), (String)"pm_billtypeparameter")) != null) {
            model.beginInit();
            this.getModel().setValue("biztype", (Object)bizTypeId);
            model.endInit();
            Long lineType = BizTypeHelper.getDefaultLineType((Long)bizTypeId);
            if (lineType != null) {
                int entryRowCount = model.getEntryRowCount("billentry");
                for (int i = 0; i < entryRowCount; ++i) {
                    model.setValue("linetype", (Object)lineType, i);
                }
            }
        }
        long userId = UserServiceHelper.getCurrentUserId();
        model.setValue("bizuser", (Object)userId);
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            return;
        }
        Long orgId = (Long)org.getPkValue();
        Map currencyAndExRateMap = CurrencyHelper.getCurrencyAndExRateTable((Long)orgId);
        if (currencyAndExRateMap != null) {
            model.setValue("currency", currencyAndExRateMap.get("baseCurrencyID"));
        }
    }

    public void beforeBindData(EventObject e) {
        super.afterLoadData(e);
        IDataModel model = this.getModel();
        DynamicObjectCollection billEntry = model.getDataEntity(true).getDynamicObjectCollection("billentry");
        if (billEntry != null && !billEntry.isEmpty()) {
            model.beginInit();
            DataEntityPropertyCollection properties = ((DynamicObject)billEntry.get(0)).getDynamicObjectType().getProperties();
            DynamicProperty materialProp = (DynamicProperty)properties.get((Object)"material");
            DynamicProperty materialNameProp = (DynamicProperty)properties.get((Object)"materialname");
            for (DynamicObject entry : billEntry) {
                DynamicObject masterid;
                DynamicObject material = (DynamicObject)materialProp.getValueFast((Object)entry);
                String materialName = (String)materialNameProp.getValueFast((Object)entry);
                if (material == null || !StringUtils.isBlank((CharSequence)materialName) || (masterid = material.getDynamicObject("masterid")) == null) continue;
                materialName = masterid.getLocaleString("name").toString();
                materialNameProp.setValueFast((Object)entry, (Object)materialName);
            }
            model.endInit();
            model.setDataChanged(false);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String stopChange = this.getPageCache().get("stopChange");
        if ("true".equals(stopChange)) {
            return;
        }
        String fieldKey = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        block18: for (int i = 0; i < changeSet.length; ++i) {
            ChangeData changeData = changeSet[i];
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            int rowIndex = changeData.getRowIndex();
            if (newValue == null && oldValue == null) {
                return;
            }
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                return;
            }
            if (oldValue instanceof BigDecimal && newValue instanceof BigDecimal && ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) == 0) {
                return;
            }
            switch (fieldKey) {
                case "material": {
                    this.changeMaterial(oldValue, newValue, rowIndex);
                    continue block18;
                }
                case "auxqty": {
                    this.changeAuxQty(newValue, rowIndex);
                    continue block18;
                }
                case "qty": {
                    this.changeQty(newValue, rowIndex);
                    continue block18;
                }
                case "unit": {
                    this.changeUnit(newValue, rowIndex);
                    continue block18;
                }
                case "biztype": {
                    this.changeBizType(oldValue, newValue);
                    continue block18;
                }
                case "billtype": {
                    this.changeBillType(newValue);
                    continue block18;
                }
                case "linetype": {
                    String entityId = this.getView().getEntityId();
                    if ("pm_xpurapplybill".equals(entityId) || "pm_xpurplanbill".equals(entityId)) continue block18;
                    this.changeLineType(oldValue, newValue, rowIndex);
                    continue block18;
                }
            }
        }
    }

    private void changeLineType(Object oldValue, Object newValue, int rowIndex) {
        if (oldValue != null && newValue == null) {
            this.getPageCache().put("stopChange", "true");
            this.getModel().setValue("linetype", ((DynamicObject)oldValue).getPkValue(), rowIndex);
            this.getPageCache().put("stopChange", "false");
            return;
        }
        Long srcBillId = (Long)this.getModel().getValue("srcbillid", rowIndex);
        Long srcBillEntryId = (Long)this.getModel().getValue("srcbillentryid", rowIndex);
        if (srcBillId != null && !srcBillId.equals(0L) || srcBillEntryId != null && !srcBillEntryId.equals(0L)) {
            return;
        }
        ConfirmCallBackListener callBack = new ConfirmCallBackListener(CONFIRM_LINETYPE, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u201c\u884c\u7c7b\u578b\u201d\u5c06\u6e05\u9664\u5f53\u524d\u5206\u5f55\u7269\u6599\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"BaseBillTplPlugin_16", (String)"scmc-pm-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, callBack, null, String.valueOf(rowIndex));
        this.getView().getPageCache().put(CACHE_LINETYPE, oldValue == null ? null : ((DynamicObject)oldValue).getPkValue().toString());
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        IDataModel model = this.getModel();
        String entryName = e.getEntryProp().getName();
        if ("billentry".equals(entryName)) {
            RowDataEntity[] rowDataEntities = e.getRowDataEntities();
            DynamicObject bizType = (DynamicObject)model.getValue("biztype");
            if (bizType == null) {
                return;
            }
            Long lineTypeId = BizTypeHelper.getDefaultLineType((Long)((Long)bizType.getPkValue()));
            if (lineTypeId == null) {
                return;
            }
            for (RowDataEntity rowDataEntity : rowDataEntities) {
                int rowIndex = rowDataEntity.getRowIndex();
                DynamicObject lineType = (DynamicObject)model.getValue("linetype", rowIndex);
                if (lineType != null) continue;
                this.getPageCache().put("stopChange", "true");
                model.setValue("linetype", (Object)lineTypeId, rowIndex);
                this.getPageCache().put("stopChange", "false");
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)CONFIRM_BIZTYPE, (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getModel().deleteEntryData("billentry");
                EntryProp entryProp = (EntryProp)this.getModel().getDataEntityType().findProperty("billentry");
                int defaultRows = entryProp.getDefaultRows();
                this.getModel().batchCreateNewEntryRow("billentry", defaultRows);
            } else {
                String bizTypeId = this.getView().getPageCache().get(CACHE_BIZTYPE);
                this.getModel().beginInit();
                this.getModel().setValue("biztype", bizTypeId == null ? null : Long.valueOf(Long.parseLong(bizTypeId)));
                this.getModel().endInit();
                this.getView().updateView("biztype");
            }
        }
        if (StringUtils.equals((CharSequence)CONFIRM_LINETYPE, (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            String customVaule = messageBoxClosedEvent.getCustomVaule();
            if (StringUtils.isBlank((CharSequence)customVaule)) {
                return;
            }
            int rowIndex = Integer.parseInt(customVaule);
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                this.getModel().setValue("material", null, rowIndex);
            } else {
                String lineTypeId = this.getView().getPageCache().get(CACHE_LINETYPE);
                this.getModel().beginInit();
                this.getModel().setValue("linetype", (Object)(lineTypeId == null ? null : Long.valueOf(Long.parseLong(lineTypeId))), rowIndex);
                this.getModel().endInit();
                this.getView().updateView("linetype", rowIndex);
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        if (!"org".equals(fieldKey)) {
            if (org == null) {
                String localeValue = ((IDataEntityProperty)model.getDataEntityType().getProperties().get((Object)"org")).getDisplayName().getLocaleValue();
                String var = String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9%s\u3002", (String)"BaseBillTplPlugin_15", (String)"scmc-pm-formplugin", (Object[])new Object[0]), localeValue);
                this.getView().showTipNotification(var);
                e.setCancel(true);
                return;
            }
            if (billType == null && !"billtype".equals(fieldKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u7c7b\u578b\u3002", (String)"BaseBillTplPlugin_11", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String formId = this.getView().getEntityId();
        int rowIndex = e.getRow();
        DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
        DynamicObject lineType = (DynamicObject)model.getValue("linetype", rowIndex);
        DynamicObject masterMaterial = material != null ? material.getDynamicObject("masterid") : null;
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        Long billTypeId = billType == null ? null : (Long)billType.getPkValue();
        switch (fieldKey) {
            case "biztype": {
                List bizTypeIds = BizTypeHelper.getAllBizTypes((String)formId, (Long)billTypeId, (String)"pm_billtypeparameter");
                if (bizTypeIds == null) break;
                QFilter q1 = new QFilter("id", "in", (Object)bizTypeIds);
                showParameter.getListFilterParameter().getQFilters().add(q1);
                break;
            }
            case "linetype": {
                if (bizType == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"BaseBillTplPlugin_12", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                List allLineTypes = BizTypeHelper.getAllLineTypes((Long)((Long)bizType.getPkValue()));
                if (allLineTypes == null) break;
                QFilter filter = new QFilter("id", "in", (Object)allLineTypes);
                showParameter.getListFilterParameter().getQFilters().add(filter);
                break;
            }
            case "material": {
                DynamicObject entryBizType;
                if (lineType == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u7c7b\u578b\u3002", (String)"BaseBillTplPlugin_14", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                List materialQFilters = MaterialHelper.getQFilterByLineType((Long)billTypeId, (Long)(bizType == null ? null : (Long)bizType.getPkValue()), (Long)((entryBizType = (DynamicObject)this.getModel().getValue("linetype", rowIndex)) == null ? null : (Long)entryBizType.getPkValue()), (String)formId, (boolean)true);
                if (materialQFilters == null) break;
                showParameter.getListFilterParameter().getQFilters().addAll(materialQFilters);
                break;
            }
            case "materialmasterid": {
                if (lineType == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u7c7b\u578b\u3002", (String)"BaseBillTplPlugin_14", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                List filters = MaterialHelper.getQFilterByLineType((Long)billTypeId, (Long)(bizType == null ? null : (Long)bizType.getPkValue()), (Long)((Long)lineType.getPkValue()), (String)formId, (boolean)true);
                if (filters == null) break;
                showParameter.getListFilterParameter().getQFilters().addAll(filters);
                break;
            }
            case "unit": {
                if (masterMaterial == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u7f16\u7801\u3002", (String)"BaseBillTplPlugin_9", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
                long srcmuId = baseUnit == null ? 0L : (Long)baseUnit.getPkValue();
                Long masterMaterialId = (Long)masterMaterial.getPkValue();
                List unitIds = BaseDataServiceHelper.getAssistMUListResult((Long)masterMaterialId, (Long)srcmuId, (String)"1");
                QFilter qFilter = new QFilter("id", "in", (Object)unitIds);
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
            case "materialversion": {
                if (masterMaterial == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u7f16\u7801\u3002", (String)"BaseBillTplPlugin_9", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                Long masterMaterialId = (Long)masterMaterial.getPkValue();
                QFilter qFilter = new QFilter("material", "=", (Object)masterMaterialId);
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
            case "taxrateid": {
                Date bizTime = (Date)model.getValue("biztime");
                QFilter activeQfilter = new QFilter("activedate", "<=", (Object)bizTime);
                QFilter expQfilter = new QFilter("expdate", ">", (Object)bizTime);
                expQfilter = QFilter.isNull((String)"expdate").or(expQfilter);
                QFilter qFilter = expQfilter.and(activeQfilter);
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
        }
    }

    private void changeBizType(Object oldValue, Object newValue) {
        DynamicObject bizType_old = (DynamicObject)oldValue;
        String msg = ResManager.loadKDString((String)"\u5207\u6362\u4e1a\u52a1\u7c7b\u578b\u5c06\u6e05\u9664\u5f53\u524d\u5355\u636e\u7269\u6599\u660e\u7ec6\u4fe1\u606f\uff0c\u662f\u5426\u786e\u8ba4\uff1f", (String)"BaseBillTplPlugin_10", (String)"scmc-pm-formplugin", (Object[])new Object[0]);
        MessageBoxOptions options = MessageBoxOptions.YesNo;
        ConfirmCallBackListener callBack = new ConfirmCallBackListener(CONFIRM_BIZTYPE, (IFormPlugin)this);
        this.getView().showConfirm(msg, options, ConfirmTypes.Default, callBack);
        this.getView().getPageCache().put(CACHE_BIZTYPE, bizType_old == null ? null : bizType_old.getPkValue().toString());
    }

    private void changeMaterial(Object oldValue, Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        model.setValue("materialname", null, rowIndex);
        model.setValue("materialmasterid", null, rowIndex);
        model.setValue("materialversion", null, rowIndex);
        model.setValue("auxpty", null, rowIndex);
        model.setValue("unit", null, rowIndex);
        model.setValue("auxunit", null, rowIndex);
        model.setValue("baseunit", null, rowIndex);
        model.setValue("qty", (Object)this.ZERO, rowIndex);
        model.setValue("auxqty", (Object)this.ZERO, rowIndex);
        model.setValue("baseqty", (Object)this.ZERO, rowIndex);
        if (newValue instanceof DynamicObject) {
            DynamicObject material = (DynamicObject)newValue;
            DynamicObject master = material.getDynamicObject("masterid");
            if (master != null) {
                model.setValue("materialmasterid", master.getPkValue(), rowIndex);
                model.setValue("materialname", master.getLocaleString("name") != null ? master.getLocaleString("name").toString() : null, rowIndex);
                if (master.getDynamicObject("auxptyunit") != null) {
                    model.setValue("auxunit", master.getDynamicObject("auxptyunit").getPkValue(), rowIndex);
                }
                if (master.getDynamicObject("baseunit") != null) {
                    model.setValue("baseunit", master.getDynamicObject("baseunit").getPkValue(), rowIndex);
                }
            }
            if (material.getDynamicObject("purchaseunit") != null) {
                model.setValue("unit", material.getDynamicObject("purchaseunit").getPkValue(), rowIndex);
            }
        }
    }

    private void changeQty(Object newValue, int rowIndex) {
        if (newValue instanceof BigDecimal) {
            IDataModel model = this.getModel();
            BigDecimal qty = (BigDecimal)newValue;
            DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
            DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
            if (material == null || unit == null) {
                return;
            }
            DynamicObject master = material.getDynamicObject("masterid");
            DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
            DynamicObject auxUnit = (DynamicObject)model.getValue("auxunit", rowIndex);
            model.beginInit();
            if (baseUnit == null && master != null && (baseUnit = master.getDynamicObject("baseunit")) != null) {
                model.setValue("baseunit", baseUnit.getPkValue(), rowIndex);
            }
            if (baseUnit != null && master != null) {
                Long masterId = (Long)master.getPkValue();
                BigDecimal baseQty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterId, (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
                model.setValue("baseqty", (Object)baseQty, rowIndex);
                if (auxUnit != null) {
                    String unitConvertDir = master.getString("unitconvertdir");
                    if (UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                        BigDecimal auxQty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterId, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)auxUnit);
                        model.setValue("auxqty", (Object)auxQty, rowIndex);
                    }
                }
            }
            model.endInit();
            this.getView().updateView("baseunit", rowIndex);
            this.getView().updateView("baseqty", rowIndex);
            this.getView().updateView("auxqty", rowIndex);
        }
    }

    private void changeUnit(Object newValue, int rowIndex) {
        if (newValue instanceof DynamicObject) {
            DynamicObject unit = (DynamicObject)newValue;
            IDataModel model = this.getModel();
            DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
            BigDecimal qty = (BigDecimal)model.getValue("qty", rowIndex);
            int precision = BillQtyAndUnitHelper.getPrecision((DynamicObject)unit);
            int precisionaccount = BillQtyAndUnitHelper.getPrecisionType((DynamicObject)unit);
            qty = qty.setScale(precision, precisionaccount);
            model.beginInit();
            model.setValue("qty", (Object)qty, rowIndex);
            model.endInit();
            if (material != null && qty != null && qty.compareTo(this.ZERO) != 0) {
                DynamicObject master = material.getDynamicObject("masterid");
                DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
                DynamicObject auxUnit = (DynamicObject)model.getValue("auxunit", rowIndex);
                model.beginInit();
                if (baseUnit == null && master != null && (baseUnit = master.getDynamicObject("baseunit")) != null) {
                    model.setValue("baseunit", baseUnit.getPkValue(), rowIndex);
                }
                if (baseUnit != null && master != null) {
                    Long masterId = (Long)master.getPkValue();
                    BigDecimal baseQty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterId, (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
                    model.setValue("baseqty", (Object)baseQty, rowIndex);
                    if (auxUnit != null) {
                        String unitConvertDir = master.getString("unitconvertdir");
                        if (UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                            BigDecimal auxQty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterId, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)auxUnit);
                            model.setValue("auxqty", (Object)auxQty, rowIndex);
                        }
                    }
                }
                model.endInit();
                this.getView().updateView("baseunit", rowIndex);
                this.getView().updateView("baseqty", rowIndex);
                this.getView().updateView("auxqty", rowIndex);
                this.getView().updateView("qty", rowIndex);
            }
        }
    }

    private void changeAuxQty(Object newValue, int rowIndex) {
        if (newValue instanceof BigDecimal) {
            IDataModel model = this.getModel();
            BigDecimal auxQty = (BigDecimal)newValue;
            DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
            DynamicObject auxUnit = (DynamicObject)model.getValue("auxunit", rowIndex);
            if (material == null || auxUnit == null) {
                return;
            }
            DynamicObject master = material.getDynamicObject("masterid");
            DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
            DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
            if (baseUnit == null && master != null && (baseUnit = master.getDynamicObject("baseunit")) != null) {
                model.setValue("baseunit", baseUnit.getPkValue(), rowIndex);
            }
            if (baseUnit != null && unit != null && master != null) {
                Long masterId = (Long)master.getPkValue();
                String unitConvertDir = master.getString("unitconvertdir");
                if (UnitConvertDirEnum.U2ND_UINV.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                    BigDecimal baseQty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterId, (DynamicObject)auxUnit, (BigDecimal)auxQty, (DynamicObject)baseUnit);
                    BigDecimal qty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterId, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)unit);
                    model.beginInit();
                    model.setValue("baseqty", (Object)baseQty, rowIndex);
                    model.setValue("qty", (Object)qty, rowIndex);
                    model.endInit();
                }
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        if ("material".equals(key)) {
            Long lineTypeID;
            int currentRowIndex = e.getCurrentRowIndex();
            ListSelectedRowCollection listSelectedRowCollection = e.getListSelectedRowCollection();
            DynamicObject lineType = (DynamicObject)this.getModel().getValue("linetype", currentRowIndex);
            Long l = lineTypeID = lineType == null ? null : (Long)lineType.getPkValue();
            if (listSelectedRowCollection.size() > 1) {
                for (int i = 1; i < listSelectedRowCollection.size(); ++i) {
                    this.getPageCache().put("stopChange", "true");
                    this.getModel().setValue("linetype", (Object)lineTypeID, i + currentRowIndex);
                    this.getPageCache().put("stopChange", "false");
                }
            }
        }
    }

    private void changeBillType(Object newValue) {
        if (newValue instanceof DynamicObject) {
            Long billTypeId = (Long)((DynamicObject)newValue).getPkValue();
            String formId = this.getView().getEntityId();
            Long defaultBizType = BizTypeHelper.getDefaultBizType((String)formId, (Long)billTypeId, (String)"pm_billtypeparameter");
            this.getModel().setValue("biztype", (Object)defaultBizType);
        }
    }
}

