/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.tpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.OperatorGroupFilterHelper;
import kd.scmc.pm.business.helper.AppParameterHelper;
import kd.scmc.pm.business.helper.BillImportHelper;
import kd.scmc.pm.business.helper.OperatorGroupHelper;
import kd.scmc.pm.business.helper.OrgHelper;
import kd.scmc.pm.enums.OperatorGrpTypeEnum;
import kd.scmc.pm.formplugin.tpl.BillTplPlugin;
import kd.scmc.pm.utils.CommonUtils;

public class BillBizInfoPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private final Log log = LogFactory.getLog(BillTplPlugin.class);

    public void registerListener(EventObject e) {
        BasedataEdit deptEdit;
        BasedataEdit operatorEdit;
        super.registerListener(e);
        IFormView view = this.getView();
        BasedataEdit operatorGroupEdit = (BasedataEdit)view.getControl("operatorgroup");
        if (operatorGroupEdit != null) {
            operatorGroupEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((operatorEdit = (BasedataEdit)view.getControl("operator")) != null) {
            operatorEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((deptEdit = (BasedataEdit)view.getControl("dept")) != null) {
            deptEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject operator;
        long userId;
        String stopChange = this.getPageCache().get("stopChange");
        if ("true".equals(stopChange)) {
            return;
        }
        String billcretype = this.getPageCache().get("billcretype");
        if (BillImportHelper.isAPI((String)billcretype) || BillImportHelper.isImport((String)billcretype)) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        Long orgId = (Long)org.getPkValue();
        Map operatorAndGroup = OperatorGroupHelper.getDefaultOperatorAndGroupByOrg((Long)orgId, (Long)(userId = UserServiceHelper.getCurrentUserId()));
        if (!operatorAndGroup.isEmpty() && (operator = (DynamicObject)operatorAndGroup.get("operator")) != null) {
            model.setValue("operator", operator.getPkValue());
            model.setValue("operatorgroup", operator.get("operatorgrpid"));
            Long deptId = UserServiceHelper.getUserMainOrgId((long)userId);
            model.setValue("dept", (Object)deptId);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String fieldName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        block8: for (int i = 0; i < changeSet.length; ++i) {
            ChangeData changeData = changeSet[i];
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            if (newValue == null && oldValue == null) {
                return;
            }
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                return;
            }
            if (oldValue instanceof BigDecimal && newValue instanceof BigDecimal && ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) == 0) {
                return;
            }
            switch (fieldName) {
                case "operatorgroup": {
                    this.changeOperatorGroup(newValue);
                    continue block8;
                }
                case "operator": {
                    this.changeOperator(newValue);
                    continue block8;
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"BillTplPlugin_25", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        Long orgId = (Long)org.getPkValue();
        Long userId = UserServiceHelper.getCurrentUserId();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        switch (fieldKey) {
            case "operator": {
                QFilter q1 = new QFilter("invalid", "=", (Object)Boolean.FALSE);
                try {
                    Object operatorGroupIsolate = AppParameterHelper.getPmAppParameter((Long)orgId, (String)"foperatorgroupisolate");
                    if (operatorGroupIsolate instanceof Boolean && ((Boolean)operatorGroupIsolate).booleanValue()) {
                        QFilter q2 = OperatorGroupFilterHelper.getOperatorGroupByUserForAll((long)UserServiceHelper.getCurrentUserId(), (DynamicObject)org, (String)OperatorGrpTypeEnum.PURCHASEGRP.getValue());
                        showParameter.getListFilterParameter().getQFilters().add(q1.and(q2));
                        break;
                    }
                    QFilter q3 = new QFilter("operatorgrpid", "in", (Object)OperatorGroupHelper.getOperatorGroupByOrg((Long)orgId));
                    showParameter.getListFilterParameter().getQFilters().add(q1.and(q3));
                }
                catch (Exception ee) {
                    showParameter.getListFilterParameter().getQFilters().add(q1);
                    this.log.error(ee.getMessage());
                }
                break;
            }
            case "operatorgroup": {
                DynamicObject operator1 = (DynamicObject)model.getValue("operator");
                if (operator1 == null) {
                    showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "=", (Object)0));
                    break;
                }
                QFilter q4 = new QFilter("operatorgrouptype", "=", (Object)OperatorGrpTypeEnum.PURCHASEGRP.getValue());
                QFilter q5 = new QFilter("entryentity.id", "=", operator1.getPkValue());
                showParameter.getListFilterParameter().getQFilters().add(q4.and(q5));
                break;
            }
            case "dept": {
                DynamicObject user;
                List deptIDs = OrgHelper.getAllToOrg((String)"15", (String)"01", (Long)orgId, (boolean)true);
                DynamicObject operator2 = (DynamicObject)model.getValue("operator");
                if (operator2 != null && (user = operator2.getDynamicObject("operatorid")) != null) {
                    Long userID = (Long)user.getPkValue();
                    Long deptID = UserServiceHelper.getUserMainOrgId((long)userID);
                    deptIDs.add(deptID);
                }
                QFilter q6 = new QFilter("id", "in", (Object)deptIDs);
                showParameter.getListFilterParameter().getQFilters().add(q6);
                break;
            }
        }
    }

    private void changeOperatorGroup(Object newValue) {
        if (newValue == null) {
            this.getModel().beginInit();
            this.getModel().setValue("operator", null);
            this.getModel().endInit();
            this.getView().updateView("operator");
            this.getModel().setValue("dept", null);
        }
    }

    private void changeOperator(Object newValue) {
        Long deptID = null;
        this.getModel().beginInit();
        if (newValue instanceof DynamicObject) {
            Long userID;
            DynamicObject operator = (DynamicObject)newValue;
            this.getModel().setValue("operatorgroup", operator.get("operatorgrpid"));
            Long l = userID = operator.get("operatorid") != null ? (Long)((DynamicObject)operator.get("operatorid")).getPkValue() : null;
            if (userID != null) {
                deptID = UserServiceHelper.getUserMainOrgId((long)userID);
            }
        } else {
            this.getModel().setValue("operatorgroup", null);
        }
        this.getModel().endInit();
        this.getView().updateView("operatorgroup");
        this.getModel().setValue("dept", deptID);
    }

    private ArrayList<Long> getOperatorGroupByUser(Long userID, Long orgID) {
        ArrayList<Long> operatorGroupList = new ArrayList<Long>();
        QFilter qFilter1 = new QFilter("operatorid", "=", (Object)userID);
        QFilter qFilter2 = new QFilter("opergrptype", "=", (Object)OperatorGrpTypeEnum.PURCHASEGRP.getValue());
        QFilter qFilter3 = new QFilter("operatorgrpid", "in", (Object)OperatorGroupHelper.getOperatorGroupByOrg((Long)orgID));
        QFilter qFilter4 = new QFilter("invalid", "=", (Object)Boolean.FALSE);
        Map map = BusinessDataServiceHelper.loadFromCache((String)"bd_operator", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3, qFilter4});
        if (!CommonUtils.isNull((Object)map)) {
            ArrayList list = new ArrayList(map.values());
            for (int i = 0; i < list.size(); ++i) {
                operatorGroupList.add(((DynamicObject)list.get(i)).getLong("operatorgrpid"));
            }
        }
        return operatorGroupList;
    }
}

