/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.formplugin.tpl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.EntryGridBindDataEvent;
import kd.bos.form.control.events.EntryGridBindDataListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.form.ClientViewProxy;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mpscmm.msbd.business.helper.BizTypeHelper;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.pm.business.helper.AmountHelper;
import kd.scmc.pm.business.helper.BillImportHelper;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.helper.BizCategoryHelper;
import kd.scmc.pm.business.helper.CurrencyHelper;
import kd.scmc.pm.business.helper.MaterialHelper;
import kd.scmc.pm.business.helper.SupplierHelper;
import kd.scmc.pm.business.pojo.AmountPropertyKey;
import kd.scmc.pm.enums.DiscountTypeEnum;
import kd.scmc.pm.enums.PayModeEnum;
import kd.scmc.pm.enums.UnitConvertDirEnum;

public class BillTplPlugin
extends AbstractBillPlugIn
implements EntryGridBindDataListener,
BeforeF7SelectListener,
AfterF7SelectListener {
    private static final String LM_INVALID = "invalid";
    private static final String PROP_SUPPLIERID = "supplierid";
    private static final String CUR_AMTPRECISION = "amtprecision";
    private static final String CUR_PRICEPRECISION = "priceprecision";
    private static final String CONFIRM_BIZTYPE = "confirm_biztype";
    private static final String CACHE_BIZTYPE = "cache_biztype";
    private static final String CONFIRM_LINETYPE = "confirm_linetype";
    private static final String CACHE_LINETYPE = "cache_linetype";

    public void initialize() {
        EntryGrid billEntry = (EntryGrid)this.getControl("billentry");
        if (billEntry != null) {
            billEntry.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void registerListener(EventObject e) {
        EntryGrid billEntry;
        Toolbar toolbar;
        BasedataEdit taxRateIDEdit;
        BasedataEdit materialversionEdit;
        BasedataEdit unitEdit;
        BasedataEdit materialEdit;
        BasedataEdit entryBizTypeEdit;
        BasedataEdit supplierLinkmanEdit;
        BasedataEdit lierLinkmanEdit;
        BasedataEdit invoiceSupplierEdit;
        BasedataEdit ReceiveSupplierEdit;
        BasedataEdit providerSupplierEdit;
        BasedataEdit supplierEdit;
        BasedataEdit invoiceBizTypeEdit;
        super.registerListener(e);
        IFormView view = this.getView();
        BasedataEdit bizTypeEdit = (BasedataEdit)view.getControl("biztype");
        if (bizTypeEdit != null) {
            bizTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((invoiceBizTypeEdit = (BasedataEdit)view.getControl("invoicebiztype")) != null) {
            invoiceBizTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplierEdit = (BasedataEdit)view.getControl("supplier")) != null) {
            supplierEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((providerSupplierEdit = (BasedataEdit)view.getControl("providersupplier")) != null) {
            providerSupplierEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((ReceiveSupplierEdit = (BasedataEdit)view.getControl("receivesupplier")) != null) {
            ReceiveSupplierEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((invoiceSupplierEdit = (BasedataEdit)view.getControl("invoicesupplier")) != null) {
            invoiceSupplierEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((lierLinkmanEdit = (BasedataEdit)view.getControl("linkman")) != null) {
            lierLinkmanEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplierLinkmanEdit = (BasedataEdit)view.getControl("providerlinkman")) != null) {
            supplierLinkmanEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((entryBizTypeEdit = (BasedataEdit)view.getControl("linetype")) != null) {
            entryBizTypeEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((materialEdit = (BasedataEdit)view.getControl("material")) != null) {
            materialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
            materialEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        }
        if ((unitEdit = (BasedataEdit)view.getControl("unit")) != null) {
            unitEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((materialversionEdit = (BasedataEdit)view.getControl("materialversion")) != null) {
            materialversionEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((taxRateIDEdit = (BasedataEdit)view.getControl("taxrateid")) != null) {
            taxRateIDEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((toolbar = (Toolbar)this.getView().getControl("tbmainentry")) != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
        if ((billEntry = (EntryGrid)view.getControl("billentry")) != null) {
            billEntry.addDataBindListener((EntryGridBindDataListener)this);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setPriceAndPriceAndTaxEnable();
        this.getView().setEnable(Boolean.FALSE, -1, new String[]{"amountandtax"});
        this.getView().setEnable(Boolean.FALSE, -1, new String[]{"amount"});
        IDataModel model = this.getModel();
        DynamicObjectCollection billEntry = model.getDataEntity(true).getDynamicObjectCollection("billentry");
        if (billEntry != null && !billEntry.isEmpty()) {
            model.beginInit();
            DataEntityPropertyCollection properties = ((DynamicObject)billEntry.get(0)).getDynamicObjectType().getProperties();
            DynamicProperty materialProp = (DynamicProperty)properties.get((Object)"material");
            DynamicProperty materialNameProp = (DynamicProperty)properties.get((Object)"materialname");
            for (DynamicObject entry : billEntry) {
                DynamicObject masterId;
                DynamicObject material = (DynamicObject)materialProp.getValueFast((Object)entry);
                String materialName = (String)materialNameProp.getValueFast((Object)entry);
                if (material == null || !StringUtils.isBlank((CharSequence)materialName) || (masterId = material.getDynamicObject("masterid")) == null) continue;
                materialName = masterId.getLocaleString("name").toString();
                materialNameProp.setValueFast((Object)entry, (Object)materialName);
            }
            model.endInit();
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.setDiscountRateScale(this.getModel().getValue("settlecurrency"));
    }

    public void afterCreateNewData(EventObject e) {
        Map currencyAndExRateMap;
        Long orgID;
        Long bizTypeId;
        String stopChange = this.getPageCache().get("stopChange");
        if ("true".equals(stopChange)) {
            return;
        }
        String billcretype = this.getPageCache().get("billcretype");
        if (BillImportHelper.isSkip((String)billcretype)) {
            return;
        }
        if (BillImportHelper.isImport((String)billcretype)) {
            return;
        }
        IDataModel model = this.getModel();
        DynamicObject billType = (DynamicObject)model.getValue("billtype");
        DynamicObject bizType = (DynamicObject)model.getValue("biztype");
        Long l = bizTypeId = bizType == null ? null : (Long)bizType.getPkValue();
        if (bizType == null && billType != null && billType.getPkValue() != null) {
            String formId = this.getView().getEntityId();
            bizTypeId = BizTypeHelper.getDefaultBizType((String)formId, (Long)((Long)billType.getPkValue()), (String)"pm_billtypeparameter");
            this.getModel().setValue("biztype", (Object)bizTypeId);
        }
        Long lineTypeId = BizTypeHelper.getDefaultLineType((Long)bizTypeId);
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        Long l2 = orgID = org == null ? null : (Long)org.getPkValue();
        if (orgID != null && (currencyAndExRateMap = CurrencyHelper.getCurrencyAndExRateTable((Long)orgID)) != null) {
            model.setValue("currency", currencyAndExRateMap.get("baseCurrencyID"));
            model.setValue("settlecurrency", currencyAndExRateMap.get("baseCurrencyID"));
            model.setValue("exratetable", currencyAndExRateMap.get("exchangeRateTableID"));
        }
        int entryRowCount = model.getEntryRowCount("billentry");
        for (int i = 0; i < entryRowCount; ++i) {
            if (orgID != null) {
                model.setValue("entrypurorg", (Object)orgID, i);
            }
            model.setValue("linetype", (Object)lineTypeId, i);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        if (rowDataEntities == null || rowDataEntities.length < 1) {
            return;
        }
        if ("billentry".equals(entryName)) {
            this.calcTotalAllAmount(rowDataEntities);
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
            if (org == null) {
                return;
            }
            Long orgId = (Long)org.getPkValue();
            Long bizTypeId = null;
            if (bizType != null) {
                bizTypeId = (Long)bizType.getPkValue();
            }
            Long lineTypeId = BizTypeHelper.getDefaultLineType(bizTypeId);
            for (RowDataEntity rowDataEntity : rowDataEntities) {
                int rowIndex = rowDataEntity.getRowIndex();
                this.getModel().setValue("entrypurorg", (Object)orgId, rowIndex);
                DynamicObject lineType = (DynamicObject)this.getModel().getValue("linetype", rowIndex);
                if (lineType != null) continue;
                this.getPageCache().put("stopChange", "true");
                this.getModel().setValue("linetype", (Object)lineTypeId, rowIndex);
                this.getPageCache().put("stopChange", "false");
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String entryName = e.getEntryProp().getName();
        if ("billentry".equals(entryName)) {
            this.calcTotalAmount();
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String stopChange = this.getPageCache().get("stopChange");
        if ("true".equals(stopChange)) {
            return;
        }
        String billcretype = this.getPageCache().get("billcretype");
        if (BillImportHelper.isSkip((String)billcretype)) {
            return;
        }
        if (BillImportHelper.isImport((String)billcretype)) {
            return;
        }
        String fieldName = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        block43: for (int i = 0; i < changeSet.length; ++i) {
            ChangeData changeData = changeSet[i];
            Object newValue = changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            int rowIndex = changeData.getRowIndex();
            if (newValue == null && oldValue == null) {
                return;
            }
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                return;
            }
            if (oldValue instanceof BigDecimal && newValue instanceof BigDecimal && ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) == 0) {
                return;
            }
            switch (fieldName) {
                case "biztype": {
                    this.changeBizType(oldValue, newValue);
                    continue block43;
                }
                case "supplier": {
                    this.changeSupplier(newValue);
                    continue block43;
                }
                case "providersupplier": {
                    this.changeProviderSupplier(newValue);
                    continue block43;
                }
                case "billtype": {
                    this.changeBillType(newValue);
                    continue block43;
                }
                case "settlecurrency": {
                    this.changeSettleCurrency(oldValue, newValue);
                    this.setDiscountRateScale(newValue);
                    continue block43;
                }
                case "istax": {
                    if (!this.checkAllIsCompliance(oldValue, newValue)) continue block43;
                    this.setPriceAndPriceAndTaxEnable();
                }
                case "exchangerate": 
                case "exchangetype": {
                    this.calAllAmount();
                    continue block43;
                }
                case "material": {
                    this.changeMaterial(oldValue, newValue, rowIndex);
                    continue block43;
                }
                case "auxqty": {
                    this.changeAuxQty(newValue, rowIndex);
                    continue block43;
                }
                case "qty": {
                    this.changeQty(newValue, rowIndex);
                    continue block43;
                }
                case "unit": {
                    this.changeUnit(newValue, rowIndex);
                    continue block43;
                }
                case "price": 
                case "priceandtax": {
                    boolean isCompliance = this.checkIsCompliance(fieldName, newValue, oldValue, rowIndex);
                    if (!isCompliance) continue block43;
                    this.calAmount(rowIndex);
                    continue block43;
                }
                case "taxrateid": {
                    this.changeTaxRateID(newValue, rowIndex);
                    continue block43;
                }
                case "taxrate": {
                    this.calAmount(rowIndex);
                    continue block43;
                }
                case "discounttype": 
                case "discountrate": {
                    this.changeDiscountField(fieldName, oldValue, newValue, rowIndex);
                    continue block43;
                }
                case "discountamount": {
                    if (!this.changeDiscountAmountInfo(oldValue, rowIndex)) continue block43;
                    this.calAmount(rowIndex, Boolean.TRUE);
                    continue block43;
                }
                case "entrychangetype": {
                    this.changeEntryChangeType(newValue, rowIndex);
                    continue block43;
                }
                case "linetype": {
                    String entityId = this.getView().getEntityId();
                    if ("pm_xpurorderbill".equals(entityId) || "pm_xspurorderbill".equals(entityId) || "pm_purorderbill".equals(entityId)) continue block43;
                    this.changeLineType(oldValue, newValue, rowIndex);
                    continue block43;
                }
            }
        }
    }

    private void changeLineType(Object oldValue, Object newValue, int rowIndex) {
        if (oldValue != null && newValue == null) {
            this.getPageCache().put("stopChange", "true");
            this.getModel().setValue("linetype", ((DynamicObject)oldValue).getPkValue(), rowIndex);
            this.getPageCache().put("stopChange", "false");
            return;
        }
        Long srcBillId = (Long)this.getModel().getValue("srcbillid", rowIndex);
        Long srcBillEntryId = (Long)this.getModel().getValue("srcbillentryid", rowIndex);
        if (srcBillId != null && !srcBillId.equals(0L) || srcBillEntryId != null && !srcBillEntryId.equals(0L)) {
            return;
        }
        ConfirmCallBackListener callBack = new ConfirmCallBackListener(CONFIRM_LINETYPE, (IFormPlugin)this);
        this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u201c\u884c\u7c7b\u578b\u201d\u5c06\u6e05\u9664\u5f53\u524d\u5206\u5f55\u7269\u6599\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"BillTplPlugin_32", (String)"scmc-pm-formplugin", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Default, callBack, null, String.valueOf(rowIndex));
        this.getView().getPageCache().put(CACHE_LINETYPE, oldValue == null ? null : ((DynamicObject)oldValue).getPkValue().toString());
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        IDataModel model = this.getModel();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        String formId = this.getView().getEntityId();
        DynamicObject billType = (DynamicObject)this.getModel().getValue("billtype");
        DynamicObject bizType = (DynamicObject)this.getModel().getValue("biztype");
        DynamicObject supplier = (DynamicObject)model.getValue("supplier");
        int rowIndex = this.getModel().getEntryCurrentRowIndex("billentry");
        DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
        DynamicObject masterMaterial = material == null ? null : material.getDynamicObject("masterid");
        DynamicObject lineType = (DynamicObject)this.getModel().getValue("linetype", rowIndex);
        Long billTypeId = null;
        if (!"org".equals(fieldKey)) {
            DynamicObject org = (DynamicObject)model.getValue("org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"BillTplPlugin_25", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            if (!"billtype".equals(fieldKey)) {
                if (billType == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u636e\u7c7b\u578b\u3002", (String)"BillTplPlugin_10", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                billTypeId = (Long)billType.getPkValue();
            }
        }
        switch (fieldKey) {
            case "biztype": {
                List bizTypeIds;
                if (billTypeId == null || (bizTypeIds = BizTypeHelper.getAllBizTypes((String)formId, billTypeId, (String)"pm_billtypeparameter")) == null) break;
                QFilter q1 = new QFilter("id", "in", (Object)bizTypeIds);
                showParameter.getListFilterParameter().getQFilters().add(q1);
                break;
            }
            case "linetype": {
                if (bizType == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"BillTplPlugin_28", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                List allLineTypes = BizTypeHelper.getAllLineTypes((Long)((Long)bizType.getPkValue()));
                if (allLineTypes == null) break;
                QFilter filter = new QFilter("id", "in", (Object)allLineTypes);
                showParameter.getListFilterParameter().getQFilters().add(filter);
                break;
            }
            case "supplier": {
                QFilter supplierFilter;
                if (bizType == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"BillTplPlugin_28", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                Long bizTypeID = (Long)bizType.getPkValue();
                if (BizCategoryHelper.isVMI((Long)bizTypeID)) {
                    QFilter qFilter = new QFilter("enablevmi", "=", (Object)"1");
                    showParameter.getListFilterParameter().getQFilters().add(qFilter);
                }
                if ((supplierFilter = this.getSupplierFilter(fieldKey)) == null) break;
                showParameter.getListFilterParameter().getQFilters().add(supplierFilter);
                break;
            }
            case "providersupplier": 
            case "invoicesupplier": 
            case "receivesupplier": {
                QFilter supplierFilter;
                if (bizType == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"BillTplPlugin_28", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                if (supplier == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u8d27\u4f9b\u5e94\u5546\u3002", (String)"BillTplPlugin_9", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                Long bizTypeID = (Long)bizType.getPkValue();
                if (BizCategoryHelper.isVMI((Long)bizTypeID)) {
                    QFilter qFilter = new QFilter("enablevmi", "=", (Object)"1");
                    showParameter.getListFilterParameter().getQFilters().add(qFilter);
                }
                if ((supplierFilter = this.getSupplierFilter(fieldKey)) == null) break;
                showParameter.getListFilterParameter().getQFilters().add(supplierFilter);
                break;
            }
            case "linkman": {
                if (supplier == null || (Long)supplier.getPkValue() == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8ba2\u8d27\u4f9b\u5e94\u5546\u3002", (String)"BillTplPlugin_9", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                DynamicObjectCollection supperlinkmans = supplier.getDynamicObjectCollection("entry_linkman");
                ArrayList<Long> supperlinkManIds = new ArrayList<Long>();
                for (DynamicObject linkMan : supperlinkmans) {
                    boolean invalid = linkMan.getBoolean(LM_INVALID);
                    if (invalid) continue;
                    supperlinkManIds.add((Long)linkMan.getPkValue());
                }
                QFilter suplmFilter = new QFilter(PROP_SUPPLIERID, "=", supplier.getPkValue());
                QFilter lmids = new QFilter("id", "in", supperlinkManIds);
                showParameter.getListFilterParameter().getQFilters().add(suplmFilter.and(lmids));
                break;
            }
            case "providerlinkman": {
                DynamicObject providerSupplier = (DynamicObject)model.getValue("providersupplier");
                if (providerSupplier == null || (Long)providerSupplier.getPkValue() == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f9b\u8d27\u4f9b\u5e94\u5546\u3002", (String)"BillTplPlugin_24", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                DynamicObjectCollection linkmans = providerSupplier.getDynamicObjectCollection("entry_linkman");
                ArrayList<Long> linkManIds = new ArrayList<Long>();
                for (DynamicObject linkMan : linkmans) {
                    boolean invalid = linkMan.getBoolean(LM_INVALID);
                    if (invalid) continue;
                    linkManIds.add((Long)linkMan.getPkValue());
                }
                QFilter supFilter = new QFilter(PROP_SUPPLIERID, "=", providerSupplier.getPkValue());
                QFilter ids = new QFilter("id", "in", linkManIds);
                showParameter.getListFilterParameter().getQFilters().add(supFilter.and(ids));
                break;
            }
            case "material": {
                Long lineTypeId;
                if (lineType == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u7c7b\u578b\u3002", (String)"BillTplPlugin_30", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                Long bizTypeId = bizType == null ? null : (Long)bizType.getPkValue();
                List qFilterByLineType = MaterialHelper.getQFilterByLineType((Long)billTypeId, (Long)bizTypeId, (Long)(lineTypeId = (Long)lineType.getPkValue()), (String)formId, (boolean)true);
                if (qFilterByLineType == null) break;
                showParameter.getListFilterParameter().getQFilters().addAll(qFilterByLineType);
                break;
            }
            case "materialmasterid": {
                Long lineTypeId;
                if (lineType == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u7c7b\u578b\u3002", (String)"BillTplPlugin_30", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                Long bizTypeId = (Long)bizType.getPkValue();
                List qFilterByLineType = MaterialHelper.getQFilterByLineType((Long)billTypeId, (Long)bizTypeId, (Long)(lineTypeId = (Long)lineType.getPkValue()), (String)formId, (boolean)false);
                if (qFilterByLineType == null) break;
                showParameter.getListFilterParameter().getQFilters().addAll(qFilterByLineType);
                break;
            }
            case "unit": {
                if (masterMaterial == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u7f16\u7801\u3002", (String)"BillTplPlugin_12", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
                long srcmuId = baseUnit == null ? 0L : (Long)baseUnit.getPkValue();
                Long masterMaterialId = (Long)masterMaterial.getPkValue();
                List unitIds = BaseDataServiceHelper.getAssistMUListResult((Long)masterMaterialId, (Long)srcmuId, (String)"1");
                QFilter qFilter = new QFilter("id", "in", (Object)unitIds);
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
            case "materialversion": {
                if (masterMaterial == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u7f16\u7801\u3002", (String)"BillTplPlugin_12", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                Long masterMaterialId = (Long)masterMaterial.getPkValue();
                QFilter qFilter = new QFilter("material", "=", (Object)masterMaterialId);
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
            case "taxrateid": {
                Date bizTime = (Date)model.getValue("biztime");
                QFilter activeQfilter = new QFilter("activedate", "<=", (Object)bizTime);
                QFilter expQfilter = new QFilter("expdate", ">", (Object)bizTime);
                expQfilter = QFilter.isNull((String)"expdate").or(expQfilter);
                QFilter qFilter = expQfilter.and(activeQfilter);
                showParameter.getListFilterParameter().getQFilters().add(qFilter);
                break;
            }
            case "invoicebiztype": {
                String appNmuber = this.getModel().getDataEntityType().getAppId();
                AppInfo appInfo = AppMetadataCache.getAppInfo((String)appNmuber);
                if (appInfo == null) break;
                String bizCloudNumber = appInfo.getCloudNum();
                QFilter appIdQFilter = new QFilter("mulbiz.fbasedataid.number", "=", (Object)bizCloudNumber);
                QFilter enableQFilter = new QFilter("enable", "=", (Object)"1");
                showParameter.getListFilterParameter().getQFilters().add(appIdQFilter.and(enableQFilter));
                break;
            }
        }
    }

    public void afterF7Select(AfterF7SelectEvent e) {
        Control source = (Control)e.getSource();
        String key = source.getKey();
        if ("material".equals(key)) {
            Long lineTypeID;
            int currentRowIndex = e.getCurrentRowIndex();
            ListSelectedRowCollection listSelectedRowCollection = e.getListSelectedRowCollection();
            DynamicObject lineType = (DynamicObject)this.getModel().getValue("linetype", currentRowIndex);
            Long l = lineTypeID = lineType == null ? null : (Long)lineType.getPkValue();
            if (listSelectedRowCollection.size() > 1) {
                for (int i = 1; i < listSelectedRowCollection.size(); ++i) {
                    this.getPageCache().put("stopChange", "true");
                    this.getModel().setValue("linetype", (Object)lineTypeID, i + currentRowIndex);
                    this.getPageCache().put("stopChange", "false");
                }
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String key;
        AbstractOperate operate = (AbstractOperate)e.getSource();
        switch (key = operate.getOperateKey()) {
            case "discountamount": {
                if (this.isBackCalculate()) {
                    return;
                }
                DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
                if (settleCurrency == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u7ed3\u7b97\u5e01\u3002", (String)"BillTplPlugin_33", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                int rowCount = this.getModel().getEntryRowCount("billentry");
                Boolean isHasRow = Boolean.FALSE;
                for (int i = 0; i < rowCount; ++i) {
                    BigDecimal discountAmount = (BigDecimal)this.getModel().getValue("discountamount", i);
                    BigDecimal amountAndTax = (BigDecimal)this.getModel().getValue("amountandtax", i);
                    boolean isPresent = (Boolean)this.getModel().getValue("ispresent", i);
                    if (isPresent || amountAndTax.add(discountAmount).compareTo(BigDecimal.ZERO) <= 0) continue;
                    isHasRow = Boolean.TRUE;
                    break;
                }
                if (isHasRow.booleanValue()) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d60\u54c1\u6216\u201c\u4ef7\u7a0e\u5408\u8ba1+\u6298\u6263\u989d\u201d\u4e3a0\u65f6\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u603b\u6298\u6263\u989d\u3002", (String)"BillTplPlugin_34", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "discountamount": {
                if (this.isBackCalculate()) {
                    return;
                }
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("pm_discountamount");
                HashMap<String, Object> customParams = new HashMap<String, Object>(8);
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
                customParams.put("currency", settleCurrency.getPkValue());
                formShowParameter.setCustomParams(customParams);
                formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pm_discountamount"));
                this.getView().showForm(formShowParameter);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        block3 : switch (actionId) {
            case "pm_discountamount": {
                BigDecimal rowDistAmount;
                int i;
                boolean isPresent;
                BigDecimal amountAndTax;
                BigDecimal discountAmount;
                int i2;
                Map discountMap;
                if (returnData == null || (discountMap = (Map)returnData) == null || discountMap.isEmpty() || discountMap.get("discountamount") == null) break;
                BigDecimal totalDiscountAmount = new BigDecimal(discountMap.get("discountamount").toString());
                BigDecimal remainDiscountAmount = new BigDecimal(discountMap.get("discountamount").toString());
                DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
                int settleAmtPrecision = settleCurrency == null ? 10 : settleCurrency.getInt(CUR_AMTPRECISION);
                BigDecimal allAmountAndTaxAndDiscount = BigDecimal.ZERO;
                int rowCount = this.getModel().getEntryRowCount("billentry");
                for (i2 = 0; i2 < rowCount; ++i2) {
                    discountAmount = (BigDecimal)this.getModel().getValue("discountamount", i2);
                    amountAndTax = (BigDecimal)this.getModel().getValue("amountandtax", i2);
                    isPresent = (Boolean)this.getModel().getValue("ispresent", i2);
                    if (isPresent) continue;
                    allAmountAndTaxAndDiscount = allAmountAndTaxAndDiscount.add(discountAmount).add(amountAndTax);
                }
                if (totalDiscountAmount.compareTo(BigDecimal.ZERO) <= 0 || totalDiscountAmount.compareTo(allAmountAndTaxAndDiscount) > 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6574\u5355\u201c\u4ef7\u683c\u5408\u8ba1+\u6298\u6263\u989d\u201d\u5927\u4e8e0\u65f6\uff0c\u603b\u6298\u6263\u989d\u5fc5\u987b\u5927\u4e8e0\u4e14\u5c0f\u4e8e\u7b49\u4e8e\u6574\u5355\u201c\u4ef7\u683c\u5408\u8ba1+\u6298\u6263\u989d\u201d\uff08\u8d60\u54c1\u9664\u5916\uff09\u3002", (String)"BillTplPlugin_35", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    return;
                }
                for (i2 = 0; i2 < rowCount; ++i2) {
                    discountAmount = (BigDecimal)this.getModel().getValue("discountamount", i2);
                    amountAndTax = (BigDecimal)this.getModel().getValue("amountandtax", i2);
                    isPresent = (Boolean)this.getModel().getValue("ispresent", i2);
                    if (isPresent || discountAmount.add(amountAndTax).compareTo(BigDecimal.ZERO) <= 0) continue;
                    this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), i2);
                }
                BigDecimal allAmountAndTax = BigDecimal.ZERO;
                ArrayList<Integer> allDistRows = new ArrayList<Integer>(16);
                for (i = 0; i < rowCount; ++i) {
                    BigDecimal amountAndTax2 = (BigDecimal)this.getModel().getValue("amountandtax", i);
                    boolean isPresent2 = (Boolean)this.getModel().getValue("ispresent", i);
                    if (isPresent2 || amountAndTax2.compareTo(BigDecimal.ZERO) <= 0) continue;
                    allAmountAndTax = allAmountAndTax.add(amountAndTax2);
                    allDistRows.add(i);
                }
                if (allAmountAndTax.compareTo(BigDecimal.ZERO) <= 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d60\u54c1\u6216\u201c\u4ef7\u7a0e\u5408\u8ba1+\u6298\u6263\u989d\u201d\u4e3a0\u65f6\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u603b\u6298\u6263\u989d\u3002", (String)"BillTplPlugin_34", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    return;
                }
                for (i = 0; i < allDistRows.size(); ++i) {
                    int rowIndex = (Integer)allDistRows.get(i);
                    BigDecimal amountAndTax3 = (BigDecimal)this.getModel().getValue("amountandtax", rowIndex);
                    rowDistAmount = BigDecimal.ZERO;
                    rowDistAmount = i == allDistRows.size() - 1 ? remainDiscountAmount : totalDiscountAmount.multiply(amountAndTax3).divide(allAmountAndTax, settleAmtPrecision, 4);
                    if (rowDistAmount.compareTo(amountAndTax3) > 0) {
                        rowDistAmount = amountAndTax3;
                    }
                    remainDiscountAmount = remainDiscountAmount.subtract(rowDistAmount);
                    this.getModel().setValue("discounttype", (Object)DiscountTypeEnum.FIXEDDIS.getValue(), rowIndex);
                    this.getModel().setValue("discountamount", (Object)rowDistAmount, rowIndex);
                }
                if (remainDiscountAmount.compareTo(BigDecimal.ZERO) <= 0 || allDistRows.isEmpty()) break;
                for (i = allDistRows.size() - 1; i >= 0; --i) {
                    Integer rowIndex = (Integer)allDistRows.get(i);
                    if (remainDiscountAmount.compareTo(BigDecimal.ZERO) == 0) break block3;
                    BigDecimal amountAndTax4 = (BigDecimal)this.getModel().getValue("amountandtax", rowIndex.intValue());
                    rowDistAmount = (BigDecimal)this.getModel().getValue("discountamount", rowIndex.intValue());
                    if (amountAndTax4.compareTo(BigDecimal.ZERO) == 0) continue;
                    if (remainDiscountAmount.compareTo(amountAndTax4) < 0) {
                        remainDiscountAmount = BigDecimal.ZERO;
                        this.getModel().setValue("discountamount", (Object)rowDistAmount.add(remainDiscountAmount), rowIndex.intValue());
                        continue;
                    }
                    remainDiscountAmount = remainDiscountAmount.subtract(amountAndTax4);
                    this.getModel().setValue("discountamount", (Object)rowDistAmount.add(amountAndTax4), rowIndex.intValue());
                }
                break;
            }
        }
    }

    public void calcTotalAllAmount(RowDataEntity[] rowDataEntities) {
        this.calcTotalAmount();
    }

    private void calcTotalAmount() {
        IDataModel model = this.getModel();
        for (Map.Entry entry : AmountHelper.calcTotalAmount((DynamicObject)model.getDataEntity(true)).entrySet()) {
            model.setValue((String)entry.getKey(), entry.getValue());
        }
    }

    private boolean checkIsCompliance(String fieldName, Object newValue, Object oldValue, int rowIndex) {
        IDataModel model = this.getModel();
        String discountType = (String)model.getValue("discounttype", rowIndex);
        boolean isCompliance = true;
        if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType) || DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType)) {
            boolean isTax = (Boolean)model.getValue("istax");
            BigDecimal discountRate = (BigDecimal)model.getValue("discountrate", rowIndex);
            BigDecimal priceAndTax = (BigDecimal)model.getValue("priceandtax", rowIndex);
            BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
            if (isTax && BigDecimalUtil.largeThan((BigDecimal)discountRate, (BigDecimal)priceAndTax)) {
                isCompliance = false;
                if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u5355\u4f4d\u6298\u6263\u989d\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"BillTplPlugin_19", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"BillTplPlugin_6", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                }
            } else if (!isTax && BigDecimalUtil.largeThan((BigDecimal)discountRate, (BigDecimal)price)) {
                isCompliance = false;
                if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u5355\u4f4d\u6298\u6263\u989d\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002", (String)"BillTplPlugin_31", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002", (String)"BillTplPlugin_5", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                }
            }
            if (!isCompliance) {
                this.getPageCache().put("stopChange", "true");
                model.setValue(fieldName, oldValue, rowIndex);
                this.getPageCache().put("stopChange", "false");
            }
        }
        return isCompliance;
    }

    private boolean checkAllIsCompliance(Object oldValue, Object newValue) {
        if (this.isBackCalculate()) {
            return true;
        }
        if (newValue instanceof Boolean && ((Boolean)newValue).booleanValue()) {
            return true;
        }
        IDataModel model = this.getModel();
        int rowCount = model.getEntryRowCount("billentry");
        for (int i = 0; i < rowCount; ++i) {
            BigDecimal price;
            BigDecimal discountRate;
            String discountType = (String)model.getValue("discounttype", i);
            if (!DiscountTypeEnum.UNITDIS.getValue().equals(discountType) && !DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType) || !BigDecimalUtil.largeThan((BigDecimal)(discountRate = (BigDecimal)model.getValue("discountrate", i)), (BigDecimal)(price = (BigDecimal)model.getValue("price", i)))) continue;
            this.getPageCache().put("stopChange", "true");
            model.setValue("istax", oldValue);
            this.getPageCache().put("stopChange", "false");
            if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u5355\u4f4d\u6298\u6263\u989d\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002", (String)"BillTplPlugin_31", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002", (String)"BillTplPlugin_5", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            }
            return false;
        }
        return true;
    }

    private void changeSupplier(Object newValue) {
        String appId;
        DynamicObject invoiceType;
        DynamicObject supplier = newValue instanceof DynamicObject ? (DynamicObject)newValue : null;
        IDataModel bill = this.getModel();
        Object invoiceBizType = bill.getValue("invoicebiztype");
        if (invoiceBizType == null && (invoiceType = SupplierHelper.getInvoiceType((DynamicObject)supplier, (String)(appId = this.getView().getFormShowParameter().getAppId()))) != null) {
            bill.setValue("invoicebiztype", (Object)invoiceType);
        }
        bill.setValue("providersupplier", (Object)SupplierHelper.getOtherSupplierId((DynamicObject)supplier, (String)"deliversupplierid"));
        bill.setValue("invoicesupplier", (Object)SupplierHelper.getOtherSupplierId((DynamicObject)supplier, (String)"invoicesupplierid"));
        bill.setValue("receivesupplier", (Object)SupplierHelper.getOtherSupplierId((DynamicObject)supplier, (String)"receivingsupplierid"));
        bill.setValue("settletype", (Object)SupplierHelper.getDefaultSettleTypeId((DynamicObject)supplier));
        bill.setValue("linkman", (Object)SupplierHelper.getDefaultLinkManId((DynamicObject)supplier));
        bill.setValue("address", (Object)SupplierHelper.getDefaultAddressString((DynamicObject)supplier));
        DynamicObject settle = (DynamicObject)bill.getValue("settlecurrency");
        if (!Boolean.parseBoolean(this.getPageCache().get("isdraw"))) {
            DynamicObject supplierSettleCurrency = SupplierHelper.getDefaultSettleCurrency((DynamicObject)supplier);
            if (supplierSettleCurrency != null) {
                if (settle != null && !settle.getPkValue().equals(supplierSettleCurrency.getPkValue())) {
                    this.getPageCache().put("changeSupplier", "1");
                }
                bill.setValue("settlecurrency", supplierSettleCurrency.getPkValue());
            } else {
                DynamicObject currency = (DynamicObject)bill.getValue("currency");
                if (settle != null && currency != null && !settle.getPkValue().equals(currency.getPkValue())) {
                    this.getPageCache().put("changeSupplier", "1");
                }
                bill.setValue("settlecurrency", currency == null ? null : currency.getPkValue());
            }
        }
    }

    private void changeProviderSupplier(Object newValue) {
        IDataModel bill = this.getModel();
        DynamicObject providerSupplier = newValue instanceof DynamicObject ? (DynamicObject)newValue : null;
        bill.setValue("providerlinkman", (Object)SupplierHelper.getDefaultLinkManId((DynamicObject)providerSupplier));
        bill.setValue("provideraddress", (Object)SupplierHelper.getDefaultAddressString((DynamicObject)providerSupplier));
    }

    private void changeBillType(Object newValue) {
        if (newValue instanceof DynamicObject) {
            Long billTypeId = (Long)((DynamicObject)newValue).getPkValue();
            String formId = this.getView().getEntityId();
            Long defaultBizType = BizTypeHelper.getDefaultBizType((String)formId, (Long)billTypeId, (String)"pm_billtypeparameter");
            this.getModel().setValue("biztype", (Object)defaultBizType);
        }
    }

    private void changeBizType(Object oldValue, Object newValue) {
        DynamicObject bizType_old = (DynamicObject)oldValue;
        String msg = ResManager.loadKDString((String)"\u5207\u6362\u4e1a\u52a1\u7c7b\u578b\u5c06\u6e05\u9664\u5f53\u524d\u5355\u636e\u7684\u4f9b\u5e94\u5546\u548c\u7269\u6599\u660e\u7ec6\u4fe1\u606f\uff0c\u662f\u5426\u5207\u6362\uff1f", (String)"BillTplPlugin_29", (String)"scmc-pm-formplugin", (Object[])new Object[0]);
        MessageBoxOptions options = MessageBoxOptions.YesNo;
        ConfirmCallBackListener callBack = new ConfirmCallBackListener(CONFIRM_BIZTYPE, (IFormPlugin)this);
        this.getView().showConfirm(msg, options, ConfirmTypes.Default, callBack);
        this.getView().getPageCache().put(CACHE_BIZTYPE, bizType_old == null ? null : bizType_old.getPkValue().toString());
    }

    private void changeMaterial(Object oldValue, Object newValue, int rowIndex) {
        DynamicObject material;
        IDataModel model = this.getModel();
        this.getPageCache().put("stopChange", "true");
        model.setValue("materialname", null, rowIndex);
        model.setValue("materialmasterid", null, rowIndex);
        model.setValue("materialversion", null, rowIndex);
        model.setValue("auxpty", null, rowIndex);
        model.setValue("unit", null, rowIndex);
        model.setValue("auxunit", null, rowIndex);
        model.setValue("baseunit", null, rowIndex);
        model.setValue("qty", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("auxqty", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("baseqty", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("price", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("priceandtax", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("taxrateid", null, rowIndex);
        model.setValue("taxrate", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("discounttype", (Object)DiscountTypeEnum.NULL.getValue(), rowIndex);
        model.setValue("discountrate", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("discountamount", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("ispresent", null, rowIndex);
        model.setValue("amount", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("taxamount", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("amountandtax", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("curamount", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("curtaxamount", (Object)BigDecimalUtil.ZERO, rowIndex);
        model.setValue("curamountandtax", (Object)BigDecimalUtil.ZERO, rowIndex);
        DynamicObject dynamicObject = material = newValue instanceof DynamicObject ? (DynamicObject)newValue : null;
        if (material != null) {
            DynamicObject supplier;
            DynamicObject defaultTaxRate;
            DynamicObject master = material.getDynamicObject("masterid");
            if (master != null) {
                model.setValue("materialmasterid", master.getPkValue(), rowIndex);
                if (master.getLocaleString("name") != null) {
                    model.setValue("materialname", (Object)master.getLocaleString("name").toString(), rowIndex);
                }
                if (master.getBoolean("isdisposable")) {
                    this.getView().setEnable(Boolean.TRUE, rowIndex, new String[]{"materialname"});
                }
                if (master.getDynamicObject("auxptyunit") != null) {
                    model.setValue("auxunit", master.getDynamicObject("auxptyunit").getPkValue(), rowIndex);
                }
                if (master.getDynamicObject("baseunit") != null) {
                    model.setValue("baseunit", master.getDynamicObject("baseunit").getPkValue(), rowIndex);
                }
            }
            if (material.getDynamicObject("purchaseunit") != null) {
                model.setValue("unit", material.getDynamicObject("purchaseunit").getPkValue(), rowIndex);
            }
            if ((defaultTaxRate = MaterialHelper.getDefaultTaxRate((DynamicObject)(supplier = (DynamicObject)model.getValue("supplier")), (DynamicObject)material)) != null) {
                model.setValue("taxrateid", defaultTaxRate.getPkValue(), rowIndex);
                model.setValue("taxrate", (Object)defaultTaxRate.getBigDecimal("taxrate"), rowIndex);
            }
        } else {
            model.setValue("taxrateid", null, rowIndex);
            model.setValue("taxrate", null, rowIndex);
        }
        this.calcTotalAmount();
        this.getPageCache().put("stopChange", "false");
    }

    private void calAmount(int rowIndex) {
        this.calAmount(rowIndex, Boolean.FALSE);
    }

    private void calAmount(int rowIndex, Boolean isCalDiscountRate) {
        if (this.isBackCalculate()) {
            return;
        }
        IDataModel model = this.getModel();
        AmountPropertyKey propertyKey = AmountPropertyKey.getInstance();
        AmountHelper.calcAmount((DynamicObject)model.getDataEntity(true), (AmountPropertyKey)propertyKey, (int)rowIndex, (Boolean)isCalDiscountRate);
        this.updateEntryAmountField(rowIndex);
        this.calcTotalAmount();
    }

    private void calAllAmount() {
        if (this.isBackCalculate()) {
            return;
        }
        IDataModel model = this.getModel();
        Map totalAmount = AmountHelper.calcAllAmount((DynamicObject)model.getDataEntity(true), (AmountPropertyKey)AmountPropertyKey.getInstance());
        this.getView().updateView("billentry");
        for (Map.Entry entry : totalAmount.entrySet()) {
            model.setValue((String)entry.getKey(), entry.getValue());
        }
    }

    private void setPriceAndPriceAndTaxEnable() {
        if (this.isBackCalculate()) {
            return;
        }
        boolean isTax = (Boolean)this.getModel().getValue("istax");
        if (isTax) {
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{"priceandtax"});
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{"price"});
        } else {
            this.getView().setEnable(Boolean.TRUE, -1, new String[]{"price"});
            this.getView().setEnable(Boolean.FALSE, -1, new String[]{"priceandtax"});
        }
    }

    private void changeQty(Object newValue, int rowIndex) {
        if (this.isBackCalculate()) {
            return;
        }
        if (newValue instanceof BigDecimal) {
            IDataModel model = this.getModel();
            BigDecimal qty = (BigDecimal)newValue;
            DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
            DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
            model.beginInit();
            if (material == null || unit == null) {
                model.setValue("baseqty", (Object)BigDecimalUtil.ZERO, rowIndex);
                model.setValue("auxqty", (Object)BigDecimalUtil.ZERO, rowIndex);
            } else {
                DynamicObject master = material.getDynamicObject("masterid");
                DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
                DynamicObject auxUnit = (DynamicObject)model.getValue("auxunit", rowIndex);
                if (baseUnit == null && master != null && (baseUnit = master.getDynamicObject("baseunit")) != null) {
                    model.setValue("baseunit", baseUnit.getPkValue(), rowIndex);
                }
                if (baseUnit != null && master != null) {
                    Long masterId = (Long)master.getPkValue();
                    BigDecimal baseQty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterId, (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
                    model.setValue("baseqty", (Object)baseQty, rowIndex);
                    if (auxUnit != null) {
                        String unitConvertDir = master.getString("unitconvertdir");
                        if (UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                            BigDecimal auxQty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterId, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)auxUnit);
                            model.setValue("auxqty", (Object)auxQty, rowIndex);
                        }
                    }
                }
            }
            model.endInit();
            this.getView().updateView("baseunit", rowIndex);
            this.getView().updateView("baseqty", rowIndex);
            this.getView().updateView("auxqty", rowIndex);
            this.calAmount(rowIndex);
        }
    }

    private void changeAuxQty(Object newValue, int rowIndex) {
        if (this.isBackCalculate()) {
            return;
        }
        if (newValue instanceof BigDecimal) {
            IDataModel model = this.getModel();
            BigDecimal auxQty = (BigDecimal)newValue;
            DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
            DynamicObject auxUnit = (DynamicObject)model.getValue("auxunit", rowIndex);
            if (material == null || auxUnit == null) {
                return;
            }
            DynamicObject master = material.getDynamicObject("masterid");
            DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
            DynamicObject unit = (DynamicObject)model.getValue("unit", rowIndex);
            if (baseUnit == null && master != null && (baseUnit = master.getDynamicObject("baseunit")) != null) {
                model.setValue("baseunit", baseUnit.getPkValue(), rowIndex);
            }
            if (baseUnit != null && unit != null && master != null) {
                Long masterId = (Long)master.getPkValue();
                String unitConvertDir = master.getString("unitconvertdir");
                if (UnitConvertDirEnum.U2ND_UINV.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                    BigDecimal baseQty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterId, (DynamicObject)auxUnit, (BigDecimal)auxQty, (DynamicObject)baseUnit);
                    BigDecimal qty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterId, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)unit);
                    model.beginInit();
                    model.setValue("baseqty", (Object)baseQty, rowIndex);
                    model.setValue("qty", (Object)qty, rowIndex);
                    model.endInit();
                    this.getView().updateView("baseqty", rowIndex);
                    this.getView().updateView("qty", rowIndex);
                    this.calAmount(rowIndex);
                }
            }
        }
    }

    private void changeUnit(Object newValue, int rowIndex) {
        if (this.isBackCalculate()) {
            return;
        }
        if (newValue instanceof DynamicObject) {
            DynamicObject unit = (DynamicObject)newValue;
            IDataModel model = this.getModel();
            DynamicObject material = (DynamicObject)model.getValue("material", rowIndex);
            BigDecimal qty = BigDecimalUtil.getNotNull((Object)model.getValue("qty", rowIndex));
            int precision = BillQtyAndUnitHelper.getPrecision((DynamicObject)unit);
            qty = qty.setScale(precision, BillQtyAndUnitHelper.getUnitRoundingMode((DynamicObject)unit));
            model.beginInit();
            model.setValue("qty", (Object)qty, rowIndex);
            model.endInit();
            if (material != null && qty.compareTo(BigDecimalUtil.ZERO) != 0) {
                DynamicObject master = material.getDynamicObject("masterid");
                DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", rowIndex);
                DynamicObject auxUnit = (DynamicObject)model.getValue("auxunit", rowIndex);
                model.beginInit();
                if (baseUnit == null && master != null && (baseUnit = master.getDynamicObject("baseunit")) != null) {
                    model.setValue("baseunit", baseUnit.getPkValue(), rowIndex);
                }
                if (baseUnit != null && master != null) {
                    Long masterId = (Long)master.getPkValue();
                    BigDecimal baseQty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterId, (DynamicObject)unit, (BigDecimal)qty, (DynamicObject)baseUnit);
                    model.setValue("baseqty", (Object)baseQty, rowIndex);
                    if (auxUnit != null) {
                        String unitConvertDir = master.getString("unitconvertdir");
                        if (UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir)) {
                            BigDecimal auxQty = BillQtyAndUnitHelper.getDesQtyConv((Long)masterId, (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)auxUnit);
                            model.setValue("auxqty", (Object)auxQty, rowIndex);
                        }
                    }
                }
                model.endInit();
                this.getView().updateView("baseunit", rowIndex);
                this.getView().updateView("baseqty", rowIndex);
                this.getView().updateView("auxqty", rowIndex);
                this.getView().updateView("qty", rowIndex);
                this.calAmount(rowIndex);
            }
        }
    }

    private void changeSettleCurrency(Object oldValue, Object newValue) {
        if (this.isBackCalculate()) {
            return;
        }
        String entityName = this.getModel().getDataEntityType().getName();
        if (!entityName.equals("pm_purorderbill")) {
            if (oldValue instanceof DynamicObject && newValue instanceof DynamicObject) {
                DynamicObject oldSettleCurrency = (DynamicObject)oldValue;
                DynamicObject newSettleCurrency = (DynamicObject)newValue;
                if (oldSettleCurrency.getInt(CUR_PRICEPRECISION) == newSettleCurrency.getInt(CUR_PRICEPRECISION) && oldSettleCurrency.getInt(CUR_AMTPRECISION) == newSettleCurrency.getInt(CUR_AMTPRECISION)) {
                    return;
                }
            }
            this.calAllAmount();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String key = e.getCallBackId();
        String resultValue = e.getResultValue();
        IDataModel model = this.getModel();
        if (CONFIRM_BIZTYPE.equals(key)) {
            if ("Yes".equals(resultValue)) {
                DynamicObject biztype;
                Long bizTYpeID;
                boolean isCredit;
                model.setValue("supplier", null);
                model.setValue("linkman", null);
                model.setValue("address", null);
                model.setValue("providersupplier", null);
                model.setValue("providerlinkman", null);
                model.setValue("provideraddress", null);
                model.setValue("invoicesupplier", null);
                model.setValue("receivesupplier", null);
                model.setValue("settletype", null);
                DynamicObject currency = (DynamicObject)model.getValue("currency");
                if (currency != null) {
                    model.setValue("settlecurrency", currency.getPkValue());
                }
                if (isCredit = BizCategoryHelper.isCredit((Long)(bizTYpeID = (biztype = (DynamicObject)this.getModel().getValue("biztype")) == null ? null : (Long)biztype.getPkValue()))) {
                    this.getView().setEnable(Boolean.FALSE, new String[]{"paymode"});
                    model.setValue("paymode", (Object)PayModeEnum.CREDIT.getValue());
                } else {
                    this.getView().setEnable(Boolean.TRUE, new String[]{"paymode"});
                }
                model.deleteEntryData("billentry");
                model.createNewEntryRow("billentry");
            } else {
                String bizTypeId = this.getView().getPageCache().get(CACHE_BIZTYPE);
                this.getModel().beginInit();
                this.getModel().setValue("biztype", bizTypeId == null ? null : Long.valueOf(Long.parseLong(bizTypeId)));
                this.getModel().endInit();
                this.getView().updateView("biztype");
            }
        }
        if (StringUtils.equals((CharSequence)CONFIRM_LINETYPE, (CharSequence)e.getCallBackId())) {
            String customVaule = e.getCustomVaule();
            if (StringUtils.isBlank((CharSequence)customVaule)) {
                return;
            }
            int rowIndex = Integer.parseInt(customVaule);
            if (e.getResult() == MessageBoxResult.Yes) {
                this.getModel().setValue("material", null, rowIndex);
            } else {
                String lineTypeId = this.getView().getPageCache().get(CACHE_LINETYPE);
                this.getModel().beginInit();
                this.getModel().setValue("linetype", (Object)(lineTypeId == null ? null : Long.valueOf(Long.parseLong(lineTypeId))), rowIndex);
                this.getModel().endInit();
                this.getView().updateView("linetype", rowIndex);
            }
        }
    }

    private void changeTaxRateID(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        if (newValue instanceof DynamicObject) {
            DynamicObject taxRateID = (DynamicObject)newValue;
            model.setValue("taxrate", (Object)taxRateID.getBigDecimal("taxrate"), rowIndex);
        } else {
            model.setValue("taxrate", (Object)BigDecimalUtil.ZERO, rowIndex);
        }
    }

    private void changeDiscountField(String fieldName, Object oldValue, Object newValue, int rowIndex) {
        if (this.isBackCalculate()) {
            return;
        }
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String discountType = (String)model.getValue("discounttype", rowIndex);
        BigDecimal discountRate = (BigDecimal)model.getValue("discountrate", rowIndex);
        boolean isRollbackField = false;
        if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
            view.setEnable(Boolean.TRUE, rowIndex, new String[]{"discountrate"});
            if (BigDecimalUtil.largeThan((BigDecimal)discountRate, (BigDecimal)BigDecimalUtil.HUNDRED) || BigDecimalUtil.lessThan((BigDecimal)discountRate, (BigDecimal)BigDecimalUtil.ZERO)) {
                isRollbackField = true;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u6298\u6263\u7387(%)\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u8303\u56f4\u4e3a\uff1a0\u2264\u5355\u4f4d\u6298\u6263(\u7387)\u2264100\u3002", (String)"BillTplPlugin_18", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            }
        } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType) || DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType)) {
            if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
                view.setEnable(Boolean.TRUE, rowIndex, new String[]{"discountrate"});
            }
            boolean isTax = (Boolean)model.getValue("istax");
            BigDecimal priceAndTax = (BigDecimal)model.getValue("priceandtax", rowIndex);
            BigDecimal price = (BigDecimal)model.getValue("price", rowIndex);
            if (isTax && BigDecimalUtil.largeThan((BigDecimal)discountRate, (BigDecimal)priceAndTax)) {
                isRollbackField = true;
                if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u5355\u4f4d\u6298\u6263\u989d\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"BillTplPlugin_19", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u542b\u7a0e\u5355\u4ef7\u3002", (String)"BillTplPlugin_6", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                }
            } else if (!isTax && BigDecimalUtil.largeThan((BigDecimal)discountRate, (BigDecimal)price)) {
                isRollbackField = true;
                if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u5355\u4f4d\u6298\u6263\u989d\u201d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002", (String)"BillTplPlugin_31", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u6298\u6263\u989d\u65f6\uff0c\u5355\u4f4d\u6298\u6263(\u7387)\u4e0d\u80fd\u5927\u4e8e\u5355\u4ef7\u3002", (String)"BillTplPlugin_5", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                }
            }
        } else if (DiscountTypeEnum.NULL.getValue().equals(discountType)) {
            view.setEnable(Boolean.FALSE, rowIndex, new String[]{"discountrate"});
            model.beginInit();
            model.setValue("discountrate", (Object)BigDecimalUtil.ZERO, rowIndex);
            model.endInit();
            view.updateView("discountrate", rowIndex);
        }
        if (isRollbackField) {
            model.beginInit();
            model.setValue(fieldName, oldValue, rowIndex);
            model.endInit();
            view.updateView(fieldName, rowIndex);
        }
        this.calAmount(rowIndex);
    }

    private boolean changeDiscountAmountInfo(Object oldValue, int rowIndex) {
        if (this.isBackCalculate()) {
            return false;
        }
        String discountType = (String)this.getModel().getValue("discounttype", rowIndex);
        if (DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType)) {
            BigDecimal qty = (BigDecimal)this.getModel().getValue("qty", rowIndex);
            DynamicObject settleCurrency = (DynamicObject)this.getModel().getValue("settlecurrency");
            int settleAmtPrecision = settleCurrency == null ? 10 : settleCurrency.getInt(CUR_AMTPRECISION);
            BigDecimal discountAmount = (BigDecimal)this.getModel().getValue("discountamount", rowIndex);
            discountAmount = discountAmount.setScale(settleAmtPrecision, 4);
            BigDecimal amountAndTax = BigDecimal.ZERO;
            boolean isTax = (Boolean)this.getModel().getValue("istax");
            if (isTax) {
                BigDecimal priceAndTax = (BigDecimal)this.getModel().getValue("priceandtax", rowIndex);
                if (qty != null && priceAndTax != null) {
                    amountAndTax = qty.multiply(priceAndTax).setScale(settleAmtPrecision, 4);
                }
            } else {
                BigDecimal price = (BigDecimal)this.getModel().getValue("price", rowIndex);
                if (qty != null && price != null) {
                    BigDecimal taxRate = (BigDecimal)this.getModel().getValue("taxrate", rowIndex);
                    if (taxRate == null) {
                        taxRate = BigDecimal.ZERO;
                    }
                    amountAndTax = qty.multiply(price).multiply(BigDecimal.ONE.add(taxRate.divide(new BigDecimal("100")))).setScale(settleAmtPrecision, 4);
                }
            }
            if (discountAmount.compareTo(amountAndTax) > 0) {
                this.getPageCache().put("stopChange", "true");
                this.getModel().setValue("discountamount", oldValue, rowIndex);
                this.getPageCache().put("stopChange", "false");
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u6263\u65b9\u5f0f\u4e3a\u201c\u6298\u6263\u989d\u201d\u65f6\uff0c\u6298\u6263\u989d\u4e0d\u80fd\u5927\u4e8e\u201c\u6570\u91cf\u201d\u4e58\u4ee5\u201c\u542b\u7a0e\u5355\u4ef7\u201d\u3002", (String)"BillTplPlugin_4", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                return false;
            }
            return true;
        }
        return false;
    }

    private void changeEntryChangeType(Object newValue, int rowIndex) {
        this.calcTotalAmount();
    }

    private void updateEntryAmountField(int rowIndex) {
        IFormView view = this.getView();
        view.updateView("price", rowIndex);
        view.updateView("priceandtax", rowIndex);
        view.updateView("amount", rowIndex);
        view.updateView("taxamount", rowIndex);
        view.updateView("discountrate", rowIndex);
        view.updateView("discountamount", rowIndex);
        view.updateView("amountandtax", rowIndex);
        view.updateView("curamount", rowIndex);
        view.updateView("curtaxamount", rowIndex);
        view.updateView("curamountandtax", rowIndex);
    }

    private boolean isBackCalculate() {
        Boolean inputAmount = (Boolean)this.getModel().getValue("inputamount");
        if (inputAmount == null) {
            return false;
        }
        return inputAmount;
    }

    private QFilter getSupplierFilter(String key) {
        if (key == null) {
            return null;
        }
        switch (key) {
            case "supplier": {
                return SupplierHelper.getPurchaseFilter();
            }
            case "providersupplier": {
                return SupplierHelper.getDeliverFilter();
            }
            case "invoicesupplier": {
                return SupplierHelper.getInvoiceFilter();
            }
            case "receivesupplier": {
                return SupplierHelper.getReceiveFilter();
            }
        }
        return null;
    }

    public void entryGridBindData(EntryGridBindDataEvent e) {
        this.setDiscountRateScale(this.getModel().getValue("settlecurrency"));
    }

    private void setDiscountRateScale(Object newValue) {
        int priceRecision = 4;
        if (newValue instanceof DynamicObject) {
            DynamicObject settleCurrency = (DynamicObject)newValue;
            priceRecision = settleCurrency.getInt(CUR_PRICEPRECISION);
        }
        ClientViewProxy clientViewProxy = (ClientViewProxy)this.getView().getService(IClientViewProxy.class);
        clientViewProxy.invokeControlMethod("billentry", "setColEditorProp", new Object[]{"discountrate", "sc", priceRecision});
    }
}

