/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pmp.formplugin.adjust;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mpscmm.msbd.pricemodel.business.helper.adjust.PriceAdjustHelper;
import kd.mpscmm.msbd.pricemodel.business.pojo.adjust.PriceBatchAdjustInfo;
import kd.scmc.pmp.utils.CommonUtils;
import org.apache.commons.lang.StringUtils;

public class PurPriceAdjustPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
RowClickEventListener {
    public static final String TAXRATE_FILTER = "taxrate_filter";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Boolean istax = (Boolean)this.getModel().getValue("istax");
        this.setPriceMustInput(istax);
        this.queryTaxrate();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int index = e.getChangeSet()[0].getRowIndex();
        switch (key) {
            case "istax": {
                this.setPriceMustInput((Boolean)newValue);
                break;
            }
            case "adjtaxrateid": {
                this.changeTaxRateID(newValue, index);
                break;
            }
            case "material": {
                this.applyMaterialNoChange((DynamicObject)newValue, index);
                this.setDefaultTaxRate((DynamicObject)newValue, index);
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        IDataModel model = this.getModel();
        String keyName = e.getEntryProp().getName();
        if (StringUtils.equals((String)"priceentryentity", (String)keyName)) {
            RowDataEntity[] rowDataEntities;
            for (RowDataEntity rowDataEntity : rowDataEntities = e.getRowDataEntities()) {
                int rowIndex = rowDataEntity.getRowIndex();
                model.setValue("adjustflag", (Object)"B", rowIndex);
                Object obj = model.getValue("purpricelist");
                if (CommonUtils.isNull((Object)obj)) continue;
                model.setValue("srcpricelist", obj, rowIndex);
            }
        }
    }

    public void registerListener(EventObject e) {
        Toolbar toolbar;
        BasedataEdit materialEdit;
        BasedataEdit taxrateid;
        super.registerListener(e);
        BasedataEdit unit = (BasedataEdit)this.getView().getControl("unit");
        if (unit != null) {
            unit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((taxrateid = (BasedataEdit)this.getView().getControl("adjtaxrateid")) != null) {
            taxrateid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((materialEdit = (BasedataEdit)this.getView().getControl("material")) != null) {
            materialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((toolbar = (Toolbar)this.getView().getControl("priceentrytoolbar")) != null) {
            toolbar.addItemClickListener((ItemClickListener)this);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        IDataModel bill = this.getModel();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("priceentryentity");
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurPriceAdjustPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        switch (key) {
            case "unit": {
                DynamicObject material = (DynamicObject)bill.getValue("material", rowIndex);
                if (material == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u4fe1\u606f\u3002", (String)"PurPriceAdjustPlugin_1", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    break;
                }
                DynamicObject mastermaterial = material.getDynamicObject("masterid");
                DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit", rowIndex);
                Long srcmuId = baseUnit == null ? Long.valueOf(0L) : (Long)baseUnit.getPkValue();
                Long masterMaterialId = (Long)mastermaterial.getPkValue();
                List unitIds = BaseDataServiceHelper.getAssistMUListResult((Long)masterMaterialId, (Long)srcmuId, (String)"1");
                QFilter qFilter = new QFilter("id", "in", (Object)unitIds);
                showParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
            case "adjtaxrateid": {
                String taxrate_filter = this.getPageCache().get(TAXRATE_FILTER);
                taxrate_filter = taxrate_filter.substring(1, taxrate_filter.length() - 1);
                if (kd.bos.util.StringUtils.isNotEmpty((String)taxrate_filter)) {
                    String[] taxrateIds = taxrate_filter.split("_");
                    ArrayList<Long> taxrateIdList = new ArrayList<Long>(taxrateIds.length);
                    for (String id : taxrateIds) {
                        if (id == null || "".equals(id)) continue;
                        taxrateIdList.add(Long.valueOf(id));
                    }
                    QFilter filter = new QFilter("id", "in", taxrateIdList);
                    showParameter.getListFilterParameter().setFilter(filter);
                    break;
                }
                QFilter filter = QFilter.of((String)"1=-1", (Object[])new Object[0]);
                showParameter.getListFilterParameter().setFilter(filter);
            }
        }
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        String itemKey = e.getItemKey();
        IDataModel model = this.getModel();
        if ("batchadjust".equals(itemKey)) {
            DynamicObjectCollection priceEntry = model.getEntryEntity("priceentryentity");
            if (priceEntry == null || priceEntry.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8c03\u6574\u660e\u7ec6\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PurPriceAdjustPlugin_2", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                return;
            }
            HashMap map = new HashMap(priceEntry.size());
            for (int j = 0; j < priceEntry.size(); ++j) {
                DynamicObject entry = (DynamicObject)priceEntry.get(j);
                HashMap<String, BigDecimal> filed = new HashMap<String, BigDecimal>(8);
                filed.put("adjprice", entry.getBigDecimal("adjprice"));
                filed.put("adjpriceandtax", entry.getBigDecimal("adjpriceandtax"));
                filed.put("adjpricefloor", entry.getBigDecimal("adjpricefloor"));
                filed.put("adjpriceceiling", entry.getBigDecimal("adjpriceceiling"));
                map.put(j, filed);
            }
            FormShowParameter fsp = new FormShowParameter();
            fsp.setFormId("pm_batchadjustment");
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "batchadjust"));
            fsp.setCustomParams(map);
            this.getView().showForm(fsp);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if ("batchadjust".equals(actionId)) {
            Map returnMap = (Map)e.getReturnData();
            if (returnMap == null) {
                return;
            }
            String scope = (String)returnMap.get("radiogroup");
            PriceBatchAdjustInfo adjustInFo = (PriceBatchAdjustInfo)returnMap.get("batchadjustinfo");
            int count = this.getModel().getEntryRowCount("priceentryentity");
            EntryGrid entryGrid = (EntryGrid)this.getControl("priceentryentity");
            int[] rows = entryGrid.getSelectRows();
            if ("ALL".equals(scope)) {
                rows = new int[count];
                for (int i = 0; i < count; ++i) {
                    rows[i] = i;
                }
            }
            PriceAdjustHelper.caclAdjustResult(Collections.singletonList(adjustInFo), (DynamicObject)this.getModel().getDataEntity(true), (int[])rows);
            this.getView().updateView("priceentryentity");
        }
    }

    private void setPriceMustInput(Boolean istax) {
        AmountEdit priceAndTaxControl = (AmountEdit)this.getView().getControl("adjpriceandtax");
        AmountEdit priceControl = (AmountEdit)this.getView().getControl("adjprice");
        if (istax.booleanValue()) {
            priceAndTaxControl.setMustInput(true);
            priceControl.setMustInput(false);
        } else {
            priceAndTaxControl.setMustInput(false);
            priceControl.setMustInput(true);
        }
    }

    private void changeTaxRateID(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        if (newValue instanceof DynamicObject) {
            DynamicObject taxRateID = (DynamicObject)newValue;
            model.setValue("taxrate", taxRateID.get("taxrate"), rowIndex);
        } else {
            model.setValue("taxrate", (Object)0, rowIndex);
        }
    }

    private void queryTaxrate() {
        Date bizTime = (Date)this.getModel().getValue("createtime");
        QFilter q1 = new QFilter("activedate", "<=", (Object)bizTime);
        QFilter q2 = new QFilter("expdate", ">", (Object)bizTime);
        QFilter q3 = q2.or(QFilter.isNull((String)"expdate"));
        q1.and(q3).and(new QFilter("enable", "=", (Object)"1"));
        Map bdTaxrate = BusinessDataServiceHelper.loadFromCache((String)"bd_taxrate", (String)"id", (QFilter[])new QFilter[]{q1});
        ArrayList<String> taxratelist = new ArrayList<String>(bdTaxrate.size());
        for (Map.Entry next : bdTaxrate.entrySet()) {
            Object pkValue = ((DynamicObject)next.getValue()).getPkValue();
            taxratelist.add(pkValue.toString());
        }
        if (taxratelist.size() > 0) {
            this.getPageCache().put(TAXRATE_FILTER, SerializationUtils.toJsonString((Object)String.join((CharSequence)"_", taxratelist)));
        }
    }

    private void setDefaultTaxRate(DynamicObject material, int rowIndex) {
        Optional.ofNullable(material).ifPresent(m -> {
            Optional<DynamicObject> taxrate = Optional.ofNullable(m.getDynamicObject("masterid.taxrate"));
            if (taxrate.isPresent()) {
                String taxrateId = taxrate.get().getString("masterid");
                this.getModel().setValue("taxrate", taxrate.get().getPkValue(), rowIndex);
                this.getModel().setValue("adjtaxrateid", (Object)taxrateId, rowIndex);
            } else {
                Optional.ofNullable(this.getModel().getValue("supplierid")).flatMap(supplier -> Optional.ofNullable(((DynamicObject)supplier).getDynamicObject("taxrate"))).ifPresent(supplierTaxRate -> this.getModel().setValue("adjtaxrateid", supplierTaxRate.getPkValue(), rowIndex));
            }
        });
    }

    private void applyMaterialNoChange(DynamicObject material, int row) {
        this.getModel().setValue("taxrate", null, row);
        this.getModel().setValue("adjprice", null, row);
        this.getModel().setValue("baseunit", null, row);
        this.getModel().setValue("adjpricefloor", null, row);
        this.getModel().setValue("adjpriceceiling", null, row);
        this.getModel().setValue("adjtaxrateid", null, row);
        this.getModel().setValue("adjpriceandtax", null, row);
        this.getModel().setValue("unit", null, row);
        this.getModel().setValue("auxpty", null, row);
        this.getModel().setValue("remark", null, row);
        if (material != null) {
            DynamicObject masterMaterial = material.getDynamicObject("masterid");
            if (masterMaterial.getDynamicObject("baseunit") != null) {
                this.getModel().setValue("baseunit", masterMaterial.getDynamicObject("baseunit").getPkValue(), row);
            }
            if (material.getDynamicObject("purchaseunit") != null) {
                this.getModel().setValue("unit", material.getDynamicObject("purchaseunit").getPkValue(), row);
            }
        }
    }
}

