/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pmp.formplugin.price;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.AmountEdit;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.pmp.business.helper.BillImportHelper;
import kd.scmc.pmp.business.helper.CurrencyHelper;
import kd.scmc.pmp.business.helper.PurStairPriceHelper;

public class PurPriceListPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
RowClickEventListener,
HyperLinkClickListener {
    public static final String TAXRATE_FILTER = "taxrate_filter";
    private static final String TAXRATEID = "taxrateid";
    private static final String ISSTAIRPRICE = "isstairprice";
    private static final String OPPARAM_AFTERCONFIRM = "afterconfirm";

    public void registerListener(EventObject e) {
        BasedataEdit supplierid;
        BasedataEdit taxrateid;
        BasedataEdit unit;
        super.registerListener(e);
        BasedataEdit materialEdit = (BasedataEdit)this.getView().getControl("material");
        if (materialEdit != null) {
            materialEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((unit = (BasedataEdit)this.getView().getControl("unit")) != null) {
            unit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((taxrateid = (BasedataEdit)this.getView().getControl(TAXRATEID)) != null) {
            taxrateid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if ((supplierid = (BasedataEdit)this.getView().getControl("supplierid")) != null) {
            supplierid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        this.addItemClickListeners(new String[]{ISSTAIRPRICE});
        Toolbar check = (Toolbar)this.getView().getControl("stairtoolbarap");
        check.addItemClickListener((ItemClickListener)this);
        Toolbar entry = (Toolbar)this.getView().getControl("tb_entry");
        entry.addItemClickListener((ItemClickListener)this);
        EntryGrid priceentryentity = (EntryGrid)this.getView().getControl("priceentryentity");
        if (priceentryentity != null) {
            priceentryentity.addRowClickListener((RowClickEventListener)this);
            priceentryentity.addHyperClickListener((HyperLinkClickListener)this);
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        if ("adjustbillno".equals(e.getFieldName())) {
            int row = this.getModel().getEntryCurrentRowIndex("priceentryentity");
            Object adjustbillid = this.getModel().getValue("adjustbillid", row);
            BillShowParameter fsp = new BillShowParameter();
            fsp.setFormId("pm_purpriceadjust");
            fsp.setPkId(adjustbillid);
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            fsp.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)fsp);
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        IDataModel model = this.getModel();
        Boolean istax = (Boolean)model.getValue("istax");
        this.setPriceMustInput(istax);
        this.updataStairToolBarap(Boolean.FALSE);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        FormOperate operate;
        String key;
        super.beforeDoOperation(e);
        if (e.getSource() instanceof FormOperate && "adjust".equals(key = (operate = (FormOperate)e.getSource()).getOperateKey())) {
            EntryGrid entryGrid = (EntryGrid)this.getControl("priceentryentity");
            int[] rows = entryGrid.getSelectRows();
            if (rows.length > 0) {
                StringBuilder rowStr = new StringBuilder(String.valueOf(rows[0]));
                for (int i = 1; i < rows.length; ++i) {
                    rowStr.append(',').append(String.valueOf(rows[i]));
                }
                operate.getOption().setVariableValue("selectRows", rowStr.toString());
            } else {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u9700\u8981\u8c03\u4ef7\u7684\u4ef7\u683c\u660e\u7ec6\u3002", (String)"PurPriceListPlugin_7", (String)"scmc-pm-formplugin", (Object[])new Object[0]), new Object[0]));
                e.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String pkId;
        FormOperate operate;
        String key;
        super.afterDoOperation(e);
        if (e.getSource() instanceof FormOperate && "adjust".equals(key = (operate = (FormOperate)e.getSource()).getOperateKey()) && operate.getOption().getVariables().containsKey("adjustBillId") && !StringUtils.isBlank((String)(pkId = operate.getOption().getVariableValue("adjustBillId")))) {
            BillShowParameter fsp = new BillShowParameter();
            fsp.setFormId("pm_purpriceadjust");
            fsp.setPkId((Object)pkId);
            fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm((FormShowParameter)fsp);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.queryTaxrate();
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = e.getProperty().getName();
        IDataModel bill = this.getModel();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("priceentryentity");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u7ec4\u7ec7\u3002", (String)"PurPriceListPlugin_1", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        switch (key) {
            case "unit": {
                DynamicObject material = (DynamicObject)bill.getValue("material", rowIndex);
                if (material == null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u7f16\u7801\u3002", (String)"PurPriceListPlugin_0", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                    e.setCancel(true);
                    return;
                }
                DynamicObject mastermaterial = material.getDynamicObject("masterid");
                DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit", rowIndex);
                Long srcmuId = baseUnit == null ? Long.valueOf(0L) : (Long)baseUnit.getPkValue();
                Long masterMaterialId = (Long)mastermaterial.getPkValue();
                List unitIds = BaseDataServiceHelper.getAssistMUListResult((Long)masterMaterialId, (Long)srcmuId, (String)"1");
                QFilter qFilter = new QFilter("id", "in", (Object)unitIds);
                showParameter.getListFilterParameter().setFilter(qFilter);
                break;
            }
            case "taxrateid": {
                String taxrate_filter = this.getPageCache().get(TAXRATE_FILTER);
                taxrate_filter = taxrate_filter.substring(1, taxrate_filter.length() - 1);
                if (StringUtils.isNotEmpty((String)taxrate_filter)) {
                    String[] taxrateIds = taxrate_filter.split("_");
                    ArrayList<Long> taxrateIdList = new ArrayList<Long>(taxrateIds.length);
                    for (String id : taxrateIds) {
                        if (id == null || "".equals(id)) continue;
                        taxrateIdList.add(Long.valueOf(id));
                    }
                    QFilter filter = new QFilter("id", "in", taxrateIdList);
                    showParameter.getListFilterParameter().setFilter(filter);
                    break;
                }
                QFilter filter = QFilter.of((String)"1=-1", (Object[])new Object[0]);
                showParameter.getListFilterParameter().setFilter(filter);
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        int row = evt.getRow();
        if (row < 0) {
            this.updataStairToolBarap(Boolean.FALSE);
            return;
        }
        IDataModel model = this.getModel();
        DynamicObjectCollection priceentryentitys = model.getEntryEntity("priceentryentity");
        DynamicObject priceentryentity = (DynamicObject)priceentryentitys.get(row);
        this.updataStairToolBarap((Boolean)priceentryentity.get(ISSTAIRPRICE));
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject currency;
        String billcretype = this.getPageCache().get("billcretype");
        if (!BillImportHelper.isManual((String)billcretype)) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org == null) {
            return;
        }
        if (this.getModel().getValue("currency") == null && (currency = CurrencyHelper.getCurrency((Long)((Long)org.getPkValue()))) != null) {
            this.getModel().setValue("currency", currency.getPkValue());
        }
        Boolean istax = (Boolean)this.getModel().getValue("istax");
        this.setPriceMustInput(istax);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        String keyName = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        switch (keyName) {
            case "purstairprice": {
                DynamicObject unit = ((DynamicObject)model.getEntryEntity("purstairprice").getParent()).getDynamicObject("unit");
                for (RowDataEntity rowDataEntity : rowDataEntities) {
                    int rowIndex = rowDataEntity.getRowIndex();
                    if (unit != null) {
                        model.setValue("unitid", (Object)unit, rowIndex);
                    }
                    if (rowIndex == 0) {
                        model.setValue("stairqtystart", (Object)BigDecimal.ZERO, 0);
                    }
                    if (rowIndex == 0) continue;
                    model.setValue("stairqtystart", model.getValue("stairqtyend", rowIndex - 1), rowIndex);
                }
                model.updateCache();
                break;
            }
            case "priceentryentity": {
                DynamicObjectCollection priceEntryEntities = model.getEntryEntity("priceentryentity");
                int row = this.getModel().getEntryCurrentRowIndex("priceentryentity");
                DynamicObject priceEntryEntity = (DynamicObject)priceEntryEntities.get(row);
                if (priceEntryEntity.getBoolean(ISSTAIRPRICE)) {
                    this.updataStairToolBarap(Boolean.TRUE);
                    break;
                }
                this.updataStairToolBarap(Boolean.FALSE);
                this.getModel().deleteEntryData("purstairprice");
                break;
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String keyName = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        switch (keyName) {
            case "priceentryentity": {
                DynamicObjectCollection priceentryentitys = model.getEntryEntity("priceentryentity");
                if (priceentryentitys.size() != 0) {
                    int row = this.getModel().getEntryCurrentRowIndex("priceentryentity");
                    DynamicObject priceentryentity = (DynamicObject)priceentryentitys.get(row);
                    this.updataStairToolBarap((Boolean)priceentryentity.get(ISSTAIRPRICE));
                    break;
                }
                this.updataStairToolBarap(Boolean.FALSE);
                break;
            }
        }
    }

    private void updataStairToolBarap(Boolean flag) {
        this.getView().setEnable(flag, new String[]{"staircheck", "stairaddrow", "stairinsertrow", "stairdeletrow"});
    }

    public void itemClick(ItemClickEvent e) {
        super.itemClick(e);
        String itemKey = e.getItemKey();
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        switch (itemKey) {
            case "isstairprice": {
                ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(ISSTAIRPRICE, (IFormPlugin)this);
                view.showConfirm(ResManager.loadKDString((String)"\u5207\u6362\u5c06\u6e05\u7a7a\u9636\u68af\u4ef7\u683c\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PurPriceListPlugin_2", (String)"scmc-pm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNoCancel, confirmCallBackListener);
                break;
            }
            case "staircheck": {
                DynamicObject priceEntryEntity = (DynamicObject)((DynamicObjectCollection)model.getValue("purstairprice")).getParent();
                DynamicObjectCollection purStairPrices = (DynamicObjectCollection)model.getValue("purstairprice");
                BigDecimal minPrice = priceEntryEntity.getBigDecimal("pricefloor");
                BigDecimal maxPrice = priceEntryEntity.getBigDecimal("priceceiling");
                int checkStairPrice = PurStairPriceHelper.getCheckStairPrice((BigDecimal)minPrice, (BigDecimal)maxPrice, (DynamicObjectCollection)purStairPrices);
                view.updateView("purstairprice");
                if (checkStairPrice != 0) {
                    String msg = PurStairPriceHelper.getDetailMsg((int)checkStairPrice);
                    view.showErrorNotification(msg);
                    break;
                }
                view.showSuccessNotification(ResManager.loadKDString((String)"\u672a\u53d1\u73b0\u9519\u8bef\u3002", (String)"PurPriceListPlugin_4", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                break;
            }
            case "bar_addrow": {
                this.updataStairToolBarap(Boolean.FALSE);
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        String itemKey = e.getItemKey();
        IDataModel model = this.getModel();
        DynamicObjectCollection purStairPrices = (DynamicObjectCollection)model.getValue("purstairprice");
        switch (itemKey) {
            case "staircheck": {
                if (purStairPrices.size() > 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9636\u68af\u4ef7\u683c\u5206\u5f55\u9700\u8981\u81f3\u5c11\u67092\u884c\u6570\u636e\u3002", (String)"PurPriceListPlugin_5", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String billcretype = this.getPageCache().get("billcretype");
        if (!BillImportHelper.isManual((String)billcretype)) {
            return;
        }
        if ("STOP".equals(this.getPageCache().get("STOP"))) {
            return;
        }
        String key = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        int index = e.getChangeSet()[0].getRowIndex();
        IDataModel model = this.getModel();
        DynamicObjectCollection purStairPrices = (DynamicObjectCollection)model.getValue("purstairprice");
        DynamicObject dataEntity = e.getChangeSet()[0].getDataEntity();
        switch (key) {
            case "taxrateid": {
                for (ChangeData changeData : valueSet) {
                    int rowIndex = changeData.getRowIndex();
                    this.changeTaxRateID(newValue, index);
                    this.calculatePrice(rowIndex);
                }
                break;
            }
            case "istax": {
                this.applyIsTaxChanged((Boolean)newValue);
                break;
            }
            case "material": {
                this.applyMaterialNoChange((DynamicObject)newValue, index, purStairPrices);
                this.setDefaultTaxRate((DynamicObject)newValue, index);
                if (newValue != null) break;
                DynamicObjectCollection stairPriceEntities = model.getEntryEntity("purstairprice");
                for (DynamicObject stairPriceEntity : stairPriceEntities) {
                    stairPriceEntity.set("unitid", null);
                }
                this.getView().updateView("purstairprice");
                break;
            }
            case "price": 
            case "priceandtax": {
                for (ChangeData changeData : valueSet) {
                    int rowIndex = changeData.getRowIndex();
                    this.calculatePrice(rowIndex);
                }
                break;
            }
            case "unit": {
                DynamicObject unit = dataEntity.getDynamicObject("unit");
                if (purStairPrices.size() == 0) break;
                if (unit == null) {
                    for (int i = 0; i < purStairPrices.size(); ++i) {
                        model.setValue("unitid", null, i);
                    }
                } else {
                    for (int i = 0; i < purStairPrices.size(); ++i) {
                        model.setValue("unitid", (Object)unit, i);
                    }
                }
                break;
            }
            case "pricelisttypeid": {
                DynamicObject priceListType = dataEntity.getDynamicObject("pricelisttypeid");
                if (priceListType == null) {
                    return;
                }
                if (priceListType.getBoolean("isstair")) {
                    model.setValue("isstair", (Object)Boolean.TRUE);
                    break;
                }
                if (((Boolean)model.getValue("isstair")).booleanValue()) break;
                model.setValue("isstair", (Object)Boolean.FALSE);
                break;
            }
            case "isstair": {
                this.isStairChange((Boolean)newValue);
                break;
            }
            case "isstairprice": {
                this.isStairPriceChange((Boolean)newValue, purStairPrices, key);
                break;
            }
        }
    }

    private void isStairChange(Boolean newValue) {
        if (newValue != null && newValue.booleanValue()) {
            this.updataStairToolBarap(Boolean.FALSE);
        }
        if (newValue != null && !newValue.booleanValue()) {
            DynamicObjectCollection priceentryentitys = this.getModel().getEntryEntity("priceentryentity");
            boolean isError = false;
            for (DynamicObject priceentryentity : priceentryentitys) {
                Boolean isstairprice = (Boolean)priceentryentity.get(ISSTAIRPRICE);
                if (!isstairprice.booleanValue()) continue;
                isError = true;
                break;
            }
            if (isError) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u5f53\u6240\u6709\u884c\u5747\u4e0d\u7ef4\u62a4\u9636\u68af\u4ef7\u683c\u65f6\uff0c\u5141\u8bb8\u4fee\u6539\u4e3a\u201c\u5426\u201d\u3002", (String)"PurPriceListPlugin_6", (String)"scmc-pm-formplugin", (Object[])new Object[0]));
                this.getModel().setValue("isstair", (Object)Boolean.TRUE);
                this.updataStairToolBarap(Boolean.TRUE);
            } else {
                this.updataStairToolBarap(Boolean.FALSE);
            }
        }
    }

    private void isStairPriceChange(Boolean newValue, DynamicObjectCollection purStairPrices, String key) {
        if (newValue != null && newValue.booleanValue()) {
            this.updataStairToolBarap(Boolean.TRUE);
            if (purStairPrices.size() == 0) {
                this.getModel().insertEntryRow("purstairprice", 1);
                this.getView().updateView("purstairprice");
            }
        } else {
            this.updataStairToolBarap(Boolean.FALSE);
            if (purStairPrices.size() != 0) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(key, (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u5207\u6362\u5c06\u6e05\u7a7a\u9636\u68af\u4ef7\u683c\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"PurPriceListPlugin_2", (String)"scmc-pm-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String key;
        super.confirmCallBack(evt);
        switch (key = evt.getCallBackId()) {
            case "isstairprice": {
                if (evt.getResult() == MessageBoxResult.Yes) {
                    OperateOption operateOption = OperateOption.create();
                    operateOption.setVariableValue(OPPARAM_AFTERCONFIRM, "true");
                    this.getModel().setValue(ISSTAIRPRICE, (Object)Boolean.FALSE);
                    this.getModel().deleteEntryData("purstairprice");
                    break;
                }
                this.getModel().setValue(ISSTAIRPRICE, (Object)Boolean.TRUE);
                break;
            }
        }
    }

    private void applyMaterialNoChange(DynamicObject material, int row, DynamicObjectCollection purStairPrices) {
        this.getPageCache().put("STOP", "STOP");
        this.getModel().setValue("taxrate", null, row);
        this.getModel().setValue("price", null, row);
        this.getModel().setValue("baseunit", null, row);
        this.getModel().setValue("pricefloor", null, row);
        this.getModel().setValue("priceceiling", null, row);
        this.getModel().setValue(TAXRATEID, null, row);
        this.getModel().setValue("priceandtax", null, row);
        this.getModel().setValue("unit", null, row);
        this.getModel().setValue("unitpriceqty", null, row);
        this.getModel().setValue("auxpty", null, row);
        if (material != null) {
            DynamicObject masterMaterial = material.getDynamicObject("masterid");
            if (masterMaterial.getDynamicObject("baseunit") != null) {
                this.getModel().setValue("baseunit", masterMaterial.getDynamicObject("baseunit").getPkValue(), row);
            }
            if (material.getDynamicObject("purchaseunit") != null) {
                this.getModel().setValue("unit", material.getDynamicObject("purchaseunit").getPkValue(), row);
                if (purStairPrices.size() != 0) {
                    for (int i = 0; i < purStairPrices.size(); ++i) {
                        this.getModel().setValue("unitid", material.getDynamicObject("purchaseunit").getPkValue(), i);
                    }
                }
            }
            this.getModel().setValue("unitpriceqty", (Object)1, row);
        }
        this.getPageCache().put("STOP", null);
    }

    private void setDefaultTaxRate(DynamicObject material, int rowIndex) {
        Optional.ofNullable(material).ifPresent(m -> {
            Optional<DynamicObject> taxrate = Optional.ofNullable(m.getDynamicObject("masterid.taxrate"));
            if (taxrate.isPresent()) {
                String taxrateId = taxrate.get().getString("masterid");
                this.getModel().setValue("taxrate", taxrate.get().getPkValue(), rowIndex);
                this.getModel().setValue(TAXRATEID, (Object)taxrateId, rowIndex);
            } else {
                Optional.ofNullable(this.getModel().getValue("supplierid")).flatMap(supplier -> Optional.ofNullable(((DynamicObject)supplier).getDynamicObject("taxrate"))).ifPresent(supplierTaxRate -> this.getModel().setValue(TAXRATEID, supplierTaxRate.getPkValue(), rowIndex));
            }
        });
    }

    private void changeTaxRateID(Object newValue, int rowIndex) {
        IDataModel model = this.getModel();
        if (newValue instanceof DynamicObject) {
            DynamicObject taxRateID = (DynamicObject)newValue;
            model.setValue("taxrate", taxRateID.get("taxrate"), rowIndex);
        } else {
            model.setValue("taxrate", (Object)0, rowIndex);
        }
    }

    private void applyIsTaxChanged(Boolean newValue) {
        this.setPriceMustInput(newValue);
    }

    private void setPriceMustInput(Boolean istax) {
        AmountEdit priceAndTaxControl = (AmountEdit)this.getView().getControl("priceandtax");
        AmountEdit priceControl = (AmountEdit)this.getView().getControl("price");
        if (istax.booleanValue()) {
            priceAndTaxControl.setMustInput(true);
            priceControl.setMustInput(false);
        } else {
            priceAndTaxControl.setMustInput(false);
            priceControl.setMustInput(true);
        }
    }

    private void calculatePrice(int rowIndex) {
        int precision = 10;
        BigDecimal price = (BigDecimal)this.getModel().getValue("price", rowIndex);
        BigDecimal priceAndTax = (BigDecimal)this.getModel().getValue("priceandtax", rowIndex);
        BigDecimal taxRate = (BigDecimal)this.getModel().getValue("taxrate", rowIndex);
        if (taxRate == null) {
            return;
        }
        taxRate = taxRate.divide(new BigDecimal(100));
        Boolean istax = (Boolean)this.getModel().getValue("istax");
        if (istax.booleanValue()) {
            if (priceAndTax != null) {
                price = priceAndTax.divide(BigDecimal.ONE.add(taxRate), precision, 4);
                this.getModel().setValue("price", (Object)price, rowIndex);
            }
        } else if (price != null) {
            priceAndTax = price.multiply(BigDecimal.ONE.add(taxRate));
            this.getModel().setValue("priceandtax", (Object)priceAndTax, rowIndex);
        }
    }

    private void queryTaxrate() {
        Date bizTime = (Date)this.getModel().getValue("createtime");
        QFilter q1 = new QFilter("activedate", "<=", (Object)bizTime);
        QFilter q2 = new QFilter("expdate", ">", (Object)bizTime);
        QFilter q3 = q2.or(QFilter.isNull((String)"expdate"));
        q1.and(q3).and(new QFilter("enable", "=", (Object)"1"));
        Map bdTaxrate = BusinessDataServiceHelper.loadFromCache((String)"bd_taxrate", (String)"id", (QFilter[])new QFilter[]{q1});
        ArrayList<String> taxratelist = new ArrayList<String>(bdTaxrate.size());
        for (Map.Entry next : bdTaxrate.entrySet()) {
            Object pkValue = ((DynamicObject)next.getValue()).getPkValue();
            taxratelist.add(pkValue.toString());
        }
        if (taxratelist.size() > 0) {
            this.getPageCache().put(TAXRATE_FILTER, SerializationUtils.toJsonString((Object)String.join((CharSequence)"_", taxratelist)));
        }
    }
}

