/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.accept;

import java.math.BigDecimal;
import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.scmc.pm.consts.PurAcceptBillConst;

public class PurAcceptInverseBillOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        String[] allRedColumns;
        String[] billRedColumns;
        super.onPreparePropertys(e);
        String[] redColumns = PurAcceptBillConst.getEntryRedColumns();
        if (redColumns != null && redColumns.length > 0) {
            e.getFieldKeys().addAll(Arrays.asList(redColumns));
        }
        if ((billRedColumns = PurAcceptBillConst.getBillRedColumns()) != null && billRedColumns.length > 0) {
            e.getFieldKeys().addAll(Arrays.asList(billRedColumns));
        }
        if ((allRedColumns = PurAcceptBillConst.getAllRedColumns()) != null && allRedColumns.length > 0) {
            e.getFieldKeys().addAll(Arrays.asList(allRedColumns));
        }
        e.getFieldKeys().add("biztype");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] datas = e.getDataEntities();
        String[] entryRedColumns = PurAcceptBillConst.getEntryRedColumns();
        String[] allRedColumns = PurAcceptBillConst.getAllRedColumns();
        String[] billRedColumns = PurAcceptBillConst.getBillRedColumns();
        for (DynamicObject order : datas) {
            DynamicObjectCollection entrys;
            DynamicObject biztype = order.getDynamicObject("biztype");
            if (biztype == null) {
                return;
            }
            String number = biztype.getString("number");
            if (number == null || !"1131".equals(number) && !"1132".equals(number) && !"1121".equals(number)) continue;
            if (entryRedColumns != null && entryRedColumns.length > 0) {
                entrys = order.getDynamicObjectCollection("billentry");
                for (DynamicObject entry : entrys) {
                    this.setNegate(entry, entryRedColumns);
                }
            }
            if (allRedColumns != null && allRedColumns.length > 0) {
                entrys = order.getDynamicObjectCollection("allocationentry");
                for (DynamicObject entry : entrys) {
                    this.setNegate(entry, allRedColumns);
                }
            }
            if (billRedColumns == null || billRedColumns.length <= 0) continue;
            this.setNegate(order, billRedColumns);
        }
    }

    private void setNegate(DynamicObject order, String[] needInverseColumns) {
        for (String column : needInverseColumns) {
            BigDecimal value = order.getBigDecimal(column);
            if (value == null) {
                value = BigDecimal.ZERO;
            }
            value = value.abs().negate();
            order.set(column, (Object)value);
        }
    }
}

