/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.apply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.changemodel.business.helper.BatXBillHelper;
import kd.mpscmm.msbd.changemodel.business.helper.ChangeModelHelper;
import kd.mpscmm.msbd.changemodel.common.enums.BatChangeStatusEnum;
import kd.mpscmm.msbd.changemodel.common.enums.BizChangeStatusEnum;
import kd.mpscmm.msbd.common.utils.PartitionUtils;
import kd.scmc.pm.business.custom.ext.bizextplugin.XSPurApplySynApplyStatusImpl;
import kd.scmc.pm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.pm.business.helper.PurApplyBillHelper;
import kd.scmc.pm.enums.UnitConvertDirEnum;
import kd.scmc.pm.validation.apply.BatXPurApplyBillSrcBillValidator;
import kd.sdk.scmc.pm.extpoint.IPurBatChangeCasePlugin;
import kd.sdk.scmc.pm.extpoint.IXPurApplyCasePlugin;

public class BatXPurApplyBillValidOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(BatXPurApplyBillValidOp.class);
    private static final String[] neededProps = new String[]{"istax", "currency", "qty", "price", "auxunit", "priceandtax", "taxrateid", "material", "taxrate", "amount", "taxamount", "amountandtax", "totalallamount", "changer", "changestatus", "changedate", "version"};

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("changedate");
        e.getFieldKeys().add("afterqty");
        e.getFieldKeys().add("afterbaseqty");
        e.getFieldKeys().add("xsbillid");
        e.getFieldKeys().add("xsbillentryid");
        e.getFieldKeys().add("changestatus");
        e.getFieldKeys().add("afterreqdate");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("unit");
        e.getFieldKeys().add("material");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BatXPurApplyBillSrcBillValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        block30: {
            try {
                Set selectRows = BatXBillHelper.getSelectRows((OperateOption)this.getOption());
                DynamicObject[] bills = e.getDataEntities();
                if (bills == null || bills.length == 0) {
                    return;
                }
                DynamicObject changeModel = ChangeModelHelper.getChangeModel4BatchXBill((String)this.billEntityType.getName());
                if (changeModel != null) {
                    String props = BatXBillHelper.getSrcFieldsByChangeModel((DynamicObject)changeModel);
                    props = String.join((CharSequence)",", props, String.join((CharSequence)",", neededProps));
                    try {
                        PluginProxy pluginProxy = PluginProxy.create(null, IPurBatChangeCasePlugin.class, (String)"SCMC_PM_PURAPPLYBCBILL_ACTIVE_MODIFYSRCBILL", null);
                        List results = pluginProxy.callReplace(p -> p.addSrcBillProps());
                        if (results != null && results.size() > 0) {
                            props = String.join((CharSequence)",", props, String.join((CharSequence)",", (Iterable)results.get(0)));
                        }
                    }
                    catch (Exception e1) {
                        String msg = ResManager.loadKDString((String)"\u5ba2\u6237\u5316\u573a\u666f[%1$s]\u63d2\u4ef6\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5ba2\u6237\u5316\u63d2\u4ef6\u3002", (String)"BatXPurOrderBillValidOp_3", (String)"scmc-pm-opplugin", (Object[])new Object[0]);
                        msg = String.format(msg, "SCMC_PM_PURAPPLYBCBILL_ACTIVE_MODIFYSRCBILL");
                        String msgTotal = msg + e;
                        log.info(msgTotal);
                        throw new KDBizException(msgTotal);
                    }
                    HashMap<Long, DynamicObject> changeEntryMap = new HashMap<Long, DynamicObject>(8);
                    HashSet<Long> srcBillIds = new HashSet<Long>(8);
                    for (DynamicObject bill : bills) {
                        changeEntryMap.clear();
                        srcBillIds.clear();
                        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
                        if (entrys != null) {
                            for (DynamicObject entry : entrys) {
                                long srcBillEntryId;
                                if (selectRows != null && selectRows.size() != 0 && !selectRows.contains((Long)entry.getPkValue())) continue;
                                long srcBillId = entry.getLong("xsbillid");
                                if (srcBillId != 0L) {
                                    srcBillIds.add(srcBillId);
                                }
                                if ((srcBillEntryId = entry.getLong("xsbillentryid")) == 0L) continue;
                                changeEntryMap.put(srcBillEntryId, entry);
                            }
                        }
                        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
                        ArrayList srcBillIdList = new ArrayList(srcBillIds);
                        List sidPartitions = PartitionUtils.partition(srcBillIdList, (int)100);
                        for (List sids : sidPartitions) {
                            DynamicObject[] sbills = BusinessDataServiceHelper.load((String)"pm_purapplybill", (String)(props + ",orderbaseqty,baseqty,rowclosestatus,closestatus,closer,closedate"), (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)sids)});
                            ArrayList<DynamicObject> cloneBills = new ArrayList<DynamicObject>(sbills.length);
                            for (DynamicObject srcBill : sbills) {
                                DynamicObject newData = (DynamicObject)new CloneUtils(false, false).clone((IDataEntityBase)srcBill);
                                cloneBills.add(newData);
                            }
                            this.modifySrcBills(sbills, changeEntryMap, user);
                            List srcBills = Arrays.asList(sbills);
                            for (DynamicObject srcBill : srcBills) {
                                XSPurApplySynApplyStatusImpl impl = new XSPurApplySynApplyStatusImpl();
                                PluginProxy pluginProxy = PluginProxy.create((Object)impl, IXPurApplyCasePlugin.class, (String)"SCMC_PM_XSPURAPPLYBILL_ACTIVE_SYNCSTATUS", null);
                                pluginProxy.callReplaceIfPresent(p -> p.activeSynApplyBillStatus(srcBill));
                            }
                            try {
                                PluginProxy pluginProxy = PluginProxy.create(null, IPurBatChangeCasePlugin.class, (String)"SCMC_PM_PURAPPLYBCBILL_ACTIVE_MODIFYSRCBILL", null);
                                List finalSrcBills = srcBills;
                                Set selectEntryIds = changeEntryMap.keySet();
                                List results = pluginProxy.callReplace(p -> p.modifySrcBills(finalSrcBills, selectEntryIds));
                                if (results != null && results.size() > 0) {
                                    srcBills = (List)results.get(results.size() - 1);
                                }
                            }
                            catch (Exception e1) {
                                String msg = ResManager.loadKDString((String)"\u5ba2\u6237\u5316\u573a\u666f[%1$s]\u63d2\u4ef6\u6267\u884c\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u5ba2\u6237\u5316\u63d2\u4ef6\u3002", (String)"BatXPurOrderBillValidOp_3", (String)"scmc-pm-opplugin", (Object[])new Object[0]);
                                msg = String.format(msg, "SCMC_PM_PURAPPLYBCBILL_ACTIVE_MODIFYSRCBILL");
                                String msgTotal = msg + e1.getMessage();
                                log.info(msgTotal);
                                throw new KDBizException(msgTotal);
                            }
                            TXHandle tx = TX.requiresNew();
                            Throwable throwable = null;
                            try {
                                try {
                                    BatXBillHelper.recChangeLog(cloneBills, (List)srcBills, (DynamicObject)bill);
                                    if (srcBills != null && srcBills.size() > 0) {
                                        SaveServiceHelper.save((DynamicObject[])srcBills.toArray(new DynamicObject[0]));
                                    }
                                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
                                }
                                catch (Exception e1) {
                                    tx.markRollback();
                                    throw e1;
                                }
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (tx == null) continue;
                                if (throwable != null) {
                                    try {
                                        tx.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                tx.close();
                            }
                        }
                    }
                    break block30;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u53d8\u66f4\u65b9\u6848\u3002", (String)"BatXPurOrderBillValidOp_2", (String)"scmc-pm-opplugin", (Object[])new Object[0]));
            }
            catch (Exception e1) {
                log.error((Throwable)e1);
                throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6548\u5931\u8d25\u3002", (String)"BatXPurOrderBillValidOp_4", (String)"scmc-pm-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void modifySrcBills(DynamicObject[] sbills, Map<Long, DynamicObject> changeEntryMap, DynamicObject user) {
        for (DynamicObject srcBill : sbills) {
            DynamicObjectCollection entrys = srcBill.getDynamicObjectCollection("billentry");
            for (DynamicObject entry : entrys) {
                DynamicObject changeEntry;
                DynamicObject masterMaterial;
                DynamicObject material = entry.getDynamicObject("material");
                if (material == null || (masterMaterial = material.getDynamicObject("masterid")) == null || (changeEntry = changeEntryMap.get(entry.getPkValue())) == null) continue;
                BigDecimal qty = changeEntry.getBigDecimal("afterqty");
                BigDecimal baseQty = changeEntry.getBigDecimal("afterbaseqty");
                entry.set("qty", (Object)qty);
                entry.set("baseqty", (Object)baseQty);
                entry.set("reqdate", changeEntry.get("afterreqdate"));
                String unitConvertDir = masterMaterial.getString("unitconvertdir");
                DynamicObject baseUnit = entry.getDynamicObject("baseunit");
                DynamicObject auxUnit = entry.getDynamicObject("auxunit");
                if (auxUnit != null && (UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir))) {
                    BigDecimal auxQty = BillQtyAndUnitHelper.getDesQtyConv((Long)((Long)masterMaterial.getPkValue()), (DynamicObject)baseUnit, (BigDecimal)baseQty, (DynamicObject)auxUnit);
                    entry.set("auxqty", (Object)auxQty);
                }
                changeEntry.set("changestatus", (Object)BatChangeStatusEnum.VALID.getValue());
            }
            PurApplyBillHelper.calcAllAmount((DynamicObject)srcBill);
            srcBill.set("changer", (Object)user);
            srcBill.set("changedate", (Object)TimeServiceHelper.now());
            String version = srcBill.getString("version");
            if (version == null || version.length() == 0 || version.equals("0") || version.startsWith("0.") || version.startsWith("1.")) {
                version = "1";
            }
            int newVersion = 1;
            try {
                newVersion = Integer.parseInt(version) + 1;
            }
            catch (NumberFormatException ee) {
                log.warn((Throwable)ee);
            }
            srcBill.set("version", (Object)String.valueOf(newVersion));
            srcBill.set("changestatus", (Object)BizChangeStatusEnum.CHANGED.getValue());
        }
    }
}

