/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.basedata;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.scmc.pm.enums.QuotaAssignSrcTypeEnum;

public class QuotaUnAuditOP
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List keys = e.getFieldKeys();
        keys.add("org");
        keys.add("quotatype");
        keys.add("material");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> quotaIds = new HashSet<Long>(10);
        HashSet<Long> materialIds = new HashSet<Long>(10);
        int needDeleteCount = 0;
        for (DynamicObject quota : dataEntities) {
            Long pkValue = (Long)quota.getPkValue();
            DynamicObject material = (DynamicObject)quota.get("material");
            if (material == null) continue;
            ++needDeleteCount;
            if (material.getDynamicObject("masterid") != null) {
                materialIds.add((Long)material.getDynamicObject("masterid").getPkValue());
            }
            quotaIds.add(pkValue);
        }
        QFilter quotaFilter = new QFilter("quota", "in", quotaIds);
        QFilter materialFilter = new QFilter("material.masterid", "in", materialIds);
        QFilter srcTypeFitler = new QFilter("srctype", "=", (Object)QuotaAssignSrcTypeEnum.QUOTA.getValue());
        int deleteCount = DeleteServiceHelper.delete((String)"pm_quotaassign", (QFilter[])new QFilter[]{quotaFilter, srcTypeFitler, materialFilter});
        if (needDeleteCount != deleteCount) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5220\u9664\u914d\u989d\u5206\u914d\u51fa\u9519\u3002", (String)"QuotaUnAuditOP_0", (String)"scmc-pm-opplugin", (Object[])new Object[0]));
        }
    }
}

