/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.order;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.pm.enums.ChangeStatusEnum;
import kd.scmc.pm.validation.order.BatXPurOrderBillIsZeroValidator;
import kd.scmc.pm.validation.order.BatXPurOrderBillOpGrpValidator;
import kd.scmc.pm.validation.order.BatXPurOrderBillSrcBillValidator;
import kd.scmc.pm.validation.order.BatXPurOrderBillSupplierValidator;
import kd.scmc.pm.validation.order.BatXPurOrderBillUniqueValidator;

public class BatXPurOrderBillSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("h_operatorgroup");
        e.getFieldKeys().add("h_operator");
        e.getFieldKeys().add("CONFIRMSTATUS");
        e.getFieldKeys().add("supplier");
        e.getFieldKeys().add("afterqty");
        e.getFieldKeys().add("afterbaseqty");
        e.getFieldKeys().add("afterdeliverdate");
        e.getFieldKeys().add("xsbillid");
        e.getFieldKeys().add("xsbillentryid");
        e.getFieldKeys().add("changestatus");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("unit");
        e.getFieldKeys().add("qty");
        e.getFieldKeys().add("baseqty");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new BatXPurOrderBillUniqueValidator());
        e.addValidator((AbstractValidator)new BatXPurOrderBillIsZeroValidator());
        e.addValidator((AbstractValidator)new BatXPurOrderBillSupplierValidator());
        e.addValidator((AbstractValidator)new BatXPurOrderBillSrcBillValidator());
        e.addValidator((AbstractValidator)new BatXPurOrderBillOpGrpValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] srcBills;
        DynamicObject[] bills = e.getDataEntities();
        if (bills == null || bills.length == 0) {
            return;
        }
        HashSet<Long> srcIds = new HashSet<Long>();
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                Long xSBillId = entry.getLong("xsbillid");
                if (xSBillId == 0L) continue;
                srcIds.add(xSBillId);
            }
        }
        QFilter q = new QFilter("id", "in", srcIds);
        for (DynamicObject srcBill : srcBills = BusinessDataServiceHelper.load((String)"pm_purorderbill", (String)"changestatus", (QFilter[])new QFilter[]{q})) {
            srcBill.set("changestatus", (Object)ChangeStatusEnum.CHANGING.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])srcBills);
    }
}

