/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.pm.opplugin.order;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.pm.enums.ChangeStatusEnum;

public class BatXPurOrderBillUnSubmitOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(BatXPurOrderBillUnSubmitOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("xsbillid");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] srcBills;
        DynamicObject[] bills = e.getDataEntities();
        if (bills == null || bills.length == 0) {
            return;
        }
        HashSet<Long> srcIds = new HashSet<Long>();
        for (DynamicObject bill : bills) {
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entrys) {
                Long xSBillId = entry.getLong("xsbillid");
                if (xSBillId == 0L) continue;
                srcIds.add(xSBillId);
            }
        }
        QFilter q = new QFilter("id", "in", srcIds);
        for (DynamicObject srcBill : srcBills = BusinessDataServiceHelper.load((String)"pm_purorderbill", (String)"changestatus,version", (QFilter[])new QFilter[]{q})) {
            String version = srcBill.getString("version");
            try {
                if (StringUtils.isBlank((CharSequence)version) || Integer.parseInt(version) == 0 || Integer.parseInt(version) == 1) {
                    srcBill.set("changestatus", (Object)ChangeStatusEnum.UNCHANGE.getValue());
                    continue;
                }
                srcBill.set("changestatus", (Object)ChangeStatusEnum.CHANGED.getValue());
            }
            catch (Exception e1) {
                log.error((Throwable)e1);
                srcBill.set("changestatus", (Object)ChangeStatusEnum.UNCHANGE.getValue());
            }
        }
        SaveServiceHelper.save((DynamicObject[])srcBills);
    }
}

